/* ********************************************************************** */
/*                            UPDATE 1.0.19_002                           */
/* ---------------------------------------------------------------------- */


-- add maiden/married name to views including patient identity

DROP VIEW billing.invoice_stub;

CREATE VIEW billing.invoice_stub (id, state, old_state, invoice_number, class_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, third_party_id, created, due, reminders, reminder_date, statement_id, settlement_id, settlement_date, amount, payment, deduction, balance) AS
	SELECT DISTINCT invoice.id, invoice.state, invoice.old_state, invoice.invoice_number, invoice.class_id, invoice.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, invoice.third_party_id, invoice.created, invoice.due, invoice.reminders, invoice.reminder_date, invoice.statement_id, invoice.settlement_id, invoice.settlement_date, invoice.amount, invoice.payment, invoice.deduction, invoice.balance
    FROM billing.invoice, patient.patient
    WHERE patient.id = invoice.patient_id;

DROP VIEW billing.activity;
    
CREATE VIEW billing.activity (id, invoice_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, accession_number, performed, code, quantity, coefficient, key_value, suffixes, majoration) AS
 	SELECT DISTINCT act.id, act.invoice_id, act.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, act.accession_number, act.performed, act.code, act.quantity, act.coefficient, act.key_value, act.suffixes, invoice.majoration
 	FROM billing.act, billing.invoice, patient.patient
 	WHERE invoice.id = act.invoice_id AND patient.id = invoice.patient_id;
 
DROP VIEW billing.transaction; 	
 	
CREATE VIEW billing.transaction (id, invoice_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, created, transaction_date, cashier_id, settlement_id, settlement_date, debit, credit) AS
	SELECT DISTINCT ledger.id, ledger.invoice_id, invoice.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, invoice.created, ledger.transaction_date, ledger.cashier_id, ledger.settlement_id, ledger.settlement_date, ledger.debit, ledger.credit
	FROM billing.ledger, billing.invoice, patient.patient
	WHERE patient.id = invoice.patient_id AND invoice.id = ledger.invoice_id;
	
DROP VIEW billing.trashed_invoice_stub;	
	
CREATE VIEW billing.trashed_invoice_stub (id, state, old_state, invoice_number, class_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, third_party_id, created, due, reminders, reminder_date, statement_id, settlement_id, settlement_date, amount, payment, deduction, balance, trasher_id, trashing_date) AS
 	SELECT DISTINCT trashed_invoice.id, trashed_invoice.state, trashed_invoice.old_state, trashed_invoice.invoice_number, trashed_invoice.class_id, trashed_invoice.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, trashed_invoice.third_party_id, trashed_invoice.created, trashed_invoice.due, trashed_invoice.reminders, trashed_invoice.reminder_date, trashed_invoice.statement_id, trashed_invoice.settlement_id, trashed_invoice.settlement_date, trashed_invoice.amount, trashed_invoice.payment, trashed_invoice.deduction, trashed_invoice.balance, trashed_invoice.trasher_id, trashed_invoice.trashing_date
	FROM billing.trashed_invoice, patient.patient
	WHERE patient.id = trashed_invoice.patient_id;	
	

/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.0.19_002.sql');