/* ************************************************************************ */
/*                             UPDATE 1.2.00_012                            */
/* ------------------------------------------------------------------------ */

/**************** add hospitalisation class to act ************************/
ALTER TABLE billing.act ADD COLUMN hospitalisation_class CHAR(1) DEFAULT null;

/** fill the columns with the acronym of the invoice's hospitalisation class **/
UPDATE billing.act 
SET hospitalisation_class = 
(
	SELECT 	hospitalisation_class.acronym 
	  FROM 	patient.hospitalisation_class, billing.invoice
	WHERE 	billing.invoice.id 		 = billing.act.invoice_id 
	  AND 	billing.invoice.class_id = patient.hospitalisation_class.id  
)
WHERE hospitalisation_class IS NULL;

/**************** add majoration to act ************************/
ALTER TABLE billing.act ADD COLUMN majoration FLOAT DEFAULT 1;

/** fill the columns with the majoration of the invoice **/
UPDATE billing.act
SET majoration = 
(
	SELECT majoration FROM billing.invoice
	WHERE billing.invoice.id = billing.act.invoice_id
);


/**************** add orgiginal coefficient to act ************************/
ALTER TABLE billing.act ADD COLUMN fix_amount FLOAT DEFAULT null;

insert into usermanagement.permission (name, description) 
	values ('BillingModule.changeAmount',E'User is allowed to change the amount of an act');

insert into usermanagement.rel_role_permission (role_id,permission_id) 
	values ((select id from usermanagement.role where name='BillingModule.Accounting'),
			(select id from usermanagement.permission where name='BillingModule.changeAmount'));

/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now', 'LAST_UPDATE', 'db_update_1.2.00_012.sql');