/* ************************************************************************ */
/*                             UPDATE 1.2.07_001                            */
/* ------------------------------------------------------------------------ */

-- prepare the DB for the new variable type
ALTER TABLE letter.templates
	ADD COLUMN placeholder_version INTEGER DEFAULT 0;
	
-- create the DB table for the placeholders
CREATE TABLE letter.placeholders
(
	id		SERIAL PRIMARY KEY,
	name	VARCHAR DEFAULT NULL UNIQUE,
	type	VARCHAR DEFAULT NULL,
	comment	TEXT DEFAULT NULL,
	script	TEXT NOT NULL DEFAULT ''
);


/* ********************************************************************** */
/* **********            ADD LETTER PLACEHOLDERS               ********** */
/* ********************************************************************** */

-- --------------------------------------------------
-- USE THIS FUNCTION FOR THE PLACEHOLDER INSERTION
-- --------------------------------------------------

-- THE FUNCTION TO INSERT OR UPDATE A NEW PLACEHOLDER
CREATE OR REPLACE FUNCTION letter.insert_letter_placeholder (p_name VARCHAR, p_type VARCHAR, p_comment TEXT, p_script TEXT)
	RETURNS void AS
$BODY$

DECLARE
	r RECORD;
	count INTEGER;
	
BEGIN
	count = 0;
	FOR r IN SELECT p.name FROM letter.placeholders p WHERE p.name = p_name
	LOOP
		count = count + 1;
	END LOOP;

	
	IF count = 0 THEN
		INSERT INTO letter.placeholders
		(name, type, comment, script)
		VALUES
		(p_name, p_type, p_comment, p_script );
	ELSE
		UPDATE letter.placeholders 
		SET type = p_type,
			comment = p_comment,
			script = p_script
		WHERE name = p_name;
	END IF;
	
	RETURN;
END
$BODY$
LANGUAGE plpgsql;



-- ADD THE INSERTS HERE ...
SELECT letter.insert_letter_placeholder(E'[PAT_LAST_INVOICE_DATE]', E'BILLING', E'The date of the last invoice of this patient', E'/**
 * [PAT_LAST_INVOICE_DATE]
 */
var invoice = getLastInvoices(PATIENT, PHYSICIAN, 1, null);


if (invoice == null || invoice.getInvoiceDate() == null)
	"";
else
	FORMATTER.formatDate(invoice.getInvoiceDate());');
SELECT letter.insert_letter_placeholder(E'[PAT_LAST_INVOICE_NUMBER]', E'BILLING', E'The number of the last invoice of this patient', E'/**
 * [PAT_LAST_INVOICE_NUMBER]
 */
var invoice = getLastInvoices(PATIENT, PHYSICIAN, 1, null);


if (invoice == null || invoice.getInvoiceNumber() == null)
	"";
else
	invoice.getInvoiceNumber();');
SELECT letter.insert_letter_placeholder(NULL, E'BILLING', E'Functions available to all BILLING placeholders', E'/**
 * BILLING FUNCTIONS
 */

/**
 * Patient patient: The patient to search the invoice for
 * Physician physician: The physician, that created the invoice or NULL
 * 	if the the physician should not be taken into consideration.
 * int count: The number of invoices to fetch or null or -1, to fetch all
 * List<Integer> states: The states of the invoices to fetch or null or empty list,
 * 	to fetch all states.
 * return: A list of the last <<count>> invoices for this patient and this physician
 *	or the last invoice, if the count == 1.
 */
function getLastInvoices (patient, physician, count, states)
{
	var query = new java.lang.StringBuilder();
	var iter;
	var parameters = new java.util.LinkedList();
	
	
	if (patient == null)
		return null;
	
	// define the query start
	query.append("SELECT OBJECT(o) FROM Invoice o")
			.append("\\nWHERE o.patient = :patient");
	parameters.add(DATABASE_MANAGER.createParameter("patient", patient));
	
	// set the physician to query for
	if (physician != null)
	{
		query.append("\\nAND o.physician = :physician");
		parameters.add(DATABASE_MANAGER.createParameter("physician", physician));
	}
	
	// set the states to query for
	if (states != null && !states.isEmpty())
	{
		query.append("\\nAND o.state IN (");
		for (iter = states.iterator(); iter.hasNext(); )
		{
			query.append(iter.next());
			if (iter.hasNext())
				query.append(", ");
		}
		query.append(")");
	}
	
	// order the result
	query.append("\\nORDER BY o.invoiceDate, o.id")
	
	// define the no of results
	if (count != null && count > 0)
	{
		if (count == 1)
			return DATABASE_MANAGER.getHqlQueryObject(query.toString(), parameters);
		else
			return DATABASE_MANAGER.doHqlQuery(query.toString(), 0, count, parameters);
	}
	else
		return DATABASE_MANAGER.doHqlQuery(query.toString(), parameters);
}');
SELECT letter.insert_letter_placeholder(E'[CONT_CNS_CODE]', E'CONTACT', E'The CNS code of this contact', E'/**
 * [CONT_CNS_CODE]
 */
toString(MAIN_CONTACT.getUcmCode());');
SELECT letter.insert_letter_placeholder(E'[CONT_COMMENT]', E'CONTACT', E'The comment to this contact', E'/**
 * [CONT_COMMENT]
 */
toString(MAIN_CONTACT.getComment());');
SELECT letter.insert_letter_placeholder(E'[CONT_EMAIL]', E'CONTACT', E'The email of this contact', E'/**
 * [CONT_EMAIL]
 */
toString(MAIN_CONTACT.getEmail());');
SELECT letter.insert_letter_placeholder(E'[CONT_FAX]', E'CONTACT', E'The fax number of this contact', E'/**
 * [CONT_FAX]
 */
toString(MAIN_CONTACT.getFax());');
SELECT letter.insert_letter_placeholder(E'[CONT_FIRST_NAMES]', E'CONTACT', E'The contact person''s first name', E'/**
 * [CONT_FIRST_NAMES]
 */
toString(MAIN_CONTACT.getNameFirst());');
SELECT letter.insert_letter_placeholder(E'[CONT_FULL_ADDRESS]', E'CONTACT', E'The full address of this contact in several lines', E'/**
 * [CONT_FULL_ADDRESS]
 */
var addresses = MAIN_CONTACT.getAddress();
var	address;
var formattedAddress = "";


if (addresses != null && addresses.size() > 0)
{
	address = addresses.iterator().next();
	formattedAddress = FORMATTER.formatAddressBlock(address);
}

formattedAddress;');
SELECT letter.insert_letter_placeholder(E'[CONT_FULL_ADDRESS_SINGLE_LINE]', E'CONTACT', E'The full address of this contact in one line', E'/**
 * [CONT_FULL_ADDRESS_SINGLE_LINE]
 */
var addresses = MAIN_CONTACT.getAddress();
var	address;
var formattedAddress = "";


if (addresses != null && addresses.size() > 0)
{
	address = addresses.iterator().next();
	formattedAddress = FORMATTER.formatAddressLine(address);
}

formattedAddress;');
SELECT letter.insert_letter_placeholder(E'[CONT_FULL_NAME]', E'CONTACT', E'The full name of this contact', E'/**
 * [CONT_FULL_NAME]
 */
var name	= new java.lang.StringBuilder();
var part;


part = toString(MAIN_CONTACT.getTitle());
name.append(part);
if (part.length() > 0)
	name.append(" ");

part = toString(MAIN_CONTACT.getNameFirst());
if (part.length() > 0)
	name.append(" ");
name.append(part);

name.append(toString(MAIN_CONTACT.getName()));

name.toString().trim();');
SELECT letter.insert_letter_placeholder(E'[CONT_LAST_NAME]', E'CONTACT', E'The contact person''s last name', E'/**
 * [CONT_LAST_NAME]
 */
toString(MAIN_CONTACT.getName());');
SELECT letter.insert_letter_placeholder(E'[CONT_MOBILE]', E'CONTACT', E'The mobile number of this contact', E'/**
 * [CONT_MOBILE]
 */
toString(MAIN_CONTACT.getPhoneMobile());');
SELECT letter.insert_letter_placeholder(E'[CONT_TEL_PRIVATE]', E'CONTACT', E'The private phone number of this contact', E'/**
 * [CONT_TEL_PRIVATE]
 */
toString(MAIN_CONTACT.getPhonePrivate());');
SELECT letter.insert_letter_placeholder(E'[CONT_TEL_WORK]', E'CONTACT', E'The working phone number of this contact', E'/**
 * [CONT_TEL_WORK]
 */
toString(MAIN_CONTACT.getPhoneWork());');
SELECT letter.insert_letter_placeholder(E'[CONT_TITLE]', E'CONTACT', E'The title of this contact', E'/**
 * [CONT_TITLE]
 */
toString(MAIN_CONTACT.getTitle());');
SELECT letter.insert_letter_placeholder(E'[GEN_DATE]', E'GENERAL', E'The current date', E'/**
 * [GEN_DATE]
 */
FORMATTER.formatDate(new Date());');
SELECT letter.insert_letter_placeholder(E'[GEN_TIME]', E'GENERAL', E'The current time', E'/**
 * [GEN_TIME]
 */
FORMATTER.formatDate(new Date(), "hh:mm");');
SELECT letter.insert_letter_placeholder(E'[OFFICE_ACCOUNT_LIST]', E'OFFICE', E'<html>The list of the office''s bank accounts.</html>', E'/**
 * [OFFICE_ACCOUNT_LIST]
 */

// use the same formating as in the print template
FORMATTER.formatAccountList(PHYSICIAN);');
SELECT letter.insert_letter_placeholder(E'[OFFICE_ALL_PHONE_AND_EMAIL]', E'OFFICE', E'The offices''s phone numbers and email, on seperate lines', E'/**
 * [OFFICE_ALL_PHONE_AND_EMAIL]
 */

var result = "";

var phone = OFFICE.getOfficePhoneByType("private");
phone = phone == null ? "" : phone.getNumber();

var fax = OFFICE.getOfficePhoneByType("fax");
fax = fax == null ? "" : fax.getNumber();

var email = OFFICE.getEmail();
email = email == null ? "" : email;

if (phone != null && phone.length != 0)
	result = "Tel: " + phone;

if (fax != null && fax.lengt != 0)
	result = result + (result.length == 0 ? "" : "\\n")
		+ "FAX: " + fax;

if (email != null && email.lengt != 0)
	result = result + (result.length == 0 ? "" : "\\n")
		+ "eMail: " + email;

result;');
SELECT letter.insert_letter_placeholder(E'[OFFICE_ALL_PHONE_AND_EMAIL_SINGLE_LINE]', E'OFFICE', E'The offices''s phone numbers and email, on one single line', E'/**
 * [OFFICE_ALL_PHONE_AND_EMAIL_SINGLE_LINE]
 */

var result = "";


var phone = OFFICE.getOfficePhoneByType("private");
phone = phone == null ? "" : phone.getNumber();

var fax = OFFICE.getOfficePhoneByType("fax");
fax = fax == null ? "" : fax.getNumber();

var email = OFFICE.getEmail();
email = email == null ? "" : email;

if (phone != null && phone.length != 0)
	result = "Tel: " + phone;

if (fax != null && fax.lengt != 0)
	result = result + (result.length == 0 ? "" : "; ")
		+ "FAX: " + fax;

if (email != null && email.lengt != 0)
	result = result + (result.length == 0 ? "" : "; ")
		+ "eMail: " + email;

result;');
SELECT letter.insert_letter_placeholder(E'[OFFICE_CNS_CODE]', E'OFFICE', E'The CNS code of the medical office / practice', E'/**
 * [OFFICE_CNS_CODE]
 */
var code = OFFICE.getUcmCode();

code == null ? "" : code;');
SELECT letter.insert_letter_placeholder(E'[OFFICE_EMAIL]', E'OFFICE', E'The email address of the medical office / practice', E'/**
 * [OFFICE_EMAIL]
 */
var email = OFFICE.getEmail();

email == null ? "" : email;');
SELECT letter.insert_letter_placeholder(E'[OFFICE_FAX]', E'OFFICE', E'The fax number of the medical office / practice', E'/**
 * [OFFICE_FAX]
 */
var fax = OFFICE.getOfficePhoneByType("fax");

fax == null ? "" : fax.getNumber();');
SELECT letter.insert_letter_placeholder(E'[OFFICE_FULL_SITE_ADDRESS_SINGLE_LINE]', E'OFFICE', E'<html>The office''s site''s full address. <br>Formatted in a single line, <br>suited e.g. as the return address</html>', E'/**
 * [OFFICE_FULL_SITE_ADDRESS_SINGLE_LINE]
 */

var adr = SITE.getSiteAddress();
 
// use the same formating as in the print template
FORMATTER.formatAddressLine(adr);');
SELECT letter.insert_letter_placeholder(E'[OFFICE_INFORMATIONS]', E'OFFICE', E'Informations about the medical office / practice', E'/**
 * [OFFICE_INFORMATIONS]
 */
var info = OFFICE.getInformation();

info == null ? "" : info;');
SELECT letter.insert_letter_placeholder(E'[OFFICE_NAME]', E'OFFICE', E'The name of the medical office / pactice', E'/**
 * [OFFICE_NAME]
 */

OFFICE.getName() == null ? "" : OFFICE.getName();');
SELECT letter.insert_letter_placeholder(E'[OFFICE_PHONE]', E'OFFICE', E'The phone number of the medical office / proctice', E'/**
 * [OFFICE_PHONE]
 */
var phone = OFFICE.getOfficePhoneByType("private")
phone == null ? "" : phone.getNumber();');
SELECT letter.insert_letter_placeholder(E'[OFFICE_WEBSIITE]', E'OFFICE', E'The Web site of the medical office / practice', E'/**
 * [OFFICE_WEBSIITE]
 */
var website = OFFICE.getWebsite();

website == null ? "" : website;');
SELECT letter.insert_letter_placeholder(E'[OFFICE_ADDRESS_COUNTRY]', E'OFFICE_ADDRESS', E'The country of the office''s address', E'/**
 * [OFFICE_ADDRESS_COUNTRY]
 */

var country;
 
try {
    // An office can, in theory, have more than one address (DB schema).
    // However, in practice there is only one, and hence the first is the only one.
    country = OFFICE.getOfficeAddress().iterator().next().getCountry();
    }
catch (error) {
    country = null;
    }

country == null ? "" : FORMATTER.translate("Country." + country);');
SELECT letter.insert_letter_placeholder(E'[OFFICE_ADDRESS_LOCALITY]', E'OFFICE_ADDRESS', E'Locality  of the office''s address', E'/**
 * [OFFICE_ADDRESS_LOCALITY]
 */

var locality;
 
try {
    // An office can, in theory, have more than one address (DB schema).
    // However, in practice there is only one, and hence the first is the only one.
    locality = OFFICE.getOfficeAddress().iterator().next().getLocality();
    }
catch (error) {
    locality = null;
    }

locality == null ? "" : locality;');
SELECT letter.insert_letter_placeholder(E'[OFFICE_ADDRESS_NB]', E'OFFICE_ADDRESS', E'The number of the office''s address', E'/**
 * [OFFICE_ADDRESS_NB]
 */

var number;
 
try {
    // An office can, in theory, have more than one address (DB schema).
    // However, in practice there is only one, and hence the first is the only one.
    number = OFFICE.getOfficeAddress().iterator().next().getStreetNumber();
    }
catch (error) {
    number = null;
    }

number == null ? "" : number;');
SELECT letter.insert_letter_placeholder(E'[OFFICE_ADDRESS_STREET]', E'OFFICE_ADDRESS', E'The street of the office''s address', E'/**
 * [OFFICE_ADDRESS_STREET]
 */

var street;
 
try {
    // An office can, in theory, have more than one address (DB schema).
    // However, in practice there is only one, and hence the first is the only one.
    street = OFFICE.getOfficeAddress().iterator().next().getStreetName();
    }
catch (error) {
    street = null;
    }

street == null ? "" : street;');
SELECT letter.insert_letter_placeholder(E'[OFFICE_ADDRESS_ZIP]', E'OFFICE_ADDRESS', E'ZIP code of the office''s address', E'/**
 * [OFFICE_ADDRESS_ZIP]
 */

var zip;
 
try {
    // an office can, in theory, have more than one address (DB schema).
    // However, in practice there is only one and hence the first is the only one.
    zip = OFFICE.getOfficeAddress().iterator().next().getZip();
    }
catch (error) {
    zip = null;
    }

zip == null ? "" : zip;');
SELECT letter.insert_letter_placeholder(E'[OFFICE_FULL_ADDRESS]', E'OFFICE_ADDRESS', E'<html>The office''s full address. <br>Formatted in an address block <br>suited for the adress window of letters</html>', E'/**
 * [OFFICE_FULL_ADDRESS]
 */

// use the same formating as in the print template
FORMATTER.formatOfficeAddress();');
SELECT letter.insert_letter_placeholder(E'[OFFICE_FULL_ADDRESS_SINGLE_LINE]', E'OFFICE_ADDRESS', E'<html>The office''s full address. <br>Formatted in a single line<br>, suited e.g. as the return addresses </html>', E'/**
 * [OFFICE_FULL_ADDRESS_SINGLE_LINE]
 */

// use the same formating as in the print template
FORMATTER.formatOfficeLine();');
SELECT letter.insert_letter_placeholder(E'[OFFICE_FULL_SITE_ADDRESS]', E'OFFICE_ADDRESS', E'<html>The office''s site''s full address. <br>Formatted in an address block <br>suited for the adress window of letters</html>', E'/**
 * [OFFICE_FULL_SITE_ADDRESS]
 */
var adr = SITE.getSiteAddress();
 
// use the same formating as in the print template
FORMATTER.formatAddressBlock(adr);');
SELECT letter.insert_letter_placeholder(E'[PAT_ADDRESS_COUNTRY]', E'PATIENT_ADDRESS', E'<html>The country of the patient''s address.<br>Translated if possible.<html>', E'/**
 * [PAT_ADDRESS_COUNTRY]
 */

var adr = PATIENT.getHomeAddress();
 
tryTranslate("Country.", adr == null ? null : adr.getCountry());');
SELECT letter.insert_letter_placeholder(E'[PAT_ADDRESS_LOCALITY]', E'PATIENT_ADDRESS', E'The locality of the patient''s address', E'/**
 * [PAT_HOME_ADDRESS_LOCALITY]
 */

var adr = PATIENT.getHomeAddress()
 
adr == null ? "" : adr.getLocality();');
SELECT letter.insert_letter_placeholder(E'[PAT_ADDRESS_NB]', E'PATIENT_ADDRESS', E'The street numberof the patient''s address', E'/**
 * [PAT_HOME_ADDRESS_NB]
 */

var adr = PATIENT.getHomeAddress()
 
adr == null ? "" : adr.getStreetNumber();');
SELECT letter.insert_letter_placeholder(E'[PAT_ADDRESS_STREET]', E'PATIENT_ADDRESS', E'The street of the patient''s address', E'/**
 * [PAT_HOME_ADDRESS_STREET]
 */

var adr = PATIENT.getHomeAddress()
 
adr == null ? "" : adr.getStreetName();');
SELECT letter.insert_letter_placeholder(E'[PAT_ADDRESS_ZIP]', E'PATIENT_ADDRESS', E'The ZIP code of the patient''s home address', E'/**
 * [PAT_HOME_ADDRESS_ZIP]
 */

var adr = PATIENT.getHomeAddress()
 
adr == null ? "" : adr.getZip();');
SELECT letter.insert_letter_placeholder(E'[PAT_FULL_ADDRESS]', E'PATIENT_ADDRESS', E'<html>The patient''s full address. <br>Formatted in an address block <br>suited for the adress window of letters</html>', E'/**
 * [PAT_FULL_ADDRESS]
 */

// use the same formating as in the print template
FORMATTER.formatPatientHomeAddress();');
SELECT letter.insert_letter_placeholder(E'[PAT_FULL_NAME_AND_ADDRESS]', E'PATIENT_ADDRESS', E'The name and the address of the patient', E'/**
 * [PAT_FULL_NAME_AND_ADDRESS]
 */
FORMATTER.formatPatientName(PATIENT, true, false) + "\\n" + 
		FORMATTER.formatPatientHomeAddress();');
SELECT letter.insert_letter_placeholder(E'[PAT_CONTACT_ALL_PHONE_AND_EMAIL]', E'PATIENT_CONTACT', E'<html>The billing address for the PATIENT. <br>This can be different from the patient''s own address. <br> Therefore it''s called the "guarantor''s" address.</html>', E'/**
 * [PAT_CONTACT_ALL_PHONE_AND_EMAIL]
 */

var result = "";

var tel = PATIENT.getPhone("private");
var mobile = PATIENT.getPhone("mobile");
var work = PATIENT.getPhone("office");
var fax = PATIENT.getPhone("fax");
var email = PATIENT.getEmail();

if (tel != null && !tel.getNumber().length == 0)
	result = "Tel: " + tel.getNumber();

if (mobile != null && !mobile.getNumber().length == 0)
	result = result + (result.length == 0 ? "" : "\\n")
		+ "Mobile: " + mobile.getNumber();

if (work != null && !work.getNumber().length == 0)
	result = result + (result.length == 0 ? "" : "\\n")
		+ "Work: " + work.getNumber();

if (fax != null && !fax.getNumber().length == 0)
	result = result + (result.length == 0 ? "" : "\\n")
		+ "FAX: " + fax.getNumber();

if (email != null && !email.isEmpty())
	result = result + (result.length == 0 ? "" : "\\n")
		+ "eMail: " + email;

result;');
SELECT letter.insert_letter_placeholder(E'[PAT_CONTACT_ALL_PHONE_AND_EMAIL_SINGLE_LINE]', E'PATIENT_CONTACT', E'All the patient''s phone numbers and email addresses, in one single line', E'/**
 * [PAT_CONTACT_ALL_PHONE_AND_EMAIL_SINGLE_LINE]
 */

var result = "";

var tel = PATIENT.getPhone("private");
var mobile = PATIENT.getPhone("mobile");
var work = PATIENT.getPhone("office");
var fax = PATIENT.getPhone("fax");
var email = PATIENT.getEmail();

if (tel != null && !tel.getNumber().length == 0)
	result = "Tel: " + tel.getNumber();

if (mobile != null && !mobile.getNumber().length == 0)
	result = result + (result.length == 0 ? "" : "; ")
		+ "Mobile: " + mobile.getNumber();

if (work != null && !work.getNumber().length == 0)
	result = result + (result.length == 0 ? "" : "; ")
		+ "Work: " + work.getNumber();

if (fax != null && !fax.getNumber().length == 0)
	result = result + (result.length == 0 ? "" : "; ")
		+ "FAX: " + fax.getNumber();

if (email != null && !email.isEmpty())
	result = result + (result.length == 0 ? "" : "; ")
		+ "eMail: " + email;

result;');
SELECT letter.insert_letter_placeholder(E'[PAT_CONTACT_EMAIL]', E'PATIENT_CONTACT', E'The patient''s eMail address', E'/**
 * [PAT_CONTACT_EMAIL]
 */

PATIENT.getEmail() == null ? "" : PATIENT.getEmail();');
SELECT letter.insert_letter_placeholder(E'[PAT_CONTACT_FAX]', E'PATIENT_CONTACT', E'The patient''s FAX number', E'/**
 * [PAT_CONTACT_FAX]
 */

PATIENT.getPhone("fax") == null ? "" : PATIENT.getPhone("fax").getNumber();');
SELECT letter.insert_letter_placeholder(E'[PAT_CONTACT_MOBILE]', E'PATIENT_CONTACT', E'The patient''s mobile phone number', E'/**
 * [PAT_CONTACT_MOBILE]
 */

PATIENT.getPhone("mobile") == null ? "" : PATIENT.getPhone("mobile").getNumber();');
SELECT letter.insert_letter_placeholder(E'[PAT_CONTACT_PHONE_PRIVATE]', E'PATIENT_CONTACT', E'The patient''s private phone number', E'/**
 * [PAT_CONTACT_PHONE_PRIVATE]
 */

PATIENT.getPhone("private") == null ? "" : PATIENT.getPhone("private").getNumber();');
SELECT letter.insert_letter_placeholder(E'[PAT_CONTACT_PHONE_WORK]', E'PATIENT_CONTACT', E'The patient''s phone number at work', E'/**
 * [PAT_CONTACT_PHONE_WORK]
 */

PATIENT.getPhone("office") == null ? "" : PATIENT.getPhone("office").getNumber();');
SELECT letter.insert_letter_placeholder(E'[PAT_GENDER]', E'PATIENT_GENDER', E'The patient''s gender', E'/**
 * [PAT_GENDER]
 */
 
var gender = PATIENT.getGender();
gender == null ? "" : FORMATTER.translate("Gender." + gender);');
SELECT letter.insert_letter_placeholder(E'[PAT_GENDER_ABBREV]', E'PATIENT_GENDER', E'The patient''s gender, as a one letter abbreviation', E'/**
 * [PAT_GENDER_ABBREV]
 */
PATIENT.getGender() == null ? "" : PATIENT.getGender().substring(0,1).toUpperCase();');
SELECT letter.insert_letter_placeholder(E'[PAT_GENDER_FEMALE]', E'PATIENT_GENDER', E'"x" if the patient''s gender is "female"', E'/**
 * [PAT_GENDER_FEMALE]
 */
PATIENT.getGender() != null && PATIENT.getGender() == "female" ? "x" : "";');
SELECT letter.insert_letter_placeholder(E'[PAT_GENDER_MALE]', E'PATIENT_GENDER', E'"x" if the patient''s gender is "male"', E'/**
 * [PAT_GENDER_MALE]
 */
PATIENT.getGender() != null && PATIENT.getGender() == "male" ? "x" : "";');
SELECT letter.insert_letter_placeholder(E'[PAT_GENDER_OTHER]', E'PATIENT_GENDER', E'"x" if the patient''s gender is other than "male" or "female"', E'/**
 * [PAT_GENDER_OTHER]
 */
PATIENT.getGender() != null && PATIENT.getGender() != "male" && PATIENT.getGender() != "female" ? "x" : "";');
SELECT letter.insert_letter_placeholder(E'[PAT_FULL_GUARANTOR_ADDRESS]', E'PATIENT_GUARANTOR', E'<html>The billing address for the patient. <br>This can be different from the patient''s own address. <br> Therefore it''s called the "guarantor''s" address.</html>', E'/**
 * [PAT_FULL_GUARANTOR_ADDRESS]
 */

 // use the same formating as in the invoice print template
FORMATTER.formatGuarantorAddress(PATIENT);');
SELECT letter.insert_letter_placeholder(E'[PAT_FULL_GUARANTOR_NAME]', E'PATIENT_GUARANTOR', E'<html>The name of the person who''s goint to pay the bills. <br>This can be different from the patient''s himself. <br> Therefore he''s called the "guarantor".</html>', E'/**
 * [PAT_FULL_GUARANTOR_NAME]
 */

 // use the same formating as in the invoice print template
FORMATTER.formatGuarantorName(PATIENT, true, false);');
SELECT letter.insert_letter_placeholder(E'[PAT_GUARANTOR_COUNTRY]', E'PATIENT_GUARANTOR', E'The country of the patient''s guarantor', E'/**
 * [PAT_GUARANTOR_COUNTRY]
 */

var adr = PATIENT.getPatientContact()
 
adr == null ? "" : FORMATTER.translate("Country." + adr.getCountry());');
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_30_DAYS]', E'PATIENT_HISTORY', E'All history entries of the patient during the last 30 days', E'/**
 * [PAT_HISTORY_30_DAYS]
 */
getPatientHistoryXDays(30);');
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_3_DAYS]', E'PATIENT_HISTORY', E'All history entries of the patient during the last 3 days', E'/**
 * [PAT_HISTORY_3_DAYS]
 */
getPatientHistoryXDays(3);');
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_7_DAYS]', E'PATIENT_HISTORY', E'All history entries of the patient during the last 7 days', E'/**
 * [PAT_HISTORY_7_DAYS]
 */
getPatientHistoryXDays(7);');
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_ALL]', E'PATIENT_HISTORY', E'All history entries of the patient', E'/**
 * [PAT_HISTORY_ALL]
 */
var html = getPatientHistory(PATIENT, null, null, null);
//println(html);
html;');
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_LAST_CONSULTATION]', E'PATIENT_HISTORY', E'The last incident of the PATIENT, that contains an SOAP entry or a measurement', E'/**
 * [PAT_HISTORY_LAST_CONSULTATION]
 */
var types;
var incident;
var html;


types     = new Array();
types[0]  = "soap.s";
types[1]  = "soap.o";
types[2]  = "soap.a";
types[3]  = "soap.p";
types[4]  = "measurement";

incident = getPatientIncidents(PATIENT, types, null, null, 1);

if (incident != null)
{
	html  = new java.lang.StringBuilder(
			"<html>\\n<head><title>history</title></head>\\n" + 
			"<body><table border=\\"1\\" cellspacing=\\"0\\"><tbody>");
	html  = appendIncidentRows(incident, html);
	
	html.append("\\n</tbody></table></body></html>");
}
else
	html  = "";

html.toString();');
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_LAST_MONTH]', E'PATIENT_HISTORY', E'All history entries of the patient during last month', E'/**
 * [PAT_HISTORY_LAST_MONTH]
 */
var from = clearCalendar(new java.util.GregorianCalendar());
var to = clearCalendar(new java.util.GregorianCalendar());


from.set(java.util.Calendar.DAY_OF_MONTH, 1);
from.add(java.util.Calendar.MONTH, -1);
to.set(java.util.Calendar.DAY_OF_MONTH, 1);

getPatientHistory(PATIENT, null, from.getTime(), to.getTime());');
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_LAST_WEEK]', E'PATIENT_HISTORY', E'All history entries of the patient during the last week', E'/**
 * [PAT_HISTORY_LAST_WEEK]
 */
var from = clearCalendar(new java.util.GregorianCalendar());
var to = clearCalendar(new java.util.GregorianCalendar());


from.set(java.util.Calendar.DAY_OF_WEEK, from.getFirstDayOfWeek());
from.add(java.util.Calendar.WEEK_OF_YEAR, -1);
to.set(java.util.Calendar.DAY_OF_WEEK, to.getFirstDayOfWeek());

getPatientHistory(PATIENT, null, from.getTime(), to.getTime());');
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_THIS_MONTH]', E'PATIENT_HISTORY', E'All history entries of the patient during this month', E'/**
 * [PAT_HISTORY_THIS_MONTH]
 */
var from = clearCalendar(new java.util.GregorianCalendar());
var to = clearCalendar(new java.util.GregorianCalendar());


from.set(java.util.Calendar.DAY_OF_MONTH, 1);
to.set(java.util.Calendar.DAY_OF_MONTH, 1);
to.add(java.util.Calendar.MONTH, 1);

getPatientHistory(PATIENT, null, from.getTime(), to.getTime());');
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_THIS_WEEK]', E'PATIENT_HISTORY', E'All history entries of the patient during this week', E'/**
 * [PAT_HISTORY_THIS_WEEK]
 */
var from = clearCalendar(new java.util.GregorianCalendar());
var to = clearCalendar(new java.util.GregorianCalendar());


from.set(java.util.Calendar.DAY_OF_WEEK, from.getFirstDayOfWeek());
to.set(java.util.Calendar.DAY_OF_WEEK, to.getFirstDayOfWeek());
to.add(java.util.Calendar.WEEK_OF_YEAR, 1);

getPatientHistory(PATIENT, null, from.getTime(), to.getTime());');
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_TODAY]', E'PATIENT_HISTORY', E'All history entries of the patient of today', E'/**
 * [PAT_HISTORY_TODAY]
 */
getPatientHistoryXDays(1);');
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_YESTERDAY]', E'PATIENT_HISTORY', E'All history entries of the patient of yesterday', E'/**
 * [PAT_HISTORY_YESTERDAY]
 */
var from = clearCalendar(new java.util.GregorianCalendar());
var to = clearCalendar(new java.util.GregorianCalendar());


from.add(java.util.Calendar.DAY_OF_MONTH, -1);

getPatientHistory(PATIENT, null, from.getTime(), to.getTime());');
SELECT letter.insert_letter_placeholder(NULL, E'PATIENT_HISTORY', E'Functions available to all PATIENT_HISTORY placeholders', E'/**
 * PATIENT HISTORY FUNCTIONS
 */

function getPatientHistoryXDays (days)
{
	var from = clearCalendar(new java.util.GregorianCalendar());
	var to = clearCalendar(new java.util.GregorianCalendar());
	
	
	from.add(java.util.Calendar.DAY_OF_MONTH, -(days-1));
	to.add(java.util.Calendar.DAY_OF_MONTH, 1);
	
	return getPatientHistory(PATIENT, null, from.getTime(), to.getTime());
}

/**
 * Patient patient: The patient to get the history from
 * String[] types: The incident entry types to fetch
 * Date fromDate: The earliest date to get the history 
 * Date toDate: The latest date to get the history
 * return: The history of the patient as HTML
 */
function getPatientHistory (patient, types, fromDate, toDate)
{
	var incidents = getPatientIncidents(patient, types, fromDate, toDate, null);
	var html      = new java.lang.StringBuilder(
			"<html><head><title>history</title></head>\\n" + 
			"<body><table border=\\"1\\" cellspacing=\\"0\\"><tbody>");
	
	
	if (incidents == null || incidents.size() == 0)
		return "";
	
	for (var i = 0; i < incidents.size(); i++)
	{
		html = appendIncidentRows(incidents.get(i), html);
	}
	
	html.append("\\n</tbody></table></body></html>");
	
	return html.toString();
}


/**
 * Patient patient: The patient to get the history from
 * String[] types: The incident entry types to fetch. Leave it null, to select all types.
 * Date fromDate: The earliest date to get the history. Leave it null, to set no start date.
 * Date toDate: The latest date to get the history. Leave it null, to set no end date.
 * Integer max: The maximum number of results. Leave it null, to set no maximum.
 * return: The incidents of the patient.
 */
function getPatientIncidents (patient, types, fromDate, toDate, max)
{
	var query = new java.lang.StringBuilder();
	
	
	// define the query
	query.append("SELECT OBJECT(i)")
			.append("\\nFROM Incident i")
			.append(types == null ? "" : ", IncidentEntry e, IncidentEntryType t")
			.append("\\nWHERE i.patientId = ").append(patient.getId());
	if (types != null)
	{
		query.append("\\nAND i.id = e.incidentId")
			.append("\\nAND t.id = e.entryTypeId")
			.append("\\nAND t.name IN (");
		for (var i = 0; i < types.length; i++)
			query.append(i == 0 ? "''" : ", ''").append(types[i]).append("''");
		query.append(")\\n");
	}
	if (fromDate != null)
		query.append("\\nAND i.incidentDate > ").append("''"+FORMATTER.formatDate(fromDate, "yyyy-MM-dd")+"''");
	if (toDate != null)
		query.append("\\nAND i.incidentDate < ").append("''"+FORMATTER.formatDate(toDate, "yyyy-MM-dd")+"''");
	query.append("\\nORDER BY i.incidentDate DESC");
	
	if (max == null)
		return DATABASE_MANAGER.doHqlQuery(query.toString());
	else if (max == 1)
		return DATABASE_MANAGER.getHqlQueryObject(query.toString());
	else
		return DATABASE_MANAGER.doHqlQuery(query.toString(), null, max);
}


/**
 * IncidentEntry entry: The incident entry to format
 * StringBuilder html: The 
 * return: HTML of the data of the incident entry
 */
function appendIncidentRows (incident, html)
{
	var type;
	var entries;
	var rows;
	var incidentDate;
	var physician;
	var iter;
	var entry;
	var content;
	var isAccident;
	var list;
	
	
	// check
	entries      = incident.getIncidentEntries();
	if (entries == null || entries.isEmpty())
		return html;
	
	isAccident   = incident.getIsAccident().booleanValue();
	rows         = entries.size() + (isAccident ? 1 : 0);
	incidentDate = incident.getIncidentDate();
	physician    = getPhysician(incident.getPhysicianId());
	
	// define the row and the date / physician cell
	html.append("\\n<tr valign=\\"top\\">\\n  <td rowspan=\\"")
			.append(rows)
			.append("\\" nowrap><b>")
			.append(FORMATTER.formatDate(incidentDate))
			.append("</b><br/><div style=\\"font-size:10px\\">")
			.append(FORMATTER.formatDate(incidentDate, "HH:mm"))
			.append(" - ")
			.append(physician == null ? "" : physician.getMnemonic())
			.append("</div></td>\\n");
	
	if (isAccident)
		html.append("\\n  <td nowrap><i>")
				.append(tryTranslate("pm.", "accident"))
				.append("</i></td>\\n  <td>")
				.append(incident.getAccidentNr())
				.append(" - ")
				.append(FORMATTER.formatDate(incident.getAccidentDate()))
				.append("</td>\\n</tr>\\n<tr valign=\\"top\\">\\n");
	
	// run through the entries and add a row for each
	for (iter = entries.iterator(); iter.hasNext(); )
	{
		// get the current entry and its type
		entry = iter.next();
		type  = entry.getEntryType().getName();
		
		if (type == null
				|| type.startsWith("soap.")
				|| type.equals("letter")
				|| type.equals("form")
				|| type.equals("dicom"))
		{
			// this is the default way to get the content of an incident entry ... 
			// ... try to translate the type ...
			if (type == null || type.trim().length == 0)
				type = "";
			else
				type = tryTranslate("patient.incident.", type);
			
			// ... and get the text content.
			content = entry.getTextContent();
			
			if (content == null)
				content = "";
			else if (content.matches("\\\\A\\\\W*\\\\<(?i)html(?-i)\\\\>[\\\\W\\\\w]*"))
			{
				if (content.matches("\\\\A(\\\\W*\\\\<(?i)html(?-i)\\\\>\\\\W*)+\\\\<(?i)head(?-i)\\\\>[\\\\W\\\\w]*"))
					content = content.substring(content.indexOf("</head>") + 7);
				
				content = content
						.replace("<html>", "")
						.replace("</html>", "")
						.replace("<body", "<span")
						.replace("</body>", "</span>");
			}
			else
				content.replace("\\n", "<br/>");
		}
		else if (type.equals("file"))
		{
			// get the content for an attached file
			type    = tryTranslate("core.", type);
			content = entry.getTextContent();
			if (content == null || content.trim().length == 0)
				content = entry.getOriginalFilename();
			else 
				content = content + "<br/><i><div style=\\"font-size:12px\\">" + entry.getOriginalFilename() + "</i></div>";
		}
		else if (type.equals("prescription"))
		{
			// get the content for a presciption
			type    = tryTranslate("pm.", type);
			list    = DATABASE_MANAGER.doHqlQuery(
					"SELECT OBJECT(p) FROM Prescription p WHERE p.incidentEntryId = " + 
					entry.getId());
			
			if (list == null || list.isEmpty())
				// no prescription found
				content = "";
			else
				// get the text of the prescription
				content = list.get(0).getTextContent().replace("\\n", "<br/>");
		}
		else if (type.equals("measurement"))
		{
			// get the content for a measurement
			type    = tryTranslate("patient.incident.", type);
			content = getMeasurementContent(entry);
		}
		else if (type.equals("labo.result"))
		{
			// get the content for a labo result
			type    = tryTranslate("patient.history.", "labo");
			content = entry.getTextContent();
		}
		else
		{
			// show, that there is an error
			// NEED TO ADD A ROW, otherwise the table will be messed up
			content = entry.getTextContent();
			println("UNSUPPORTED TYPE: " + type + " (" + content + ")");
		}
		
		// replace the HTML start tag, as this may mess up the HTML table
		//content = content.replace("<html>", "");
		
		html.append("\\n  <td nowrap><i>")
				.append(type)
				.append("</i></td>\\n  <td>")
				.append(content)
				.append("</td>\\n</tr>");
		if (iter.hasNext())
			html.append("\\n<tr valign=\\"top\\">");
	}
	
	return html;
}


/**
 * IncidentEntry entry: The entry to fetch the measurements from
 * return: An HTML formatted string, representing the measurements
 */
function getMeasurementContent (entry)
{
	var values;
	var iter;
	var value;
	var type;
	var content = new java.lang.StringBuilder("\\n<span><table border=\\"0\\" cellspacing=\\"2\\"><tbody>\\n");
	var tabbed = false;
	
	
	// get the measurement values of the given incident entry
	values    = DATABASE_MANAGER.doHqlQuery(
			"SELECT OBJECT(v) FROM MeasurementValue v WHERE incidentEntryId = " + entry.getId());
	
	for (iter = values.iterator(); iter.hasNext(); )
	{
		value = iter.next();
		type  = value.getMeasurementType();
		
		// I know it''s evil, but it''s JavaScript ...
		value = type.isNumericType() ? value.getValueNumeric() : value.getValueString();
		
		if (value == null)
			// leave this value
			continue;
		
		if (!tabbed)
			content.append("    <tr valign=\\"top\\">");
		
		if (type.getAlias() != null && type.getAlias().trim().length() > 0)
			content.append("<td><b>")
					.append(type.getAlias())
					.append(": </b></td>")
		else
			content.append("<td />");
		content.append("<td><i>")
				.append(value)
				.append("</i> ")
				.append(type.getUnit())
				.append("</td>");
		
		if (tabbed)
			content.append("</tr>\\n");
		
		tabbed = !tabbed;
	}
	
	// if tabbed is true, the row is not closed
	if (tabbed)
		content.append("<td></td><td></td></tr>\\n");
	content.append("</tbody></table></span>\\n");
	
	
	return content.toString();
}');
SELECT letter.insert_letter_placeholder(E'[PAT_ID_EUROPE]', E'PATIENT_ID', E'The patient''s European ID', E'/**
 * [PAT_ID_EUROPE]
 */

PATIENT.getIdEuropean() == null ? "" : PATIENT.getIdEuropean()');
SELECT letter.insert_letter_placeholder(E'[PAT_ID_FUTURE_NATIONAL]', E'PATIENT_ID', E'The patient''s future national ID', E'/**
 * [PAT_ID_FUTURE_NATIONAL]
 */

PATIENT.getIdFutureNational() == null ? "" : PATIENT.getIdFutureNational()');
SELECT letter.insert_letter_placeholder(E'[PAT_ID_GECAMED]', E'PATIENT_ID', E'The patient''s internal GECAMed ID', E'/**
 * [PAT_ID_GECAMED]
 */

PATIENT.getId() + ""');
SELECT letter.insert_letter_placeholder(E'[PAT_ID_HIS_RIS]', E'PATIENT_ID', E'The patient''s HIS/RIS ID', E'/**
 * [PAT_ID_HIS_RIS]
 */

PATIENT.getIdRIS() == null ? "" : PATIENT.getIdRIS()');
SELECT letter.insert_letter_placeholder(E'[PAT_ID_LUX]', E'PATIENT_ID', E'The patient''s Lux ID', E'/**
 * [PAT_ID_LUX]
 */

PATIENT.getIdLuxembourg() == null ? "" : PATIENT.getIdLuxembourg()');
SELECT letter.insert_letter_placeholder(E'[PAT_ID_MR]', E'PATIENT_ID', E'The patient''s MR identification number (MR = Medecin Referent)', E'/**
 * [PAT_ID_MR]
 */

 var id = PATIENT.getMrDeclarationNo();
 
 id == null ? "" : id;');
SELECT letter.insert_letter_placeholder(E'[PAT_SSN]', E'PATIENT_ID', E'The patient''s SocialSecurity Number', E'/**
 * [PAT_SSN]
 */

// PATIENT.getSocialSecurityNumber() == null ? "" : PATIENT.getSocialSecurityNumber();

// use the same formating as in the print templates
var ssn = PATIENT.getSocialSecurityNumber();

FORMATTER.formatSSN(ssn);');
SELECT letter.insert_letter_placeholder(E'[PAT_SSN_SUFFIX]', E'PATIENT_ID', E'The suffix of the patient''s SocialSecurity Number. i.e. everything beyond the 8th digit', E'/**
 * [PAT_SSN_SUFFIX]
 */

PATIENT.getSocialSecurityNumber() == null ? "" : 
    PATIENT.getSocialSecurityNumber().substring(8).trim();');
SELECT letter.insert_letter_placeholder(E'[PAT_BIRTHDATE]', E'PATIENT_INFO', E'The patient''s birthdate', E'/**
 * [PAT_BIRTHDATE]
 */

PATIENT.getBirthDate() == null ? "" : 
    FORMATTER.formatDate(PATIENT.getBirthDate());');
SELECT letter.insert_letter_placeholder(E'[PAT_BIRTHPLACE]', E'PATIENT_INFO', E'The patient''s birthplace', E'/**
 * [PAT_BIRTHPLACE]
 */

PATIENT.getBirthLocality() == null ? "" : PATIENT.getBirthLocality();');
SELECT letter.insert_letter_placeholder(E'[PAT_INSURANCE_COMPLEMENTARY]', E'PATIENT_INFO', E'The patient''s complementary insurance policy', E'/**
 * [PAT_INSURANCE_COMPLEMENTARY]
 */
var insurance = PATIENT.getComplementary();
 
insurance == null ? "" : insurance.getName();');
SELECT letter.insert_letter_placeholder(E'[PAT_INSURANCE_PRIMARY]', E'PATIENT_INFO', E'The patient''s primary insurance company, full name', E'/**
 * [PAT_INSURANCE_PRIMARY]
 */
var insurance = PATIENT.getInsurance();
 
insurance == null ? "" : insurance.getName();');
SELECT letter.insert_letter_placeholder(E'[PAT_INSURANCE_PRIMARY_SHORT]', E'PATIENT_INFO', E'The patient''s primary insurance company', E'/**
 * [PAT_INSURANCE_PRIMARY_SHORT]
 */
var insurance = PATIENT.getInsurance();
 
insurance == null ? "" : insurance.getAcronym();');
SELECT letter.insert_letter_placeholder(E'[PAT_MARITAL_STATUS]', E'PATIENT_INFO', E'The patient''s marital status', E'/**
 * [PAT_MARITAL_STATUS]
 */
 
tryTranslate("MaritalStatus.", PATIENT.getMaritalStatus());');
SELECT letter.insert_letter_placeholder(E'[PAT_ACTIVE_PROBLEMS]', E'PATIENT_MEDICAL', E'The active problems of the patient as text as entered in GECAMed', E'/**
 * [PAT_ACTIVE_PROBLEMS]
 */
var text = "";
var patientDatas = getPatientDatas(PATIENT.getId());
if (patientDatas != null)
{
	text = patientDatas.getActiveProblem();
	if (text == null)
		text = "";
}
text;');
SELECT letter.insert_letter_placeholder(E'[PAT_ALLERGIES]', E'PATIENT_MEDICAL', E'The allergies of the patient', E'/**
 * [PAT_ALLERGIES]
 */
var allergies = getPatientAllergies(PATIENT.getId());
var iter;
var element;
var text = new java.lang.StringBuilder();


if (allergies != null)
{
	iter = allergies.iterator();
	while (iter.hasNext())
	{
		element = iter.next();
		text.append(element.getAllergenName());
		if (element.getComment() != null && !("".equals(element.getComment()))) 
		{
		    text.append(" (").append(element.getComment()).append(")");
		}
		if (iter.hasNext())
			text.append("\\n");
	}
}
text.toString();');
SELECT letter.insert_letter_placeholder(E'[PAT_ANTECEDENTS]', E'PATIENT_MEDICAL', E'The antecedents of the patient', E'/**
 * [PAT_ANTECEDENTS]
 */
var text = new java.lang.StringBuffer("");
var antecedents = getPatientAntecedents(PATIENT.getId());
var iter;
var desc;
var element;


if (antecedents != null)
{
	iter = antecedents.iterator();
    while (iter.hasNext()) 
    {
		element = iter.next();
		text.append("<b>").append(element.getShortcut()).append("</b>");
		desc = element.getDescription();
		if (desc != null && desc.trim().length() > 0) 
			text.append(desc);
		else
			text.append("<br>");
    }
}
text = text.toString()
		.replaceAll("\\\\</?(html|head|body)\\\\>", "");
"<html>" + text + "</html>";');
SELECT letter.insert_letter_placeholder(E'[PAT_CHRONIC_TREATMENTS]', E'PATIENT_MEDICAL', E'The chronic treatments of the patient as text as entered in GECAMed', E'/**
 * [PAT_CHRONICLE_TREATMENTS]
 */
var text = "";
var patientDatas = getPatientDatas(PATIENT.getId());
if (patientDatas != null)
{
	text = patientDatas.getChronicalTreatments();
	if (text == null)
		text = "";
}
text;
');
SELECT letter.insert_letter_placeholder(NULL, E'PATIENT_MEDICAL', E'Functions available to all PATIENT_MEDICAL placeholders', E'/**
 * PATIENT_MEDICAL FUNCTIONS
 */

/**
 * The bean PatientDatas contains the chronicle treatments (getChronicalTreatments()) 
 * and the active problems (getActiveProblem()) of a patient as string
 * 
 * int patientId: The ID of the patient to get the data from
 * return: The PatientDatas bean of the specified patient
 */
function getPatientDatas (patientId)
{
	var query = "SELECT OBJECT(o) FROM PatientDatas o WHERE o.patientId = " + patientId;
	
	return DATABASE_MANAGER.getHqlQueryObject(query);
}



/**
 * int patientId: The ID of the patient to get the allergies from
 * return: A list of allergies, entered for the patient with the specified ID
 */
function getPatientAllergies (patientId)
{
	var query = "SELECT OBJECT(o) FROM Allergies o" +
		"\\nWHERE o.patientId = " + patientId + 
		"\\nAND o.deletionDate IS NULL" +
		"\\nORDER BY o.created DESC";
	return DATABASE_MANAGER.doHqlQuery(query);
}



/**
 * int patientId: The ID of the patient to get the antecedents from
 * return: A list of antecedents, entered for the patient with the specified ID
 */
function getPatientAntecedents (patientId)
{
	var userId = USER.getId();
	var query = "SELECT OBJECT(o) FROM Antecedents o" +
			"\\nWHERE o.patientId = " + patientId + 
			"\\nAND o.deletedDate IS NULL" +
			"\\nAND" +
			"\\n((o.lockedBy IS NOT NULL" +
			"\\n  AND o.lockedBy = " + userId + ")" +
			"\\n  OR o.lockedBy IS NULL)" +
			"\\nORDER BY o.created DESC";
	return DATABASE_MANAGER.doHqlQuery(query);
}');
SELECT letter.insert_letter_placeholder(E'[PAT_FIRST_NAMES]', E'PATIENT_NAME', E'The patient''s first name', E'/**
 * [PAT_FIRST_NAMES]
 */
toString(PATIENT.getFirstName());');
SELECT letter.insert_letter_placeholder(E'[PAT_FULL_NAME]', E'PATIENT_NAME', E'The patient''s full name, with title', E'/**
 * [PAT_FULL_NAME]
 */
toString(FORMATTER.formatPatientName(true, false));');
SELECT letter.insert_letter_placeholder(E'[PAT_LAST_NAME]', E'PATIENT_NAME', E'The patient''s name', E'/**
 * [PAT_LAST_NAME]
 */
toString(PATIENT.getSurName());');
SELECT letter.insert_letter_placeholder(E'[PAT_MAIDEN_NAME]', E'PATIENT_NAME', E'The patient''s given name', E'/**
 * [PAT_MAIDEN_NAME]
 */
toString(PATIENT.getMaidenName());');
SELECT letter.insert_letter_placeholder(E'[PAT_TITLE_LONG]', E'PATIENT_NAME', E'The patient''s long title: M., Mme, Mlle (FR) - Herr, Frau, Fräulein (DE) - Mr., Mrs. Ms. (EN)"Monsieur, Madame, Mademoiselle (FR) - Herr, Frau, Fräulein (DE) - Sir, Madam, Miss (EN)', E'/**
 * [PAT_TITLE_LONG]
 */
toString(FORMATTER.translate("Title.Long." + PATIENT.getTitle()));');
SELECT letter.insert_letter_placeholder(E'[PAT_TITLE_SHORT]', E'PATIENT_NAME', E'The patient''s short title: M., Mme, Mlle (FR) - Herr, Frau, Fräulein (DE) - Mr., Mrs. Ms. (EN)', E'/**
 * [PAT_TITLE_SHORT]
 */
toString(FORMATTER.translate("Title." + PATIENT.getTitle()));');
SELECT letter.insert_letter_placeholder(E'[PHYS_ALL_PHONE_AND_EMAIL]', E'PHYSICIAN', E'The physician''s phone numbers and email, on seperate lines', E'/**
 * [PHYS_ALL_PHONE_AND_EMAIL]
 */

var result = "";

var phone = PHYSICIAN.getPhoneExtension();
var mobile = PHYSICIAN.getGsm();
var fax = PHYSICIAN.getFax();
var email = PHYSICIAN.getEmail();

if (phone != null && !phone.isEmpty())
	result = "Tel: " + phone;

if (mobile != null && !mobile.isEmpty())
	result = result + (result.length == 0 ? "" : "\\n")
		+ "Mobile: " + mobile;

if (fax != null && !fax.isEmpty())
	result = result + (result.length == 0 ? "" : "\\n")
		+ "FAX: " + fax;

if (email != null && !email.isEmpty())
	result = result + (result.length == 0 ? "" : "\\n")
		+ "eMail: " + email;

result;');
SELECT letter.insert_letter_placeholder(E'[PHYS_ALL_PHONE_AND_EMAIL_SINGLE_LINE]', E'PHYSICIAN', E'The physician''s phone numbers and email, in one single line', E'/**
 * [PHYS_ALL_PHONE_AND_EMAIL_SINGLE_LINE]
 */

var result = "";
var phone = PHYSICIAN.getPhoneExtension();
var mobile = PHYSICIAN.getGsm();
var fax = PHYSICIAN.getFax();
var email = PHYSICIAN.getEmail();

if (phone != null && !phone.isEmpty())
	result = "Tel: " + phone;

if (mobile != null && !mobile.isEmpty())
	result = result + (result.length == 0 ? "" : "; ")
		+ "Mobile: " + mobile;

if (fax != null && !fax.isEmpty())
	result = result + (result.length == 0 ? "" : "; ")
		+ "FAX: " + fax;

if (email != null && !email.isEmpty())
	result = result + (result.length == 0 ? "" : "; ")
		+ "eMail: " + email;

result;');
SELECT letter.insert_letter_placeholder(E'[PHYS_CNS_CODE]', E'PHYSICIAN', E'The physician''s CNS code', E'/**
 * [PHYS_CNS_CODE]
 */

PHYSICIAN.getUcmCode() == null ? "" : PHYSICIAN.getUcmCode();');
SELECT letter.insert_letter_placeholder(E'[PHYS_EMAIL]', E'PHYSICIAN', E'The physician''s eMail address', E'/**
 * [PHYS_EMAIL]
 */

PHYSICIAN.getEmail() == null ? "" : PHYSICIAN.getEmail();');
SELECT letter.insert_letter_placeholder(E'[PHYS_FAX]', E'PHYSICIAN', E'The physician''s fax number', E'/**
 * [PHYS_FAX]
 */

PHYSICIAN.getFax() == null ? "" : PHYSICIAN.getFax();');
SELECT letter.insert_letter_placeholder(E'[PHYS_FIRST_NAMES]', E'PHYSICIAN', E'The physician''s first names', E'/**
 * [PHYS_FIRST_NAMES]
 */

PHYSICIAN.getFirstName() == null  
   ? "" :PHYSICIAN.getFirstName();');
SELECT letter.insert_letter_placeholder(E'[PHYS_FULL_NAME]', E'PHYSICIAN', E'The physician''s full name, with title', E'/**
 * [PHYS_FULL_NAME]
 */

// use the same formating as in the print template
FORMATTER.formatPhysicianName(true) ;');
SELECT letter.insert_letter_placeholder(E'[PHYS_LAST_NAME]', E'PHYSICIAN', E'The physician''s last name', E'/**
 * [PHYS_LAST_NAME]
 */

PHYSICIAN.getName() == null  
   ? "" :PHYSICIAN.getName();');
SELECT letter.insert_letter_placeholder(E'[PHYS_MOBILE]', E'PHYSICIAN', E'The physician''s cell phone number', E'/**
 * [PHYS_MOBILE]
 */

PHYSICIAN.getGsm() == null ? "" : PHYSICIAN.getGsm();');
SELECT letter.insert_letter_placeholder(E'[PHYS_PHONE]', E'PHYSICIAN', E'The physician''s phone number', E'/**
 * [PHYS_PHONE]
 */

PHYSICIAN.getPhoneExtension() == null ? "" : PHYSICIAN.getPhoneExtension();');
SELECT letter.insert_letter_placeholder(E'[PHYS_SPECIALTY]', E'PHYSICIAN', E'The physician''s medical specialty', E'/**
 * [PHYS_SPECIALTY]
 */

PHYSICIAN.getSpeciality() == null ? "" : PHYSICIAN.getSpeciality();');
SELECT letter.insert_letter_placeholder(E'[PHYS_TITLE]', E'PHYSICIAN', E'The physician''s title', E'/**
 * [PHYS_TITLE]
 */

PHYSICIAN.getTitle() == null  
   ? "" :PHYSICIAN.getTitle();');
SELECT letter.insert_letter_placeholder(E'[PHYS_ADDRESS_COUNTRY]', E'PHYSICIAN_ADDRESS', E'The country of the physician''s address', E'/**
 * [PHYS_ADDRESS_COUNTRY]
 */
var adr = PHYSICIAN.getPhysicianAddress();
 
tryTranslate("Country.", adr == null ? null : adr.getCountry());');
SELECT letter.insert_letter_placeholder(E'[PHYS_ADDRESS_LOCALITY]', E'PHYSICIAN_ADDRESS', E'The locality of the physician''s address', E'/**
 * [PHYS_ADDRESS_LOCALITY]
 */

var adr = PHYSICIAN.getPhysicianAddress();

adr == null ? "" : (adr.getStreetNumber() == null ? "" : adr.getLocality());');
SELECT letter.insert_letter_placeholder(E'[PHYS_ADDRESS_NB]', E'PHYSICIAN_ADDRESS', E'The street number of the physician''s address', E'/**
 * [PHYS_ADDRESS_NB]
 */

var adr = PHYSICIAN.getPhysicianAddress();

adr == null ? "" : (adr.getStreetNumber() == null ? "" : adr.getStreetNumber());');
SELECT letter.insert_letter_placeholder(E'[PHYS_ADDRESS_STREET]', E'PHYSICIAN_ADDRESS', E'The street name of the physician''s address', E'/**
 * [PHYS_ADDRESS_STREET]
 */

var adr = PHYSICIAN.getPhysicianAddress();

adr == null ? "" : (adr.getStreetNumber() == null ? "" : adr.getStreetName());');
SELECT letter.insert_letter_placeholder(E'[PHYS_ADDRESS_ZIP]', E'PHYSICIAN_ADDRESS', E'The ZIP code of the physician''s address', E'/**
 * [PHYS_ADDRESS_ZIP]
 */

var adr = PHYSICIAN.getPhysicianAddress();

adr == null ? "" : (adr.getStreetNumber() == null ? "" : adr.getZip());');
SELECT letter.insert_letter_placeholder(E'[PHYS_FULL_ADDRESS]', E'PHYSICIAN_ADDRESS', E'<html>The physician''s full address. <br>Formatted in an address block <br>suited for the adress window of letters</html>', E'/**
 * [PHYS_FULL_ADDRESS]
 */

// use the same formating as in the print template
FORMATTER.formatPhysicianAddress();');
SELECT letter.insert_letter_placeholder(E'[PHYS_FULL_ADDRESS_SINGLE_LINE]', E'PHYSICIAN_ADDRESS', E'<html>The physician''s full address. <br>Formatted on a single line</html>', E'/**
 * [PHYS_FULL_ADDRESS_SINGLE_LINE]
 */

// use the same formating as in the print template
FORMATTER.formatPhysicianLine();');
SELECT letter.insert_letter_placeholder(NULL, NULL, E'Global functions, always charged', E'/**
 * GLOBAL FUNCTIONS
 */

/**
 * Takes the object and returns emtpy string, if it is null,
 * otherwise it creates a string out of it.
 */
function toString (o)
{
	return o == null ? "" : o.toString().trim();
}


/**
 * Tries to translate ''label'' into the user''s chosen language.
 * This is done by concatenating ''prefix'' to the ''label'' 
 * and sending it to the GECAMed translatlor. If it can be translated,
 * than the translation is returned, If not the ''label'' is returned.
 */
function tryTranslate (prefix, label)
{
	var translation;
	
	
	if (label == null)
		return "";
	if (prefix == null)
		prefix = "";
	
    // Concats the label onto the prefix string and tries to translate
    // them by calling FORMATTER.translate().
	translation = FORMATTER.translate(prefix+label);
	
    // If this translation returns null, the label is returned.
	if (translation == null)
		return label;
	else
		return translation;
}


/**
 * Calendar cal: The calendar to clear
 * return: The given calendar, with unchanged date, but
 * time set to 00:00:00.000
 */
function clearCalendar(cal)
{
	cal.set(java.util.Calendar.HOUR_OF_DAY, 0);
	cal.set(java.util.Calendar.MINUTE, 0);
	cal.set(java.util.Calendar.SECOND, 0);
	cal.set(java.util.Calendar.MILLISECOND, 0);
	
	return cal;
}


/**
 * int id: the physician ID
 * return: the physician with the given ID
 */
function getPhysician (id)
{
	var iter = PHYSICIAN_LIST.iterator();
	var p;
	
	
	while (iter.hasNext())
	{
		p = iter.next();
		if (p.getId().equals(id))
			// physician found!
			return p;
	}
	
	// no physician found, with the specified ID
	return null;
}');


/* ********************************************************************** */

/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.2.07_001.sql');