/* ********************************************************************** */
/*                            UPDATE 1.3.00_006                                  */
/* ---------------------------------------------------------------------- */

-- add permissions
INSERT INTO usermanagement.permission (name, description) 
VALUES 
('ReportModule.useReports','User is allowed to use reports'),
('ReportModule.createReports', 'User is allowed to create new reports');

-- add roles
INSERT INTO usermanagement.role (name, description) 
VALUES 
('ReportModule.admin', 'Use and create reports'),
('ReportModule.user', 'Use created reports');

-- add permissions to roles
INSERT INTO usermanagement.rel_role_permission (role_id,permission_id) 
VALUES 
-- assign permissions for admin 
((SELECT id FROM usermanagement.role WHERE name='PatientModule.admin'),
	(SELECT id FROM usermanagement.permission WHERE name='ReportModule.useReports')),
((SELECT id FROM usermanagement.role WHERE name='PatientModule.admin'),
	(SELECT id FROM usermanagement.permission WHERE name='ReportModule.createReports')),
-- assign permissions for report module admin
((SELECT id FROM usermanagement.role WHERE name='ReportModule.admin'),
	(SELECT id FROM usermanagement.permission WHERE name='ReportModule.useReports')),
((SELECT id FROM usermanagement.role WHERE name='ReportModule.admin'),
	(SELECT id FROM usermanagement.permission WHERE name='ReportModule.createReports')),
-- assign permissions for report module user
((SELECT id FROM usermanagement.role WHERE name='ReportModule.user'),
	(SELECT id FROM usermanagement.permission WHERE name='ReportModule.useReports'));
-- assign permissions for report module user
--((SELECT id FROM usermanagement.role WHERE name='PatientModule.physician'),
--	(SELECT id FROM usermanagement.permission WHERE name='ReportModule.useReports'));


-- ADD PARAMETER QUERIES
INSERT INTO reporting.parameter_query
(name, comment, query)
VALUES
('Physicians', 'Returns the ID of the selected physician', 'SELECT NULL AS value, '''' AS label UNION SELECT id, (name || '', '' || first_name) AS label FROM office.physician ORDER BY label'),
('Incident Entry Types', 'Returns the ID of the selected incident entry type', 'SELECT NULL AS value, '''' AS label UNION SELECT id, name FROM patient.incident_entry_types'),
('Incident Entry Statuses', 'Returns the name of the incident entry status', 'SELECT NULL AS value, '''' AS label UNION SELECT status, status FROM patient.incident_entry WHERE status IS NOT NULL ORDER BY value');


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.3.00_006.sql');
