/* ********************************************************************** */
/*                            UPDATE 1.3.02_001                           */
/* ---------------------------------------------------------------------- */

-- majoration of deleted and former deleted invoices corrected

UPDATE billing.trashed_invoice inv
SET majoration = (
  SELECT ins.majoration FROM patient.insurance ins
  WHERE inv.insurance_id = ins.id
)
WHERE majoration IS NULL;

UPDATE billing.invoice inv
SET majoration = (
  SELECT ins.majoration FROM patient.insurance ins
  WHERE inv.insurance_id = ins.id
)
WHERE majoration IS NULL;


-- ALTER the trashed_act table

ALTER TABLE billing.trashed_act
  ADD COLUMN hospitalisation_class	CHAR(1) DEFAULT NULL,
  ADD COLUMN majoration 			FLOAT DEFAULT 1,
  ADD COLUMN fix_amount 			FLOAT DEFAULT NULL,
  ADD COLUMN amount					FLOAT DEFAULT NULL,
  ADD COLUMN org_coefficient		FLOAT DEFAULT NULL;

-- UPDATE the new values of the trashed_act table
UPDATE billing.act a
SET majoration = (
  SELECT majoration FROM billing.invoice i 
  WHERE i.id = a.invoice_id
)
WHERE majoration IS NULL;

UPDATE billing.act a
SET hospitalisation_class = (
  SELECT h.acronym FROM patient.hospitalisation_class h, billing.invoice i 
  WHERE i.id = a.invoice_id
  AND i.class_id = h.id
)
WHERE hospitalisation_class IS NULL;

UPDATE billing.trashed_act a
SET majoration = (
  SELECT majoration FROM billing.trashed_invoice i 
  WHERE i.id = a.invoice_id
), 
hospitalisation_class = (
  SELECT h.acronym FROM patient.hospitalisation_class h, billing.trashed_invoice i 
  WHERE i.id = a.invoice_id
  AND i.class_id = h.id
);


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.3.02_001.sql');
