/* ********************************************************************** */
/*                            UPDATE 1.3.02_002                           */
/* ---------------------------------------------------------------------- */
-- Patient search changement

-- add search column to patient table
ALTER TABLE patient.patient
ADD COLUMN search TEXT;


-- add search column to patient stub 
DROP VIEW IF EXISTS patient.patient_stub;
CREATE OR REPLACE VIEW patient.patient_stub AS
SELECT patient.id, patient.social_security_number, patient.sur_name, patient.first_name, patient.maiden_name, patient.gender, patient.insurance_id,
	(TRIM (trailing E'\n' FROM 
		(SELECT concat(((((((((address.zip::text || ' '::text) || address.locality::text) || ' '::text) || address.streetnumber::text) || ', '::text) || address.streetname::text) || ' - '::text) || address.country::text) || E'\n'::text) 
		FROM patient.patient sub_p1
		LEFT JOIN patient.patient_address address ON sub_p1.id = address.patient_id 
		WHERE sub_p1.id = patient.id))) as address,
	(TRIM (trailing E'\n' FROM 
		(SELECT concat(((phone.type::text || ': '::text) || phone.number::text) || E'\n'::text)
		FROM patient.patient sub_p2
		LEFT JOIN patient.patient_phone phone ON sub_p2.id = phone.patient_id
		WHERE sub_p2.id = patient.id))) as phone, patient.doctor_id,
	patient.search
FROM patient.patient patient;


-- create unaccent function
CREATE OR REPLACE FUNCTION patient.unaccent (TEXT)
  RETURNS TEXT AS $$
BEGIN
  IF $1 IS NULL
  THEN
    RETURN '';
  ELSE
    RETURN regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace(
        regexp_replace($1, 
            E'[ÀÁÂÃÄÅĀÆĂ]', 'A', 'g'), 
            E'[àáâãäåæāă]', 'a', 'g'), 
            E'[ÇČĆ]', 'C', 'g'), 
            E'[çčć]', 'c', 'g'), 
            E'[ĐĎ]', 'D', 'g'),
            E'[đ]', 'd', 'g'),
            E'[ÈÉÊËĒ]', 'E', 'g'), 
            E'[èéêëē]', 'e', 'g'), 
            E'[Ğ]', 'G', 'g'),
            E'[ğ]', 'g', 'g'),
            E'[ÌÍÎÏĪ]', 'I', 'g'), 
            E'[ìíîïī]', 'i', 'g'), 
            E'[ÑŇ]', 'N', 'g'), 
            E'[ñň]', 'n', 'g'), 
            E'[ÒÓÔÕÖØŌŒ]', 'O', 'g'), 
            E'[òóôõöøōœ]', 'o', 'g'), 
            E'[Ř]', 'R', 'g'),
            E'[ř]', 'r', 'g'),
            E'[Š]', 'S', 'g'),
            E'[š]', 's', 'g'),
            E'[Ť]', 'T', 'g'),
            E'[ÙÚÛŨÜŪ]', 'U', 'g'), 
            E'[ùúûũüū]', 'u', 'g'), 
            E'[ŸÝ]', 'Y', 'g'), 
            E'[ÿý]', 'y', 'g'),
            E'[ŽŹŻ]', 'Z', 'g'),
            E'[žźż]', 'z', 'g');
  END IF;
END;
$$ LANGUAGE plpgsql IMMUTABLE;


-- create function to compare text, considering NULL values
CREATE OR REPLACE FUNCTION not_equals (TEXT, TEXT)
  RETURNS BOOLEAN AS $BODY$
BEGIN
  RETURN ($1 IS NULL AND $2 IS NOT NULL)
      OR ($1 IS NOT NULL AND $2 IS NULL)
      OR ($1 <> $2);
END
$BODY$ LANGUAGE plpgsql;


-- create search update trigger function for updates
CREATE OR REPLACE FUNCTION patient.update_search_column_func ()
  RETURNS TRIGGER AS $$
BEGIN
  IF     not_equals(OLD.first_name, NEW.first_name)
      OR not_equals(OLD.sur_name, NEW.sur_name)
      OR not_equals(OLD.maiden_name, NEW.maiden_name)
      OR not_equals(OLD.social_security_number, NEW.social_security_number)
  THEN
    UPDATE patient.patient 
    SET search = ' '
      || UPPER(patient.unaccent(NEW.first_name)) || ' ' 
      || UPPER(patient.unaccent(NEW.sur_name))   || ' ' 
      || UPPER(patient.unaccent(NEW.maiden_name))|| ' ' 
      || UPPER(patient.unaccent(NEW.social_security_number))
    WHERE id = NEW.id;
  END IF;

  RETURN NEW;
END 
$$ LANGUAGE plpgsql;

-- create search update trigger function
CREATE OR REPLACE FUNCTION patient.insert_search_column_func ()
  RETURNS TRIGGER AS $$
BEGIN
  UPDATE patient.patient 
  SET search = ' '
    || UPPER(patient.unaccent(NEW.first_name)) || ' ' 
    || UPPER(patient.unaccent(NEW.sur_name))   || ' ' 
    || UPPER(patient.unaccent(NEW.maiden_name))|| ' ' 
    || UPPER(patient.unaccent(NEW.social_security_number))
  WHERE id = NEW.id;
  
  RETURN NEW;
END
$$ LANGUAGE plpgsql;


-- initialize the search column
UPDATE patient.patient 
SET search = ' '
  || UPPER(patient.unaccent(first_name)) || ' ' 
  || UPPER(patient.unaccent(sur_name))   || ' ' 
  || UPPER(patient.unaccent(maiden_name))|| ' '
  || UPPER(patient.unaccent(social_security_number));


-- create search update trigger
DROP TRIGGER IF EXISTS update_search_colmn_trig ON patient.patient;
CREATE TRIGGER update_search_colmn_trig 
AFTER UPDATE ON patient.patient
FOR EACH ROW
EXECUTE PROCEDURE patient.update_search_column_func();


-- create search insert trigger
DROP TRIGGER IF EXISTS insert_search_colmn_trig ON patient.patient;
CREATE TRIGGER insert_search_colmn_trig 
AFTER INSERT
ON patient.patient
FOR EACH ROW
EXECUTE PROCEDURE patient.insert_search_column_func();


-- create search index
DROP INDEX IF EXISTS patient.idx_patient_patient_search;
CREATE INDEX idx_patient_patient_search 
ON patient.patient 
USING btree
(search);



/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.3.02_002.sql');
