/* ********************************************************************** */
/*                            UPDATE 2.00.02_002                           */
/* ---------------------------------------------------------------------- */

-- change the JavaScript function to make it work for Nashorn under Java 8
-- and some bugfixes added

-- THE FUNCTION TO INSERT OR UPDATE A NEW PLACEHOLDER
CREATE OR REPLACE FUNCTION letter.insert_letter_placeholder (p_name VARCHAR, p_type VARCHAR, p_comment TEXT, p_script TEXT)
	RETURNS void AS
$BODY$

DECLARE
	r RECORD;
	count INTEGER;
	
BEGIN
	count = 0;
	FOR r IN SELECT p.name FROM letter.placeholders p 
	WHERE p.name = p_name 
	OR (
		p.name IS NULL AND p_name IS NULL
		AND (
			p.type = p_type
			OR (
				p.type IS NULL AND p_type IS NULL
			)
		)
	)
	LOOP
		count = count + 1;
	END LOOP;

	
	IF count = 0 THEN
		INSERT INTO letter.placeholders
		(name, type, comment, script)
		VALUES
		(p_name, p_type, p_comment, p_script );
	ELSE
		UPDATE letter.placeholders p
		SET comment = p_comment,
			script = p_script
		WHERE p.name = p_name 
		OR (
			p.name IS NULL AND p_name IS NULL
			AND (
				p.type = p_type
				OR (
					p.type IS NULL AND p_type IS NULL
				)
			)
		);
	END IF;
	
	RETURN;
END
$BODY$
LANGUAGE plpgsql;


-- println removed, because this isn't allowed in nashorn
SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_ALL]', E'PATIENT_HISTORY', E'All history entries of the patient as a table', E'/**
 * [PAT_HISTORY_ALL]
 */
var html = getPatientHistory(PATIENT, null, null, null);
html;');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_ALL_TEXT]', E'PATIENT_HISTORY', E'All history entries of the patient as text instead of a table', E'/**
 * [PAT_HISTORY_ALL_TEXT]
 */
var html = getPatientHistory(PATIENT, null, null, null, false);
html;');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_30_DAYS_TEXT]', E'PATIENT_HISTORY', E'All history entries of the patient during the last 30 days as text (not as table)', E'/**
 * [PAT_HISTORY_30_DAYS_TEXT]
 */
var html = getPatientHistoryXDays(30, false);
html;');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_3_DAYS_TEXT]', E'PATIENT_HISTORY', E'All history entries of the patient during the last 3 days as text (not as table)', E'/**
 * [PAT_HISTORY_3_DAYS_TEXT]
 */
var html = getPatientHistoryXDays(3, false);
html;');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_7_DAYS_TEXT]', E'PATIENT_HISTORY', E'All history entries of the patient during the last 7 days as text (not as table)', E'/**
 * [PAT_HISTORY_7_DAYS_TEXT]
 */
var html = getPatientHistoryXDays(7, false);
html;');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_LAST_CONSULTATION_TEXT]', E'PATIENT_HISTORY', E'The last incident of the PATIENT, that contains an SOAP entry or a measurement as text (not as a table)', E'/**
 * [PAT_HISTORY_LAST_CONSULTATION_TEXT]
 */
var types;
var incident;
var html;


types     = new Array();
types[0]  = "soap.s";
types[1]  = "soap.o";
types[2]  = "soap.a";
types[3]  = "soap.p";
types[4]  = "measurement";

incident = getPatientIncidents(PATIENT, types, null, null, 1);

if (incident != null)
{
	html  = new java.lang.StringBuilder(
			"<html>\\n<head><title>history</title></head>\\n");
	html  = appendIncidentRows(incident, html, false);
	
	html.append("\\n</body></html>");
}
else
	html  = "";

html.toString();');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_LAST_MONTH_TEXT]', E'PATIENT_HISTORY', E'All history entries of the patient during last month as text (not as a table).', E'/**
 * [PAT_HISTORY_LAST_MONTH_TEXT]
 */
var from = clearCalendar(new java.util.GregorianCalendar());
var to = clearCalendar(new java.util.GregorianCalendar());


from.set(java.util.Calendar.DAY_OF_MONTH, 1);
from.add(java.util.Calendar.MONTH, -1);
to.set(java.util.Calendar.DAY_OF_MONTH, 1);

getPatientHistory(PATIENT, null, from.getTime(), to.getTime(), false);');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_LAST_WEEK_TEXT]', E'PATIENT_HISTORY', E'All history entries of the patient during the last week as text (not as a table).', E'/**
 * [PAT_HISTORY_LAST_WEEK_TEXT]
 */
var from = clearCalendar(new java.util.GregorianCalendar());
var to = clearCalendar(new java.util.GregorianCalendar());


from.set(java.util.Calendar.DAY_OF_WEEK, from.getFirstDayOfWeek());
from.add(java.util.Calendar.WEEK_OF_YEAR, -1);
to.set(java.util.Calendar.DAY_OF_WEEK, to.getFirstDayOfWeek());

getPatientHistory(PATIENT, null, from.getTime(), to.getTime(), false);');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_THIS_MONTH_TEXT]', E'PATIENT_HISTORY', E'All history entries of the patient during this month as text (not as a table).', E'/**
 * [PAT_HISTORY_THIS_MONTH_TEXT]
 */
var from = clearCalendar(new java.util.GregorianCalendar());
var to = clearCalendar(new java.util.GregorianCalendar());


from.set(java.util.Calendar.DAY_OF_MONTH, 1);
to.set(java.util.Calendar.DAY_OF_MONTH, 1);
to.add(java.util.Calendar.MONTH, 1);

getPatientHistory(PATIENT, null, from.getTime(), to.getTime(), false);');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_THIS_WEEK_TEXT]', E'PATIENT_HISTORY', E'All history entries of the patient during this week as text (not as a table).', E'/**
 * [PAT_HISTORY_THIS_WEEK_TEXT]
 */
var from = clearCalendar(new java.util.GregorianCalendar());
var to = clearCalendar(new java.util.GregorianCalendar());


from.set(java.util.Calendar.DAY_OF_WEEK, from.getFirstDayOfWeek());
to.set(java.util.Calendar.DAY_OF_WEEK, to.getFirstDayOfWeek());
to.add(java.util.Calendar.WEEK_OF_YEAR, 1);

getPatientHistory(PATIENT, null, from.getTime(), to.getTime(), false);');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_TODAY_TEXT]', E'PATIENT_HISTORY', E'All history entries of the patient of today as text (not as a table).', E'/**
 * [PAT_HISTORY_TODAY_TEXT]
 */
getPatientHistoryXDays(1, false);');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_YESTERDAY_TEXT]', E'PATIENT_HISTORY', E'All history entries of the patient of yesterday as text (not as a table).', E'/**
 * [PAT_HISTORY_YESTERDAY_TEXT]
 */
var from = clearCalendar(new java.util.GregorianCalendar());
var to = clearCalendar(new java.util.GregorianCalendar());


from.add(java.util.Calendar.DAY_OF_MONTH, -1);

getPatientHistory(PATIENT, null, from.getTime(), to.getTime(), false);');


-- Date defined as java.util.Date, because otherwise nashorn takes its own Date class
SELECT letter.insert_letter_placeholder(E'[GEN_DATE]', E'GENERAL', E'The current date', E'/**
 * [GEN_DATE]
 */
FORMATTER.formatDate(new java.util.Date());');

SELECT letter.insert_letter_placeholder(E'[GEN_TIME]', E'GENERAL', E'The current time', E'/**
 * [GEN_TIME]
 */
FORMATTER.formatDate(new java.util.Date(), "hh:mm");');


-- changed the method to be more stable concerning null values and added the output and translation for the new conultation entriess
SELECT letter.insert_letter_placeholder(NULL, E'PATIENT_HISTORY', E'Functions available to all PATIENT_HISTORY placeholders', E'/**
 * PATIENT HISTORY FUNCTIONS
 */

/**
 * int days: The last x days to get the history.
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 */
function getPatientHistoryXDays (days, asTable)
{
	if (typeof asTable == "undefined")
		asTable = true;
	
	var from = clearCalendar();
	var to = clearCalendar();
	
	
	from.add(java.util.Calendar.DAY_OF_MONTH, -(days-1));
	to.add(java.util.Calendar.DAY_OF_MONTH, 1);
	
	return getPatientHistory(PATIENT, null, from.getTime(), to.getTime(), asTable);
}

/**
 * Patient patient: The patient to get the history from
 * String[] types: The incident entry types to fetch
 * Date fromDate: The earliest date to get the history 
 * Date toDate: The latest date to get the history
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 * return: The history of the patient as HTML or text (depending on the asTable flag).
 */
function getPatientHistory (patient, types, fromDate, toDate, asTable)
{
	if (patient == null || !patient.isPersistent())
		return "";
	
	if (typeof asTable == "undefined")
		asTable = true;
	
	var incidents = getPatientIncidents(patient, types, fromDate, toDate, null);
	var text = new java.lang.StringBuilder(
			"<html><head><title>history</title></head><body>\\n");
	
	if (asTable)
		text = text.append("<table border=\\"1\\" cellspacing=\\"0\\"><tbody>");
	
	if (incidents == null || incidents.size() == 0)
		return "";
	
	for (var i = 0; i < incidents.size(); i++)
	{
		text = appendIncidentRows(incidents.get(i), text, asTable);
	}
	
	if (asTable)
		text.append("\\n</tbody></table>");
	text.append("</body></html>");
	
	return text.toString();
}


/**
 * Patient patient: The patient to get the history from
 * String[] types: The incident entry types to fetch. Leave it null, to select all types.
 * Date fromDate: The earliest date to get the history. Leave it null, to set no start date.
 * Date toDate: The latest date to get the history. Leave it null, to set no end date.
 * Integer max: The maximum number of results. Leave it null, to set no maximum.
 * return: The incidents of the patient.
 */
function getPatientIncidents (patient, types, fromDate, toDate, max, test)
{
	var query = new java.lang.StringBuilder();
	
	
	if (patient == null || !patient.isPersistent().booleanValue())
		return null;
	
	// define the query
	query.append("SELECT OBJECT(i)")
			.append("\\nFROM Incident i")
			.append(types == null ? "" : ", IncidentEntry e, IncidentEntryType t")
			.append("\\nWHERE i.patientId = ").append(patient.getId());
	if (types != null)
	{
		query.append("\\nAND i.id = e.incidentId")
			.append("\\nAND t.id = e.entryTypeId")
			.append("\\nAND t.name IN (");
		for (var i = 0; i < types.length; i++)
			query.append(i == 0 ? "''" : ", ''").append(types[i]).append("''");
		query.append(")\\n");
	}
	if (fromDate != null)
		query.append("\\nAND i.incidentDate > ").append("''"+FORMATTER.formatDate(fromDate, "yyyy-MM-dd")+"''");
	if (toDate != null)
		query.append("\\nAND i.incidentDate < ").append("''"+FORMATTER.formatDate(toDate, "yyyy-MM-dd")+"''");
	query.append("\\nORDER BY i.incidentDate DESC");
	
	if (max == null)
		return DATABASE_MANAGER.doHqlQuery(query.toString());
	else if (max == 1)
		return DATABASE_MANAGER.getHqlQueryObject(query.toString());
	else
		return DATABASE_MANAGER.doHqlQuery(query.toString(), null, max);
}


/**
 * IncidentEntry entry: The incident entry to format
 * StringBuilder text: The 
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 * return: The data of the incident entry
 */
function appendIncidentRows (incident, text, asTable)
{
	if (typeof asTable == "undefined")
		asTable = true;
	
	var type;
	var entries;
	var rows;
	var incidentDate;
	var physician;
	var iter;
	var entry;
	var content;
	var isAccident;
	var list;
	
	
	// check
	entries      = incident.getIncidentEntries();
	if (entries == null || entries.isEmpty())
		return text;
	
	isAccident   = incident.getIsAccident().booleanValue();
	rows         = entries.size() + (isAccident ? 1 : 0);
	incidentDate = incident.getIncidentDate();
	physician    = getPhysician(incident.getPhysicianId());
	
	// define the row and the date / physician cell
	if (asTable)
	{
		text.append("\\n<tr valign=\\"top\\">\\n  <td rowspan=\\"")
				.append(rows)
				.append("\\" nowrap>");
	}
	text.append("<b>")
			.append(FORMATTER.formatDate(incidentDate))
			.append(asTable ? "</b><br/>" : "</b>&nbsp;")
			.append("<span style=\\"font-size:10px\\">")
			.append(FORMATTER.formatDate(incidentDate, "HH:mm"));
	if (physician != null) 
		text.append(" - ")
				.append(physician.getMnemonic());
	text.append("</span>");
	
	if (asTable)
		text.append("</td>\\n");
	else
		text.append("<br>");
	
	if (isAccident)
	{
		var accidentDate = incident.getAccidentDate();
		var accidentNr   = incident.getAccidentNr();
		
		if (asTable)
			text.append("\\n  <td nowrap>");
		text.append("<i>")
				.append(tryTranslate("pm.", "accident"));
		
		if (accidentDate != null || accidentNr != null)
		{
			text.append("</i>");
			if (asTable)
				text.append("</td>\\n  <td>");
			
			if (accidentNr != null)
				text.append(accidentNr);
			if (accidentDate != null && accidentNr != null)
				text.append(" - ");
			if (accidentDate != null)
				text.append(FORMATTER.formatDate(accidentDate))
			
			if (asTable)
				text.append("</td>\\n</tr>\\n<tr valign=\\"top\\">\\n");
			else
				text.append("<br>");
		}
	}
	
	// run through the entries and add a row for each
	for (iter = entries.iterator(); iter.hasNext(); )
	{
		// get the current entry and its type
		entry = iter.next();
		type  = entry.getEntryType().getName();
		
		if (type == null
				|| type.startsWith("soap.")
				|| type.startsWith("cons.")
				|| type.equals("letter")
				|| type.equals("form")
				|| type.equals("dicom"))
		{
			// this is the default way to get the content of an incident entry ... 
			// ... get the text content ...
			content = entry.getTextContent();
			if (content == null)
			{
				content = new java.lang.String("");
			}
			else if (content.matches("\\\\A\\\\W*\\\\<(?i)html(?-i)\\\\>[\\\\W\\\\w]*"))
			{
				if (content.matches("\\\\A(\\\\W*\\\\<(?i)html(?-i)\\\\>\\\\W*)+\\\\<(?i)head(?-i)\\\\>[\\\\W\\\\w]*"))
					content = content.substring(content.indexOf("</head>") + 7);
				
				content = content
						.replace("<html>", "")
						.replace("</html>", "")
						.replace("<body", "<span")
						.replace("</body>", "</span>");
			}
			else
			{
				content.replace("\\n", "<br/>");
			}
			
			// ... abd the code value ...
			var code = entry.getCode();
			
			if (code != null && !code.isEmpty())
			{
				var label = new java.lang.String("patient.incident.code." + type);
				var codeLabel = tryTranslate(label);
				print("Translate \\"patient.incident."+label + "\\" to \\"" + codeLabel + "\\"\\n");
				
				if (codeLabel == null || codeLabel.equals(label))
				{
					codeLabel = tryTranslate("patient.incident.code");
					if (codeLabel == null)
						codeLabel = new java.lang.String("Code");
				}
				
				content = new java.lang.StringBuilder(content)
						.append(content.isEmpty() ? "<b>" : "<br/><b>")
						.append(codeLabel)
						.append(":</b> ")
						.append(code)
						.toString();
			}
			
			// ... try to translate the type ...
			if (type == null || type.trim().length == 0)
				type = new java.lang.String("");
			else
				type = tryTranslate("patient.incident.", type);
		}
		else if (type.equals("file"))
		{
			// get the content for an attached file
			type    = tryTranslate("core.", type);
			content = entry.getTextContent();
			if (content == null || content.trim().length == 0)
				content = entry.getOriginalFilename();
			else 
				content = new java.lang.String(content + "<br/><i><span style=\\"font-size:12px\\">" + entry.getOriginalFilename() + "</i></span>");
		}
		else if (type.equals("prescription"))
		{
			// get the content for a presciption
			type    = tryTranslate("pm.", type);
			list    = DATABASE_MANAGER.doHqlQuery(
					"SELECT OBJECT(p) FROM Prescription p WHERE p.incidentEntryId = " + 
					entry.getId());
			
			if (list == null || list.isEmpty())
				// no prescription found
				content = new java.lang.String("");
			else
				// get the text of the prescription
				content = list.get(0).getTextContent().replace("\\n", "<br/>");
		}
		else if (type.equals("measurement"))
		{
			// get the content for a measurement
			type    = tryTranslate("patient.incident.", type);
			content = getMeasurementContent(entry, asTable);
		}
		else if (type.equals("labo.result"))
		{
			// get the content for a labo result
			type    = tryTranslate("patient.history.", "labo");
			content = entry.getTextContent();
		}
		else if (type.equals("sick_leave"))
		{
			// print the sickleave
			var code  = entry.getCode();
			var start = entry.getSickLeaveStartDate();
			var end   = entry.getSickLeaveEndDate();
			
			type = tryTranslate("patient.incident." + type);
			if (type == null || type.trim().isEmpty())
				type = new java.lang.String("Sickleave");
			
			content = code != null ? code : new java.lang.String("");
			// no sense to print only start or end date, there for it is only printen, if both are set
			if (start != null && end != null)
			{
				content = new java.lang.StringBuilder(content)
						.append(code == null ? "" : " (")
						.append(FORMATTER.formatDate(start))
						.append(" - ")
						.append(FORMATTER.formatDate(end))
						.append(code == null ? "" : ")")
						.toString();
			}
		}
		else
		{
			// show, that there is an error
			// NEED TO ADD A ROW, otherwise the table will be messed up
			content = entry.getTextContent();
			print("UNSUPPORTED TYPE: " + type + " (" + content + ")" + "\\n");
		}
		
		// replace the HTML start tag, as this may mess up the HTML table
		//content = content.replace("<html>", "");
		
		text.append(asTable ? "\\n  <td nowrap><i>" : "\\n<div  style=\\"margin-top: 5px, margin-bottom: 0px\\"><i>")
				.append(type == null ? "" : type)
				.append(asTable ? "</i></td>\\n  <td>" : ":</i></div>\\n")
				.append(content == null ? "" : content);
		if (asTable && iter.hasNext())
			text.append("</td>\\n</tr>\\n<tr valign=\\"top\\">");
		else if (!asTable)
			text.append("<br>\\n");
	}
	if (!asTable)
		text.append("<br>\\n");
	return text;
}


/**
 * IncidentEntry entry: The entry to fetch the measurements from
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 * return: An HTML formatted string, representing the measurements
 */
function getMeasurementContent (entry, asTable)
{
	if (typeof asTable == "undefined")
		asTable = true;
	
	var values;
	var iter;
	var value;
	var type;
	var content;
	var tabbed = false;
	
	
	if (asTable)
		content = new java.lang.StringBuilder("\\n<span><table border=\\"0\\" cellspacing=\\"2\\"><tbody>\\n");
	else
		content = new java.lang.StringBuilder();
	
	// get the measurement values of the given incident entry
	values    = DATABASE_MANAGER.doHqlQuery(
			"SELECT OBJECT(v) FROM MeasurementValue v WHERE incidentEntryId = " + entry.getId());
	
	for (iter = values.iterator(); iter.hasNext(); )
	{
		value = iter.next();
		type  = value.getMeasurementType();
		value = type.isNumericType() ? value.getValueNumeric() : value.getValueString();
		
		if (value == null)
			// leave this value
			continue;
		
		if (asTable)
		{
			if (!tabbed)
				content.append("    <tr valign=\\"top\\">");
			
			if (type.getAlias() != null && type.getAlias().trim().length() > 0)
				content.append("<td><b>")
						.append(type.getAlias())
						.append(": </b></td>")
			else
				content.append("<td />");
			content.append("<td><i>")
					.append(value)
					.append("</i> ")
					.append(type.getUnit())
					.append("</td>");
			
			if (tabbed)
				content.append("</tr>\\n");
		}
		else
		{
			if (type.getAlias() != null && type.getAlias().trim().length() > 0)
				content.append("<b>")
						.append(type.getAlias())
						.append(": </b>");
			content.append("<i>")
					.append(value)
					.append("</i>")
					.append(type.getUnit());
			if (iter.hasNext())
				content.append("<br>");
		}
		tabbed = !tabbed;
	}
	
	// if tabbed is true, the row is not closed
	if (asTable)
	{
		if (tabbed)
			content.append("<td></td><td></td></tr>\\n");
		content.append("</tbody></table></span>\\n");
	}
	
	return content.toString();
}');


-- The new calendar functions, used to get the future appointments of the patient
SELECT letter.insert_letter_placeholder(E'[PAT_CALENDAR_FUTURE_APPOINTMENTS]', E'PATIENT_CALENDAR', E'The up to 10 next appointments of this patient. Every appointment in its own line.', E'/**
 * [PAT_CALENDAR_FUTURE_APPOINTMENTS]
 */
var cal = clearCalendar();
cal.add(java.util.Calendar.DAY_OF_YEAR, 1);
printAppointments (PATIENT, cal, null, 10, false);');

SELECT letter.insert_letter_placeholder(E'[PAT_CALENDAR_FUTURE_APPOINTMENTS_SINGLE_LINE]', E'PATIENT_CALENDAR', E'The up to 10 next appointments of this patient in one line, separated by a comma.', E'/**
 * [PAT_CALENDAR_FUTURE_APPOINTMENTS_SINGLE_LINE]
 */
var cal = clearCalendar();
cal.add(java.util.Calendar.DAY_OF_YEAR, 1);
printAppointments (PATIENT, cal, null, 10, true);');

SELECT letter.insert_letter_placeholder(E'[PAT_CALENDAR_LAST_APPOINTMENT]', E'PATIENT_CALENDAR', E'The last appointment of the patient.', E'/**
 * [PAT_CALENDAR_LAST_APPOINTMENT]
 */
var cal = new java.util.GregorianCalendar();
printAppointments (PATIENT, null, cal, 1, true, false);');


-- PATIENT_CALENDAR functions
SELECT letter.insert_letter_placeholder(NULL, E'PATIENT_CALENDAR', E'Functions available to all PATIENT_CALENDAR placeholders', E'/**
 * PATIENT CALENDAR FUNCTIONS
 */

/**
 * Patient patient: The patient to get the appointments from. DEFAULT: PATIENT
 * Date / Calendar startDate: Start date to fetch the appointments or null, to have no start date. DEFAULT: null
 * Date / Calendar endDate: The end date to stop fetching the appontments or null, to have no end date. DEFAULT: null
 * Integer / int maxAppointments: The maximal number of appointments or null, to have no limit. DEFAULT: null
 * boolean searchForward: Needed together with maxAppointments, to define where the counting should start. DEFAULT: true
 * boolean ascendingOrder: Defines in which order the appointments are returned.
 * reutrn: An ArrayList of appointments of this patient.
 */
function getAppointments (patient, startDate, endDate, maxAppointments, searchForward, ascendingOrder)
{
	var Calendar		= java.util.Calendar;
	var singleAppParams = new java.util.ArrayList(3);
	var recurrAppParams = new java.util.ArrayList(2);
	var singleAppQuery  = new java.lang.StringBuilder();
	var recurrAppQuery  = new java.lang.StringBuilder();
	var Integer         = java.lang.Integer;
	var result;
	var appointments;
	
	
	if (typeof patient == "undefined")
		patient = PATIENT;
	
	// transform from Calendar to Date
	if (startDate != null && startDate instanceof Calendar)
		startDate = startDate.getTime();
	if (endDate != null && endDate instanceof Calendar)
		endDate = endDate.getTime();
	
	// check values and init defaults
	if (typeof searchForward == "undefined")
		searchForward = (startDate != null && endDate != null)
				? startDate.before(endDate)
				: endDate != null && maxAppointments != null
				? false
				: true;
	
	if (endDate != null 
			&& startDate != null 
			&& endDate.before(startDate))
	{
		// switch the dates
		var tmp = endDate;
		endDate = startDate;
		startDate = tmp;
	}
	
	if (typeof ascendingOrder == "undefined")
		ascendingOrder = true;
	
	if (typeof maxAppointments == "undefined")
		maxAppointments = null;
	
	
	// add the patient ID to the parameter
	singleAppQuery.append("SELECT Object(a) FROM Appointment a\\nWHERE a.patientId = ?\\n");
	singleAppParams.add(patient.getId());
	recurrAppQuery.append("SELECT Object(a) FROM Appointment a\\nWHERE a.patientId = ?\\n");
	recurrAppParams.add(patient.getId());
	if (startDate != null)
	{
		singleAppQuery.append("AND (a.startDate >= ? AND a.frequency = 0)\\n");
		singleAppParams.add(startDate);
		recurrAppQuery.append("AND a.frequency > 0\\n");
	}
	if (endDate != null)
	{
		singleAppQuery.append("AND a.startDate <= ?\\n");
		singleAppParams.add(endDate);
		recurrAppQuery.append("AND a.startDate <= ?\\n");
		recurrAppParams.add(endDate);
	}
	// don''t check the order here, as it will be put into a TreeSet anyway
	singleAppQuery.append("ORDER BY a.startDate ")
			.append(searchForward ? "ASC" : "DESC");
	
	
	// query the appointments (without recurring appointments)
	appointments = new java.util.TreeSet();
	result = DATABASE_MANAGER.doHqlQuery(singleAppQuery.toString(), null, maxAppointments, singleAppParams);
	if (result != null && !result.isEmpty())
		appointments.addAll(result);
	
	// query the recurring appointments
	result = DATABASE_MANAGER.doHqlQuery(recurrAppQuery.toString(), null, maxAppointments, recurrAppParams);
	
	// take the recurring appointment entries and produce fix appointments
	if (endDate == null)
	{
		var cal = new java.util.GregorianCalendar();
		cal.add(Calendar.YEAR, 1);
		endDate = cal.getTime();
	}
	
	var recurredEvents;
	var singleApp;
	var app;
	var event;
	var count;
	for (var appIter = result.iterator(); appIter.hasNext(); )
	{
		app = appIter.next();
		if (app.getFrequency() == 0)
			continue;
		
		// create the recursive appointments
		recurredEvents = CLASS_LOADER.execute("lu.tudor.santec.gecamed.agenda.gui.DefaultNamedCalendar", 
				"createRecurrEvents", app, endDate, java.util.Locale.getDefault());
		
		if (recurredEvents == null)
			continue;
		
		count = 0;
		for (var eventIter = recurredEvents.iterator(); eventIter.hasNext(); )
		{
			if (searchForward && maxAppointments != null && count > maxAppointments)
				break;
			
			event = eventIter.next();
			
			if ((searchForward && event.getStart().after(startDate))
					|| !searchForward && event.getStart().after(endDate))
			{
				singleApp = CLASS_LOADER.create("lu.tudor.santec.gecamed.agenda.ejb.entity.beans.Appointment");
				
				// transfer the data from the event to the appointment
				singleApp.setDescription(event.getDescription());
				singleApp.setEndDate(event.getEnd());
				singleApp.setStartDate(event.getStart());
				singleApp.setSummary(event.getSummary());
				
				// transfer the data from the recurring appointment to the single appointment
				singleApp.setCalendarId(app.getCalendarId());
				singleApp.setCreated(app.getCreated());
				singleApp.setCreatedBy(app.getCreatedBy());
				singleApp.setFrequency(0);
				singleApp.setIsBackground(app.getIsBackground());
				singleApp.setPatientId(app.getPatientId());
				singleApp.setPrivate(app.isPrivate());
				singleApp.setRRule(app.getRRule());
				singleApp.setStatus(app.getStatus());
				singleApp.setTypeId(app.getTypeId());
				singleApp.setUntil(app.getUntil());
				
				// add this of the recurring appointment created appointments
				appointments.add(singleApp);
			}
			count++;
		}
	}
	
	if (maxAppointments != null)
	{
		if (searchForward)
			while (appointments.size() > maxAppointments)
				appointments.pollLast();
		else // if (!searchForward)
			while (appointments.size() > maxAppointments)
				appointments.pollFirst();
	}
	
	var resultList = new java.util.ArrayList(appointments.size());
	if (ascendingOrder)
	{
		resultList.addAll(appointments);
	}
	else
	{
		while (!appointments.isEmpty())
			resultList.add(appointments.pollLast());
	}
	
	return resultList;
}


/**
 * Loads the physician belonging to a calendar from the database 
 * and stores it in the script context or, if it was already loaded 
 * into the script context, takes it directly from there.
 * 
 * Integer calendarId: The id of the calendar, to get the physician from
 * return: The physician, that belongs to that calendar or null, if there 
 *   is not physician for that calendar
 */
function getPhysicianOfCalendar (calendarId)
{
	if (calendarId == null)
		return null;
	
	// create the key to search for the physician in the script context
	var key       = "physicianOfCalendarId_" + java.lang.String.valueOf(calendarId);
	/* This is null, if it wasn''t searched for this calendar ID, 
	 * a physician if it was already searched for this calendar ID and a physician was found
	 * or Boolean.FALSE, if it was searched for this calendar ID and no physician was found.
	 */
	var physician = SCRIPT_CONTEXT.get(key);
	
	if (physician == null)
	{
		// physician is not yet stored in the script context
		// load it from the DB
		var parameters = new java.util.ArrayList(1);
		parameters.add(calendarId);
		physician = DATABASE_MANAGER.getHqlQueryObject(
				"SELECT Object(p) FROM Physician p, AgendaCalendar c " + 
				"WHERE c.id = ? AND c.physicianId = p.id", 
				parameters);
		
		if (physician == null)
		{
			SCRIPT_CONTEXT.put(key, java.lang.Boolean.FALSE);
		}
		else
		{
			// store the physician in the script context
			SCRIPT_CONTEXT.put(key, physician);
		}
	}
	
	if (java.lang.Boolean.FALSE.equals(physician))
		return null;
	else
		return physician;
}


/**
 * Patient patient: The patient to get the appointments from. DEFAULT: PATIENT
 * Date / Calendar startDate: Start date to fetch the appointments or null, to have no start date. DEFAULT: null
 * Date / Calendar endDate: The end date to stop fetching the appontments or null, to have no end date. DEFAULT: null
 * Integer / int maxAppointments: The maximal number of appointments or null, to have no limit. DEFAULT: null
 * boolean asSingleLine: Defines wether the appointments shall be printed in one line, separated by a ",", or if each 
 *   appointment shall have its own line. DEFAULT: false
 * boolean searchForward: Needed together with maxAppointments, to define where the counting should start. DEFAULT: true
 * boolean ascendingOrder: Defines in which order the appointments are returned.
 * return: A String, representing the appointments of the patient
 */
function printAppointments (patient, startDate, endDate, maxAppointments, asSingleLine, searchForward, ascendingOrder)
{
	// check values and init defaults
	if (typeof asSingleLine == "undefined")
		asSingleLine = false;
	
	var appointments    = getAppointments(patient, startDate, endDate, maxAppointments, searchForward, ascendingOrder);
	var text            = new java.lang.StringBuilder();
	var appendSeparator = false;
	var start;
	var physician;
	var appointment
	
	
	for (var iter = appointments.iterator(); iter.hasNext(); )
	{
		appointment = iter.next();
		
		if (appendSeparator)
		{
			if (asSingleLine)
				text.append(", ");
			else 
				text.append("\\n");
		}
		else
		{
			appendSeparator = true;
		}
		
		start     = appointment.getStartDate();
		physician = getPhysicianOfCalendar(appointment.getCalendarId());
		text.append(FORMATTER.formatDate(start))
				.append(FORMATTER.formatDate(start, " HH:mm"));
		if (physician != null)
			text.append(" (")
					.append(FORMATTER.formatPhysicianName(physician, true))
					.append(")");
	}
	
	return text.toString();
}');

-- ensure that the function tryTranslate always returns java.lang.String and not a JavaScript String
SELECT letter.insert_letter_placeholder(NULL, NULL, E'Global functions, always charged', E'/**
 * GLOBAL FUNCTIONS
 */


/**
 * Takes the object and returns emtpy string, if it is null,
 * otherwise it creates a string out of it.
 */
function toString (o)
{
	return o == null ? "" : o.toString().trim();
}


/**
 * Tries to translate ''label'' into the user''s chosen language.
 * This is done by concatenating ''prefix'' to the ''label'' 
 * and sending it to the GECAMed translatlor. If it can be translated,
 * than the translation is returned, If not the ''label'' is returned.
 */
function tryTranslate (prefix, label)
{
	var translation;
	
	
	if (label == null)
		label = java.lang.String("");
	if (prefix == null)
		prefix = "";
	
    // Concats the label onto the prefix string and tries to translate
    // them by calling FORMATTER.translate().
	translation = FORMATTER.translate(prefix+label);
	
    // If this translation returns null, the label is returned.
	if (translation == null)
		return label;
	else
		return translation;
}


/**
 * Calendar cal: The calendar to clear. DEFAULT: new GregorianCalendar()
 * return: The given calendar, with unchanged date, but
 * time set to 00:00:00.000
 */
function clearCalendar(cal)
{
	if (typeof cal == "undefined")
	{
		cal = new java.util.GregorianCalendar();
	}
	else if (cal instanceof java.util.Date())
	{
		var c = new java.util.GregorianCalendar();
		c.setTime(cal);
		cal = c;
	}
	
	cal.set(java.util.Calendar.HOUR_OF_DAY, 0);
	cal.set(java.util.Calendar.MINUTE, 0);
	cal.set(java.util.Calendar.SECOND, 0);
	cal.set(java.util.Calendar.MILLISECOND, 0);
	
	return cal;
}


/**
 * int id: the physician ID
 * return: the physician with the given ID
 */
function getPhysician (id)
{
	var iter = PHYSICIAN_LIST.iterator();
	var p;
	
	
	while (iter.hasNext())
	{
		p = iter.next();
		if (p.getId().equals(id))
			// physician found!
			return p;
	}
	
	// no physician found, with the specified ID
	return null;
}');


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_2.00.02_002.sql');