/* ********************************************************************** */
/*                            UPDATE 2.00.07_003                          */
/* ---------------------------------------------------------------------- */

-- change patient history functions to keep the line breaks of the history texts when transforming to HTML

SELECT letter.insert_letter_placeholder('[PAT_HISTORY_LAST_CONSULTATION_TEXT]', 'PATIENT_HISTORY', E'The last incident of the PATIENT, that contains an SOAP entry or a measurement as text (not as a table)',
E'/**
 * [PAT_HISTORY_LAST_CONSULTATION_TEXT]
 */
var types;
var incident;
var html;


types     = getConsultationTypes();

incident = getPatientIncidents(PATIENT, types, null, null, 1);

if (incident != null)
{
	html  = new java.lang.StringBuilder(
			"<html><head><meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=utf-8\\" /><title>history</title></head>\\n<body>");
	html  = appendIncidentRows(incident, html, false);
	
	html.append("\\n</body></html>");
}
else
	html  = "";

html.toString();');

SELECT letter.insert_letter_placeholder('[PAT_HISTORY_LAST_CONSULTATION]', 'PATIENT_HISTORY', E'The last incident of the PATIENT, that contains an SOAP entry or a measurement',
E'/**
 * [PAT_HISTORY_LAST_CONSULTATION]
 */
var types;
var incident;
var html;


types     = getConsultationTypes();

incident  = getPatientIncidents(PATIENT, types, null, null, 1);

if (incident != null)
{
	html  = new java.lang.StringBuilder(
			"<html><head><meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=utf-8\\" /><title>history</title></head>\\n<body>" + 
			"<body><table border=\\"1\\" cellspacing=\\"0\\"><tbody>");
	html  = appendIncidentRows(incident, html);
	
	html.append("\\n</tbody></table></body></html>");
}
else
	html  = "";

html.toString();');


SELECT letter.insert_letter_placeholder(NULL, 'PATIENT_HISTORY', E'Functions available to all PATIENT_HISTORY placeholders',
E'/**
 * PATIENT HISTORY FUNCTIONS
 */

/**
 * return: An array with the names of all consulation types.
 */
function getConsultationTypes ()
{
	types     = new Array();
	types[0]  = "soap.s";
	types[1]  = "soap.o";
	types[2]  = "soap.a";
	types[3]  = "soap.p";
	types[4]  = "cons.1";
	types[5]  = "cons.2";
	types[6]  = "cons.3";
	types[7]  = "measurement";
	
	return types;
}


/**
 * int days: The last x days to get the history.
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 */
function getPatientHistoryXDays (days, asTable)
{
	if (typeof asTable == "undefined")
		asTable = true;
	
	var from = clearCalendar();
	var to = clearCalendar();
	
	
	from.add(java.util.Calendar.DAY_OF_MONTH, -(days-1));
	to.add(java.util.Calendar.DAY_OF_MONTH, 1);
	
	return getPatientHistory(PATIENT, null, from.getTime(), to.getTime(), asTable);
}


/**
 * Patient patient: The patient to get the history from
 * String[] types: The incident entry types to fetch
 * Date fromDate: The earliest date to get the history 
 * Date toDate: The latest date to get the history
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 * return: The history of the patient as HTML or text (depending on the asTable flag).
 */
function getPatientHistory (patient, types, fromDate, toDate, asTable)
{
	if (patient == null || !patient.isPersistent())
		return "";
	
	if (typeof asTable == "undefined")
		asTable = true;
	
	var incidents = getPatientIncidents(patient, types, fromDate, toDate, null);
	var text = new java.lang.StringBuilder(
			"<html><head><meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=utf-8\\" /><title>history</title></head><body>\\n");
	
	if (asTable)
		text = text.append("<table border=\\"1\\" cellspacing=\\"0\\"><tbody>");
	
	if (incidents == null || incidents.size() == 0)
		return "";
	
	for (var i = 0; i < incidents.size(); i++)
	{
		text = appendIncidentRows(incidents.get(i), text, asTable);
	}
	
	if (asTable)
		text.append("\\n</tbody></table>");
	text.append("</body></html>");
	
	return text.toString();
}


/**
 * Patient patient: The patient to get the history from
 * String[] types: The incident entry types to fetch. Leave it null, to select all types.
 * Date fromDate: The earliest date to get the history. Leave it null, to set no start date.
 * Date toDate: The latest date to get the history. Leave it null, to set no end date.
 * Integer max: The maximum number of results. Leave it null, to set no maximum.
 * return: The incidents of the patient.
 */
function getPatientIncidents (patient, types, fromDate, toDate, max, test)
{
	var query = new java.lang.StringBuilder();
	
	
	if (patient == null || !patient.isPersistent().booleanValue())
		return null;
	
	// define the query
	query.append("SELECT OBJECT(i)")
			.append("\\nFROM Incident i")
			.append(types == null ? "" : ", IncidentEntry e, IncidentEntryType t")
			.append("\\nWHERE i.patientId = ").append(patient.getId());
	if (types != null)
	{
		query.append("\\nAND i.id = e.incidentId")
			.append("\\nAND t.id = e.entryTypeId")
			.append("\\nAND t.name IN (");
		for (var i = 0; i < types.length; i++)
			query.append(i == 0 ? "''" : ", ''").append(types[i]).append("''");
		query.append(")\\n");
	}
	if (fromDate != null)
		query.append("\\nAND i.incidentDate > ").append("''"+FORMATTER.formatDate(fromDate, "yyyy-MM-dd")+"''");
	if (toDate != null)
		query.append("\\nAND i.incidentDate < ").append("''"+FORMATTER.formatDate(toDate, "yyyy-MM-dd")+"''");
	query.append("\\nORDER BY i.incidentDate DESC");
	
	if (max == null)
		return DATABASE_MANAGER.doHqlQuery(query.toString());
	else if (max == 1)
		return DATABASE_MANAGER.getHqlQueryObject(query.toString());
	else
		return DATABASE_MANAGER.doHqlQuery(query.toString(), null, max);
}


/**
 * IncidentEntry entry: The incident entry to format
 * StringBuilder text: The 
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 * return: The data of the incident entry
 */
function appendIncidentRows (incident, text, asTable)
{
	if (typeof asTable == "undefined")
		asTable = true;
	
	var type;
	var entries;
	var rows;
	var incidentDate;
	var physician;
	var iter;
	var entry;
	var content;
	var isAccident;
	var list;
	
	
	// check
	entries      = incident.getIncidentEntries();
	if (entries == null || entries.isEmpty())
		return text;
	
	isAccident   = incident.getIsAccident().booleanValue();
	rows         = entries.size() + (isAccident ? 1 : 0);
	incidentDate = incident.getIncidentDate();
	physician    = getPhysician(incident.getPhysicianId());
	
	// define the row and the date / physician cell
	if (asTable)
	{
		text.append("\\n<tr valign=\\"top\\">\\n  <td rowspan=\\"")
				.append(rows)
				.append("\\" nowrap>");
	}
	text.append("<b>")
			.append(FORMATTER.formatDate(incidentDate))
			.append(asTable ? "</b><br>" : "</b>&nbsp;")
			.append("<span style=\\"font-size:10px\\">")
			.append(FORMATTER.formatDate(incidentDate, "HH:mm"));
	if (physician != null) 
		text.append(" - ")
				.append(physician.getMnemonic());
	text.append("</span>");
	
	if (asTable)
		text.append("</td>\\n");
	else
		text.append("<br>");
	
	if (isAccident)
	{
		var accidentDate = incident.getAccidentDate();
		var accidentNr   = incident.getAccidentNr();
		
		if (asTable)
			text.append("\\n  <td nowrap>");
		text.append("<u>")
				.append(tryTranslate("pm.", "accident"));
		
		if (accidentDate != null || accidentNr != null)
		{
			text.append("</u>");
			if (asTable)
				text.append("</td>\\n  <td>");
			
			if (accidentNr != null)
				text.append(accidentNr);
			if (accidentDate != null && accidentNr != null)
				text.append(" - ");
			if (accidentDate != null)
				text.append(FORMATTER.formatDate(accidentDate))
			
			if (asTable)
				text.append("</td>\\n</tr>\\n<tr valign=\\"top\\">\\n");
			else
				text.append("<br>");
		}
	}
	
	var Pattern           = java.util.regex.Pattern;
	var htmlStartPattern  = Pattern.compile("<(?i)html(?-i)\\\\>");
	var htmlHeaderPattern = Pattern.compile("<(?i)head(?-i)\\\\>");
	var newlinePattern    = Pattern.compile("$(?=.)", Pattern.MULTILINE | Pattern.DOTALL);
	
	// run through the entries and add a row for each
	for (iter = entries.iterator(); iter.hasNext(); )
	{
		// get the current entry and its type
		entry = iter.next();
		type  = entry.getEntryType().getName();
		
		if (type == null
				|| type.startsWith("soap.")
				|| type.startsWith("cons.")
				|| type.equals("letter")
				|| type.equals("form")
				|| type.equals("dicom"))
		{
			// this is the default way to get the content of an incident entry ... 
			// ... get the text content ...
			content = entry.getTextContent();
			if (content == null)
			{
				content = new java.lang.String("");
			}
			else if (htmlStartPattern.matcher(content).find())
			{
				if (htmlHeaderPattern.matcher(content).find())
					content = content.substring(content.indexOf("</head>") + 7);
				
				content = content
						.replace("<html>",  "")
						.replace("</html>", "")
						.replace("<body",   "<span")
						.replace("</body>", "</span>");
			}
			else
			{
				content = newlinePattern.matcher(content).replaceAll("<br>");
				// content.replace("\\n", "<br>");
			}
			
			// ... abd the code value ...
			var code = entry.getCode();
			
			if (code != null && !code.isEmpty())
			{
				var label = new java.lang.String("patient.incident.code." + type);
				var codeLabel = tryTranslate(label);
				
				if (codeLabel == null || codeLabel.equals(label))
				{
					codeLabel = tryTranslate("patient.incident.code");
					if (codeLabel == null)
						codeLabel = new java.lang.String("Code");
				}
				
				content = new java.lang.StringBuilder(content)
						.append(content.isEmpty() ? "<p><i>" : "<br><p><i>")
						.append(codeLabel)
						.append(":</i> ")
						.append(code)
						.append("</p>")
						.toString();
			}
			
			// ... try to translate the type ...
			if (type == null || type.trim().length == 0)
				type = new java.lang.String("");
			else
				type = tryTranslate("patient.incident.", type);
		}
		else if (type.equals("file"))
		{
			// get the content for an attached file
			type    = tryTranslate("core.", type);
			content = entry.getTextContent();
			if (content == null || content.trim().length == 0)
				content = entry.getOriginalFilename();
			else 
				content = new java.lang.String(content + "<br><span style=\\"font-size:12px\\"><i>" + entry.getOriginalFilename() + "</i></span>");
		}
		else if (type.equals("prescription"))
		{
			// get the content for a presciption
			type    = tryTranslate("pm.", type);
			list    = DATABASE_MANAGER.doHqlQuery(
					"SELECT OBJECT(p) FROM Prescription p WHERE p.incidentEntryId = " + 
					entry.getId());
			
			if (list == null || list.isEmpty())
				// no prescription found
				content = new java.lang.String("");
			else
				// get the text of the prescription
				content = list.get(0).getTextContent().replace("\\n", "<br>");
		}
		else if (type.equals("measurement"))
		{
			// get the content for a measurement
			type    = tryTranslate("patient.incident.", type);
			content = getMeasurementContent(entry, asTable);
		}
		else if (type.equals("labo.result"))
		{
			// get the content for a labo result
			type    = tryTranslate("patient.history.", "labo");
			content = entry.getTextContent();
		}
		else if (type.equals("sick_leave"))
		{
			// print the sickleave
			var code  = entry.getCode();
			var start = entry.getSickLeaveStartDate();
			var end   = entry.getSickLeaveEndDate();
			
			type = tryTranslate("patient.incident." + type);
			if (type == null || type.trim().isEmpty())
				type = new java.lang.String("Sickleave");
			
			content = code != null ? code : new java.lang.String("");
			// no sense to print only start or end date, there for it is only printen, if both are set
			if (start != null && end != null)
			{
				content = new java.lang.StringBuilder(content)
						.append(code == null ? "" : " (")
						.append(FORMATTER.formatDate(start))
						.append(" - ")
						.append(FORMATTER.formatDate(end))
						.append(code == null ? "" : ")")
						.toString();
			}
		}
		else
		{
			// show, that there is an error
			// NEED TO ADD A ROW, otherwise the table will be messed up
			content = entry.getTextContent();
			print("UNSUPPORTED TYPE: " + type + " (" + content + ")" + "\\n");
		}
		
		// replace the HTML start tag, as this may mess up the HTML table
		//content = content.replace("<html>", "");
		
		if (asTable)
			text.append("\\n  <td nowrap><u>");
		else
			text.append("\\n<div  style=\\"margin-top: 5px, margin-bottom: 0px\\"><u>");
		
		if (type != null)
			text.append(type);
		
		if (asTable)
			text.append("</u></td>\\n  <td>");
		else
			text.append(":</u></div>\\n");
		
		if (content != null)
			text.append("<p>").append(content).append("</p>");
		
		if (asTable)
		{
			text.append("</td>\\n</tr>\\n");
			if (iter.hasNext())
				text.append("<tr valign=\\"top\\">");
		}
	}
	if (!asTable)
		text.append("<br>\\n");
	return text;
}


/**
 * IncidentEntry entry: The entry to fetch the measurements from
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 * return: An HTML formatted string, representing the measurements
 */
function getMeasurementContent (entry, asTable)
{
	var Double = java.lang.Double;
	var Boolean = java.lang.Boolean;
	var Math = java.lang.Math;
	var Array = java.lang.reflect.Array;
	var StringBuilder = java.lang.StringBuilder;
	var LinkedList = java.util.LinkedList;
	
	var values;
	var iter;
	var value;
	var type;
	var content;
	var tabbed = false;
	
	
	if (typeof asTable == "undefined")
		asTable = true;
	
	content = new StringBuilder();
	
	// get the measurement values of the given incident entry
	values    = DATABASE_MANAGER.doHqlQuery(
			"SELECT OBJECT(v) FROM MeasurementValue v WHERE incidentEntryId = " + entry.getId());
	
	var orderedValues    = Array.newInstance(values.iterator().next().getClass(), 9);
	for (iter = values.iterator(); iter.hasNext(); )
	{
		value = iter.next();
		type  = value.getMeasurementType();
		
		if (type.getName().equals("SYS"))
			orderedValues[0] = value;
		else if (type.getName().equals("DIA"))
			orderedValues[1] = value;
		else if (type.getName().equals("POULSE"))
			orderedValues[2] = value;
		else if (type.getName().equals("HEIGHT"))
			orderedValues[3] = value;
		else if (type.getName().equals("WEIGHT"))
			orderedValues[4] = value;
		// else: here should stand the BMI, but it must be calculated first
		else if (type.getName().equals("measurement_1"))
			orderedValues[6] = value;
		else if (type.getName().equals("measurement_2"))
			orderedValues[7] = value;
		else if (type.getName().equals("measurement_3"))
			orderedValues[8] = value;
	}
	
	if (       orderedValues[3] != null 
			&& orderedValues[3].getValueNumeric() != null
			&& orderedValues[4] != null 
			&& orderedValues[4].getValueNumeric() != null)
	{
		var height = orderedValues[3].getValueNumeric().doubleValue();
		var weight = orderedValues[4].getValueNumeric().doubleValue();
		var bmi    = Double.parseDouble(Math.round(weight / (height * height) * 10) / 10);
		var mv     = orderedValues[4].clone();
		var mt     = mv.getMeasurementType().clone();
		
		mv.setMeasurementType(mt);
		mt.setAlias("bmi");
		mt.setName("bmi");
		mt.setUnit("kg/m2");
		mt.setDefault(Boolean.TRUE);
		mt.setNumericType(Boolean.TRUE);
		mv.setValueNumeric(Double.valueOf(bmi));
		mv.setId(null);
		orderedValues[5] = mv;
	}
	
	values = LinkedList();
	for (var index = 0; index < orderedValues.length; index++)
	{
		value = orderedValues[index];
		if (value != null)
			values.add(value);
	}
	
	for (iter = values.iterator(); iter.hasNext(); )
	{
		value = iter.next();
		type  = value.getMeasurementType();
		value = type.isNumericType() ? value.getValueNumeric() : value.getValueString();
		
		if (value == null)
			// leave this value
			continue;
		
		if (type.getAlias() != null && type.getAlias().trim().length() > 0)
			content.append("")
					.append(tryTranslate("patient.incident.measurement.", type.getAlias()))
					.append(": ");
		content.append("")
				.append(value)
				.append(" ")
				.append(type.getUnit());
		if (iter.hasNext())
			content.append("<br>");
	}
	
	return content.toString();
}');


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.00.07_003.sql');