/* ********************************************************************** */
/*                            UPDATE 2.01.02_001                          */
/* ---------------------------------------------------------------------- */

-- Delete measurement entries without measurements
DELETE FROM patient.incident_entry
WHERE id IN (
  SELECT e.id FROM patient.incident_entry e
  INNER JOIN patient.incident_entry_types t
    on t.id = e.entry_type_id
  LEFT JOIN patient.measurement_values v
    ON e.id = v.incident_entry_id
  WHERE t.name = 'measurement'
  AND v.id IS NULL
);


-- There may be some incidents without entries, after deleting the empty measurements.
-- Delete them.
DELETE FROM patient.incidents
WHERE id IN (
  SELECT i.id FROM patient.incidents i
  LEFT JOIN patient.incident_entry e
    ON i.id = e.incident_id
  WHERE e.id IS NULL
  AND i.is_accident = false
);


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.01.02_001.sql');