/* ********************************************************************** */
/*                            UPDATE 2.02.00_003                          */
/* ---------------------------------------------------------------------- */

-- store the digits to round in the act
ALTER TABLE billing.act
ADD COLUMN fraction_digits INTEGER DEFAULT 1;

ALTER TABLE billing.trashed_act
ADD COLUMN fraction_digits INTEGER DEFAULT 1;

DROP VIEW IF EXISTS billing.activity;
CREATE VIEW billing.activity (id, invoice_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, accession_number, performed, code, quantity, coefficient, key_value, fraction_digits, suffixes, majoration) AS
 	SELECT DISTINCT act.id, act.invoice_id, act.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, act.accession_number, act.performed, act.code, act.quantity, act.coefficient, act.key_value, act.fraction_digits, act.suffixes, invoice.majoration
 	FROM billing.act, billing.invoice, patient.patient
 	WHERE invoice.id = act.invoice_id AND patient.id = invoice.patient_id;

-- remove the spaces at the beginning and end of a code label
UPDATE billing.rate
SET code = TRIM(code)
WHERE code LIKE ' %'
OR code LIKE '% ';

/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO core.info (date, key, value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.02.00_003.sql');
