/* ********************************************************************** */
/*                            UPDATE 2.02.00_005                          */
/* ---------------------------------------------------------------------- */

SELECT SETVAL('patient.insurance_id_seq', (SELECT MAX(id)+1 FROM patient.insurance), FALSE);

-- Add the addional insurance MISA "Ministère de Santé"
INSERT INTO patient.insurance (acronym,name, ucm_affiliated, is_primary, is_third_party, is_private, majoration)  VALUES (E'MISA' ,E'Ministère de Santé', 'true', 'false', 'true', 'false', 1.0);

select setval('patient.insurance_id_seq', 1000);


-- Add the German DKV as insurance plan
INSERT INTO patient.insurance_plan
(name, insurance_id)
SELECT acronym, id FROM patient.insurance 
WHERE acronym = 'DKV';

-- Add the Luxembourgish DKV as insurance plan
INSERT INTO patient.insurance_plan
(name, insurance_id)
SELECT acronym, id FROM patient.insurance 
WHERE acronym = 'DKVLUX';

-- Make the CMCM and the DKV 3rd Party payer
UPDATE patient.insurance
SET is_third_party = true
WHERE acronym IN ('DKVLUX', 'DKV', 'CMCM');

-- Add a column in the patient table, to store the number of the complementary insurance (e.g. DKV or CMCM)
ALTER TABLE patient.patient
ADD COLUMN complementary_insurance_number VARCHAR DEFAULT NULL;


-- Remove the character limitation of all VARCHARs in the schema "core"
ALTER TABLE core.autocompletion
ALTER COLUMN "context" TYPE VARCHAR,
ALTER COLUMN "short_cut" TYPE VARCHAR;

ALTER TABLE core.language
ALTER COLUMN "value" TYPE VARCHAR;

ALTER TABLE core.locale
ALTER COLUMN "language" TYPE VARCHAR,
ALTER COLUMN "country" TYPE VARCHAR;

ALTER TABLE core.log
ALTER COLUMN "username" TYPE VARCHAR,
ALTER COLUMN "operation" TYPE VARCHAR,
ALTER COLUMN "module" TYPE VARCHAR,
ALTER COLUMN "host" TYPE VARCHAR,
ALTER COLUMN "site" TYPE VARCHAR;

ALTER TABLE core.log_types
ALTER COLUMN "name" TYPE VARCHAR;

ALTER TABLE core.marital_status
ALTER COLUMN "value" TYPE VARCHAR;

ALTER TABLE core.national_holiday
ALTER COLUMN "description" TYPE VARCHAR;

ALTER TABLE core.nationality
ALTER COLUMN "value" TYPE VARCHAR;

ALTER TABLE core.phone_type
ALTER COLUMN "value" TYPE VARCHAR;

ALTER TABLE core.template_type
ALTER COLUMN "value" TYPE VARCHAR,
ALTER COLUMN "template_file_path" TYPE VARCHAR;

ALTER TABLE core.templates
ALTER COLUMN "type" TYPE VARCHAR,
ALTER COLUMN "name" TYPE VARCHAR;

ALTER TABLE core.dr_title
ALTER COLUMN "value" TYPE VARCHAR;


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO core.info (date, key, value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.02.00_005.sql');