/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.utils.fileappender;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileAppender {
    private static final String UTF8BOM = "\ufeff";
    private static final Pattern HELP_PATTERN = Pattern.compile("\\s*(-){0,2}h(elp)?\\s*");
    private static final Pattern OPTION_PATTERN = Pattern.compile("\\s*(-)(d|t|p|e|E|l|s)\\s*");
    private static final Pattern UFT8_ENCODING_PATTERN = Pattern.compile("UTF-?8", 2);
    private String sourceEncoding = "UTF8";
    private String targetEncoding = "UTF8";
    private String lineSeparator = System.getProperty("line.separator");
    private String scriptSeperator = String.valueOf(System.getProperty("line.separator")) + System.getProperty("line.separator");
    private Pattern filterPattern = null;
    private FileFilter fileFilter = new FileFilter(){

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return FileAppender.this.recursive;
            }
            if (FileAppender.this.filterPattern == null) {
                return true;
            }
            return FileAppender.this.filterPattern.matcher(file.getName()).matches();
        }
    };
    private boolean recursive = false;

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getFileNamePattern() {
        return this.filterPattern == null ? null : this.filterPattern.pattern();
    }

    public void setFileNamePattern(String fileNamePattern) {
        this.filterPattern = fileNamePattern == null ? null : Pattern.compile(fileNamePattern);
    }

    public String getScriptSeperator() {
        return this.scriptSeperator;
    }

    public void setScriptSeperator(String scriptSeperator) {
        this.scriptSeperator = scriptSeperator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getTargetEncoding() {
        return this.targetEncoding;
    }

    public void setTargetEncoding(String targetEncoding) {
        this.targetEncoding = targetEncoding;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void appendFile(String sourcePath, String targetPath, String startFileName) {
        boolean startFileFound;
        File targetFile;
        File sourceDir;
        block26: {
            TreeSet<File> sourceFiles = new TreeSet<File>();
            sourceDir = new File(sourcePath);
            targetFile = new File(targetPath);
            Writer writer = null;
            File appenderJar = FileAppender.getJarFile();
            startFileFound = false;
            if (sourcePath == null || sourcePath.trim().length() == 0) {
                sourceDir = new File(sourceDir.getAbsolutePath());
            }
            if (!sourceDir.exists()) {
                System.err.println("The sourceDir (\"" + sourceDir.getAbsolutePath() + "\") does not exist.");
                return;
            }
            if (!sourceDir.isDirectory()) {
                System.err.println("The sourceDir (\"" + sourceDir.getAbsolutePath() + "\") is not a directory.");
                return;
            }
            if (targetFile.exists() && !targetFile.delete()) {
                System.err.println("The target file (\"" + targetFile.getAbsolutePath() + "\") does already exist and cannot be deleted.");
                return;
            }
            File[] fileArray = sourceDir.listFiles(this.fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (appenderJar == null || !appenderJar.equals(f)) {
                    sourceFiles.add(f);
                }
                ++n2;
            }
            try {
                if (!targetFile.createNewFile()) {
                    System.err.println("The target file (\"" + targetFile.getAbsolutePath() + "\") could NOT be created.");
                    return;
                }
            }
            catch (IOException e) {
                System.err.println("Error while trying to create the target file (\"" + targetFile.getAbsolutePath() + "\").");
                e.printStackTrace();
            }
            try {
                try {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), this.getTargetEncoding()));
                    for (File sourceFile : sourceFiles) {
                        if (!startFileFound) {
                            if (!sourceFile.getName().equals(startFileName)) continue;
                            startFileFound = true;
                        }
                        this.append(sourceFile, writer);
                    }
                    writer.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block26;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!startFileFound) {
            System.err.println("FAILED! Couldn't find the start file \"" + startFileName + "\" in the source directory \"" + sourceDir.getAbsolutePath() + "\".");
            return;
        }
        System.out.println("All scripts written into file: " + targetFile.getAbsolutePath());
        this.checkBOM(targetFile);
        System.out.println("Done!");
    }

    private void append(File source, Writer writer) {
        boolean firstLine = false;
        BufferedReader reader = null;
        System.out.println("Appending file " + source.getAbsolutePath());
        try {
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), this.getSourceEncoding()));
                if (UFT8_ENCODING_PATTERN.matcher(this.getSourceEncoding()).matches()) {
                    firstLine = true;
                }
                while ((line = reader.readLine()) != null) {
                    if (firstLine && line.startsWith(UTF8BOM)) {
                        line = line.substring(1);
                        firstLine = false;
                    }
                    writer.write(line);
                    writer.write(this.getLineSeparator());
                }
                writer.write(this.getScriptSeperator());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean containsHelpOption(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (HELP_PATTERN.matcher(a).matches()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static File getJarFile() {
        File f;
        try {
            f = new File(FileAppender.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            try {
                f = new File(FileAppender.class.getResource(".").toURI());
                String packagePath = FileAppender.class.getPackage().getName().replace(".", File.separator);
                String classPath = f.getPath();
                String jarPath = classPath.substring(0, classPath.indexOf(packagePath));
                f = new File(jarPath);
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
                return null;
            }
        }
        if (f == null || f.isDirectory()) {
            return null;
        }
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkBOM(File file) {
        if (UFT8_ENCODING_PATTERN.matcher(this.getTargetEncoding()).matches()) {
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    String line = reader.readLine();
                    if (line != null && line.startsWith(UTF8BOM)) {
                        System.out.println("The file \"" + file.getAbsolutePath() + "\" is UTF8 with BOM.");
                        return;
                    }
                    System.out.println("The file \"" + file.getAbsolutePath() + "\" is UTF8 without BOM.");
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (reader == null) return;
                        reader.close();
                        return;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                return;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("The file \"" + file.getAbsolutePath() + "\" is not UTF8.");
    }

    private static void printHelp() {
        String s = "The FileAppender tool can be used to automatically append the content of text file located in a\n" + "directory into another file.\n" + "You must define, from which file to start the appending. This file and all following files\n" + "(alphabetical order) will be " + "written into the target file.\n\n" + "Please use this tool as follows:\n" + "java -jar FileAppender [OPTIONS]* startFileName\n\n" + "OPTIONS:\n" + "  -d <<DIR>>       Directory with the files to append.\n" + "                   The default is the current directory.\n" + "  -t <<FILE>>      Target file, to write into.\n" + "                   The default is  \"all_sql_updates.sql\" in the current directoyr.\n" + "  -p <<PATTERN>>   The file name regex pattern, to decide, which files are appended" + "                   By default all files are appended." + "  -e <<ENCODING>>  The file encoding of the source files.\n" + "                   The default is UTF-8.\n\n" + "  -E <<ENCODING>>  The file encoding of the target file.\n" + "                   The default is UTF-8.\n\n" + "  -l <<CHAR>>      The line separator to use for the target file.\n" + "                   The default is the system line seperator.\n\n" + "  -s <<FILE>>      The script separator used between the files.\n" + "                   The default is the system line seperator.\n\n" + " \"startFileName\" defines the file, from which to start the appending (in alphabetical order).\n";
        System.out.println(s);
    }

    public static void main(String[] args) {
        if (args.length < 1 || FileAppender.containsHelpOption(args)) {
            FileAppender.printHelp();
            return;
        }
        FileAppender appender = new FileAppender();
        String sourceDir = "";
        String targetFile = "all_sql_updates.sql";
        String startFileName = null;
        String sourceEncoding = null;
        String targetEncoding = null;
        String lineSeparator = null;
        String scriptSeperator = null;
        String filenamePattern = null;
        boolean recursive = false;
        int index = 0;
        while (index < args.length) {
            block22: {
                block21: {
                    Matcher m = OPTION_PATTERN.matcher(args[index]);
                    if (!m.matches()) break block21;
                    if (args.length <= index) {
                        System.err.println("Invalid use.");
                        FileAppender.printHelp();
                        return;
                    }
                    String option = m.group(2);
                    if (option == null || option.length() != 1) {
                        System.err.println("Illegal option: " + args[index]);
                        FileAppender.printHelp();
                        return;
                    }
                    switch (option.charAt(0)) {
                        case 'd': {
                            sourceDir = args[++index];
                            break block22;
                        }
                        case 't': {
                            targetFile = args[++index];
                            break block22;
                        }
                        case 'e': {
                            sourceEncoding = args[++index];
                            break block22;
                        }
                        case 'E': {
                            targetEncoding = args[++index];
                            break block22;
                        }
                        case 'l': {
                            lineSeparator = args[++index];
                            break block22;
                        }
                        case 's': {
                            scriptSeperator = args[++index];
                            break block22;
                        }
                        case 'p': {
                            filenamePattern = args[++index];
                            break block22;
                        }
                        default: {
                            System.err.println("Unsupported option: " + args[index - 1]);
                            return;
                        }
                    }
                }
                if (args.length == index + 1) {
                    startFileName = args[index];
                } else {
                    System.err.println("Invalid use");
                    FileAppender.printHelp();
                    return;
                }
            }
            ++index;
        }
        if (startFileName == null) {
            System.err.println("startFileName is missing.");
            FileAppender.printHelp();
            return;
        }
        if (sourceEncoding != null) {
            appender.setSourceEncoding(sourceEncoding);
        }
        if (targetEncoding != null) {
            appender.setTargetEncoding(targetEncoding);
        }
        if (lineSeparator != null) {
            appender.setLineSeparator(lineSeparator);
        }
        if (scriptSeperator != null) {
            appender.setScriptSeperator(String.valueOf(scriptSeperator) + scriptSeperator);
        }
        if (filenamePattern != null) {
            appender.setFileNamePattern(filenamePattern);
        }
        appender.setRecursive(recursive);
        appender.appendFile(sourceDir, targetFile, startFileName);
    }
}

