/* ************************************************************************ */
/*                             UPDATE 1.2.06_004                            */
/* ------------------------------------------------------------------------ */

/********************  ENLARGE THE SSN  ***********************/

/* =====   DROP VIEWS THAT CONTAIN THE SSN   ===== */

DROP VIEW IF EXISTS labo.result_stub;
DROP VIEW IF EXISTS patient.patient_stub;
DROP VIEW IF EXISTS billing.activity;
DROP VIEW IF EXISTS billing.invoice_stub;
DROP VIEW IF EXISTS billing.transaction;
DROP VIEW IF EXISTS billing.trashed_invoice_stub;
DROP VIEW IF EXISTS patient.patient_incident_statistics;


/* ==========    CHANGE THE SSN SIZE    ========== */
ALTER TABLE patient.patient
ALTER COLUMN social_security_number TYPE VARCHAR(128);


/* ===== RECREATE VIEWS THAT CONTAIN THE SSN ===== */

-- RECREATE VIEW: labo.result_stub
CREATE OR REPLACE VIEW labo.result_stub (id, laboratory_id, laboratory_name, prescriber_id, patient_id, patient_first_name, patient_name, patient_ssn, result_number, prescription_date, specimen_date, examination_date, downloaded, reference, examination_status, result_status ) AS
SELECT DISTINCT result.id, result.laboratory_id, laboratory.name, result.prescriber_id, result.patient_id, patient.first_name, patient.sur_name, patient.social_security_number, result.result_number, result.prescription_date, result.specimen_date, result.examination_date, result.downloaded, result.reference, result.examination_status, result.result_status
FROM labo.result, labo.laboratory, patient.patient
WHERE laboratory.id = result.laboratory_id 
AND patient.id = result.patient_id;

-- RECREATE VIEW: patient.patient_stub
CREATE OR REPLACE VIEW patient.patient_stub AS
SELECT patient.id, patient.social_security_number, patient.sur_name, patient.first_name, patient.maiden_name, patient.gender, patient.insurance_id, 
	(TRIM (trailing E'\n' FROM 
		(SELECT concat(((((((((address.zip::text || ' '::text) || address.locality::text) || ' '::text) || address.streetnumber::text) || ', '::text) || address.streetname::text) || ' - '::text) || address.country::text) || E'\n'::text) 
		FROM patient.patient sub_p1
		LEFT JOIN patient.patient_address address ON sub_p1.id = address.patient_id 
		WHERE sub_p1.id = patient.id))) as address,
	(TRIM (trailing E'\n' FROM 
		(SELECT concat(((phone.type::text || ': '::text) || phone.number::text) || E'\n'::text)
		FROM patient.patient sub_p2
		LEFT JOIN patient.patient_phone phone ON sub_p2.id = phone.patient_id
		WHERE sub_p2.id = patient.id))) as phone
FROM patient.patient patient;

-- RECREATE VIEW: billing.activity
CREATE OR REPLACE VIEW billing.activity (id, invoice_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, accession_number, performed, code, quantity, coefficient, key_value, suffixes, majoration) AS
SELECT DISTINCT act.id, act.invoice_id, act.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, act.accession_number, act.performed, act.code, act.quantity, act.coefficient, act.key_value, act.suffixes, invoice.majoration
FROM billing.act, billing.invoice, patient.patient
WHERE invoice.id = act.invoice_id 
AND patient.id = invoice.patient_id;

-- RECREATE VIEW: billing.invoice_stub
CREATE OR REPLACE VIEW billing.invoice_stub (id, state, old_state, invoice_number, class_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, third_party_id, created, due, reminders, reminder_date, statement_id, settlement_id, settlement_date, amount, payment, deduction, balance) AS
SELECT DISTINCT invoice.id, invoice.state, invoice.old_state, invoice.invoice_number, invoice.class_id, invoice.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, invoice.third_party_id, invoice.created, invoice.due, invoice.reminders, invoice.reminder_date, invoice.statement_id, invoice.settlement_id, invoice.settlement_date, invoice.amount, invoice.payment, invoice.deduction, invoice.balance
FROM billing.invoice, patient.patient
WHERE patient.id = invoice.patient_id;

-- RECREATE VIEW: billing.transaction
CREATE OR REPLACE VIEW billing.transaction (id, invoice_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, created, transaction_date, cashier_id, settlement_id, settlement_date, debit, credit) AS
SELECT DISTINCT ledger.id, ledger.invoice_id, invoice.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, invoice.created, ledger.transaction_date, ledger.cashier_id, ledger.settlement_id, ledger.settlement_date, ledger.debit, ledger.credit
FROM billing.ledger, billing.invoice, patient.patient
WHERE patient.id = invoice.patient_id 
AND invoice.id = ledger.invoice_id;

-- RECREATE VIEW: billing.trashed_invoice_stub
CREATE OR REPLACE VIEW billing.trashed_invoice_stub (id, state, old_state, invoice_number, class_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, third_party_id, created, due, reminders, reminder_date, statement_id, settlement_id, settlement_date, amount, payment, deduction, balance, trasher_id, trashing_date) AS
SELECT DISTINCT trashed_invoice.id, trashed_invoice.state, trashed_invoice.old_state, trashed_invoice.invoice_number, trashed_invoice.class_id, trashed_invoice.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, trashed_invoice.third_party_id, trashed_invoice.created, trashed_invoice.due, trashed_invoice.reminders, trashed_invoice.reminder_date, trashed_invoice.statement_id, trashed_invoice.settlement_id, trashed_invoice.settlement_date, trashed_invoice.amount, trashed_invoice.payment, trashed_invoice.deduction, trashed_invoice.balance, trashed_invoice.trasher_id, trashed_invoice.trashing_date
FROM billing.trashed_invoice, patient.patient
WHERE patient.id = trashed_invoice.patient_id;

-- RECREATE VIEW: patient.patient_incident_statistics
CREATE OR REPLACE VIEW patient.patient_incident_statistics AS
SELECT  incident.id AS "id", patient.title AS "patient_title", patient.sur_name  AS "patient_surname", patient.first_name  AS "patient_firstname", patient.social_security_number  AS "patient_ssn", incident.incident_date AS "incident_date", physician.title AS "dr_title", physician.name AS "dr_surname", physician.first_name AS "dr_firstname", physician.ucm_code  AS "dr_ucmcode", site.name  AS "site_name", site.id  AS "site_id"
FROM patient.incidents AS incident LEFT OUTER JOIN office.site AS site ON (incident.site_id=site.id), patient.patient AS patient, office.physician AS physician 
WHERE patient.id=incident.patient_id 
AND physician.id=incident.physician_id
ORDER BY site.id, incident.incident_date;



/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.2.06_004.sql');