/* ************************************************************************ */
/*                             UPDATE 1.3.00_005                            */
/* ------------------------------------------------------------------------ */


/* ************************************************************************ */
-- THE STRING AGGREGATE FUNCTION 
/* ************************************************************************ */

/* This string aggregation is used, to keep the compatibility to PostgreSQL 
 * versions older than 8.4
 */
 -- The function for the aggregation
CREATE OR REPLACE FUNCTION aggregate_string (TEXT, TEXT)
  RETURNS TEXT AS $$
DECLARE
  text1 TEXT;
  text2 TEXT;
  separator TEXT;
  
BEGIN
  text1 = $1;
  text2 = $2;
  separator = E'\n-------------------------\n';

  IF text2 IS NOT NULL THEN
    IF trim(both text2) = '' THEN 
      text2 = NULL;
    END IF;
  END IF;
  
  
  IF text1 IS NULL THEN
    IF text2 IS NULL THEN
      RETURN NULL;
    ELSE
      RETURN text2;
    END IF;
  ELSE 
    IF text2 IS NULL THEN
      RETURN text1;
    ELSE 
      RETURN text1 || separator || text2;
    END IF;
  END IF;
END; 
$$ LANGUAGE plpgsql;

-- the aggregation
DROP AGGREGATE IF EXISTS aggregate_string (TEXT);
CREATE AGGREGATE aggregate_string (
  BASETYPE = TEXT,
  SFUNC = aggregate_string,
  STYPE = TEXT
);


/* ************************************************************************ */
-- THE REPAIR FUNCTION 
/* ************************************************************************ */

DROP FUNCTION IF EXISTS repair_duplicate_patient_data ();
CREATE FUNCTION repair_duplicate_patient_data ()
  RETURNS INTEGER AS 
$BODY$

DECLARE
  r RECORD;				-- the record returned by the for-loop
  sum INTEGER;		-- counts the patients with more than one patient data entry
  contents RECORD;		-- the record containing both, the active problems and the chronicle treatments
  apContent VARCHAR;	-- content of all active problems of a patient
  ctContent VARCHAR;	-- content of all chronicle treatments of a patient

BEGIN
  sum = 0;
  FOR r IN 
    SELECT DISTINCT(patient_id) FROM patient.patient_datas d
    WHERE (
      SELECT COUNT(id) FROM patient.patient_datas
      WHERE d.patient_id = patient_id
    ) > 1
  LOOP	
    -- iterate over all patient id, that exist in more than one entry
    sum = sum + 1;	-- count the number of multiple entries to return it
    
    -- concat all entries with this patient ID, separated with minuses
    SELECT aggregate_string(ap) AS ap, 
           aggregate_string(ct) AS ct
      INTO contents
      FROM 
      (
        SELECT active_problem AS ap, 
               chronical_treatments AS ct 
        FROM patient.patient_datas 
        WHERE patient_id = r.patient_id ORDER BY id
      ) AS tab;
    -- assign the result of the query 
    apContent = contents.ap;
    ctContent = contents.ct;
    
    -- delete all entries of this patient
    DELETE FROM patient.patient_datas 
      WHERE patient_id = r.patient_id;

    -- create a new entry with all data and this patient ID
    INSERT INTO patient.patient_datas 
      (patient_id, active_problem, chronical_treatments)
      VALUES
      (r.patient_id, apContent, ctContent);
  END LOOP;
  
  RETURN sum;	-- the number of concerned entries 
END
$BODY$
  LANGUAGE plpgsql VOLATILE;

SELECT repair_duplicate_patient_data();
 	
/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.3.00_005.sql');