/* ********************************************************************** */
/*                            UPDATE 1.4.03_001                           */
/* ---------------------------------------------------------------------- */

/* remove the user settings, that are too big ("too" big means in this context more than 100.000.000 bytes = 100 MB)
 * and those that haven't got any existing users anymore
 */
DELETE FROM usermanagement.setting
WHERE id IN (
SELECT s.id AS "settings_id" 
FROM usermanagement.setting AS s 
FULL JOIN usermanagement.gecamed_user AS u ON s.user_id = u.id
WHERE (u.id IS NULL AND s.user_id <> -1)
OR char_length(xml_config) > 100000000
ORDER BY s.id);


-- --------------------
-- 	Remove the hotkeys from the user settings
-- --------------------

UPDATE usermanagement.setting
SET xml_config = regexp_replace(xml_config, 
    E'\<string\>hotkeys\</string\>([^<]|(\<(?!/object)))+', 
    E'<string>hotkeys</string><object class="java.util.Hashtable">');


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.4.03_001.sql');
