/* ********************************************************************** */
/*                            UPDATE 1.6.00_005                           */
/* ---------------------------------------------------------------------- */

-- Remark for eSanté intermediate versions:
-- Clean the DB from the eSanté entries 
-- (incident entries, incident types, DSP ID):
/*
-- remove the Luxembourg IDs
UPDATE patient.patient
SET id_luxembourg = NULL
WHERE id NOT IN (
  SELECT patient_id FROM esante.dsp
);

-- delete the CDA incident entries
DELETE FROM patient.incident_entry
WHERE entry_type_id IN (
  SELECT id FROM patient.incident_entry_types
  WHERE name = 'cda'
);

-- delete the CDA incident entry types
DELETE FROM patient.incident_entry_types
WHERE name = 'cda';
*/

-- fill the eSanté tables with data (initialize)

-- create the CDA IE type
INSERT INTO patient.incident_entry_types
(name, mime_type)
VALUES
('cda', E'text/xml');


INSERT INTO esante.property
(name, value)
VALUES
('CDA_DOWNLOAD_SITE',               E'client'),
('WSDL_URL_SAML_USER',              E'https://www.esante.lu/dsp-habilitation/UserSAMLService'),
('WSDL_URL_SAML_USER_X509',         E'https://www.esante.lu/dsp-habilitation/X509UserSAMLService'),
('WSDL_URL_PDQ',                    E'https://www.esante.lu/dsp-habilitation/dspAdministrativeService'),
('WSDL_URL_REGISTRY',               E'https://www.esante.lu/dsp-xdsreg'),
('WSDL_URL_RETRIEVE',               E'https://www.esante.lu/dsp-xdsrep'),
('WSDL_URL_PROVIDE',                E'https://www.esante.lu/dsp-xdsrep'),
('WSDL_URL_EHR_ACCESS_RIGHTS',      E'https://www.esante.lu/dsp-habilitation/CheckAccessRightsEhr'),
('WSDL_URL_ASSERTION_SAML_SERVICE', E'https://www.esante.lu/dsp-habilitation/AssertionSAMLService'),
('EPSOS_URL',                       E'https://openncp.esante.lu'),
('EHEALTH_ID_SUPPORT_LINK',         E'http://www.esante.lu'),
('GECAMED_APPLICATION_ID',          E'1337');



-- insert the code types
INSERT INTO esante.code_type
  (name, uuid, coding_scheme)
  VALUES
('classCode',                  'urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a', '1.3.182.10.7.1'),
('typeCode',                   'urn:uuid:f0306f51-975f-434e-a61c-c59651d33983', '1.3.182.10.10.1'),
('healthCareFacilityTypeCode', 'urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1', '1.3.182.10.14.1'),
('formatCode',                 'urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d', '1.3.182.10.12.1'),
('confidentialityCode',        'urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f', '1.3.182.10.8.1'),
('practiceSettingCode',        'urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead', '1.3.182.10.23.1'),
('languageCode',               null,                                            '1.3.182.10.15.1'),
('authorRole',                 null,                                            '1.3.182.10.5.1'),
('authorSpecialty',            null,                                            '1.3.182.10.6.1');

-- eSanté_ClassCode (1.3.182.10.7.1) (13 entries)
SELECT esante.insert_code_description('10', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Personal data', E'Données personnelles', E'Persönliche Daten', E'Personal data', null, null, null);
SELECT esante.insert_code_description('15', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Syntheses', E'Synthèses', E'Synthesen', E'Syntheses', null, null, null);
SELECT esante.insert_code_description('20', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Certificates and declarations', E'Certificats et déclarations', E'Zertifikate und Deklarationen', E'Certificates and declarations', null, null, null);
SELECT esante.insert_code_description('25', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Dispensation', E'Dispensations', E'Dispensation', E'Dispensation', null, null, null);
SELECT esante.insert_code_description('30', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Management documents', E'Documents de gestion', E'Management Dokumente', E'Management documents', null, null, null);
SELECT esante.insert_code_description('35', E'1.3.182.10.7.1', E'1.3.182.5.7', E'General medical data', E'Données Médicales', E'Medizinische Dokumente', E'Medical documents', null, null, null);
SELECT esante.insert_code_description('40', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Social data', E'Données Sociales ', E'Soziale Daten', E'Social data', null, null, null);
SELECT esante.insert_code_description('45', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Medical imaging', E'Imagerie médicale', E'Bildbefundung', E'Medical imaging', null, null, null);
SELECT esante.insert_code_description('50', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Laboratory', E'Laboratoire', E'Labor', E'Laboratory', null, null, null);
SELECT esante.insert_code_description('55', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Prevention', E'Prévention', E'Vorsorge', E'Prevention', null, null, null);
SELECT esante.insert_code_description('60', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Care plans, care protocols', E'Suivi de Soins', E'Pflegepläne, Pflegeprotokolle', E'Care plans, care protocols', null, null, null);
SELECT esante.insert_code_description('65', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Prescription', E'Prescription', E'Verschreibung', E'Prescription', null, null, null);
SELECT esante.insert_code_description('70', E'1.3.182.10.7.1', E'1.3.182.5.7', E'Vaccinations', E'Vaccination', E'Impfungen', E'Vaccinations', null, null, null);
-- eSanté TypeCode (1.3.182.10.10.1) (45 entries 6 of those are deactivated)
-- SELECT esante.insert_code_description(E'64300-7', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Organ donation consent', E'Don d''organes', E'Organspendenachweis', E'Document which contains the patient´s consent for organ donation.', null, null, '10');
SELECT esante.insert_code_description(E'51855-5', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Patient note', E'Expression du titulaire', E'Patientennotiz', E'A patient authored note is generated by a patient, or a patient agent (proxy), acting in a non-clinical role to provide clinically relevant information. The information within the note is used to support planned or unplanned health care services. This document gives healthcare providers and others involved in a person''s care information which the patient considers essential input during care delivery and coordination. This document enables patients and their agents to contribute to the continuity of care. The patient agent may not have a legally defined relationship with the patient (e.g. a close friend). Because a patient authored note is generated by a person acting as a non-clinician, this document may not be a complete medical summary and should be considered in context with other information routinely collected by clinicians during care delivery and coordination. This general class of patient authored notes includes information that is interoperable with data defined for clinician-generated documents. Other more specific classes of patient authored notes may include more tightly defined content. This document may be generated from a patient-, clinician-, or payer-controlled source system.', null, null, '10');
SELECT esante.insert_code_description(E'60591-5', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Patient summary ', E'Résumé patient', E'Patientendossier', E'From epSOS. This document is a concise clinical document that provides an electronic, pre-defined patient health data set applicable both for unexpected, as well as expected (planned), health care contact. This document may be either the product of a medical act or an automatic excerpt from national/regional EHRs. A Patient Summary gives a healthcare provider the essential information needed for health care coordination and, in cases of an unexpected need or when the patient consults a provider other than his regular contact person (e.g. the general practitioner he/she is registered with), this document enables continuity of care. Because it is meant to be a summary, this document might not include a detailed medical history, details on clinical conditions or a full list of all prescriptions and dispensed medicines.', null, null, '15');
SELECT esante.insert_code_description(E'47045-0', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Study report', E'Rapports médicaux', E'Ärztliche Gutachten', E'Document that is generated in response to a request.', null, null, '20');
SELECT esante.insert_code_description(E'DT-20001', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Medical certificates', E'Certificats médicaux', E'Medizinische Zeugnisse', E'Medical certificates', null, null, '20');
SELECT esante.insert_code_description(E'60593-1', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Medication dispensed, extended document', E'Dispensation médicamenteuse', E'Dispensation von Medikamenten (erweitert)', E'Codes from epSOS. This medication dispensed information collection includes information useful for describing the dispensed drugs and the supply act (who did what and when), the context where the document was produced, and additional administrative information if requested. Some of the additional information may include specification of the kinds of exemptions a patient may have (e.g. older than a specified age, pregnant, etc), or specification of financial information (e.g. the amount of co-payment).', null, null, '25');
-- SELECT esante.insert_code_description(E'34106-5', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Physician Hospital Discharge summary', E'Résumé de sortie d´hospitalisation (médecin)', E'Krankenhaus Entlassbericht', E'Discharge summary is a synopsis of a patient''s admission to a hospital; it provides pertinent information for the continuation of care following discharge. The summary may include the reason for hospitalization, procedures performed, the care, treatment and services provided, the patient''s condition and disposition at discharge, information provided to the patient and family, and provisions for follow-up care.', null, null, '35');
-- SELECT esante.insert_code_description(E'11490-0', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Discharge summarization note (physician)', E'Résumé de sortie (médecin)', E'Entlassungsbericht ärztlich', E'Discharge summary is a synopsis of a patient''s admission to a hospital; it provides pertinent information for the continuation of care following discharge. The summary may include the reason for hospitalization, procedures performed, the care, treatment and services provided, the patient''s condition and disposition at discharge, information provided to the patient and family, and provisions for follow-up care.', null, null, '35');
SELECT esante.insert_code_description(E'34117-2', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'History and physical note ', E'Antécédents médicaux et chirurgicaux', E'Medizinische Vorgeschichte', E'History and physical (H&P) note is a medical report that documents the current and past conditions of the patient. It contains essential information that helps determine an individual''s health status.', null, null, '35');
SELECT esante.insert_code_description(E'8670-2', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'History of family member diseases ', E'Antécédents familiaux', E'Familienvorgeschichte', E'History of family member diseases ', null, null, '35');
SELECT esante.insert_code_description(E'48765-2', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Allergies &or adverse reactions', E'Allergies  intolérances reconnues', E'Allergien anerkannte Unduldsamkeiten', E'Contains a list and description of any allergies or adverse reactions pertinent to current or past medical history. At a minimum this section should contain currently active and any relevant historical allergies and adverse reactions.', null, null, '35');
SELECT esante.insert_code_description(E'46264-8', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'History of medical device use ', E'Prothèses et appareillages', E'Prothesen und Apparaturen', E'History of medical device (medical equipment) use defines a patient''s implanted and external medical devices and equipment that their health status depends on, as well as any pertinent equipment or device history. This term is also used to itemize any pertinent current or historical durable medical equipment (DME) used to help maintain the patient''s health status. All pertinent equipment relevant to the diagnosis, care, and treatment of a patient should be included.', null, null, '35');
SELECT esante.insert_code_description(E'70004-7', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Diagnostic study note ', E'CR d''actes diagnostiques', E'Berichte diagnostischer Urkunden(Handlungen)', E'Diagnostic study note ', null, null, '35');
SELECT esante.insert_code_description(E'47519-4', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'History of procedures', E'CR d''actes thérapeutiques', E'Berichte therapeutischer Urkunden(Handlungen)', E'This section defines all interventional, surgical, diagnostic, or therapeutic procedures or treatments pertinent to the patient historically and at the time the document is generated.', null, null, '35');
SELECT esante.insert_code_description(E'18842-5', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Discharge summarization note', E'CR de séjours hospitaliers et lettres de sorties', E'Entlassungsbericht', E'Discharge summary is a synopsis of a patient''s admission to a hospital; it provides pertinent information for the continuation of care following discharge. The summary may include the reason for hospitalization, procedures performed, the care, treatment and services provided, the patient''s condition and disposition at discharge, information provided to the patient and family, and provisions for follow-up care.', null, null, '35');
SELECT esante.insert_code_description(E'DT-40001', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Profession and levels of study', E'Profession et niveaux d''étude', E'Beruf und Niveaus von Studium', E'Profession and levels of study', null, null, '40');
SELECT esante.insert_code_description(E'DT-40002', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Health insurance fund', E'Caisse de Maladie', E'Krankenkasse', E'Health insurance fund', null, null, '40');
SELECT esante.insert_code_description(E'DT-40003', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Medical surgical  or other additional mutual insurance company', E'Caisse médico-chirurgicale ou autre mutuelle supplémentaire', E'Ärztliche chirurgische Kasse oder andere zusätzliche Versicherung auf Gegenseitigkeit', E'Medical surgical  or other additional mutual insurance company', null, null, '40');
SELECT esante.insert_code_description(E'DT-40004', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Accommodation', E'Logement', E'Unterkunft', E'Accommodation', null, null, '40');
SELECT esante.insert_code_description(E'DT-40005', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Social further information', E'Renseignements complémentaires sociaux', E'Soziale ergänzende Informationen', E'Social further information', null, null, '40');
SELECT esante.insert_code_description(E'DT-40006', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Long-term care insurance ', E'Assurance Dépendance ', E'Versicherung(Sicherheit) Abhängigkeit ', E'Long-term care insurance ', null, null, '40');
SELECT esante.insert_code_description(E'DT-40007', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Supervision / guardianship legal Protection', E'Tutelle/Curatelle Protection juridique', E'Vormundschaft / Vormundschaft Gerichtsschutz', E'Supervision / guardianship legal Protection', null, null, '40');
SELECT esante.insert_code_description(E'DT-40008', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Informal help people / third helping', E'Entourage/Aidant informel/Tiers aidant/Accompagnateur DSP', E'Der informelle / dritte helfende ', E'Informal help people / third helping', null, null, '40');
SELECT esante.insert_code_description(E'DT-40009', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Pad palliative care', E'Carnet soins palliatifs', E'Notizbuch palliative Versorgungen', E'Pad palliative care', null, null, '40');
SELECT esante.insert_code_description(E'18748-4', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Diagnostic Imaging Report', E'Images radiologiques ou autres imageries médicales', E'Röntgenbilder oder andere medizinischen Bilderfabrikationen', E'Diagnostic Imaging Report (DIR) contains a consulting specialist''s interpretation of image data. It conveys the interpretation to the referring (ordering) physician and is for use in Radiology, Endoscopy, Cardiology, and other imaging specialties.', null, null, '45');
SELECT esante.insert_code_description(E'11502-2', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Laboratory report total', E'Résultats d''examens biologiques', E'Laborbefund', E'Laboratory report total', null, null, '50');
SELECT esante.insert_code_description(E'51898-5', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Risk factors ', E'Facteurs de risques individuels', E'Eigene Risikofaktoren', E'This is a general risk factors document for data about a patient. Originally created (but not limited in use) for HAI reporting, where the information recorded in the Risk Factors section varies according to Report type. Devices, procedures, other factors associated with risk.', null, null, '55');
SELECT esante.insert_code_description(E'28570-0', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Procedure note', E'CR d''actes à visée préventive', E'Berichte diagnostischer und therapeutischer Urkunden(Handlungen) in vorbeugendem Plan', E'Procedure note is a broad term that encompasses many specific types of non-operative procedures including interventional cardiology, interventional radiology, gastrointestinal endoscopy, osteopathic manipulation, and many other specialty fields. Procedure Notes are differentiated from Operative Notes in that the procedures documented do not involve incision or excision as the primary act. The Procedure Note is created immediately following a non-operative procedure and records the indications for the procedure and, when applicable, post-procedure diagnosis, pertinent events of the procedure, and the patient’s tolerance of the procedure.', null, null, '55');
SELECT esante.insert_code_description(E'DT-55001', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Prescribed or administered preventive treatments(processings)', E'Traitements préventifs prescrits ou administrés', E'Vorgeschriebene oder verwaltete(verabreichte) Präventivbehandlungen(Präventivverarbeitungen)', E'Prescribed or administered preventive treatments(processings)', null, null, '55');
-- SELECT esante.insert_code_description(E'34745-0', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Discharge summarization note (nursing)', E'Résumé des soins / Fiche de liaison de soins', E'Entlassungsbericht pflegerisch', E'Discharge summary is a synopsis of a patient''s admission to a hospital; it provides pertinent information for the continuation of care following discharge. The summary may include the reason for hospitalization, procedures performed, the care, treatment and services provided, the patient''s condition and disposition at discharge, information provided to the patient and family, and provisions for follow-up care.', null, null, '60');
SELECT esante.insert_code_description(E'28636-9', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Initial evaluation note ', E'Bilan d''autonomie', E'Bilanz von Autonomie', E'Initial evaluation note ', null, null, '60');
SELECT esante.insert_code_description(E'47420-5', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Functional status assessment note ', E'Bilan fonctionnel', E'Funktionale Bilanz', E'Functional status assessment describes the patient''s status of normal functioning at the time a care record was created. Functional statuses include information regarding the patient relative to ambulatory ability, mental status or competency, activities of daily living (ADLs) (i.e. bathing, dressing, feeding, grooming), home/living situation having an effect on the health status of the patient, ability to care for self, social activity (i.e. issues with social cognition, participation with friends and acquaintances other than family members), occupation activity (i.e. activities partly or directly related to working), housework or volunteering, family and home responsibilities or activities related to home and family, communication ability (i.e. issues with speech, writing or cognition required for communication), and perception, including sight, hearing, taste, skin sensation, kinesthetic sense, proprioception, or balance.', null, null, '60');
SELECT esante.insert_code_description(E'DT-60001', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Prescribed nursing treatments', E'Traitements soignants prescrits', E'Vorgeschriebene Pflegebehandlungen', E'Prescribed nursing treatments', null, null, '60');
SELECT esante.insert_code_description(E'34140-4', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Transfer of care referral note ', E'Suivi de soins et actes pluridisciplinaires', E'Versorgungsbetreuung und multidisziplinäre Urkunden(Handlungen)', E'Transfer of care referral note ', null, null, '60');
SELECT esante.insert_code_description(E'DT-60002', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Protocol of care relative to the chronic affections', E'Protocole de soins relatifs aux affections chroniques', E'Versorgungsprotokoll, der chronischen Zuneigungen bezüglich', E'Protocol of care relative to the chronic affections', null, null, '60');
SELECT esante.insert_code_description(E'34895-3', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Education note ', E'Education', E'Erziehung', E'Education note ', null, null, '60');
SELECT esante.insert_code_description(E'57833-6', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Prescription for medication', E'Traitements médicamenteux', E'Verschreibung von Medikamenten', E'Prescription for medication. Document used to prescribe drugs (Note: it is the document, not the medication).', null, null, '65');
-- SELECT esante.insert_code_description(E'57829-4', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Prescription for medical equipment or product', E'Prescription pour équipement ou produit médical', E'Verschreibung medizinischer Geräte oder Produkte', E'Prescription for medical equipment or product. Document used to prescribe medical equipments (e.g wheelchairs) and/or sanitary products (sanitary towels, sanitary napkins, urine bags,...)', null, null, '65');
-- SELECT esante.insert_code_description(E'57832-8', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Prescription for diagnostic or specialist care', E'Prescription d''actes diagnostics ou de soins spécialisés', E'Verschreibung für weiterführende medizinische Behandlung (Überweisung)', E'Prescription for diagnostic or specialist care', null, null, '65');
SELECT esante.insert_code_description(E'57828-6', E'1.3.182.10.10.1', E'2.16.840.1.113883.6.1', E'Prescription list ', E'Traitements médicaux prescrits', E'Vorgeschriebene medizinische Behandlungen(Verarbeitungen)', E'A document (or section) including a list of all prescriptions made for a patient (medications, services, admissions, equipment, etc.).', null, null, '65');
SELECT esante.insert_code_description(E'DT-65001', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Therapeutic plan', E'Schéma thérapeutique', E'Therapeutisches Schema', E'Therapeutic plan', null, null, '65');
SELECT esante.insert_code_description(E'DT-65002', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Protocol of distress', E'Protocole de détresse', E'Notprotokoll', E'Protocol of distress', null, null, '65');
SELECT esante.insert_code_description(E'DT-65003', E'1.3.182.10.10.1', E'1.3.182.5.9', E'null', E'CR d''administration', E'null', E'null', null, null, '65');
SELECT esante.insert_code_description(E'DT-70001', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Vaccinations', E'Vaccinations', E'Impfungen', E'Vaccinations', null, null, '70');
SELECT esante.insert_code_description(E'DT-70002', E'1.3.182.10.10.1', E'1.3.182.5.9', E'Calendar of the vaccinations', E'Calendrier des vaccinations', E'Kalender der Impfungen', E'Calendar of the vaccinations', null, null, '70');
-- eSante HealthcareFacilityTypeCode (1.3.182.10.14.1) (95 entries)
SELECT esante.insert_code_description(E'F-000', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Établissement non identifié', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-010', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Cabinet privé médical', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-011', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Maison médicalisée', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-012', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Cabinet de médecins privé', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-013', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique médicale', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-014', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Cabinet privé non médical', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-020', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Maison de soins', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-021', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Maison de soins spécialisés', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-022', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Infirmerie scolaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-030', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Pharmacie (officine) de ville', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-040', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Organisation professionnelle', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-041', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Association usagers', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-042', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Syndicat professionnel', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-050', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Institution médico-sociale', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-051', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Réseau d''aide et de soins à domicile', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-060', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Entreprise dans le domaine médical', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-061', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Entreprise de transports sanitaires', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-062', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Entreprise de transports spécialisés médico-sanitaires', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-063', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Entreprise de taxis agréée pour transport sanitaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-064', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Entreprise de service à la personne', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-070', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Fournisseur dans le domaine médical', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-071', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Fournisseur de produits médicamenteux', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-072', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Fournisseur de dispositifs médicaux', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-073', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Fournisseur de produits dérivés du sang', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-074', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Fournisseur de produits médicaux', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-075', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Fournisseur de cosmetique', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-080', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Établissements et organismes de formation médicale ou de santé', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-081', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Établissement public de formation médicale ou de santé', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-082', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Établissement privé de formation médicale ou de santé', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-083', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Organisme de formation médicale ou de santé', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-084', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Organisme de formation continue médicale ou de santé', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-090', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Cliniques vétérinaires', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-091', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Laboratoire spécilisé en clinique vétérinaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-100', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Établissement de soins de santé', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-101', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de traitement médical', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-102', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Hôpital de soins primaires (soins aigüs)', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-103', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Hôpital de soins secondaires (soins spécialisés)', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-104', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Hôpital de soins tertiaires (soins supplémentaires)', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-105', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Hôpital de soins intermédiaires (soins à moyen terme)', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-106', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Hôpital de soins intermédiaires pour des personnes ayant une déficience intellectuelle', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-107', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de traitement pour des enfants présentant des troubles affectifs', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-108', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Hôpital de soins de longue durée', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-109', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre anticancéreux', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-110', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Hôpital pour enfants', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-111', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Hôpital psychiatrique', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-112', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de désintoxication', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-113', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de traitement pour toxicomanes', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-114', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Hôpital de réadaptation', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-116', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de traumatologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-117', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de brûlés', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-118', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Hôpital gériatrique', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-119', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique externe d''un hôpital', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-120', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique indépendante', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-121', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique indépendante de médecine familiale', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-122', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique indépendante de réadaptation', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-123', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique indépendante de pédiatrie', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-124', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique indépendante de santé mentale', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-125', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique indépendante de psychiatrie', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-126', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique indépendante de gériatrie', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-127', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique d''urgence indépendante', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-128', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique indépendante de chirurgie ambulatoire', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-129', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre des naissances indépendant', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-130', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique sans rendez-vous', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-131', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de vaccination', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-132', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique des voyageurs', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-133', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique des maladies sexuellement transmissibles', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-134', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Dispensaire antivénérien', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-135', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique externe de psychiatrie d''une hôpital', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-136', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique externe de gériatrie d''un hôpital', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-137', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre mère-enfant hospitalier', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-138', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Clinique indépendante de chirurgie d''un jour', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-139', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre mère-enfant indépendant', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-140', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de traitement de la douleur', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-141', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Maison de retraite', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-147', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Établissement pour personnes déficientes (mentales ou physiques)', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-148', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre d''aide psycho-social', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-149', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Établissement spécialisé en psychologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-150', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Établissements de cures thermales et de convalescence', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-151', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de dialyse', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-200', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre médico-social', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-201', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de service à la personne', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-202', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre d''information médico-sociale', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-203', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre d''accueil médical ou social', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-204', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre d''accueil de jour', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-205', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre d''accueil de nuit', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-206', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre d''accueil spécialisé (jour et-ou nuit)', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-207', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Crèches et garderies', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-208', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de réadaptation professionnel', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-209', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre spécialisé pour personne déficiente', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-210', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre d''orientation', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-211', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre local de santé communautaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-300', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de radiologie indépendant', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-301', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Laboratoire indépendant', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-302', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre de médecine du travail', null, null, null, null, null);
SELECT esante.insert_code_description(E'F-303', E'1.3.182.10.14.1', E'1.3.182.5.3', null, E'Centre ou établissement de recherche', null, null, null, null, null);
-- eSanté FormatCode (1.3.182.10.12.1) (5 entries)
SELECT esante.insert_code_description(E'urn:ihe:iti:xds-sd:pdf:2008',E'1.3.182.10.12.1', E'1.3.6.1.4.1.19376.1.2.3', E'PDF', E'PDF', E'PDF', E'If the document is a PDF - file', null, null, null);
SELECT esante.insert_code_description(E'urn:ihe:iti:xds-sd:text:2008',E'1.3.182.10.12.1', E'1.3.6.1.4.1.19376.1.2.3', E'TXT', E'TXT', E'TXT', E'If the document contains text', null, null, null);
SELECT esante.insert_code_description(E'urn:ihe:lab:xd-lab:2008',E'1.3.182.10.12.1', E'1.3.6.1.4.1.19376.1.2.3', E'CDA', E'CDA', E'CDA', E'If the document is a structured XD-Lab conformant document', null, null, null);
SELECT esante.insert_code_description(E'urn:ihe:pcc:xds-ms:2007',E'1.3.182.10.12.1', E'1.3.6.1.4.1.19376.1.2.3', E'CDA', E'CDA', E'CDA', E'If the document is a medical summary (XDS-MS)', null, null, null);
SELECT esante.insert_code_description(E'urn:esante:cda:cda1b:2013', E'1.3.182.10.12.1', E'1.3.182.5.10', E'CDA-1b', E'CDA-1b', E'CDA-1b', E'If the document is a medical document conformant to CDA Level 1b', null, null, null);
-- eSanté ConfidentialityCode(1.3.182.10.8.1) (4 entries)
SELECT esante.insert_code_description(E'N', E'1.3.182.10.8.1', E'2.16.840.1.113883.5.25', E'normal', E'Normal', E'normal', E'Normal confidentiality rules (according to good health care practice) apply, that is, only authorized individuals with a legitimate medical or business need may access this item.', null, null, null);
SELECT esante.insert_code_description(E'R', E'1.3.182.10.8.1', E'2.16.840.1.113883.5.25', E'restricted', E'Restreint', E'eingeschränkt', E'Restricted access, e.g. only to providers having a current care relationship to the patient.', null, null, null);
SELECT esante.insert_code_description(E'I', E'1.3.182.10.8.1', E'2.16.840.1.113883.5.25', E'individual', E'Privé', E'privat', E'Access only to individual persons who are mentioned explicitly as actors of this service and whose actor type warrants that access (cf. to actor type code).', null, null, null);
SELECT esante.insert_code_description(E'T', E'1.3.182.10.8.1', E'2.16.840.1.113883.5.25', E'taboo', E'Bloqué', E'blockiert', E'Information not to be disclosed or discussed with patient except through physician assigned to patient in this case. This is usually a temporary constraint only, example use is a new fatal diagnosis or finding, such as malignancy or HIV.', null, null, null);
-- eSanté PracticeSettingCode(1.3.182.10.23.1) (54 entries)
SELECT esante.insert_code_description(E'FP-000', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service non connu', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-001', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service hospitalier non spécifié', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-010', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service ou unité hospitaliers', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-011', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service antidouleur', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-012', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de cardiologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-013', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de chirurgie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-014', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de consultations externes d''un hôpital', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-015', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de dermatologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-016', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de gastro-entérologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-017', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de gérotonlogie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-018', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de gynécologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-019', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Clinique externe de gynécologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-020', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de médecine', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-021', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de neurologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-022', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de pédiatrie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-023', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de physiatrie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-024', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de pneumologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-025', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité de rééducation', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-026', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de réadaptation', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-027', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de rhumatologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-028', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de santé mentale (psychiatrie)', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-029', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service d''endocrinologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-030', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service dentaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-031', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service des maladies infectueuses', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-032', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service des maladies respiratoires', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-033', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service d''hématologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-034', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service d''immunologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-035', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service d''allergologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-036', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service d''obstétrique', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-037', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Centre des naissances', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-038', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service d''oncologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-039', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service d''ophtalmologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-040', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service d''orthopédie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-041', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service d''oto-rhino-laryngologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-042', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de psychologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-043', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service d''urgence', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-044', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de traumatologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-045', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service d''urologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-046', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service pour le dépistage des maladies du sein', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-047', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service pour troubles du système vasculaire périphérique', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-055', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité de soins palliatifs', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-080', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité de soins ambulatoires', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-081', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité de chirurgie de court séjour', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-082', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité de chirurgie ambulatoire', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-090', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de soins ou d''hospitalisation à domicile', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-091', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Service de soins spécialisés à domicile', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-100', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité spécialisée (plateau technique)', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-101', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité de laboratoire', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-102', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité de pharmacie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-103', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité de radiologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-104', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité de radiothérapie', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-105', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité de recherche médicale ou clinique', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-106', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité de spécialisée de gestion don organe', null, null, null, null, null);
SELECT esante.insert_code_description(E'FP-200', E'1.3.182.10.23.1', E'1.3.182.5.4', null, E'Unité médicale en milieu carcéral', null, null, null, null, null);
-- eSante languageCode (1.3.182.10.15.1) (5 entries)
SELECT esante.insert_code_description(E'lb-LU', E'1.3.182.10.15.1', null, E'Luxembourgish', E'Luxembourgeois', E'luxemburgisch', null, null, null, null);
SELECT esante.insert_code_description(E'de-LU', E'1.3.182.10.15.1', null, E'German', E'Allemand', E'deutsch', null, null, null, null);
SELECT esante.insert_code_description(E'fr-LU', E'1.3.182.10.15.1', null, E'French', E'Français', E'französisch', null, null, null, null);
SELECT esante.insert_code_description(E'en-LU', E'1.3.182.10.15.1', null, E'English', E'Anglais', E'englisch', null, null, null, null);
SELECT esante.insert_code_description(E'pt-LU', E'1.3.182.10.15.1', null, E'Portuguese', E'Portugais', E'portugiesisch', null, null, null, null);
-- eSante AuthorRole (1.3.182.10.5.1) (22 entries)
SELECT esante.insert_code_description(E'ADMPHYS', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'admitting physician', E'Médecin instruisant l''admission', E'Aufnehmender Arzt', E'A physician who admitted a patient to a hospital or other care unit that is the context of this service.', null, null, null);
SELECT esante.insert_code_description(E'ANRS', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'anesthesia nurse', E'Infirmière anesthésiste', E'Anästhesie Assistent', E'In a typical anesthesia setting the nurse principally assisting the anesthesiologist during the critical periods.', null, null, null);
SELECT esante.insert_code_description(E'ANEST', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'anesthesist', E'Anesthésiste', E'Anästhesist', E'In a typical anesthesia setting an anesthesiologist or anesthesia resident in charge of the anesthesia and life support, but only a witness to the surgical procedure itself.', null, null, null);
SELECT esante.insert_code_description(E'ATTPHYS', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'attending physician', E'Médecin traitant', E'Behandelnder Arzt', E'A physician who is primarily responsible for a patient during the hospitalization, which is the context of the service.', null, null, null);
SELECT esante.insert_code_description(E'DISPHYS', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'discharging physician', E'Médecin autorisant la sortie', E'Entlassender Arzt', E'A physician who discharged a patient from a hospital or other care unit that is the context of this service.', null, null, null);
SELECT esante.insert_code_description(E'FASST', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'first assistant surgeon', E'Premier assistant chirurgien', E'Erster Assistent der Chirurgie', E'In a typical surgery setting the assistant facing the primary surgeon.', null, null, null);
SELECT esante.insert_code_description(E'MDWF', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'midwife', E'Sage-femme', E'Hebamme', E'A person (usually female) helping a woman deliver a baby.', null, null, null);
SELECT esante.insert_code_description(E'NASST', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'nurse assistant', E'Aide soignant', E'Pflegehelfer/Pflegehelferin', E'In a typical surgery setting the non-sterile nurse handles material supply from the stock, forwards specimen to pathology, and helps with other non-sterile tasks (e.g., phone calls, etc.).', null, null, null);
SELECT esante.insert_code_description(E'PCP', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'primary care physician', E'Médecin de famille,Médecin généraliste', E'Hausarzt, Grundversorger', E'The healthcare provider that holds primary responsibility for the overall care of a patient.', null, null, null);
SELECT esante.insert_code_description(E'CPCP', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'contractual primary care physician', E'Médecin référent', E'Referenzarzt', E'The healthcare provider which has a legal contract with the patient for primary responsibility for the overall care of a patient, being the "Médecin Référent" in Luxembourg.', null, null, null);
SELECT esante.insert_code_description(E'PRISURG', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'primary surgeon', E'Chirurgien responsable', E'Verantwortlicher Chirurg', E'In a typical surgery setting the primary performing surgeon.', null, null, null);
SELECT esante.insert_code_description(E'SASST', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'second assistant surgeon', E'Deuxième assistant chirurgien', E'Zweiter Assistent der Chirurgie', E'In a typical surgery setting the assistant who primarily holds the hooks.', null, null, null);
SELECT esante.insert_code_description(E'SNRS', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'scrub nurse', E'Infirmière de salle d''opération', E'OP-Schwester', E'In a typical surgery setting the nurse in charge of the instrumentation.', null, null, null);
SELECT esante.insert_code_description(E'TASST', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'third assistant', E'Autre assistant', E'Weiterer Assistent', E'In a typical surgery setting there is rarely a third assistant (e.g., in some operations the third assistant postures the affected leg).', null, null, null);
SELECT esante.insert_code_description(E'OTH', E'1.3.182.10.5.1', E'2.16.840.1.113883.5.88', E'others', E'Texte libre', E'Freitext welcher die Rolle beschreibt.', E'If the specific role is not presented in the value set, the code "OTH" can be used. The display name can contain freetext describing this role.', null, null, null);
SELECT esante.insert_code_description(E'PAT', E'1.3.182.10.5.1', E'1.3.182.5.6', E'patient', E'Patient', E'Patient', E'The patient himself.', null, null, null);
SELECT esante.insert_code_description(E'GUARD', E'1.3.182.10.5.1', E'1.3.182.5.6', E'guardian', E'Tuteur', E'Vormund (gesetzl.)', E'The role played by a person or institution legally empowered with responsibility for the care of a ward.', null, null, null);
SELECT esante.insert_code_description(E'INTERPHYS', E'1.3.182.10.5.1', E'1.3.182.5.6', E'interpreting physician', E'Médecin interprétant (les résultats)', E'', E'The role played by a health professional which is consulted to interpret ', null, null, null);
SELECT esante.insert_code_description(E'PRS', E'1.3.182.10.5.1', E'1.3.182.5.6', E'personal relationship', E'Relation Personnelle (Personne de confiance)', E'Persönliche Beziehung', E'Links two people in a personal relationship. The character of the relationship must be defined by a PersonalRelationshipRoleType code. The player and scoper are determined by PersonalRelationshipRoleType code as well.', null, null, null);
-- eSanté authorSpecialty (1.3.182.10.6.1) (140 entries)
SELECT esante.insert_code_description(E'P-000', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Non précisé', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-001', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Médecin généraliste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-002', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Allergologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-003', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Anatomopathologiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-004', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Anesthésiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-005', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Autres médecins', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-006', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Cardiologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-007', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Chirurgien (chirurgie générale)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-008', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Chirurgien cardiovasculaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-009', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Chirurgien orthopédiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-010', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Chirurgien plasticien', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-011', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Chirurgien spécialiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-012', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Chirurgien thoracique', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-013', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Dermatologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-014', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Endocrinologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-015', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Gastro-entérologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-016', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Gérontologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-017', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Gynécologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-018', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Hématologiste de laboratoire', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-019', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Hématologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-020', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Immunologiste clinique', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-021', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Infectiologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-022', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Interniste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-023', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Médecin (hygiène et santé publique)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-024', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Médecin (médecine de famille)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-025', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Médecin (médecine générale)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-026', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Médecin (médecine interne)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-027', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Médecin (santé communautaire)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-028', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Médecin biochimiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-029', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Médecin de laboratoire', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-030', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Médecin microbiologiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-031', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Médecin spécialiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-032', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Médecin spécialiste en électroencéphalographie', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-033', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Néonatalogiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-034', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Néphrologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-035', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Neurochirurgien', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-036', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Neurologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-037', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Neuropathologiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-038', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Neuropsychiatre', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-039', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Obstétricien', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-040', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Ophthalmologiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-041', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Oto-rhino-laryngologiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-042', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Pathologiste clinicien', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-043', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Pathologiste général', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-044', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Pédiatre', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-045', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Pédo-psychiatre', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-046', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Physiatre', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-047', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Pneumologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-048', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Psychiatre', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-049', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Radiologiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-050', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Radio-oncologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-051', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Radiothérapeute', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-052', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Rhumatologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-053', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Spécialiste en médecine nucléaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-054', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Spécialiste en radiologie diagnostique', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-055', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Urologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-056', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Urgentiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-070', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Assistant médical', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-080', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Dentiste, en général', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-081', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Dentiste spécialiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-082', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Orthodontiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-083', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Périodontiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-084', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Endodontiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-085', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Prothodontiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-086', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Prothodontiste (prothèses fixes)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-087', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Prothodontiste (prothèses amovibles)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-088', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Dentiste (hygiène publique)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-089', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Chirurgien buccal', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-090', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Spécialiste en chirurgie buccale et maxillo-faciale', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-091', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Pathologiste buccal', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-092', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Pathologiste buccale', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-093', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Spécialiste en gérodontologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-094', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Pédodontiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-095', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Assistant dentaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-096', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Assistant dentaire (enfants d''âge préscolaire et scolaire)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-097', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Hygiéniste dentaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-100', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Pharmacien', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-101', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Assistant pharmacien', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-110', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Infirmier diplômé, en général', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-111', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Infirmier diplômé spécialisé', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-112', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Infirmier de santé publique', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-113', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Infirmier en santé du travail', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-114', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Autres infirmiers diplômés', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-115', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Infirmier auxiliaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-116', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Aide-infirmier', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-120', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Sage-femme diplômée', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-121', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Sage-femme auxiliaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-130', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Diététiste, en général', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-131', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Nutritionniste en santé publique', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-132', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Autres diététistes et nutritionnistes en santé publiques', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-133', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Optométriste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-134', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Opticien d''ordonnances', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-135', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Physiothérapeute', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-136', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Ergothérapeute', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-137', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Masseur', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-138', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Psychomotricien', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-139', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Ostéopathe', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-140', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Chiropraticien', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-141', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Hygiéniste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-142', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Technicien en orthopédie', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-143', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Orthophoniste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-144', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Orthoptiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-145', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Podologue', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-150', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Travailleur social, en général', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-151', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Agent d''aide sociale', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-152', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Animateur culturel', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-153', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Travailleur social (délinquance)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-154', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Travailleur social (santé mentale)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-155', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Autres travailleurs sociaux', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-199', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Autres personnels assimilés soignant', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-200', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Anatomiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-201', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Biochimiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-202', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Physiologiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-203', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Bactériologiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-204', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Pathologiste (médecine)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-205', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Pharmacologiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-206', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Autres bactériologistes, pharmacologistes et spécialistes assimilés', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-207', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Technicien en biologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-208', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Autres techniciens des sciences biologiques', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-209', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Technicien en radiologie', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-300', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Vétérinaire, en général', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-301', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Vétérinaire (santé publique)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-302', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Autres vétérinaires', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-304', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Assistant vétérinaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-400', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Agent administratif', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-401', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Analyste de systèmes', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-402', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Administrateur (administration publique)', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-403', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Directeur général', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-404', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Directeur administratif', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-405', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Directeur du budget et de la comptabilité', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-406', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Directeur du personnel et des relations de travail', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-407', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Autres directeurs', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-408', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Administrateur scolaire', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-409', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Administrateur d''hôpital', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-410', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Archiviste médical', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-411', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Secrétaire-sténographe', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-412', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Commis à la distribution du courrier', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-413', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Standardiste', null, null, null, null, null);
SELECT esante.insert_code_description(E'P-414', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Aide juridique', null, null, null, null, null);
SELECT esante.insert_code_description(E'PAT', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Patient', null, null, null, null, null);
SELECT esante.insert_code_description(E'DEV', E'1.3.182.10.6.1', E'1.3.182.5.2', null, E'Appareil', null, null, null, null, null);


-- eventCodeList
-- (7, E'CCAM', E'Antécédent, prescription, couverture sociale, examen complémentaire');
-- ------------------------------


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.6.00_005.sql');