/* ********************************************************************** */
/*                            UPDATE 2.00.03_003                          */
/* ---------------------------------------------------------------------- */

-- Function added to print sickleave entries and measurement entry ordered

-- changed the method to be more stable concerning null values and added the output and translation for the new conultation entriess
SELECT letter.insert_letter_placeholder(NULL, E'PATIENT_HISTORY', E'Functions available to all PATIENT_HISTORY placeholders', 
E'/**
 * PATIENT HISTORY FUNCTIONS
 */

/**
 * int days: The last x days to get the history.
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 */
function getPatientHistoryXDays (days, asTable)
{
	if (typeof asTable == "undefined")
		asTable = true;
	
	var from = clearCalendar();
	var to = clearCalendar();
	
	
	from.add(java.util.Calendar.DAY_OF_MONTH, -(days-1));
	to.add(java.util.Calendar.DAY_OF_MONTH, 1);
	
	return getPatientHistory(PATIENT, null, from.getTime(), to.getTime(), asTable);
}

/**
 * Patient patient: The patient to get the history from
 * String[] types: The incident entry types to fetch
 * Date fromDate: The earliest date to get the history 
 * Date toDate: The latest date to get the history
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 * return: The history of the patient as HTML or text (depending on the asTable flag).
 */
function getPatientHistory (patient, types, fromDate, toDate, asTable)
{
	if (patient == null || !patient.isPersistent())
		return "";
	
	if (typeof asTable == "undefined")
		asTable = true;
	
	var incidents = getPatientIncidents(patient, types, fromDate, toDate, null);
	var text = new java.lang.StringBuilder(
			"<html><head><title>history</title><meta charset=\\"utf-8\\"/></head><body>\\n");
	
	if (asTable)
		text = text.append("<table border=\\"1\\" cellspacing=\\"0\\"><tbody>");
	
	if (incidents == null || incidents.size() == 0)
		return "";
	
	for (var i = 0; i < incidents.size(); i++)
	{
		text = appendIncidentRows(incidents.get(i), text, asTable);
		if ((i + 1) < incidents.size())
			text.append("<br>");
	}
	
	if (asTable)
		text.append("\\n</tbody></table>");
	text.append("</body></html>");
	
	return text.toString();
}


/**
 * Patient patient: The patient to get the history from
 * String[] types: The incident entry types to fetch. Leave it null, to select all types.
 * Date fromDate: The earliest date to get the history. Leave it null, to set no start date.
 * Date toDate: The latest date to get the history. Leave it null, to set no end date.
 * Integer max: The maximum number of results. Leave it null, to set no maximum.
 * return: The incidents of the patient.
 */
function getPatientIncidents (patient, types, fromDate, toDate, max)
{
	var query = new java.lang.StringBuilder();
	
	
	if (typeof max == "undefined")
		max = null;
	if (typeof toDate == "undefined")
		toDate = null;
	if (typeof fromDate == "undefined")
		fromDate = null;
	if (typeof types == "undefined")
		types = null;
	
	if (patient == null || !patient.isPersistent().booleanValue())
		return null;
	
	// define the query
	query.append("SELECT OBJECT(i)")
			.append("\\nFROM Incident i")
			.append(types == null ? "" : ", IncidentEntry e, IncidentEntryType t")
			.append("\\nWHERE i.patientId = ").append(patient.getId());
	if (types != null && types.length > 0)
	{
		query.append("\\nAND i.id = e.incidentId")
			.append("\\nAND t.id = e.entryTypeId")
			.append("\\nAND t.name IN (");
		for (var i = 0; i < types.length; i++)
			query.append(i == 0 ? "''" : ", ''").append(types[i]).append("''");
		query.append(")\\n");
	}
	if (fromDate != null)
		query.append("\\nAND i.incidentDate > ").append("''"+FORMATTER.formatDate(fromDate, "yyyy-MM-dd")+"''");
	if (toDate != null)
		query.append("\\nAND i.incidentDate < ").append("''"+FORMATTER.formatDate(toDate, "yyyy-MM-dd")+"''");
	query.append("\\nORDER BY i.incidentDate DESC");
	
	var incidents = null;
	if (max == null)
		incidents = DATABASE_MANAGER.doHqlQuery(query.toString());
	else
		incidents = DATABASE_MANAGER.doHqlQuery(query.toString(), null, max);
	
	if (incidents != null && !incidents.isEmpty() && types != null && types.length > 0)
	{
		// remove all IncidentEntries, that doesn''t fit the type
		var incident;
		var entries;
		var newEntries;
		var entry;
		// put the types into a HashSet for a faster search
		var typeSet = new java.util.HashSet(types.length);
		java.util.Collections.addAll(typeSet, types);
		
		for (var iter = incidents.iterator(); iter.hasNext(); )
		{
			incident = iter.next();
			entries = incident.getIncidentEntries();
			
			if (entries == null || entries.isEmpty())
				continue;
			
			newEntries = new java.util.ArrayList(entries.size());
			for (var entryIter = entries.iterator(); entryIter.hasNext(); )
			{
				entry = entryIter.next();
				if (entry.getEntryType() != null
						&& typeSet.contains(entry.getEntryType().getName()))
					newEntries.add(entry);
			}
			incident.setIncidentEntries(newEntries);
		}
	}
	
	return incidents;
}


/**
 * IncidentEntry entry: The incident entry to format
 * StringBuilder text: The 
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 * return: The data of the incident entry
 */
function appendIncidentRows (incident, text, asTable)
{
	if (typeof asTable == "undefined")
		asTable = true;
	
	var type;
	var entries;
	var rows;
	var incidentDate;
	var physician;
	var iter;
	var entry;
	var content;
	var isAccident;
	var list;
	
	
	// check
	entries      = incident.getIncidentEntries();
	if (entries == null || entries.isEmpty())
		return text;
	
	isAccident   = incident.getIsAccident().booleanValue();
	rows         = entries.size() + (isAccident ? 1 : 0);
	incidentDate = incident.getIncidentDate();
	physician    = getPhysician(incident.getPhysicianId());
	
	// define the row and the date / physician cell
	if (asTable)
	{
		text.append("\\n<tr valign=\\"top\\">\\n  <td rowspan=\\"")
				.append(rows)
				.append("\\" nowrap>");
	}
	text.append("<b>")
			.append(FORMATTER.formatDate(incidentDate))
			.append(asTable ? "</b><br>" : "</b>&nbsp;")
			.append("<span style=\\"font-size:10px\\">")
			.append(FORMATTER.formatDate(incidentDate, "HH:mm"));
	if (physician != null) 
		text.append(" - ")
				.append(physician.getMnemonic());
	text.append("</span>");
	
	if (asTable)
		text.append("</td>\\n");
	else
		text.append("<br>");
	
	if (isAccident)
	{
		var accidentDate = incident.getAccidentDate();
		var accidentNr   = incident.getAccidentNr();
		
		if (asTable)
			text.append("\\n  <td nowrap>");
		text.append("<i>")
				.append(tryTranslate("pm.", "accident"));
		
		if (accidentDate != null || accidentNr != null)
		{
			text.append("</i>");
			if (asTable)
				text.append("</td>\\n  <td>");
			
			if (accidentNr != null)
				text.append(accidentNr);
			if (accidentDate != null && accidentNr != null)
				text.append(" - ");
			if (accidentDate != null)
				text.append(FORMATTER.formatDate(accidentDate))
			
			if (asTable)
				text.append("</td>\\n</tr>\\n<tr valign=\\"top\\">\\n");
			else
				text.append("<br>");
		}
	}
	
	// run through the entries and add a row for each
	for (iter = entries.iterator(); iter.hasNext(); )
	{
		// get the current entry and its type
		entry = iter.next();
		type  = entry.getEntryType().getName();
		
		if (type == null
				|| type.startsWith("soap.")
				|| type.startsWith("cons.")
				|| type.equals("letter")
				|| type.equals("form")
				|| type.equals("dicom"))
		{
			// this is the default way to get the content of an incident entry ... 
			// ... get the text content ...
			content = entry.getTextContent();
			if (content == null)
			{
				content = new java.lang.String("");
			}
			else if (content.matches("\\\\A\\\\W*\\\\<(?i)html(?-i)\\\\>[\\\\W\\\\w]*"))
			{
				if (content.matches("\\\\A(\\\\W*\\\\<(?i)html(?-i)\\\\>\\\\W*)+\\\\<(?i)head(?-i)\\\\>[\\\\W\\\\w]*"))
					content = content.substring(content.indexOf("</head>") + 7);
				
				content = content
						.replace("<html>", "")
						.replace("</html>", "")
						.replace("<body", "<span")
						.replace("</body>", "</span>");
			}
			else
			{
				content.replace("\\n", "<br>");
			}
			
			// ... abd the code value ...
			var code = entry.getCode();
			
			if (code != null && !code.isEmpty())
			{
				var label = new java.lang.String("patient.incident.code." + type);
				var codeLabel = tryTranslate(label);
				//print("Translate \\"patient.incident."+label + "\\" to \\"" + codeLabel + "\\"\\n");
				
				if (codeLabel == null || codeLabel.equals(label))
				{
					codeLabel = tryTranslate("patient.incident.code");
					if (codeLabel == null)
						codeLabel = new java.lang.String("Code");
				}
				
				content = new java.lang.StringBuilder(content)
						.append(content.isEmpty() ? "<b>" : "<br><b>")
						.append(codeLabel)
						.append(":</b> ")
						.append(code)
						.toString();
			}
			
			// ... try to translate the type ...
			if (type == null || type.trim().length == 0)
				type = new java.lang.String("");
			else
				type = tryTranslate("patient.incident.", type);
		}
		else if (type.equals("file"))
		{
			// get the content for an attached file
			type    = tryTranslate("core.", type);
			content = entry.getTextContent();
			if (content == null || content.trim().length == 0)
				content = entry.getOriginalFilename();
			else 
				content = new java.lang.String(content + "<br><i><span style=\\"font-size:12px\\">" + entry.getOriginalFilename() + "</i></span>");
		}
		else if (type.equals("prescription"))
		{
			// get the content for a presciption
			type    = tryTranslate("pm.", type);
			list    = DATABASE_MANAGER.doHqlQuery(
					"SELECT OBJECT(p) FROM Prescription p WHERE p.incidentEntryId = " + 
					entry.getId());
			
			if (list == null || list.isEmpty())
				// no prescription found
				content = new java.lang.String("");
			else
				// get the text of the prescription
				content = list.get(0).getTextContent().replace("\\n", "<br>");
		}
		else if (type.equals("measurement"))
		{
			// get the content for a measurement
			type    = tryTranslate("patient.incident.", type);
			content = getMeasurementContent(entry, asTable);
		}
		else if (type.equals("labo.result"))
		{
			// get the content for a labo result
			type    = tryTranslate("patient.history.", "labo");
			content = entry.getTextContent();
		}
		else if (type.equals("sick_leave"))
		{
			// print the sickleave
			var code  = entry.getCode();
			var start = entry.getSickLeaveStartDate();
			var end   = entry.getSickLeaveEndDate();
			
			type = tryTranslate("patient.incident." + type);
			if (type == null || type.trim().isEmpty())
				type = new java.lang.String("Sickleave");
			
			content = code != null ? code : new java.lang.String("");
			// no sense to print only start or end date, there for it is only printen, if both are set
			if (start != null && end != null)
			{
				content = new java.lang.StringBuilder(content)
						.append(code == null ? "" : " (")
						.append(FORMATTER.formatDate(start))
						.append(" - ")
						.append(FORMATTER.formatDate(end))
						.append(code == null ? "" : ")")
						.toString();
			}
		}
		else
		{
			// show, that there is an error
			// NEED TO ADD A ROW, otherwise the table will be messed up
			content = entry.getTextContent();
			print("UNSUPPORTED TYPE: " + type + " (" + content + ")" + "\\n");
		}
		
		// replace the HTML start tag, as this may mess up the HTML table
		//content = content.replace("<html>", "");
		
		text.append(asTable ? "\\n  <td nowrap><i>" : "\\n<div  style=\\"margin-top: 5px, margin-bottom: 0px\\"><i>")
				.append(type == null ? "" : type)
				.append(asTable ? "</i></td>\\n  <td>" : ":</i></div>\\n")
				.append(content == null ? "" : content);
		if (iter.hasNext())
		{
			if (asTable)
				text.append("</td>\\n</tr>\\n<tr valign=\\"top\\">");
			else if (!asTable)
				text.append("<br>\\n");
		}
	}
	//if (!asTable)
	//	text.append("<br>\\n");
	return text;
}


/**
 * IncidentEntry entry: The entry to fetch the measurements from
 * boolean asTable: Whether or not the text shall be formatted as HTML. DEFAULT: true
 * return: An HTML formatted string, representing the measurements
 */
function getMeasurementContent (entry, asTable)
{
	if (typeof asTable == "undefined")
		asTable = true;
	
	var values;
	var iter;
	var value;
	var type;
	var content;
	var tabbed = false;
	
	
	// get the measurement values of the given incident entry
	values    = DATABASE_MANAGER.doHqlQuery(
			"SELECT OBJECT(v) FROM MeasurementValue v\\n" + 
			"WHERE incidentEntryId = " + entry.getId());
	
	var sys    = null;
	var dia    = null;
	var pulse  = null;
	var height = null;
	var weight = null;
	var bmi    = null;
	var m1     = null;
	var m2     = null;
	var m3     = null;
	
	for (iter = values.iterator(); iter.hasNext(); )
	{
		value    = iter.next();
		type     = value.getMeasurementType();
		typeName = type.getName();
		
		if (typeName == null)
			print("Type of measurement is NULL!\\n");
		else if (typeName.equals("SYS"))
			sys = value;
		else if (typeName.equals("DIA"))
			dia = value;
		else if (typeName.equals("POULSE"))
			pulse = value;
		else if (typeName.equals("HEIGHT"))
			height = value;
		else if (typeName.equals("WEIGHT"))
			weight = value;
		else if (typeName.equals("measurement_1"))
			m1 = value;
		else if (typeName.equals("measurement_2"))
			m2 = value;
		else if (typeName.equals("measurement_3"))
			m3 = value;
		else
			print("Type of measurement \\""+typeName+"\\" is unknown!\\n");
	}
	
	var text;
	if (asTable)
	{
		text = new java.lang.StringBuilder("<span><table border=\\"0\\" cellspacing=\\"2\\"><tbody>\\n")
				.append("<tr><td>$HEI</td><td>$BP</td><td>$M1</td></tr>\\n")
				.append("<tr><td>$WEI</td><td>$PUL</td><td>$M2</td></tr>\\n")
				.append("<tr><td>$BMI</td><td></td><td>$M3</td></tr>\\n")
				.append("</tbody></table></span>\\n")
				.toString();
	}
	else
	{
		text = new java.lang.StringBuilder("<span>")
				.append("$HEI<br>$WEI<br>$BMI<br>")
				.append("$BP<br>$PUL<br>")
				.append("$M1<br>$M2<br>$M3")
				.append("</span>\\n")
				.toString();
	}
	
	text = text.replace("$HEI", printMeasurementValue(height));
	text = text.replace("$WEI", printMeasurementValue(weight));
	text = text.replace("$PUL", printMeasurementValue(pulse));
	text = text.replace("$M1",  printMeasurementValue(m1));
	text = text.replace("$M2",  printMeasurementValue(m2));
	text = text.replace("$M3",  printMeasurementValue(m3));
	
	var type;
	var value;
	var decimalFormat = new java.text.DecimalFormat("#0.00");
	
	// print the blood pressure
	if (sys == null && dia == null)
	{
		text = text.replace("$BP", "");
	}
	else
	{
		if (sys != null)
		{
			type = sys.getMeasurementType();
			sys  = type.isNumericType() ? decimalFormat.format(sys.getValueNumeric()) : sys.getValueString();
			if (sys == null || sys.trim().equals(""))
				sys = "?";
		}
		else
		{
			sys  = "?";
		}
		
		if (dia != null)
		{
			type = dia.getMeasurementType();
			dia  = type.isNumericType() ? decimalFormat.format(dia.getValueNumeric()) : dia.getValueString();
			if (dia == null || dia.trim().equals(""))
				dia = "?";
		}
		else
		{
			dia  = "?";
		}
		
		if (dia.equals("?") && sys.equls("?"))
			text = text.replace("$BP", "");
		else
			text = text.replace("$BP", "<b>PA: </b><i>" + sys + "/" + dia + "</i> mmHg");
	}
	
	// print the BMI
	if (height != null 
			&& height.getValueNumeric() != null
			&& weight != null
			&& weight.getValueNumeric() != null)
	{
		var h = height.getValueNumeric();
		var w = weight.getValueNumeric();
		
		bmi = w / (h * h);
		bmi = new java.lang.StringBuilder(6)
				.append(decimalFormat.format(bmi))
				.toString();
		text = text.replace("$BMI", "<b>IMC: </b><i>" + bmi + "</i>");
	}
	else
	{
		text = text.replace("$BMI", "");
	}
	
	// clean up
	if (asTable)
	{
		while (text.contains("<td></td></tr>"))
			text = text.replace("<td></td></tr>", "</tr>");
		while (text.contains("<tr></tr>"))
			text = text.replace("<tr></tr>", "");
	}
	else
	{
		while (text.contains("<br><br>"))
			text = text.replace("<br><br>", "<br>");
		text = text.replace("<br></span>", "</span>");
	}
	
	return text;
}


function printMeasurementValue (mv)
{
	if (mv == null)
		return "";
	
	var type  = mv.getMeasurementType();
	var value = java.lang.String.valueOf(type.isNumericType() ? mv.getValueNumeric() : mv.getValueString());
	
	if (value == null || value.trim().equals(""))
		return "";
	
	var content = new java.lang.StringBuilder();
	if (type.getAlias() != null && type.getAlias().trim().length() > 0)
		content.append("<b>")
				.append(type.getAlias())
				.append(": </b>");
	content.append("<i>")
			.append(value)
			.append("</i>")
			.append(type.getUnit());
	
	return content.toString();
}');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_ALL_SICKLEAVES]', E'PATIENT_HISTORY', E'Prints all sickleave entries as a HTML table.', 
E'/**
 * [PAT_HISTORY_ALL_SICKLEAVES]
 */
var types = java.lang.reflect.Array.newInstance(java.lang.String, 1);
types[0] = "sick_leave";
getPatientHistory(PATIENT, null, null, null, true);');

SELECT letter.insert_letter_placeholder(E'[PAT_HISTORY_ALL_SICKLEAVES_TEXT]', E'PATIENT_HISTORY', E'Prints all sickleave entries as a HTML formatted text.', 
E'/**
 * [PAT_HISTORY_ALL_SICKLEAVES]
 */
var types = java.lang.reflect.Array.newInstance(java.lang.String, 1);
types[0] = "sick_leave";
getPatientHistory(PATIENT, null, null, null, false);');


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_2.00.03_003.sql');