/* ********************************************************************** */
/*                            UPDATE 2.02.00_004                          */
/* ---------------------------------------------------------------------- */

/**
 * FUNCTION billing.add_rate_index
 * 
 * Adds a new rate index, if it doesn't exist, yet.
 * Otherwise no error is thrown, but a notice.
 * 
 * p_IndexLabel: The label of the new rate index
 * p_ParentIndexLabel: The label of the parent rate index
 * p_Description: The description of the new rate index
 */
CREATE OR REPLACE FUNCTION billing.add_rate_index (p_IndexLabel VARCHAR, p_ParentIndexLabel VARCHAR, p_Description VARCHAR)
  RETURNS void AS $BODY$
DECLARE
  indexId INTEGER;
  
BEGIN
  BEGIN
    -- check existence of rate index
    indexId := id FROM billing.rate_index 
        WHERE label = p_IndexLabel;

    IF indexId IS NOT NULL THEN
      RAISE NOTICE 'Rate index % already exists.', p_IndexLabel;
      RETURN;
    END IF;
  EXCEPTION WHEN CARDINALITY_VIOLATION THEN
    RAISE NOTICE 'Rate index % already exists (multiple times !!!).', p_IndexLabel;
    RETURN;
  END;
  
  BEGIN
    -- check existence of parent rate index
    indexId := id FROM billing.rate_index 
        WHERE label = p_ParentIndexLabel;

    IF indexId IS NULL THEN
      RAISE NOTICE 'Parent rate index % does NOT exist. Cannot add rate index %', p_ParentIndexLabel, p_IndexLabel;
      RETURN;
    END IF;
  EXCEPTION WHEN CARDINALITY_VIOLATION THEN
    RAISE NOTICE 'Parent rate index % does exist multiple times. Cannot add rate index %', p_ParentIndexLabel, p_IndexLabel;
    RETURN;
  END;
  
  -- insert the rate index
  INSERT INTO billing.rate_index
  (label, parent_id, title)
  VALUES
  (p_IndexLabel, indexId, p_Description);
  
  RETURN;
END $BODY$
LANGUAGE plpgsql VOLATILE;


-- add the missing rate indexes
SELECT billing.add_rate_index ('DG_1', 'DG', 'Consultations du médecin-dentiste');
SELECT billing.add_rate_index ('DT_1', 'DT', 'Soins gingivaux et dentaires');

-- correct the index references of rate from ...
--  - chapter 1 Actes Generaux Dentist
UPDATE billing.rate
SET index_id = (
  SELECT id FROM billing.rate_index
  WHERE label = 'DG_1'
)
WHERE index_id = (
  SELECT id FROM billing.rate_index
  WHERE label = 'DG'
);

--  - chapter 1 Actes Techniques Dentist
UPDATE billing.rate
SET index_id = (
  SELECT id FROM billing.rate_index
  WHERE label = 'DT_1'
)
WHERE index_id = (
  SELECT id FROM billing.rate_index
  WHERE label = 'DT'
);


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO core.info (date, key, value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.02.00_004.sql');
