/* ********************************************************************** */
/*                            UPDATE db_update_2.03.02_002.sql                   */
/* ---------------------------------------------------------------------- */

-- add rule log to invoice
ALTER TABLE billing.invoice ADD COLUMN rule_log TEXT;

-- add printed, closure_date, insurance_id
DROP VIEW billing.invoice_stub;
CREATE VIEW billing.invoice_stub         (id, state, old_state, invoice_number, class_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, insurance_id, third_party_id, created, due, printed, closure_date, reminders, reminder_date, statement_id, settlement_id, settlement_date, amount, payment, deduction, balance) AS
	SELECT DISTINCT invoice.id, invoice.state, invoice.old_state, invoice.invoice_number, invoice.class_id, invoice.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, invoice.insurance_id, invoice.third_party_id, invoice.created, invoice.due, invoice.printed, invoice.closure_date, invoice.reminders, invoice.reminder_date, invoice.statement_id, invoice.settlement_id, invoice.settlement_date, invoice.amount, invoice.payment, invoice.deduction, invoice.balance
    FROM billing.invoice, patient.patient
    WHERE patient.id = invoice.patient_id;

-- add printed, closure_date, insurance_id
DROP VIEW billing.trashed_invoice_stub;
CREATE VIEW billing.trashed_invoice_stub (id, state, old_state, invoice_number, class_id, physician_id, patient_id, patient_first_name, patient_maiden_name, patient_name, patient_ssn, insurance_id, third_party_id, created, due, printed, closure_date, reminders, reminder_date, statement_id, settlement_id, settlement_date, amount, payment, deduction, balance, trasher_id, trashing_date) AS
 	SELECT DISTINCT trashed_invoice.id, trashed_invoice.state, trashed_invoice.old_state, trashed_invoice.invoice_number, trashed_invoice.class_id, trashed_invoice.physician_id, patient.id, patient.first_name, patient.maiden_name, patient.sur_name, patient.social_security_number, trashed_invoice.insurance_id, trashed_invoice.third_party_id, trashed_invoice.created, trashed_invoice.due, trashed_invoice.printed, trashed_invoice.closure_date, trashed_invoice.reminders, trashed_invoice.reminder_date, trashed_invoice.statement_id, trashed_invoice.settlement_id, trashed_invoice.settlement_date, trashed_invoice.amount, trashed_invoice.payment, trashed_invoice.deduction, trashed_invoice.balance, trashed_invoice.trasher_id, trashed_invoice.trashing_date
	FROM billing.trashed_invoice, patient.patient
	WHERE patient.id = trashed_invoice.patient_id;	


-- remove old rates
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (1, 23, 'F41', E'OBSOLETE: Traitement stationnaire dans un centre de rééducation et réadaptation fonctionnelle, par jour d''hospitalisation', '2011-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (1, 23, 'F45', E'OBSOLETE: Réhabilitation psychosociale, par jour d''hospitalisation', '2011-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (1, 23, 'F46', E'OBSOLETE: Réhabilitation dans un centre thérapeutique pour dépendance, par jour d''hospitalisation', '2011-01-01', 0.0, false, false, false, false);
INSERT INTO billing.rate (key_type, index_id, code, label, applicability, coefficient, cat, cac, apcm, acm) VALUES (1, 23, 'F47', E'OBSOLETE: Réhabilitation d''une maladie psychiatrique grave instable de longue durée, par jour d''hospitalisation', '2011-01-01', 0.0, false, false, false, false);



/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO core.info (date, key, value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.03.02_002.sql');