/* ********************************************************************** */
/*                            UPDATE db_update_2.08.00_004.sql            */
/* ---------------------------------------------------------------------- */

CREATE TABLE patient.incident_categories
(
   id serial NOT NULL, 
   name character varying(5) NOT NULL, 
   description character varying(255), 
   cat_type character varying(20) NOT NULL, 
   is_built_in boolean NOT NULL, 
   CONSTRAINT incident_category_idx PRIMARY KEY (id)
);

ALTER TABLE patient.incident_categories
  ADD CONSTRAINT incident_category_name_type_un UNIQUE (name, cat_type);


ALTER TABLE patient.incidents
  ADD COLUMN category_id integer;
  
ALTER TABLE patient.incidents
  ADD CONSTRAINT fk_incident_category_id FOREIGN KEY (category_id) REFERENCES patient.incident_categories (id) ON UPDATE NO ACTION ON DELETE NO ACTION;
  
ALTER TABLE patient.incident_entry
  ADD COLUMN category_id integer;
  
ALTER TABLE patient.incident_entry
  ADD CONSTRAINT fk_incident_entry_category_id FOREIGN KEY (category_id) REFERENCES patient.incident_categories (id) ON UPDATE NO ACTION ON DELETE NO ACTION;

/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO core.info (date, key, value) VALUES ('now', 'LAST_UPDATE', 'db_update_2.08.00_004.sql');