/* ********************************************************************** */
/*                            UPDATE 002                                  */
/* ---------------------------------------------------------------------- */

CREATE OR REPLACE VIEW patient.patient_incident_statistics AS
SELECT  incident.id AS "id", patient.title AS "patient_title", patient.sur_name  AS "patient_surname", patient.first_name  AS "patient_firstname", patient.social_security_number  AS "patient_ssn", incident.incident_date AS "incident_date", physician.title AS "dr_title", physician.name AS "dr_surname", physician.first_name AS "dr_firstname", physician.ucm_code  AS "dr_ucmcode", site.name  AS "site_name", site.id  AS "site_id"
FROM patient.incidents AS incident LEFT OUTER JOIN office.site AS site ON (incident.site_id=site.id), patient.patient AS patient, office.physician AS physician 
WHERE patient.id=incident.patient_id 
AND physician.id=incident.physician_id
ORDER BY site.id, incident.incident_date;

/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.0.14_002.sql');