/* ************************************************************************ */
/*                             UPDATE 1.2.00_013                            */
/* ------------------------------------------------------------------------ */

/* ========================================= */
/*       CREATE INDICES FOR ALL TABLES       */
/* ========================================= */

CREATE INDEX idx_addressbook_contact_address_contact_id 
ON addressbook.contact_address USING btree (contact_id);

CREATE INDEX idx_agenda_appointment_calendar_id
ON agenda.appointment USING btree (calendar_id);
CREATE INDEX idx_agenda_appointment_patient_id
ON agenda.appointment USING btree (patient_id);

CREATE INDEX idx_billing_act_invoice_id
ON billing.act USING btree (invoice_id);
CREATE INDEX idx_billing_invoice_patient_physician_site_id
ON billing.invoice USING btree (patient_id, physician_id, site_id);
CREATE INDEX idx_billing_rate_key_value_id
ON billing.rate USING btree (key_value_id);
CREATE INDEX idx_billing_rate_code
ON billing.rate USING btree (code);

-- CREATE INDEX idx_cara_image_study_inst_uid
-- ON cara.image USING btree (study_inst_uid);
-- CREATE INDEX idx_cara_medical_info_patient_id
-- ON cara.medical_info USING btree (patient_id);
-- CREATE INDEX idx_cara_study_patient_id
-- ON cara.study USING btree (patient_id);

CREATE INDEX idx_core_autocompletion_context_user_id
ON core.autocompletion USING btree (context, user_id);

CREATE INDEX idx_dicom_image_series_id
ON dicom.image USING btree (series_id);
CREATE INDEX idx_dicom_image_instance_uid
ON dicom.image USING btree (instance_uid);
CREATE INDEX idx_dicom_series_study_id
ON dicom.series USING btree (study_id);
CREATE INDEX idx_dicom_series_instance_uid
ON dicom.series USING btree (instance_uid);
CREATE INDEX idx_dicom_study_patient_id
ON dicom.study USING btree (patient_id);
CREATE INDEX idx_dicom_study_instance_uid
ON dicom.study USING btree (instance_uid);

-- CREATE INDEX idx_hl7interface_import_address_quarantined_messagereceptionid
-- ON hl7interface.import_address USING btree (quarantined, messagereceptionid);
-- CREATE INDEX idx_hl7interface_import_adt_quarantined_messagereceptionid
-- ON hl7interface.import_adt USING btree (quarantined, triggerevent);
-- CREATE INDEX idx_hl7interface_import_guarantor_quarantined_messagereceptioni
-- ON hl7interface.import_guarantor USING btree (quarantined, messagereceptionid);
-- CREATE INDEX idx_hl7interface_import_insurance_quarantined_messagereceptioni
-- ON hl7interface.import_insurance USING btree (quarantined, messagereceptionid);
-- CREATE INDEX idx_hl7interface_import_orm_quarantined
-- ON hl7interface.import_orm USING btree (quarantined);
-- CREATE INDEX idx_hl7interface_import_oru_quarantined
-- ON hl7interface.import_oru USING btree (quarantined);
-- CREATE INDEX idx_hl7interface_import_order_quarantined_messagereceptionid
-- ON hl7interface.import_order USING btree (quarantined, messagereceptionid);
-- CREATE INDEX idx_hl7interface_import_phone_quarantined_messagereceptionid
-- ON hl7interface.import_phone USING btree (quarantined, messagereceptionid);
-- CREATE INDEX idx_hl7interface_import_prescription_quarantined_messagereceptioni
-- ON hl7interface.import_prescription USING btree (quarantined, messagereceptionid);
-- CREATE INDEX idx_hl7interface_import_report_quarantined_messagereceptionid
-- ON hl7interface.import_report USING btree (quarantined, messagereceptionid);

CREATE INDEX idx_labo_reaction_antibiotic_id
ON labo.reaction USING btree (antibiotic_id);
CREATE INDEX idx_labo_rel_result_contact_result_contact_id
ON labo.rel_result_contact USING btree (result_id, contact_id);
CREATE INDEX idx_labo_analysis_result_id
ON labo.analysis USING btree (result_id);
CREATE INDEX idx_labo_antibiogram_result_id
ON labo.antibiogram USING btree (result_id);
CREATE INDEX idx_labo_result_incident_entry_id
ON labo.result USING btree (incident_entry_id);
CREATE INDEX idx_labo_result_prescriber_laboratory_result_number
ON labo.result USING btree (prescriber_id, laboratory_id, result_number);

CREATE INDEX idx_letter_letters_incident_entry_id
ON letter.letters USING btree (incident_entry_id);
CREATE INDEX idx_letter_letters_type
ON letter.letters USING btree (type);

CREATE INDEX idx_patient_allergies_patient_id
ON patient.allergies USING btree (patient_id);
CREATE INDEX idx_patient_allergies_allergen_id
ON patient.allergies USING btree (allergen_id);
CREATE INDEX idx_patient_antecedents_patient_id
ON patient.antecedents USING btree (patient_id);
CREATE INDEX idx_patient_antecedents_locked_by
ON patient.antecedents USING btree (locked_by);
CREATE INDEX idx_patient_hospitalisation_pas_id
ON patient.hospitalisation USING btree (pas_id);
CREATE INDEX idx_patient_hospitalisation_patient_id
ON patient.hospitalisation USING btree (patient_id);
CREATE INDEX idx_patient_incident_entry_incident_id
ON patient.incident_entry USING btree (incident_id);
CREATE INDEX idx_patient_incident_relations_parent
ON patient.incident_relations USING btree (parent_incident_id);
CREATE INDEX idx_patient_incident_relations_child
ON patient.incident_relations USING btree (child_incident_id);
CREATE INDEX idx_patient_incidents_patient_id
ON patient.incidents USING btree (patient_id);
CREATE INDEX idx_patient_measurement_values_incident_id
ON patient.measurement_values USING btree (incident_id);
CREATE INDEX idx_patient_hospital_prescription_hospperiod_id
ON patient.hospital_prescription USING btree (hospperiod_id);
CREATE INDEX idx_patient_hospital_prescription_order_number
ON patient.hospital_prescription USING btree (order_number);
CREATE INDEX idx_patient_hospital_prescription_page_hospprescription_id
ON patient.hospital_prescription_page USING btree (hospprescription_id);
CREATE INDEX idx_patient_hospital_report_hospital_report
ON patient.hospital_report USING btree (hospprescription_id);
CREATE INDEX idx_patient_hospitalisation_period_hospitalisation_id
ON patient.hospitalisation_period USING btree (hospitalisation_id);
CREATE INDEX idx_patient_passage_hospperiod_id
ON patient.passage USING btree (hospperiod_id);
CREATE INDEX idx_patient_patient_id_ris
ON patient.patient USING btree (id_ris);
CREATE INDEX idx_patient_patient_social_security_number
ON patient.patient USING btree (social_security_number);
CREATE INDEX idx_patient_patient_first_name
ON patient.patient USING btree (upper(first_name));
CREATE INDEX idx_patient_patient_sur_name
ON patient.patient USING btree (upper(sur_name));
CREATE INDEX idx_patient_patient_maiden_name
ON patient.patient USING btree (upper(maiden_name));
CREATE INDEX idx_patient_patient_foto_patient_id
ON patient.patient_foto USING btree (patient_id);
CREATE INDEX idx_patient_patient_address_patient_id
ON patient.patient_address USING btree (patient_id);
CREATE INDEX idx_patient_patient_phone_patient_id
ON patient.patient_phone USING btree (patient_id);
CREATE INDEX idx_patient_patient_contact_patient_id
ON patient.patient_contact USING btree (patient_id);
CREATE INDEX idx_patient_patient_datas_patient_id
ON patient.patient_datas USING btree (patient_id);
CREATE INDEX idx_patient_patient_memo_patient_id
ON patient.patient_memo USING btree (patient_id);
CREATE INDEX idx_patient_patient_memo_author_id
ON patient.patient_memo USING btree (author_id);
CREATE INDEX idx_patient_patient_relation_parent_id
ON patient.patient_relation USING btree (parent_id);
CREATE INDEX idx_patient_patient_relation_child_id
ON patient.patient_relation USING btree (child_id);

CREATE INDEX idx_prescription_prescription_drug_revisions_prescription_rev_id
ON prescription.prescription_drug_revisions USING btree (prescription_rev_id);
CREATE INDEX idx_prescription_prescription_drugs_prescriptions_id
ON prescription.prescription_drugs USING btree (prescriptions_id);
CREATE INDEX idx_prescription_print_prescription_prescription_id
ON prescription.print_prescription USING btree (prescription_id);
CREATE INDEX idx_prescription_prescriptions_prescription_types_id
ON prescription.prescriptions USING btree (prescription_types_id);


/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now', 'LAST_UPDATE', 'db_update_1.2.00_013.sql');