/* ********************************************************************** */
/*                            UPDATE 1.4.03_002                           */
/* ---------------------------------------------------------------------- */

-- --------------------
-- 	Labo varchars set to 
-- --------------------

-- drop the view, that blocks the columns to be updated
DROP VIEW IF EXISTS labo.result_stub;

ALTER TABLE labo.masterpassword
ALTER COLUMN password TYPE VARCHAR;

ALTER TABLE labo.laboratory
ALTER COLUMN name TYPE VARCHAR,
ALTER COLUMN ucm_code TYPE VARCHAR,
ALTER COLUMN phone TYPE VARCHAR,
ALTER COLUMN mobile TYPE VARCHAR,
ALTER COLUMN fax TYPE VARCHAR,
ALTER COLUMN email TYPE VARCHAR;

ALTER TABLE labo.labo_address
ALTER COLUMN streetname TYPE VARCHAR,
ALTER COLUMN streetnumber TYPE VARCHAR,
ALTER COLUMN pobox TYPE VARCHAR,
ALTER COLUMN zip TYPE VARCHAR,
ALTER COLUMN locality TYPE VARCHAR,
ALTER COLUMN country TYPE VARCHAR;
     

ALTER TABLE labo.labo_certificate
ALTER COLUMN label TYPE VARCHAR;

ALTER TABLE labo.physician_key
ALTER COLUMN label TYPE VARCHAR,
ALTER COLUMN password TYPE VARCHAR;

ALTER TABLE labo.connection
ALTER COLUMN server TYPE VARCHAR,
ALTER COLUMN username TYPE VARCHAR,
ALTER COLUMN password TYPE VARCHAR;

ALTER TABLE labo.result
ALTER COLUMN reference TYPE VARCHAR,
ALTER COLUMN examination_status TYPE VARCHAR,
ALTER COLUMN result_status TYPE VARCHAR,
ALTER COLUMN comments TYPE VARCHAR;

ALTER TABLE labo.analysis
ALTER COLUMN comment TYPE VARCHAR,
ALTER COLUMN title TYPE VARCHAR,
ALTER COLUMN sub_title TYPE VARCHAR,
ALTER COLUMN code_internal TYPE VARCHAR,
ALTER COLUMN code_loinc TYPE VARCHAR,
ALTER COLUMN label_internal TYPE VARCHAR,
ALTER COLUMN label_loinc TYPE VARCHAR,
ALTER COLUMN value TYPE VARCHAR,
ALTER COLUMN unit TYPE VARCHAR,
ALTER COLUMN reference_value TYPE VARCHAR,
ALTER COLUMN previous_value TYPE VARCHAR;
    
ALTER TABLE labo.antibiogram
ALTER COLUMN title TYPE VARCHAR,
ALTER COLUMN unit TYPE VARCHAR,
ALTER COLUMN comments TYPE VARCHAR;

ALTER TABLE labo.antibiotic
ALTER COLUMN name TYPE VARCHAR;

ALTER TABLE labo.culture
ALTER COLUMN name TYPE VARCHAR,
ALTER COLUMN concentration TYPE VARCHAR,
ALTER COLUMN unit TYPE VARCHAR;

ALTER TABLE labo.reaction
ALTER COLUMN interpretation TYPE VARCHAR,
ALTER COLUMN MIC TYPE VARCHAR,
ALTER COLUMN unit TYPE VARCHAR;

ALTER TABLE labo.certifier
ALTER COLUMN label TYPE VARCHAR,
ALTER COLUMN certificate TYPE VARCHAR;

-- recreate the dropped view
CREATE VIEW labo.result_stub (id, laboratory_id, laboratory_name, prescriber_id, patient_id, patient_first_name, patient_name, patient_ssn, result_number, prescription_date, specimen_date, examination_date, downloaded, reference, examination_status, result_status ) AS
    SELECT DISTINCT result.id, result.laboratory_id, laboratory.name, result.prescriber_id, result.patient_id, patient.first_name, patient.sur_name, patient.social_security_number, result.result_number, result.prescription_date, result.specimen_date, result.examination_date, result.downloaded, result.reference, result.examination_status, result.result_status
    FROM labo.result, labo.laboratory, patient.patient
    WHERE laboratory.id = result.laboratory_id AND patient.id = result.patient_id;

/**** UPDATE THE SCRIPTNAME BELOW TO THE FILENAME OF THIS FILE !!!!!!!! *****/
INSERT INTO "core"."info" (date,key,value) VALUES ('now','LAST_UPDATE' ,'db_update_1.4.03_002.sql');
