/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.gecamed.core.gui.launcher;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import lu.tudor.santec.gecamed.core.gui.GECAMedOptionPane;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.launcher.ManagementServer;
import lu.tudor.santec.gecamed.core.gui.launcher.ServerCommand;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientStub;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.PatientAdminBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.PatientAdminInterface;
import lu.tudor.santec.gecamed.patient.gui.PatientListModule;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class GECAMedLauncherServer {
    private static Logger logger = Logger.getLogger(GECAMedLauncherServer.class.getName());
    private static final File LOGFILE = new File("GECAMedLauncherServer.log");
    private static final File LOCKFILE = new File("GECAMedLauchnerServer.isrunning");
    private static final String CONFIG_FILE = "config/GECAMedLaucherServer.conf";
    private static final String USER_CONFIG_FILE = "user.conf";
    private static Properties serverConfig = null;
    private ManagementServer mServer;
    private static final String APP_NAME = "GECAMedLaucher Server";
    private static String username = null;
    private static String password = null;
    private static String[] commands = null;
    private static Boolean gecamedStartup = true;

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            if ("start".equals(args[0].toLowerCase())) {
                GECAMedLauncherServer server = new GECAMedLauncherServer();
                server.startServer();
                while (LOCKFILE.exists()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                server.stopServer();
                System.out.println("Exiting GECAMedLaucher Server ....BYE BYE");
            } else if ("stop".equals(args[0].toLowerCase())) {
                LOCKFILE.delete();
            } else {
                System.out.println("Help: run GECAMedLaucher Server with parameter start/stop");
            }
        } else {
            System.out.println("Help: run GECAMedLaucher Server with parameter start/stop");
        }
    }

    public void startServer() {
        try {
            LOCKFILE.createNewFile();
            LOCKFILE.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initLogger();
        logger.info("\r\n#######################################################\r\n#\r\n#  STARTING GECAMedLaucher Server\r\n#\r\n#######################################################");
        this.loadConfig();
        int port = Integer.parseInt((String)serverConfig.get("SERVER_PORT"));
        int timeOut = Integer.parseInt((String)serverConfig.get("SERVER_TIMEOUT"));
        this.mServer = new ManagementServer(APP_NAME, port, timeOut);
        this.mServer.registerCommand(new ServerCommand("execute", "Execute a GECAMedLauncher Command, returns OK if successful"){

            public String runCommand(String params) {
                System.out.println("Params: " + params);
                logger.info("Send params: " + params);
                if (!params.equalsIgnoreCase("")) {
                    commands = params.split(" ");
                    String[] loginCommand = commands[0].split(":");
                    logger.info("Login command: " + loginCommand);
                    username = loginCommand[1];
                    password = loginCommand[2];
                    System.out.println("... wait for gecamed is ready ...");
                    logger.info("... wait for gecamed is ready ...");
                    while (gecamedStartup.booleanValue()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            System.out.println("GECAMed Launchserver can't sleep");
                            logger.info("GECAMed Launchserver can't sleep");
                            e.printStackTrace();
                        }
                    }
                    System.out.println("GECAMed is ready!!!");
                    logger.info("GECAMed is ready!!! Run commands ...");
                    Integer openPatient = 0;
                    int i = 1;
                    while (i < commands.length) {
                        String[] searchCommand;
                        ArrayList patientList;
                        Integer limit;
                        PatientAdminInterface patientInterface;
                        String[] command = commands[i].split(":");
                        System.out.println("try commamd:" + commands[i]);
                        logger.info("try commamd:" + commands[i]);
                        if (command[0].equalsIgnoreCase("PATIENTSEARCH")) {
                            MainFrame.getInstance().selectModule("PatientList");
                            PatientListModule.getInstance().patientListPanel.searchPatient(commands);
                            MainFrame.getInstance().setToFront();
                        }
                        if (command[0].equalsIgnoreCase("PATIENTMATRICULESEARCH")) {
                            MainFrame.getInstance().selectModule("PatientList");
                            PatientListModule.getInstance().patientListPanel.searchPatient(commands);
                            MainFrame.getInstance().setToFront();
                        }
                        if (command[0].equalsIgnoreCase("GOTOMODULE") && openPatient != 2) {
                            String moduleName = command[1];
                            MainFrame.getInstance().selectModule(moduleName);
                            MainFrame.getInstance().setToFront();
                        }
                        if (command[0].equalsIgnoreCase("OPENPATIENTBYID")) {
                            Integer patientId = null;
                            patientId = new Integer(command[1]);
                            if (patientId != null) {
                                openPatient = 1;
                                PatientManagerModule.getInstance().loadPatient(patientId);
                            }
                            MainFrame.getInstance().setToFront();
                        }
                        if (command[0].equalsIgnoreCase("OPENPATIENTBYNAME")) {
                            patientInterface = (PatientAdminInterface)ManagerFactory.getRemote(PatientAdminBean.class);
                            limit = (Integer)PatientListModule.getInstance().patientListSettingsPlugin.getValue("SearchLimit");
                            try {
                                patientList = new ArrayList(patientInterface.getPatientStubListBySearchString(command[1], "", "", limit));
                                if (patientList.size() == 1) {
                                    openPatient = 1;
                                    PatientManagerModule.getInstance().loadPatient(((PatientStub)patientList.get(0)).getId());
                                } else {
                                    openPatient = 2;
                                    MainFrame.getInstance().selectModule("PatientList");
                                    searchCommand = new String[]{"PATIENTSEARCH:" + command[1]};
                                    PatientListModule.getInstance().patientListPanel.searchPatient(searchCommand);
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Error OPENPATIENTBYNAME:\n" + e.getStackTrace());
                                e.printStackTrace();
                            }
                            MainFrame.getInstance().setToFront();
                        }
                        if (command[0].equalsIgnoreCase("OPENPATIENTBYMATRICULE")) {
                            patientInterface = (PatientAdminInterface)ManagerFactory.getRemote(PatientAdminBean.class);
                            limit = (Integer)PatientListModule.getInstance().patientListSettingsPlugin.getValue("SearchLimit");
                            try {
                                patientList = new ArrayList(patientInterface.getPatientStubListBySSec(command[1], limit));
                                if (patientList.size() == 1) {
                                    openPatient = 1;
                                    PatientManagerModule.getInstance().loadPatient(((PatientStub)patientList.get(0)).getId());
                                } else {
                                    openPatient = 2;
                                    MainFrame.getInstance().selectModule("PatientList");
                                    searchCommand = new String[]{"PATIENTMATRICULESEARCH:" + command[1]};
                                    PatientListModule.getInstance().patientListPanel.searchPatient(searchCommand);
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Error OPENPATIENTBYMATRICULE:\n" + e.getStackTrace());
                                e.printStackTrace();
                            }
                            MainFrame.getInstance().setToFront();
                        }
                        if (command[0].equalsIgnoreCase("OPENPATIENTBYKIS")) {
                            patientInterface = (PatientAdminInterface)ManagerFactory.getRemote(PatientAdminBean.class);
                            limit = (Integer)PatientListModule.getInstance().patientListSettingsPlugin.getValue("SearchLimit");
                            try {
                                patientList = new ArrayList(patientInterface.getPatientByRisID(command[1], limit));
                                if (patientList.size() == 1) {
                                    openPatient = 1;
                                    PatientManagerModule.getInstance().loadPatient(((Patient)patientList.get(0)).getId());
                                } else {
                                    openPatient = 2;
                                    if (patientList.size() > 0) {
                                        String msg = "KIS-ID " + command[1] + " found several times:\n";
                                        for (Patient patient : patientList) {
                                            msg = String.valueOf(msg) + "Patient: " + patient.getId() + " | " + patient.getFirstName() + " " + patient.getSurName() + " | " + patient.getIdRIS() + "\n";
                                        }
                                        GECAMedOptionPane.showMessageDialog((Component)MainFrame.getInstance(), (Object)msg, (String)"WARNING: Open Patient by KIS-ID", (int)2);
                                    } else {
                                        GECAMedOptionPane.showMessageDialog((Component)MainFrame.getInstance(), (Object)("NO PATIENT WITH KIS-ID: " + command[1] + " FOUND"), (String)"WARNING: Open Patient by KIS-ID", (int)2);
                                    }
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Error OPENPATIENTBYKIS:\n" + e.getStackTrace());
                                e.printStackTrace();
                            }
                            MainFrame.getInstance().setToFront();
                        }
                        ++i;
                    }
                } else {
                    System.out.println("no params are set !!!");
                    logger.info("GECAMedLauncher is called with no parameter !!!");
                    username = "";
                    password = "";
                    commands = new String[1];
                    commands[0] = "";
                }
                return "OK";
            }
        });
        this.mServer.start();
        MainFrame.addShutdownHook((Object)"stop launcher", (Thread)new Thread(){

            public void run() {
                try {
                    logger.info("GECAMedLaucher Server Shutdown hook: Stopping server");
                    GECAMedLauncherServer.this.stopServer();
                }
                catch (Throwable e) {
                    logger.warn("Can not stopping server!\n", e);
                }
            }
        });
    }

    public void stopServer() {
        try {
            this.mServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOCKFILE.delete();
        logger.info("\r\n#######################################################\r\n#\r\n# GECAMedLaucher Server STOPPED\r\n#\r\n#######################################################");
    }

    private void initLogger() {
        try {
            Logger.getRootLogger().removeAllAppenders();
            PatternLayout layout = new PatternLayout("%d{yyyy-MM-dd hh:mm:ss,SSS} %c %M (line %L)%n%p: %m%n");
            Logger.getRootLogger().addAppender(new ConsoleAppender(layout));
            RollingFileAppender fileAppender = new RollingFileAppender(layout, LOGFILE.getAbsolutePath(), true);
            fileAppender.setMaxFileSize("5MB");
            fileAppender.setMaxBackupIndex(3);
            fileAppender.setEncoding("UTF-8");
            BasicConfigurator.configure(fileAppender);
            Logger.getRootLogger().setLevel(Level.INFO);
            Logger.getLogger("org.apache.fop").setLevel(Level.ERROR);
            Logger.getLogger("net.sf.jasperreports").setLevel(Level.ERROR);
        }
        catch (Exception e) {
            logger.log(Level.ERROR, "Error initializing Logger", e);
        }
    }

    private void loadConfig() {
        try {
            serverConfig = new Properties();
            serverConfig.load(new FileInputStream(CONFIG_FILE));
            String userpath = (String)serverConfig.get("USER_PATH");
            if (userpath != null && userpath.length() > 0) {
                String userConfigPath = String.valueOf(userpath) + USER_CONFIG_FILE;
                serverConfig.load(new FileInputStream(userConfigPath));
            }
        }
        catch (Throwable e) {
            logger.warn("Unable to load server config file!\n" + e.getStackTrace());
        }
        try {
            StringBuffer sb = new StringBuffer("Using Config:\n");
            for (Object key : serverConfig.keySet()) {
                sb.append("\t").append(key).append("=").append(serverConfig.get(key)).append("\n");
            }
            logger.info(sb.toString());
        }
        catch (Exception e) {
            logger.warn("Error printing Config", e);
        }
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    public String[] getCommands() {
        return commands;
    }

    public void setGECAMedStartup(Boolean startup) {
        gecamedStartup = startup;
    }
}

