/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.gecamed.core.gui.launcher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.LinkedHashMap;
import lu.tudor.santec.gecamed.core.gui.launcher.ServerCommand;
import org.apache.log4j.Logger;

public class ManagementServer {
    private static Logger logger = Logger.getLogger(ManagementServer.class.getName());
    private LinkedHashMap<String, ServerCommand> commands = new LinkedHashMap();
    private Thread serverRunningThread;
    private boolean running;
    private String serverName;
    private ServerSocket serverSocket;
    private int telnetPort;
    private int timeOut;

    public ManagementServer(String serverName, int telnetPort, int timeOutSec) {
        this.serverName = serverName;
        this.telnetPort = telnetPort;
        this.timeOut = timeOutSec;
    }

    public void start() {
        this.running = true;
        this.serverRunningThread = new Thread(){

            public void run() {
                try {
                    ManagementServer.this.serverSocket = new ServerSocket(ManagementServer.this.telnetPort);
                    logger.info("openend new ManagementConnection at: " + ManagementServer.this.serverSocket.getLocalPort());
                    while (ManagementServer.this.running) {
                        Socket incoming = ManagementServer.this.serverSocket.accept();
                        this.handleSocket(incoming);
                        incoming.close();
                    }
                }
                catch (Exception e) {
                    logger.warn("Error: Can not openend new ManagementConnection at: " + ManagementServer.this.serverSocket.getLocalPort() + "\n" + e.getStackTrace());
                    e.printStackTrace();
                }
            }

            public void handleSocket(Socket incoming) {
                try {
                    ManagementServer.this.running = true;
                    incoming.setSoTimeout(ManagementServer.this.timeOut * 1000);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(incoming.getInputStream()));
                    OutputStreamWriter writer = new OutputStreamWriter(incoming.getOutputStream());
                    logger.info("openend new ServerManagementConnection at: " + incoming.getPort());
                    System.out.println("openend new ServerManagementConnection at: " + incoming.getPort());
                    while (!incoming.isClosed()) {
                        if (!incoming.isClosed()) {
                            writer = new OutputStreamWriter(incoming.getOutputStream());
                        }
                        String serverCommandStr = reader.readLine();
                        System.out.println("s: " + serverCommandStr);
                        int splitPos = serverCommandStr.indexOf("=");
                        String cmd = null;
                        try {
                            cmd = serverCommandStr.substring(0, splitPos);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        System.out.println("command: " + cmd);
                        String params = "";
                        try {
                            params = serverCommandStr.substring(splitPos + 1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        System.out.println("params: " + params);
                        logger.info("received |xxx:" + serverCommandStr + "| on " + incoming.getLocalAddress() + " from " + incoming.getInetAddress());
                        if (cmd.toLowerCase().equals("info")) {
                            writer.write("The following server commands are supported\n");
                            for (String cmdName : ManagementServer.this.commands.keySet()) {
                                ServerCommand serverCommand = (ServerCommand)ManagementServer.this.commands.get(cmdName);
                                writer.write("\t" + serverCommand.toString() + "\n");
                            }
                        } else {
                            ServerCommand sc = (ServerCommand)ManagementServer.this.commands.get(cmd);
                            if (sc != null) {
                                writer.write(String.valueOf(sc.runCommand(params)) + "\n");
                            } else {
                                writer.write("command '" + cmd + "=" + params + "' not supported\n");
                            }
                        }
                        writer.flush();
                        writer.close();
                    }
                }
                catch (SocketTimeoutException e) {
                    logger.info(String.valueOf(ManagementServer.this.serverName) + " closing manage connection (SocketTimeOut)");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    logger.info(String.valueOf(ManagementServer.this.serverName) + " closing manage connection (wrong command send)");
                }
                catch (Exception e) {
                    logger.warn("Error: Can not openend new ServerManagementConnection at: " + incoming.getPort() + "\n" + e.getStackTrace());
                    e.printStackTrace();
                }
            }
        };
        this.serverRunningThread.start();
    }

    public void registerCommand(ServerCommand serverCommand) {
        this.commands.put(serverCommand.getCommand(), serverCommand);
    }

    public void stop() {
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            System.out.println("Error: Can not stop server thread.");
            logger.warn("Error: Can not stop server thread.\n" + e.getStackTrace());
            e.printStackTrace();
        }
    }
}

