/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.view;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.editor.view.spi.FlyView;

public class ViewUtilitiesImpl {
    private ViewUtilitiesImpl() {
    }

    public static int findViewIndexBounded(View view, int n) {
        int n2 = view.getStartOffset();
        if (n == n2) {
            return 0;
        }
        if (n >= n2 && n < view.getEndOffset()) {
            return ViewUtilitiesImpl.findViewIndex(view, n);
        }
        return -1;
    }

    public static int findViewIndex(View view, int n) {
        return ViewUtilitiesImpl.findViewIndex(view, n, null);
    }

    private static int findViewIndex(View view, int n, OffsetMatchUpdater offsetMatchUpdater) {
        FlyView.Parent parent = view instanceof FlyView.Parent ? (FlyView.Parent)((Object)view) : null;
        int n2 = 0;
        int n3 = view.getViewCount() - 1;
        if (n3 == -1) {
            return -1;
        }
        while (n2 <= n3) {
            int n4;
            int n5 = (n2 + n3) / 2;
            int n6 = n4 = parent != null ? parent.getStartOffset(n5) : view.getView(n5).getStartOffset();
            if (n4 < n) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > n) {
                n3 = n5 - 1;
                continue;
            }
            if (offsetMatchUpdater != null) {
                n5 = offsetMatchUpdater.updateIndex(n5, n, view, parent);
            }
            return n5;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    public static int findLowerViewIndex(View view, int n, boolean bl) {
        LowerOffsetMatchUpdater lowerOffsetMatchUpdater = bl ? LowerOffsetMatchUpdater.adjacent : LowerOffsetMatchUpdater.normal;
        return ViewUtilitiesImpl.findViewIndex(view, n, lowerOffsetMatchUpdater);
    }

    public static int findUpperViewIndex(View view, int n, boolean bl) {
        UpperOffsetMatchUpdater upperOffsetMatchUpdater = bl ? UpperOffsetMatchUpdater.exclude : UpperOffsetMatchUpdater.normal;
        return ViewUtilitiesImpl.findViewIndex(view, n, upperOffsetMatchUpdater);
    }

    public static Rectangle maybeNew(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (rectangle == null || rectangle.x != n || rectangle.y != n2 || rectangle.width != n3 || rectangle.height != n4) {
            return new Rectangle(n, n2, n3, n4);
        }
        return rectangle;
    }

    public static Rectangle maybeNew(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || !rectangle.equals(rectangle2)) {
            rectangle = new Rectangle(rectangle2);
        }
        return rectangle;
    }

    public static String axisToString(int n) {
        switch (n) {
            case 0: {
                return "x";
            }
            case 1: {
                return "y";
            }
        }
        return "<invalid-axis-value=" + n + ">";
    }

    static int getNextVisualPositionFrom(View view, int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3;
        boolean bl;
        if (view.getViewCount() == 0) {
            return n;
        }
        boolean bl2 = bl = n2 == 1 || n2 == 7;
        if (n == -1) {
            Shape shape2;
            int n4 = bl ? view.getViewCount() - 1 : 0;
            View view2 = view.getView(n4);
            n3 = view2.getNextVisualPositionFrom(n, bias, shape2 = view.getChildAllocation(n4, shape), n2, biasArray);
            if (n3 == -1 && !bl && view.getViewCount() > 1) {
                view2 = view.getView(1);
                shape2 = view.getChildAllocation(1, shape);
                n3 = view2.getNextVisualPositionFrom(-1, biasArray[0], shape2, n2, biasArray);
            }
        } else {
            Shape shape3;
            int n5 = bl ? -1 : 1;
            int n6 = bias == Position.Bias.Backward && n > 0 ? view.getViewIndex(n - 1, Position.Bias.Forward) : view.getViewIndex(n, Position.Bias.Forward);
            View view3 = view.getView(n6);
            n3 = view3.getNextVisualPositionFrom(n, bias, shape3 = view.getChildAllocation(n6, shape), n2, biasArray);
            if (n3 == -1 && (n6 += n5) >= 0 && n6 < view.getViewCount()) {
                view3 = view.getView(n6);
                n3 = view3.getNextVisualPositionFrom(-1, bias, shape3 = view.getChildAllocation(n6, shape), n2, biasArray);
                if (n3 == n && biasArray[0] != bias) {
                    return ViewUtilitiesImpl.getNextVisualPositionFrom(view, n, biasArray[0], shape, n2, biasArray);
                }
            } else if (n3 != -1 && biasArray[0] != bias && (n5 == 1 && view3.getEndOffset() == n3 || n5 == -1 && view3.getStartOffset() == n3) && n6 >= 0 && n6 < view.getViewCount()) {
                view3 = view.getView(n6);
                shape3 = view.getChildAllocation(n6, shape);
                Position.Bias bias2 = biasArray[0];
                int n7 = view3.getNextVisualPositionFrom(-1, bias, shape3, n2, biasArray);
                if (biasArray[0] == bias) {
                    n3 = n7;
                } else {
                    biasArray[0] = bias2;
                }
            }
        }
        return n3;
    }

    public static void checkViewHierarchy(View view) {
        ViewUtilitiesImpl.checkChildrenParent(view);
    }

    private static void checkChildrenParent(View view) {
        int n = view.getViewCount();
        for (int i = 0; i < n; ++i) {
            View view2 = view.getView(i);
            View view3 = view2.getParent();
            if (view3 != view) {
                throw new IllegalStateException("child=" + view2 + " has parent=" + view3 + " instead of " + view);
            }
            ViewUtilitiesImpl.checkChildrenParent(view2);
        }
    }

    static class UpperOffsetMatchUpdater
    implements OffsetMatchUpdater {
        static final UpperOffsetMatchUpdater normal = new UpperOffsetMatchUpdater(false);
        static final UpperOffsetMatchUpdater exclude = new UpperOffsetMatchUpdater(true);
        private final boolean excludeAtOffset;

        UpperOffsetMatchUpdater(boolean bl) {
            this.excludeAtOffset = bl;
        }

        public int updateIndex(int n, int n2, View view, FlyView.Parent parent) {
            int n3 = view.getViewCount() - 1;
            while (true) {
                int n4;
                int n5 = n4 = parent != null ? parent.getEndOffset(n) : view.getView(n).getEndOffset();
                if (n4 != n2) {
                    if (!this.excludeAtOffset) break;
                    --n;
                    break;
                }
                if (n == n3) break;
                ++n;
            }
            return n;
        }
    }

    static class LowerOffsetMatchUpdater
    implements OffsetMatchUpdater {
        static final LowerOffsetMatchUpdater normal = new LowerOffsetMatchUpdater(false);
        static final LowerOffsetMatchUpdater adjacent = new LowerOffsetMatchUpdater(true);
        private final boolean lowerAdjacent;

        LowerOffsetMatchUpdater(boolean bl) {
            this.lowerAdjacent = bl;
        }

        public int updateIndex(int n, int n2, View view, FlyView.Parent parent) {
            while (--n >= 0) {
                int n3 = parent != null ? parent.getStartOffset(n) : view.getView(n).getStartOffset();
                if (n3 == n2) continue;
                if (!this.lowerAdjacent) break;
                --n;
                break;
            }
            return n + 1;
        }
    }

    static interface OffsetMatchUpdater {
        public int updateIndex(int var1, int var2, View var3, FlyView.Parent var4);
    }
}

