/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openidex.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindDialogMemory {
    private static final int maxFileNamePatternCount = 10;
    private static final int maxReplExprCount = 10;
    private static FindDialogMemory singleton;
    private SearchType lastSearchType = null;
    private List<String> fileNamePatterns;
    private List<String> replExpressions;
    private boolean wholeWords;
    private boolean caseSensitive;
    private boolean regularExpression;
    private boolean textPatternSpecified;
    private boolean fileNamePatternSpecified;

    private FindDialogMemory() {
    }

    public static FindDialogMemory getDefault() {
        if (singleton == null) {
            singleton = new FindDialogMemory();
        }
        return singleton;
    }

    public void setLastUsedSearchType(SearchType searchType) {
        this.lastSearchType = searchType;
    }

    public SearchType getLastSearchType() {
        return this.lastSearchType;
    }

    void storeFileNamePattern(String string) {
        if (this.fileNamePatterns == null) {
            this.fileNamePatterns = new ArrayList<String>(10);
            this.fileNamePatterns.add(string);
            return;
        }
        assert (!this.fileNamePatterns.isEmpty());
        int n = this.fileNamePatterns.indexOf(string);
        if (n != -1) {
            if (n == this.fileNamePatterns.size() - 1) {
                return;
            }
            this.fileNamePatterns.remove(n);
        } else if (this.fileNamePatterns.size() == 10) {
            this.fileNamePatterns.remove(0);
        }
        this.fileNamePatterns.add(string);
    }

    List<String> getFileNamePatterns() {
        assert (this.fileNamePatterns == null || !this.fileNamePatterns.isEmpty());
        return this.fileNamePatterns != null ? this.fileNamePatterns : Collections.emptyList();
    }

    void storeReplacementExpression(String string) {
        if (this.replExpressions == null) {
            this.replExpressions = new ArrayList<String>(10);
            this.replExpressions.add(string);
            return;
        }
        assert (!this.replExpressions.isEmpty());
        int n = this.replExpressions.indexOf(string);
        if (n != -1) {
            if (n == this.replExpressions.size() - 1) {
                return;
            }
            this.replExpressions.remove(n);
        } else if (this.replExpressions.size() == 10) {
            this.replExpressions.remove(0);
        }
        this.replExpressions.add(string);
    }

    List<String> getReplacementExpressions() {
        assert (this.replExpressions == null || !this.replExpressions.isEmpty());
        return this.replExpressions != null ? this.replExpressions : Collections.emptyList();
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean bl) {
        this.wholeWords = bl;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean isRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(boolean bl) {
        this.regularExpression = bl;
    }

    boolean isTextPatternSpecified() {
        return this.textPatternSpecified;
    }

    void setTextPatternSpecified(boolean bl) {
        this.textPatternSpecified = bl;
    }

    boolean isFileNamePatternSpecified() {
        return this.fileNamePatternSpecified;
    }

    void setFileNamePatternSpecified(boolean bl) {
        this.fileNamePatternSpecified = bl;
    }
}

