/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.HashSet;
import java.util.Set;
import mondrian.olap.ConnectionBase;
import mondrian.olap.FunDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Parser;
import mondrian.olap.Query;
import mondrian.olap.fun.CustomizedFunctionTable;
import mondrian.olap.fun.ParenthesesFunDef;
import mondrian.test.FoodMartTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizedParserTest
extends FoodMartTestCase {
    Parser p = new Parser();

    public CustomizedParserTest(String name) {
        super(name);
    }

    CustomizedFunctionTable getCustomizedFunctionTable(Set<String> funNameSet) {
        HashSet<FunDef> specialFunctions = new HashSet<FunDef>();
        specialFunctions.add(new ParenthesesFunDef(7));
        CustomizedFunctionTable cftab = new CustomizedFunctionTable(funNameSet, specialFunctions);
        cftab.init();
        return cftab;
    }

    private String wrapExpr(String expr) {
        return "with member [Measures].[Foo] as " + expr + "\n select from [Sales]";
    }

    private void checkErrorMsg(Throwable e, String expectedErrorMsg) {
        while (e.getCause() != null && !e.getCause().equals(e)) {
            e = e.getCause();
        }
        String actualMsg = e.getMessage();
        CustomizedParserTest.assertEquals((String)CustomizedParserTest.fold(expectedErrorMsg), (String)actualMsg);
    }

    private Query getParsedQueryForExpr(CustomizedFunctionTable cftab, String expr, boolean strictValidation) {
        String mdx = this.wrapExpr(expr);
        return ((ConnectionBase)this.getConnection()).parseQuery(mdx, cftab, strictValidation);
    }

    private Query getParsedQueryForExpr(CustomizedFunctionTable cftab, String expr) {
        return this.getParsedQueryForExpr(cftab, expr, false);
    }

    public void testAddition() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("+");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "([Measures].[Store Cost] + [Measures].[Unit Sales])");
            q.resolve(q.createValidator(cftab));
        }
        catch (Throwable e) {
            CustomizedParserTest.fail((String)e.getMessage());
        }
    }

    public void testSubtraction() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("-");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "([Measures].[Store Cost] - [Measures].[Unit Sales])");
            q.resolve(q.createValidator(cftab));
        }
        catch (Throwable e) {
            CustomizedParserTest.fail((String)e.getMessage());
        }
    }

    public void testSingleMultiplication() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("*");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "[Measures].[Store Cost] * [Measures].[Unit Sales]");
            q.resolve(q.createValidator(cftab));
        }
        catch (Throwable e) {
            CustomizedParserTest.fail((String)e.getMessage());
        }
    }

    public void testMultipleMultiplication() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("*");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "([Measures].[Store Cost] * [Measures].[Unit Sales] * [Measures].[Store Sales])");
            q.resolve(q.createValidator(cftab));
        }
        catch (Throwable e) {
            CustomizedParserTest.fail((String)e.getMessage());
        }
    }

    public void testLiterals() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("+");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "([Measures].[Store Cost] + 10)");
            q.resolve(q.createValidator(cftab));
        }
        catch (Throwable e) {
            CustomizedParserTest.fail((String)e.getMessage());
        }
    }

    public void testMissingObjectFail() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("+");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "'[Measures].[Store Cost] + [Measures].[Unit Salese]'");
            q.resolve(q.createValidator(cftab));
            CustomizedParserTest.fail((String)"Expected error did not occur.");
        }
        catch (Throwable e) {
            this.checkErrorMsg(e, "Mondrian Error:MDX object '[Measures].[Unit Salese]' not found in cube 'Sales'");
        }
    }

    public void testMissingObjectFailWithStrict() {
        this.testMissingObject(true);
    }

    public void testMissingObjectSucceedWithoutStrict() {
        this.testMissingObject(false);
    }

    private void testMissingObject(boolean strictValidation) {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("+");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        MondrianProperties properties = MondrianProperties.instance();
        boolean oldIgnoreInvalidMembers = properties.IgnoreInvalidMembers.get();
        boolean oldIgnoreInvalidMembersDuringQuery = properties.IgnoreInvalidMembersDuringQuery.get();
        try {
            properties.IgnoreInvalidMembers.set(true);
            properties.IgnoreInvalidMembersDuringQuery.set(true);
            Query q = this.getParsedQueryForExpr(cftab, "'[Measures].[Store Cost] + [Measures].[Unit Salese]'", strictValidation);
            q.resolve(q.createValidator(cftab));
            CustomizedParserTest.fail((String)("Expected error does not occur when strictValidation is set:" + strictValidation));
        }
        catch (Throwable e) {
            properties.IgnoreInvalidMembers.set(oldIgnoreInvalidMembers);
            properties.IgnoreInvalidMembersDuringQuery.set(oldIgnoreInvalidMembersDuringQuery);
            if (strictValidation) {
                this.checkErrorMsg(e, "Mondrian Error:MDX object '[Measures].[Unit Salese]' not found in cube 'Sales'");
            }
            this.checkErrorMsg(e, "Expected error does not occur when strictValidation is set:" + strictValidation);
        }
    }

    public void testMultiplicationFail() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("+");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "([Measures].[Store Cost] * [Measures].[Unit Sales])");
            q.resolve(q.createValidator(cftab));
            CustomizedParserTest.fail((String)"Expected error did not occur.");
        }
        catch (Throwable e) {
            this.checkErrorMsg(e, "Mondrian Error:No function matches signature '<Member> * <Member>'");
        }
    }

    public void testMixingAttributesFail() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("+");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "([Measures].[Store Cost] + [Store].[Store Country])");
            q.resolve(q.createValidator(cftab));
            CustomizedParserTest.fail((String)"Expected error did not occur.");
        }
        catch (Throwable e) {
            this.checkErrorMsg(e, "Mondrian Error:No function matches signature '<Member> + <Level>'");
        }
    }

    public void testCrossJoinFail() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("+");
        functionNameSet.add("-");
        functionNameSet.add("*");
        functionNameSet.add("/");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "CrossJoin([Measures].[Store Cost], [Measures].[Unit Sales])");
            q.resolve(q.createValidator(cftab));
            CustomizedParserTest.fail((String)"Expected error did not occur.");
        }
        catch (Throwable e) {
            this.checkErrorMsg(e, "Mondrian Error:No function matches signature 'CrossJoin(<Member>, <Member>)'");
        }
    }

    public void testMeasureSlicerFail() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("+");
        functionNameSet.add("-");
        functionNameSet.add("*");
        functionNameSet.add("/");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "([Measures].[Store Cost], [Gender].[F])");
            q.resolve(q.createValidator(cftab));
            CustomizedParserTest.fail((String)"Expected error did not occur.");
        }
        catch (Throwable e) {
            this.checkErrorMsg(e, "Mondrian Error:No function matches signature '(<Member>, <Member>)'");
        }
    }

    public void testTupleFail() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("+");
        functionNameSet.add("-");
        functionNameSet.add("*");
        functionNameSet.add("/");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "([Store].[USA], [Gender].[F])");
            q.resolve(q.createValidator(cftab));
            CustomizedParserTest.fail((String)"Expected error did not occur.");
        }
        catch (Throwable e) {
            this.checkErrorMsg(e, "Mondrian Error:No function matches signature '(<Member>, <Member>)'");
        }
    }

    public void testMixingMemberLimitation() {
        HashSet<String> functionNameSet = new HashSet<String>();
        functionNameSet.add("+");
        CustomizedFunctionTable cftab = this.getCustomizedFunctionTable(functionNameSet);
        try {
            Query q = this.getParsedQueryForExpr(cftab, "([Measures].[Store Cost] + [Store].[USA])");
            q.resolve(q.createValidator(cftab));
            CustomizedParserTest.fail((String)"Expected error did not occur.");
        }
        catch (Throwable e) {
            this.checkErrorMsg(e, "Expected error did not occur.");
        }
    }
}

