/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import mondrian.olap.Id;
import mondrian.olap.MondrianException;
import mondrian.olap.Util;
import mondrian.util.ServiceDiscovery;
import mondrian.util.UnionIterator;

public class UtilTestCase
extends TestCase {
    public UtilTestCase(String s) {
        super(s);
    }

    public void testParseConnectStringSimple() {
        Util.PropertyList properties = Util.parseConnectString("foo=x;bar=y;foo=z");
        UtilTestCase.assertEquals((String)"y", (String)properties.get("bar"));
        UtilTestCase.assertEquals((String)"y", (String)properties.get("BAR"));
        UtilTestCase.assertNull((Object)properties.get(" bar"));
        UtilTestCase.assertEquals((String)"z", (String)properties.get("foo"));
        UtilTestCase.assertNull((Object)properties.get("kipper"));
        UtilTestCase.assertEquals((int)2, (int)properties.list.size());
        UtilTestCase.assertEquals((String)"foo=z; bar=y", (String)properties.toString());
    }

    public void testParseConnectStringComplex() {
        Util.PropertyList properties = Util.parseConnectString("normalProp=value;emptyValue=; spaceBeforeProp=abc; spaceBeforeAndAfterProp =def; space in prop = foo bar ;equalsInValue=foo=bar;semiInProp;Name=value; singleQuotedValue = 'single quoted value ending in space ' ; doubleQuotedValue = \"=double quoted value preceded by equals\" ; singleQuotedValueWithSemi = 'one; two'; singleQuotedValueWithSpecials = 'one; two \"three''four=five'");
        UtilTestCase.assertEquals((int)11, (int)properties.list.size());
        String value = properties.get("normalProp");
        UtilTestCase.assertEquals((String)"value", (String)value);
        value = properties.get("emptyValue");
        UtilTestCase.assertEquals((String)"", (String)value);
        value = properties.get("spaceBeforeProp");
        UtilTestCase.assertEquals((String)"abc", (String)value);
        value = properties.get("spaceBeforeAndAfterProp");
        UtilTestCase.assertEquals((String)"def", (String)value);
        value = properties.get("space in prop");
        UtilTestCase.assertEquals((String)value, (String)"foo bar");
        value = properties.get("equalsInValue");
        UtilTestCase.assertEquals((String)"foo=bar", (String)value);
        value = properties.get("semiInProp;Name");
        UtilTestCase.assertEquals((String)"value", (String)value);
        value = properties.get("singleQuotedValue");
        UtilTestCase.assertEquals((String)"single quoted value ending in space ", (String)value);
        value = properties.get("doubleQuotedValue");
        UtilTestCase.assertEquals((String)"=double quoted value preceded by equals", (String)value);
        value = properties.get("singleQuotedValueWithSemi");
        UtilTestCase.assertEquals((String)value, (String)"one; two");
        value = properties.get("singleQuotedValueWithSpecials");
        UtilTestCase.assertEquals((String)value, (String)"one; two \"three'four=five");
        UtilTestCase.assertEquals((String)"normalProp=value; emptyValue=; spaceBeforeProp=abc; spaceBeforeAndAfterProp=def; space in prop=foo bar; equalsInValue=foo=bar; semiInProp;Name=value; singleQuotedValue=single quoted value ending in space ; doubleQuotedValue==double quoted value preceded by equals; singleQuotedValueWithSemi='one; two'; singleQuotedValueWithSpecials='one; two \"three''four=five'", (String)properties.toString());
    }

    public void testConnectStringMore() {
        this.p("singleQuote=''''", "singleQuote", "'");
        this.p("doubleQuote=\"\"\"\"", "doubleQuote", "\"");
        this.p("empty= ;foo=bar", "empty", "");
    }

    public void testBug1938151() {
        Util.PropertyList properties = Util.parseConnectString("foo=true; bar=xxx;");
        UtilTestCase.assertEquals((int)2, (int)properties.list.size());
        properties = Util.parseConnectString("foo=true; bar=xxx; ");
        UtilTestCase.assertEquals((int)2, (int)properties.list.size());
        properties = Util.parseConnectString("   ");
        UtilTestCase.assertEquals((int)0, (int)properties.list.size());
        properties = Util.parseConnectString("provider=mondrian; JdbcDrivers=org.hsqldb.jdbcDriver;Jdbc=jdbc:hsqldb:./sql/sampledata;Catalog=C:\\cygwin\\home\\src\\jfreereport\\engines\\classic\\extensions-mondrian\\demo\\steelwheels.mondrian.xml;JdbcUser=sa; JdbcPassword=; ");
        UtilTestCase.assertEquals((int)6, (int)properties.list.size());
        UtilTestCase.assertEquals((String)"", (String)properties.get("JdbcPassword"));
    }

    void p(String connectString, String name, String expectedValue) {
        Util.PropertyList list = Util.parseConnectString(connectString);
        String value = list.get(name);
        UtilTestCase.assertEquals((String)expectedValue, (String)value);
    }

    public void testOleDbSpec() {
        this.p("Provider='MSDASQL'", "Provider", "MSDASQL");
        this.p("Provider='MSDASQL.1'", "Provider", "MSDASQL.1");
        this.p("Provider='MSDASQL';Location='3Northwind'", "Location", "3Northwind");
        this.p("Jet OLE DB:System Database=c:\\system.mda", "Jet OLE DB:System Database", "c:\\system.mda");
        this.p("Authentication;Info=Column 5", "Authentication;Info", "Column 5");
        this.p("Verification==Security=True", "Verification=Security", "True");
        this.p("Many====One=Valid", "Many==One", "Valid");
        this.p("TooMany===False", "TooMany=", "False");
        this.p("ExtendedProperties=\"Integrated Security='SSPI';Initial Catalog='Northwind'\"", "ExtendedProperties", "Integrated Security='SSPI';Initial Catalog='Northwind'");
        this.p("ExtendedProperties='Integrated Security=\"SSPI\";Databse=\"My Northwind DB\"'", "ExtendedProperties", "Integrated Security=\"SSPI\";Databse=\"My Northwind DB\"");
        this.p("DataSchema='\"MyCustTable\"'", "DataSchema", "\"MyCustTable\"");
        this.p("DataSchema=\"'MyOtherCustTable'\"", "DataSchema", "'MyOtherCustTable'");
        this.p("NewRecordsCaption='\"Company''s \"new\" customer\"'", "NewRecordsCaption", "\"Company's \"new\" customer\"");
        this.p("NewRecordsCaption=\"\"\"Company's \"\"new\"\" customer\"\"\"", "NewRecordsCaption", "\"Company's \"new\" customer\"");
        this.p("MyKeyword=My Value", "MyKeyword", "My Value");
        this.p("MyKeyword= My Value ;MyNextValue=Value", "MyKeyword", "My Value");
        this.p("MyKeyword=' My Value  '", "MyKeyword", " My Value  ");
        this.p("MyKeyword=\"  My Value \"", "MyKeyword", "  My Value ");
        this.p("Provider='MSDASQL';Location='Northwind';Cache Authentication='True';Prompt='Complete';Location='Customers'", "Location", "Customers");
        this.p("Provider='MSDASQL';Location='Northwind'; Provider='SQLOLEDB'", "Provider", "MSDASQL");
    }

    public void testQuoteMdxIdentifier() {
        UtilTestCase.assertEquals((String)"[San Francisco]", (String)Util.quoteMdxIdentifier("San Francisco"));
        UtilTestCase.assertEquals((String)"[a [bracketed]] string]", (String)Util.quoteMdxIdentifier("a [bracketed] string"));
        UtilTestCase.assertEquals((String)"[Store].[USA].[California]", (String)Util.quoteMdxIdentifier(Arrays.asList(new Id.Segment("Store", Id.Quoting.QUOTED), new Id.Segment("USA", Id.Quoting.QUOTED), new Id.Segment("California", Id.Quoting.QUOTED))));
    }

    public void testBufReplace() {
        UtilTestCase.checkReplace("xoxox", "x", "yy", "yyoyyoyy");
        UtilTestCase.checkReplace("xxoxxoxx", "xx", "z", "zozoz");
        UtilTestCase.checkReplace("xxoxxoxx", "xx", "", "oo");
        UtilTestCase.checkReplace("xox", "x", "xx", "xxoxx");
        UtilTestCase.checkReplace("cacab", "cab", "bb", "cabb");
        UtilTestCase.checkReplace("the quick brown fox", "coyote", "wolf", "the quick brown fox");
        UtilTestCase.checkReplace("", "coyote", "wolf", "");
        UtilTestCase.checkReplace("fox", "", "dog", "dogfdogodogxdog");
    }

    private static void checkReplace(String original, String seek, String replace, String expected) {
        UtilTestCase.assertEquals((String)expected, (String)original.replaceAll(seek, replace));
        StringBuilder buf = new StringBuilder(original);
        StringBuilder buf2 = Util.replace(buf, 0, seek, replace);
        UtilTestCase.assertTrue((buf == buf2 ? 1 : 0) != 0);
        UtilTestCase.assertEquals((String)expected, (String)buf.toString());
        UtilTestCase.assertEquals((String)expected, (String)Util.replace(original, seek, replace));
    }

    public void testImplode() {
        List<Id.Segment> fooBar = Arrays.asList(new Id.Segment("foo", Id.Quoting.UNQUOTED), new Id.Segment("bar", Id.Quoting.UNQUOTED));
        UtilTestCase.assertEquals((String)"[foo].[bar]", (String)Util.implode(fooBar));
        List<Id.Segment> empty = Collections.emptyList();
        UtilTestCase.assertEquals((String)"", (String)Util.implode(empty));
        List<Id.Segment> nasty = Arrays.asList(new Id.Segment("string", Id.Quoting.UNQUOTED), new Id.Segment("with", Id.Quoting.UNQUOTED), new Id.Segment("a [bracket] in it", Id.Quoting.UNQUOTED));
        UtilTestCase.assertEquals((String)"[string].[with].[a [bracket]] in it]", (String)Util.implode(nasty));
    }

    public void testParseIdentifier() {
        List<Id.Segment> strings = Util.parseIdentifier("[string].[with].[a [bracket]] in it]");
        UtilTestCase.assertEquals((int)3, (int)strings.size());
        UtilTestCase.assertEquals((String)"a [bracket] in it", (String)strings.get((int)2).name);
        strings = Util.parseIdentifier("[Worklog].[All].[calendar-[LANGUAGE]].js]");
        UtilTestCase.assertEquals((int)3, (int)strings.size());
        UtilTestCase.assertEquals((String)"calendar-[LANGUAGE].js", (String)strings.get((int)2).name);
        try {
            strings = Util.parseIdentifier("[foo].bar");
            Util.discard(strings);
            UtilTestCase.fail((String)"expected exception");
        }
        catch (MondrianException e) {
            UtilTestCase.assertEquals((String)"Mondrian Error:Invalid member identifier '[foo].bar'", (String)e.getMessage());
        }
        try {
            strings = Util.parseIdentifier("[foo].[bar");
            Util.discard(strings);
            UtilTestCase.fail((String)"expected exception");
        }
        catch (MondrianException e) {
            UtilTestCase.assertEquals((String)"Mondrian Error:Invalid member identifier '[foo].[bar'", (String)e.getMessage());
        }
    }

    public void testReplaceProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        map.put("empty", "");
        map.put("null", null);
        map.put("foobarbaz", "bang!");
        map.put("malformed${foo", "groovy");
        UtilTestCase.assertEquals((String)"abarb", (String)Util.replaceProperties("a${foo}b", map));
        UtilTestCase.assertEquals((String)"twicebarbar", (String)Util.replaceProperties("twice${foo}${foo}", map));
        UtilTestCase.assertEquals((String)"bar at start", (String)Util.replaceProperties("${foo} at start", map));
        UtilTestCase.assertEquals((String)"xyz", (String)Util.replaceProperties("x${empty}y${empty}${empty}z", map));
        UtilTestCase.assertEquals((String)"x${nonexistent}bar", (String)Util.replaceProperties("x${nonexistent}${foo}", map));
        UtilTestCase.assertEquals((String)"${malformedbarbar", (String)Util.replaceProperties("${malformed${foo}${foo}", map));
        UtilTestCase.assertEquals((String)"x$foo", (String)Util.replaceProperties("x$foo", map));
        UtilTestCase.assertEquals((String)"${}", (String)Util.replaceProperties("${}", map));
        map.put("", "v");
        UtilTestCase.assertEquals((String)"${}", (String)Util.replaceProperties("${}", map));
        UtilTestCase.assertEquals((String)"${null}", (String)Util.replaceProperties("${null}", map));
        UtilTestCase.assertEquals((String)"${foobarbaz}", (String)Util.replaceProperties("${foo${foo}baz}", map));
    }

    public void testWildcard() {
        UtilTestCase.assertEquals((String)".\\QFoo\\E.|\\QBar\\E.*\\QBAZ\\E", (String)Util.wildcardToRegexp(Arrays.asList("_Foo_", "Bar%BAZ")));
    }

    public void testCamel() {
        UtilTestCase.assertEquals((String)"FOO_BAR", (String)Util.camelToUpper("FooBar"));
        UtilTestCase.assertEquals((String)"FOO_BAR", (String)Util.camelToUpper("fooBar"));
        UtilTestCase.assertEquals((String)"URL", (String)Util.camelToUpper("URL"));
        UtilTestCase.assertEquals((String)"URLTO_CLICK_ON", (String)Util.camelToUpper("URLtoClickOn"));
        UtilTestCase.assertEquals((String)"", (String)Util.camelToUpper(""));
    }

    public void testParseCommaList() {
        UtilTestCase.assertEquals(new ArrayList(), Util.parseCommaList(""));
        UtilTestCase.assertEquals(Arrays.asList("x"), Util.parseCommaList("x"));
        UtilTestCase.assertEquals(Arrays.asList("x", "y"), Util.parseCommaList("x,y"));
        UtilTestCase.assertEquals(Arrays.asList("x,y"), Util.parseCommaList("x,,y"));
        UtilTestCase.assertEquals(Arrays.asList(",x", "y"), Util.parseCommaList(",,x,y"));
        UtilTestCase.assertEquals(Arrays.asList("x,", "y"), Util.parseCommaList("x,,,y"));
        UtilTestCase.assertEquals(Arrays.asList("x,,y"), Util.parseCommaList("x,,,,y"));
        UtilTestCase.assertEquals(Arrays.asList("x", "y"), Util.parseCommaList("x,y,"));
        UtilTestCase.assertEquals(Arrays.asList("x", "y,"), Util.parseCommaList("x,y,,"));
    }

    public void testUnionIterator() {
        List<String> xyList = Arrays.asList("x", "y");
        List<String> abcList = Arrays.asList("a", "b", "c");
        List emptyList = Collections.emptyList();
        String total = "";
        for (String s : Util.union(new Collection[]{xyList, abcList})) {
            total = total + s + ";";
        }
        UtilTestCase.assertEquals((String)"x;y;a;b;c;", (String)total);
        total = "";
        for (String s : Util.union(new Collection[]{xyList, emptyList})) {
            total = total + s + ";";
        }
        UtilTestCase.assertEquals((String)"x;y;", (String)total);
        total = "";
        for (String s : Util.union(new Collection[]{emptyList, xyList, emptyList})) {
            total = total + s + ";";
        }
        UtilTestCase.assertEquals((String)"x;y;", (String)total);
        total = "";
        for (String s : Util.union(new Collection[0])) {
            total = total + s + ";";
        }
        UtilTestCase.assertEquals((String)"", (String)total);
        total = "";
        UnionIterator unionIterator = new UnionIterator(new Collection[]{xyList, abcList});
        while (unionIterator.hasNext()) {
            total = total + (String)unionIterator.next() + ";";
        }
        UtilTestCase.assertEquals((String)"x;y;a;b;c;", (String)total);
        if (Util.Retrowoven) {
            return;
        }
        total = "";
        for (String s : Util.union(new Iterable[]{xyList, abcList})) {
            total = total + s + ";";
        }
        UtilTestCase.assertEquals((String)"x;y;a;b;c;", (String)total);
    }

    public void testAreOccurrencesEqual() {
        UtilTestCase.assertFalse((boolean)Util.areOccurencesEqual(Collections.emptyList()));
        UtilTestCase.assertTrue((boolean)Util.areOccurencesEqual(Arrays.asList("x")));
        UtilTestCase.assertTrue((boolean)Util.areOccurencesEqual(Arrays.asList("x", "x")));
        UtilTestCase.assertFalse((boolean)Util.areOccurencesEqual(Arrays.asList("x", "y")));
        UtilTestCase.assertFalse((boolean)Util.areOccurencesEqual(Arrays.asList("x", "y", "x")));
        UtilTestCase.assertTrue((boolean)Util.areOccurencesEqual(Arrays.asList("x", "x", "x")));
        UtilTestCase.assertFalse((boolean)Util.areOccurencesEqual(Arrays.asList("x", "x", "y", "z")));
    }

    public void testServiceDiscovery() {
        ServiceDiscovery<Driver> serviceDiscovery = ServiceDiscovery.forClass(Driver.class);
        List<Class<Driver>> list = serviceDiscovery.getImplementor();
        UtilTestCase.assertFalse((boolean)list.isEmpty());
        ArrayList<String> expectedClassNames = new ArrayList<String>(Arrays.asList("mondrian.olap4j.MondrianOlap4jDriver", "org.olap4j.driver.xmla.XmlaOlap4jDriver"));
        for (Class<Driver> driverClass : list) {
            expectedClassNames.remove(driverClass.getName());
        }
        UtilTestCase.assertTrue((String)((Object)expectedClassNames).toString(), (boolean)expectedClassNames.isEmpty());
    }
}

