/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import mondrian.olap.CacheControl;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Id;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.rolap.MemberCacheHelper;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SmartMemberReader;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.cache.HardSmartCache;
import mondrian.spi.impl.DataSourceChangeListenerImpl;
import mondrian.spi.impl.DataSourceChangeListenerImpl2;
import mondrian.spi.impl.DataSourceChangeListenerImpl3;
import mondrian.spi.impl.DataSourceChangeListenerImpl4;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;
import org.apache.log4j.Logger;

public class DataSourceChangeListenerTest
extends FoodMartTestCase {
    private static final Logger logger = Logger.getLogger(DataSourceChangeListenerTest.class);
    final SqlConstraintFactory scf = SqlConstraintFactory.instance();

    public DataSourceChangeListenerTest() {
    }

    public DataSourceChangeListenerTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataSourceChangeListenerPlugin() {
        MondrianProperties properties = MondrianProperties.instance();
        if (properties.TestExpDependencies.get() > 0) {
            return;
        }
        TestContext testContext = this.getTestContext();
        CacheControl cacheControl = testContext.getConnection().getCacheControl(null);
        Connection connection = testContext.getConnection();
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        CacheControl.CellRegion measuresRegion = cacheControl.createMeasuresRegion(salesCube);
        cacheControl.flush(measuresRegion);
        boolean do_caching_orig = properties.DisableCaching.get();
        properties.DisableCaching.setString("false");
        cacheControl.flushSchemaCache();
        SmartMemberReader smr = this.getSmartMemberReader("Store");
        MemberCacheHelper smrch = (MemberCacheHelper)smr.getMemberCache();
        smrch.mapLevelToMembers.setCache(new HardSmartCache());
        smrch.mapMemberToChildren.setCache(new HardSmartCache());
        smrch.mapKeyToMember = new HardSmartCache<Object, RolapMember>();
        MemberCacheHelper rcsmrch = ((RolapCubeHierarchy.RolapCubeHierarchyMemberReader)((Object)smr)).getRolapCubeMemberCacheHelper();
        rcsmrch.mapLevelToMembers.setCache(new HardSmartCache());
        rcsmrch.mapMemberToChildren.setCache(new HardSmartCache());
        rcsmrch.mapKeyToMember = new HardSmartCache<Object, RolapMember>();
        SmartMemberReader ssmr = this.getSharedSmartMemberReader("Store");
        MemberCacheHelper ssmrch = (MemberCacheHelper)ssmr.getMemberCache();
        ssmrch.mapLevelToMembers.setCache(new HardSmartCache());
        ssmrch.mapMemberToChildren.setCache(new HardSmartCache());
        ssmrch.mapKeyToMember = new HardSmartCache<Object, RolapMember>();
        SqlLogger sqlLogger = new SqlLogger();
        RolapUtil.threadHooks.set(sqlLogger);
        try {
            Result r1 = this.executeQuery("select {[Store].[All Stores].[USA].[CA].[San Francisco]} on columns from [Sales]");
            Util.discard((Object)r1);
            String s1 = sqlLogger.getSqlQueries().toString();
            sqlLogger.clear();
            DataSourceChangeListenerTest.assertFalse((boolean)"[]".equals(s1));
            Result r2 = this.executeQuery("select {[Store].[All Stores].[USA].[CA].[San Francisco]} on columns from [Sales]");
            Util.discard((Object)r2);
            String s2 = sqlLogger.getSqlQueries().toString();
            sqlLogger.clear();
            DataSourceChangeListenerTest.assertEquals((String)"[]", (String)s2);
            smrch.changeListener = new DataSourceChangeListenerImpl();
            ssmrch.changeListener = new DataSourceChangeListenerImpl();
            rcsmrch.changeListener = new DataSourceChangeListenerImpl();
            Result r3 = this.executeQuery("select {[Store].[All Stores].[USA].[CA].[San Francisco]} on columns from [Sales]");
            Util.discard((Object)r3);
            String s3 = sqlLogger.getSqlQueries().toString();
            sqlLogger.clear();
            DataSourceChangeListenerTest.assertEquals((String)"[]", (String)s3);
            smrch.mapKeyToMember.clear();
            smrch.mapLevelToMembers.clear();
            smrch.mapMemberToChildren.clear();
            ssmrch.mapKeyToMember.clear();
            ssmrch.mapLevelToMembers.clear();
            ssmrch.mapMemberToChildren.clear();
            rcsmrch.mapKeyToMember.clear();
            rcsmrch.mapLevelToMembers.clear();
            rcsmrch.mapMemberToChildren.clear();
            Result r4 = this.executeQuery("select {[Store].[All Stores].[USA].[CA].[San Francisco]} on columns from [Sales]");
            Util.discard((Object)r4);
            String s4 = sqlLogger.getSqlQueries().toString();
            sqlLogger.clear();
            DataSourceChangeListenerTest.assertFalse((boolean)"[]".equals(s4));
            smrch.changeListener = new DataSourceChangeListenerImpl2();
            ssmrch.changeListener = new DataSourceChangeListenerImpl2();
            rcsmrch.changeListener = new DataSourceChangeListenerImpl2();
            Result r5 = this.executeQuery("select {[Store].[All Stores].[USA].[CA].[San Francisco]} on columns from [Sales]");
            Util.discard((Object)r5);
            String s5 = sqlLogger.getSqlQueries().toString();
            sqlLogger.clear();
            DataSourceChangeListenerTest.assertEquals((String)s4, (String)s5);
            smrch.changeListener = new DataSourceChangeListenerImpl3();
            ssmrch.changeListener = new DataSourceChangeListenerImpl3();
            rcsmrch.changeListener = new DataSourceChangeListenerImpl3();
            RolapStar star = this.getStar("Sales");
            star.setChangeListener(smrch.changeListener);
            Result r6 = this.executeQuery("select {[Store].[All Stores].[USA].[CA].[San Francisco]} on columns from [Sales]");
            Util.discard((Object)r6);
            String s6 = sqlLogger.getSqlQueries().toString();
            sqlLogger.clear();
            DataSourceChangeListenerTest.assertEquals((String)s1, (String)s6);
        }
        finally {
            smrch.changeListener = null;
            ssmrch.changeListener = null;
            rcsmrch.changeListener = null;
            RolapStar star = this.getStar("Sales");
            star.setChangeListener(null);
            RolapUtil.threadHooks.set(null);
            if (do_caching_orig) {
                properties.DisableCaching.setString("true");
            } else {
                properties.DisableCaching.setString("false");
            }
        }
    }

    public void testParallelDataSourceChangeListenerPlugin() {
        this.checkCacheFlushing(5, 8);
    }

    private void checkCacheFlushing(int workerCount, final int cycleCount) {
        int i;
        final Random random = new Random(123456L);
        Worker[] workers = new Worker[workerCount];
        Thread[] threads = new Thread[workerCount];
        final String[] queries = new String[]{"with member [Store Type].[All Store Types].[All Types] as 'Aggregate({[Store Type].[All Store Types].[Deluxe Supermarket],  [Store Type].[All Store Types].[Gourmet Supermarket],  [Store Type].[All Store Types].[HeadQuarters],  [Store Type].[All Store Types].[Mid-Size Grocery],  [Store Type].[All Store Types].[Small Grocery],  [Store Type].[All Store Types].[Supermarket]})'  select NON EMPTY {[Time].[1997]} ON COLUMNS,   NON EMPTY [Store].[All Stores].[USA].[CA].Children ON ROWS   from [Sales] where ([Store Type].[All Store Types].[All Types], [Measures].[Unit Sales], [Customers].[All Customers].[USA], [Product].[All Products].[Drink])  ", "with member [Measures].[Shipped per Ordered] as ' [Measures].[Units Shipped] / [Measures].[Unit Sales] ', format_string='#.00%'\n member [Measures].[Profit per Unit Shipped] as ' [Measures].[Profit] / [Measures].[Units Shipped] '\nselect\n {[Measures].[Unit Sales], \n  [Measures].[Units Shipped],\n  [Measures].[Shipped per Ordered],\n  [Measures].[Profit per Unit Shipped]} on 0,\n NON EMPTY Crossjoin([Product].Children, [Time].[1997].Children) on 1\nfrom [Warehouse and Sales]", "select {[Measures].[Profit Per Unit Shipped]} ON COLUMNS, {[Store].[All Stores].[USA].[CA], [Store].[All Stores].[USA].[OR], [Store].[All Stores].[USA].[WA]} ON ROWS from [Warehouse and Sales Format Expression Cube No Cache] where [Time].[1997]", "select {[Store].[All Stores].[USA].[CA].[San Francisco]} on columns from [Sales]"};
        final String[] results = new String[]{DataSourceChangeListenerTest.fold("Axis #0:\n{[Store Type].[All Store Types].[All Types], [Measures].[Unit Sales], [Customers].[All Customers].[USA], [Product].[All Products].[Drink]}\nAxis #1:\n{[Time].[1997]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\nRow #0: 1,945\nRow #1: 2,422\nRow #2: 2,560\nRow #3: 175\n"), DataSourceChangeListenerTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Units Shipped]}\n{[Measures].[Shipped per Ordered]}\n{[Measures].[Profit per Unit Shipped]}\nAxis #2:\n{[Product].[All Products].[Drink], [Time].[1997].[Q1]}\n{[Product].[All Products].[Drink], [Time].[1997].[Q2]}\n{[Product].[All Products].[Drink], [Time].[1997].[Q3]}\n{[Product].[All Products].[Drink], [Time].[1997].[Q4]}\n{[Product].[All Products].[Food], [Time].[1997].[Q1]}\n{[Product].[All Products].[Food], [Time].[1997].[Q2]}\n{[Product].[All Products].[Food], [Time].[1997].[Q3]}\n{[Product].[All Products].[Food], [Time].[1997].[Q4]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q1]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q2]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q3]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q4]}\nRow #0: 5,976\nRow #0: 4637.0\nRow #0: 77.59%\nRow #0: $1.50\nRow #1: 5,895\nRow #1: 4501.0\nRow #1: 76.35%\nRow #1: $1.60\nRow #2: 6,065\nRow #2: 6258.0\nRow #2: 103.18%\nRow #2: $1.15\nRow #3: 6,661\nRow #3: 5802.0\nRow #3: 87.10%\nRow #3: $1.38\nRow #4: 47,809\nRow #4: 37153.0\nRow #4: 77.71%\nRow #4: $1.64\nRow #5: 44,825\nRow #5: 35459.0\nRow #5: 79.11%\nRow #5: $1.62\nRow #6: 47,440\nRow #6: 41545.0\nRow #6: 87.57%\nRow #6: $1.47\nRow #7: 51,866\nRow #7: 34706.0\nRow #7: 66.91%\nRow #7: $1.91\nRow #8: 12,506\nRow #8: 9161.0\nRow #8: 73.25%\nRow #8: $1.76\nRow #9: 11,890\nRow #9: 9227.0\nRow #9: 77.60%\nRow #9: $1.65\nRow #10: 12,343\nRow #10: 9986.0\nRow #10: 80.90%\nRow #10: $1.59\nRow #11: 13,497\nRow #11: 9291.0\nRow #11: 68.84%\nRow #11: $1.86\n"), DataSourceChangeListenerTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Profit Per Unit Shipped]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: |1.6|style=red\nRow #1: |2.1|style=green\nRow #2: |1.5|style=red\n"), DataSourceChangeListenerTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\nRow #0: 2,117\n")};
        final TestContext testContext = TestContext.create(null, null, "<Cube name=\"Warehouse No Cache\" cache=\"false\">\n  <Table name=\"inventory_fact_1997\"/>\n\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <Measure name=\"Units Shipped\" column=\"units_shipped\" aggregator=\"sum\" formatString=\"#.0\"/>\n</Cube>\n<VirtualCube name=\"Warehouse and Sales Format Expression Cube No Cache\">\n  <VirtualCubeDimension name=\"Store\"/>\n  <VirtualCubeDimension name=\"Time\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Store Cost]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Store Sales]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse No Cache\" name=\"[Measures].[Units Shipped]\"/>\n  <CalculatedMember name=\"Profit\" dimension=\"Measures\">\n    <Formula>[Measures].[Store Sales] - [Measures].[Store Cost]</Formula>\n  </CalculatedMember>\n  <CalculatedMember name=\"Profit Per Unit Shipped\" dimension=\"Measures\">\n    <Formula>[Measures].[Profit] / [Measures].[Units Shipped]</Formula>\n    <CalculatedMemberProperty name=\"FORMAT_STRING\" expression=\"IIf(([Measures].[Profit Per Unit Shipped] > 2.0), '|0.#|style=green', '|0.#|style=red')\"/>\n  </CalculatedMember>\n</VirtualCube>", null, null, null);
        SmartMemberReader smrStore = this.getSmartMemberReader(testContext.getConnection(), "Store");
        MemberCacheHelper smrStoreCacheHelper = (MemberCacheHelper)smrStore.getMemberCache();
        SmartMemberReader smrProduct = this.getSmartMemberReader(testContext.getConnection(), "Product");
        MemberCacheHelper smrProductCacheHelper = (MemberCacheHelper)smrProduct.getMemberCache();
        smrProductCacheHelper.changeListener = smrStoreCacheHelper.changeListener = new DataSourceChangeListenerImpl4(500, 50);
        RolapStar star = this.getStar(testContext.getConnection(), "Sales");
        star.setChangeListener(smrStoreCacheHelper.changeListener);
        star = this.getStar(testContext.getConnection(), "Warehouse No Cache");
        star.setChangeListener(smrStoreCacheHelper.changeListener);
        for (i = 0; i < workerCount; ++i) {
            workers[i] = new Worker(){

                public void runSafe() {
                    for (int i = 0; i < cycleCount; ++i) {
                        this.cycle();
                        try {
                            Thread.sleep(random.nextInt(100));
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw Util.newInternal(e, "interrupted");
                        }
                    }
                }

                private void cycle() {
                    int idx = random.nextInt(4);
                    String query = queries[idx];
                    String result = results[idx];
                    testContext.assertQueryReturns(query, result);
                }
            };
            threads[i] = new Thread(workers[i]);
        }
        for (i = 0; i < workerCount; ++i) {
            threads[i].start();
        }
        for (i = 0; i < workerCount; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw Util.newInternal(e, "while joining thread #" + i);
            }
        }
        StringBuilder messages = new StringBuilder();
        int failures = 0;
        for (Worker worker : workers) {
            for (Throwable throwable : worker.failures) {
                String message = throwable.toString() + throwable.getMessage();
                if (message == null) continue;
                ++failures;
                if (messages.length() != 0) {
                    messages.append(Util.nl);
                }
                messages.append(message);
            }
        }
        if (failures != 0) {
            TestCase.fail((String)(failures + " threads failed\n" + messages));
        }
    }

    Result executeQuery(String mdx, Connection connection) {
        Query query = connection.parseQuery(mdx);
        return connection.execute(query);
    }

    SmartMemberReader getSmartMemberReader(String hierName) {
        Connection con = this.getTestContext().getFoodMartConnection();
        return this.getSmartMemberReader(con, hierName);
    }

    SmartMemberReader getSmartMemberReader(Connection con, String hierName) {
        RolapCube cube = (RolapCube)con.getSchema().lookupCube("Sales", true);
        RolapSchemaReader schemaReader = (RolapSchemaReader)cube.getSchemaReader();
        RolapHierarchy hierarchy = (RolapHierarchy)cube.lookupHierarchy(new Id.Segment(hierName, Id.Quoting.UNQUOTED), false);
        DataSourceChangeListenerTest.assertNotNull((Object)hierarchy);
        return (SmartMemberReader)hierarchy.createMemberReader(schemaReader.getRole());
    }

    SmartMemberReader getSharedSmartMemberReader(String hierName) {
        Connection con = this.getTestContext().getFoodMartConnection();
        return this.getSharedSmartMemberReader(con, hierName);
    }

    SmartMemberReader getSharedSmartMemberReader(Connection con, String hierName) {
        RolapCube cube = (RolapCube)con.getSchema().lookupCube("Sales", true);
        RolapSchemaReader schemaReader = (RolapSchemaReader)cube.getSchemaReader();
        RolapCubeHierarchy hierarchy = (RolapCubeHierarchy)cube.lookupHierarchy(new Id.Segment(hierName, Id.Quoting.UNQUOTED), false);
        DataSourceChangeListenerTest.assertNotNull((Object)hierarchy);
        return (SmartMemberReader)hierarchy.getRolapHierarchy().createMemberReader(schemaReader.getRole());
    }

    RolapStar getStar(String starName) {
        Connection con = this.getTestContext().getFoodMartConnection();
        return this.getStar(con, starName);
    }

    RolapStar getStar(Connection con, String starName) {
        RolapCube cube = (RolapCube)con.getSchema().lookupCube(starName, true);
        return cube.getStar();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SqlLogger
    implements RolapUtil.ExecuteQueryHook {
        private final List<String> sqlQueries = new ArrayList<String>();

        public void clear() {
            this.sqlQueries.clear();
        }

        public List<String> getSqlQueries() {
            return this.sqlQueries;
        }

        @Override
        public void onExecuteQuery(String sql) {
            this.sqlQueries.add(sql);
        }
    }

    private static abstract class Worker
    implements Runnable {
        final List<Throwable> failures = new ArrayList<Throwable>();

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.runSafe();
            }
            catch (Throwable e) {
                List<Throwable> list = this.failures;
                synchronized (list) {
                    this.failures.add(e);
                }
            }
        }

        public abstract void runSafe();
    }
}

