/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import mondrian.calc.ResultStyle;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluationUnsupportedException;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.rolap.BatchTestCase;
import mondrian.rolap.MemberCacheHelper;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNative;
import mondrian.rolap.RolapNativeRegistry;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SmartMemberReader;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.cache.HardSmartCache;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.spi.Dialect;
import mondrian.test.SqlPattern;
import mondrian.test.TestContext;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.eigenbase.util.property.BooleanProperty;
import org.eigenbase.util.property.IntegerProperty;
import org.eigenbase.util.property.StringProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonEmptyTest
extends BatchTestCase {
    private static Logger logger = Logger.getLogger(NonEmptyTest.class);
    SqlConstraintFactory scf = SqlConstraintFactory.instance();

    public NonEmptyTest() {
    }

    public NonEmptyTest(String name) {
        super(name);
    }

    public void testBugCantRestrictSlicerToCalcMember() throws Exception {
        TestContext ctx = TestContext.instance();
        ctx.assertQueryReturns("WITH MEMBER [Time].[Aggr] AS 'Aggregate({[Time].[1998].[Q1], [Time].[1998].[Q2]})' SELECT {[Measures].[Store Sales]} ON COLUMNS, NON EMPTY Order(TopCount([Customers].[Name].Members,3,[Measures].[Store Sales]),[Measures].[Store Sales],BASC) ON ROWS FROM [Sales] WHERE ([Time].[Aggr])", NonEmptyTest.fold("Axis #0:\n{[Time].[Aggr]}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n"));
    }

    public void testBug1961163() throws Exception {
        TestContext ctx = TestContext.instance();
        ctx.assertQueryReturns("with member [Measures].[AvgRevenue] as 'Avg([Store].[Store Name].Members, [Measures].[Store Sales])' select NON EMPTY {[Measures].[Store Sales], [Measures].[AvgRevenue]} ON COLUMNS, NON EMPTY Filter([Store].[Store Name].Members, ([Measures].[AvgRevenue] < [Measures].[Store Sales])) ON ROWS from [Sales]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Store Sales]}" + nl + "{[Measures].[AvgRevenue]}" + nl + "Axis #2:" + nl + "{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}" + nl + "{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}" + nl + "{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}" + nl + "{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}" + nl + "{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}" + nl + "{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}" + nl + "{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}" + nl + "{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}" + nl + "{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}" + nl + "Row #0: 45,750.24" + nl + "Row #0: 43,479.86" + nl + "Row #1: 54,545.28" + nl + "Row #1: 43,479.86" + nl + "Row #2: 54,431.14" + nl + "Row #2: 43,479.86" + nl + "Row #3: 55,058.79" + nl + "Row #3: 43,479.86" + nl + "Row #4: 87,218.28" + nl + "Row #4: 43,479.86" + nl + "Row #5: 52,896.30" + nl + "Row #5: 43,479.86" + nl + "Row #6: 52,644.07" + nl + "Row #6: 43,479.86" + nl + "Row #7: 49,634.46" + nl + "Row #7: 43,479.86" + nl + "Row #8: 74,843.96" + nl + "Row #8: 43,479.86" + nl);
    }

    public void testTopCountWithCalcMemberInSlicer() {
        TestContext ctx = TestContext.instance();
        ctx.assertQueryReturns("with member [Time].[First Term] as 'Aggregate({[Time].[1997].[Q1], [Time].[1997].[Q2]})' select {[Measures].[Unit Sales]} ON COLUMNS, TopCount([Product].[Product Subcategory].Members, 3, [Measures].[Unit Sales]) ON ROWS from [Sales] where ([Time].[First Term]) ", "Axis #0:" + nl + "{[Time].[First Term]}" + nl + "Axis #1:" + nl + "{[Measures].[Unit Sales]}" + nl + "Axis #2:" + nl + "{[Product].[All Products].[Food].[Produce].[Vegetables].[Fresh Vegetables]}" + nl + "{[Product].[All Products].[Food].[Produce].[Fruit].[Fresh Fruit]}" + nl + "{[Product].[All Products].[Food].[Canned Foods].[Canned Soup].[Soup]}" + nl + "Row #0: 10,215" + nl + "Row #1: 5,711" + nl + "Row #2: 3,926" + nl);
    }

    public void testTopCountCacheKeyMustIncludeCount() {
        TestContext ctx = TestContext.instance();
        ctx.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS, TopCount([Product].[Product Subcategory].Members, 2, [Measures].[Unit Sales]) ON ROWS from [Sales]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Unit Sales]}" + nl + "Axis #2:" + nl + "{[Product].[All Products].[Food].[Produce].[Vegetables].[Fresh Vegetables]}" + nl + "{[Product].[All Products].[Food].[Produce].[Fruit].[Fresh Fruit]}" + nl + "Row #0: 20,739" + nl + "Row #1: 11,767" + nl);
        ctx.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS, TopCount([Product].[Product Subcategory].Members, 3, [Measures].[Unit Sales]) ON ROWS from [Sales]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Unit Sales]}" + nl + "Axis #2:" + nl + "{[Product].[All Products].[Food].[Produce].[Vegetables].[Fresh Vegetables]}" + nl + "{[Product].[All Products].[Food].[Produce].[Fruit].[Fresh Fruit]}" + nl + "{[Product].[All Products].[Food].[Canned Foods].[Canned Soup].[Soup]}" + nl + "Row #0: 20,739" + nl + "Row #1: 11,767" + nl + "Row #2: 8,006" + nl);
    }

    public void testStrMeasure() {
        TestContext ctx = TestContext.create(null, "<Cube name=\"StrMeasure\"> \n  <Table name=\"promotion\"/> \n  <Dimension name=\"Promotions\"> \n    <Hierarchy hasAll=\"true\" > \n      <Level name=\"Promotion Name\" column=\"promotion_name\" uniqueMembers=\"true\"/> \n    </Hierarchy> \n  </Dimension> \n  <Measure name=\"Media\" column=\"media_type\" aggregator=\"max\" datatype=\"String\"/> \n</Cube> \n", null, null, null, null);
        ctx.assertQueryReturns("select {[Measures].[Media]} on columns from [StrMeasure]", NonEmptyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Media]}\nRow #0: TV\n"));
    }

    public void testBug1515302() {
        TestContext ctx = TestContext.create(null, "<Cube name=\"Bug1515302\"> \n  <Table name=\"sales_fact_1997\"/> \n  <Dimension name=\"Promotions\" foreignKey=\"promotion_id\"> \n    <Hierarchy hasAll=\"false\" primaryKey=\"promotion_id\"> \n      <Table name=\"promotion\"/> \n      <Level name=\"Promotion Name\" column=\"promotion_name\" uniqueMembers=\"true\"/> \n    </Hierarchy> \n  </Dimension> \n  <Dimension name=\"Customers\" foreignKey=\"customer_id\"> \n    <Hierarchy hasAll=\"true\" allMemberName=\"All Customers\" primaryKey=\"customer_id\"> \n      <Table name=\"customer\"/> \n      <Level name=\"Country\" column=\"country\" uniqueMembers=\"true\"/> \n      <Level name=\"State Province\" column=\"state_province\" uniqueMembers=\"true\"/> \n      <Level name=\"City\" column=\"city\" uniqueMembers=\"false\"/> \n      <Level name=\"Name\" column=\"customer_id\" type=\"Numeric\" uniqueMembers=\"true\"/> \n    </Hierarchy> \n  </Dimension> \n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"/> \n</Cube> \n", null, null, null, null);
        ctx.assertQueryReturns("select {[Measures].[Unit Sales]} on columns, non empty crossjoin({[Promotions].[Big Promo]}, Descendants([Customers].[USA], [City], SELF_AND_BEFORE)) on rows from [Bug1515302]", NonEmptyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Anacortes]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Ballard]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Bellingham]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Burien]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Everett]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Issaquah]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Kirkland]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Lynnwood]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Marysville]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Olympia]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Puyallup]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Redmond]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Renton]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Seattle]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Sedro Woolley]}\n{[Promotions].[Big Promo], [Customers].[All Customers].[USA].[WA].[Tacoma]}\nRow #0: 1,789\nRow #1: 1,789\nRow #2: 20\nRow #3: 35\nRow #4: 15\nRow #5: 18\nRow #6: 60\nRow #7: 42\nRow #8: 36\nRow #9: 79\nRow #10: 58\nRow #11: 520\nRow #12: 438\nRow #13: 14\nRow #14: 20\nRow #15: 65\nRow #16: 3\nRow #17: 366\n"));
    }

    public void testVirtualCube() throws Exception {
        if (MondrianProperties.instance().TestExpDependencies.get() > 0) {
            return;
        }
        TestCase c = new TestCase(99, 3, "select NON EMPTY {[Measures].[Unit Sales], [Measures].[Warehouse Sales]} ON COLUMNS, NON EMPTY [Product].[All Products].Children ON ROWS from [Warehouse and Sales]");
        c.run();
    }

    public void testVirtualCubeMembers() throws Exception {
        if (MondrianProperties.instance().TestExpDependencies.get() > 0) {
            return;
        }
        TestCase c = new TestCase(6, 3, "select NON EMPTY {[Measures].[Unit Sales], [Measures].[Warehouse Sales]} ON COLUMNS, NON EMPTY {[Product].[Product Family].Members} ON ROWS from [Warehouse and Sales]");
        c.run();
    }

    public void testVirtualCubeMembersNonConformingDim() throws Exception {
        this.checkNotNative(1, "select non empty {[Customers].[Country].members} on columns, {[Measures].[Units Ordered]} on rows from [Warehouse and Sales]");
    }

    public void testNativeFilter() {
        String query = "select {[Measures].[Store Sales]} ON COLUMNS, NON EMPTY Order(Filter(Descendants([Customers].[All Customers].[USA].[CA], [Customers].[Name]), ([Measures].[Store Sales] > 200.0)), [Measures].[Store Sales], DESC) ON ROWS from [Sales] where ([Time].[1997])";
        this.propSaver.set(MondrianProperties.instance().EnableNativeFilter, true);
        boolean requestFreshConnection = true;
        this.checkNative(32, 18, query, null, requestFreshConnection);
    }

    public void testCmNativeFilter() {
        String query = "with member [Measures].[Rendite] as '([Measures].[Store Sales] - [Measures].[Store Cost]) / [Measures].[Store Cost]' select NON EMPTY {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Rendite], [Measures].[Store Sales]} ON COLUMNS, NON EMPTY Order(Filter([Product].[Product Name].Members, ([Measures].[Rendite] > 1.8)), [Measures].[Rendite], BDESC) ON ROWS from [Sales] where ([Store].[All Stores].[USA].[CA], [Time].[1997])";
        String result = "Axis #0:\n{[Store].[All Stores].[USA].[CA], [Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Rendite]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Baking Goods].[Jams and Jellies].[Peanut Butter].[Plato].[Plato Extra Chunky Peanut Butter]}\n{[Product].[All Products].[Food].[Snack Foods].[Snack Foods].[Popcorn].[Horatio].[Horatio Buttered Popcorn]}\n{[Product].[All Products].[Food].[Canned Foods].[Canned Tuna].[Tuna].[Better].[Better Canned Tuna in Oil]}\n{[Product].[All Products].[Food].[Produce].[Fruit].[Fresh Fruit].[High Top].[High Top Cantelope]}\n{[Product].[All Products].[Non-Consumable].[Household].[Electrical].[Lightbulbs].[Denny].[Denny 75 Watt Lightbulb]}\n{[Product].[All Products].[Food].[Breakfast Foods].[Breakfast Foods].[Cereal].[Johnson].[Johnson Oatmeal]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Portsmouth].[Portsmouth Light Wine]}\n{[Product].[All Products].[Food].[Produce].[Vegetables].[Fresh Vegetables].[Ebony].[Ebony Squash]}\nRow #0: 42\nRow #0: 24.06\nRow #0: 1.93\nRow #0: 70.56\nRow #1: 36\nRow #1: 29.02\nRow #1: 1.91\nRow #1: 84.60\nRow #2: 39\nRow #2: 20.55\nRow #2: 1.85\nRow #2: 58.50\nRow #3: 25\nRow #3: 21.76\nRow #3: 1.84\nRow #3: 61.75\nRow #4: 43\nRow #4: 59.62\nRow #4: 1.83\nRow #4: 168.99\nRow #5: 34\nRow #5: 7.20\nRow #5: 1.83\nRow #5: 20.40\nRow #6: 36\nRow #6: 33.10\nRow #6: 1.83\nRow #6: 93.60\nRow #7: 46\nRow #7: 28.34\nRow #7: 1.81\nRow #7: 79.58\n";
        this.propSaver.set(MondrianProperties.instance().EnableNativeFilter, true);
        boolean requestFreshConnection = true;
        this.checkNative(0, 8, query, NonEmptyTest.fold(result), requestFreshConnection);
    }

    public void testNonNativeFilterWithNullMeasure() {
        String query = "select Filter([Store].[Store Name].members,               Not ([Measures].[Store Sqft] - [Measures].[Grocery Sqft] < 10000)) on rows, {[Measures].[Store Sqft], [Measures].[Grocery Sqft]} on columns from [Store]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sqft]}\n{[Measures].[Grocery Sqft]}\nAxis #2:\n{[Store].[All Stores].[Mexico].[DF].[Mexico City].[Store 9]}\n{[Store].[All Stores].[Mexico].[DF].[San Andres].[Store 21]}\n{[Store].[All Stores].[Mexico].[Yucatan].[Merida].[Store 8]}\n{[Store].[All Stores].[USA].[CA].[Alameda].[HQ]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\nRow #0: 36,509\nRow #0: 22,450\nRow #1: \nRow #1: \nRow #2: 30,797\nRow #2: 20,141\nRow #3: \nRow #3: \nRow #4: \nRow #4: \nRow #5: 39,696\nRow #5: 24,390\nRow #6: 33,858\nRow #6: 22,123\nRow #7: \nRow #7: \nRow #8: \nRow #8: \n";
        this.propSaver.set(MondrianProperties.instance().EnableNativeFilter, false);
        this.checkNotNative(9, query, NonEmptyTest.fold(result));
    }

    public void testNativeFilterWithNullMeasure() {
        String query = "select Filter([Store].[Store Name].members,               Not ([Measures].[Store Sqft] - [Measures].[Grocery Sqft] < 10000)) on rows, {[Measures].[Store Sqft], [Measures].[Grocery Sqft]} on columns from [Store]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sqft]}\n{[Measures].[Grocery Sqft]}\nAxis #2:\n{[Store].[All Stores].[Mexico].[DF].[Mexico City].[Store 9]}\n{[Store].[All Stores].[Mexico].[Yucatan].[Merida].[Store 8]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\nRow #0: 36,509\nRow #0: 22,450\nRow #1: 30,797\nRow #1: 20,141\nRow #2: 39,696\nRow #2: 24,390\nRow #3: 33,858\nRow #3: 22,123\n";
        this.propSaver.set(MondrianProperties.instance().EnableNativeFilter, true);
        Connection conn = this.getTestContext().getFoodMartConnection(false);
        TestContext context = this.getTestContext(conn);
        context.assertQueryReturns(query, NonEmptyTest.fold(result));
    }

    public void testNonNativeFilterWithCalcMember() {
        String query = "with\nmember [Time].[Date Range] as 'Aggregate({[Time].[1997].[Q1]:[Time].[1997].[Q4]})'\nselect\n{[Measures].[Unit Sales]} ON columns,\nFilter ([Store].[Store State].members, [Measures].[Store Cost] > 100) ON rows\nfrom [Sales]\nwhere [Time].[Date Range]\n";
        String result = "Axis #0:\n{[Time].[Date Range]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 74,748\nRow #1: 67,659\nRow #2: 124,366\n";
        this.propSaver.set(MondrianProperties.instance().EnableNativeFilter, false);
        this.checkNotNative(3, query, NonEmptyTest.fold(result));
    }

    public void testNativeFilterNonEmpty() {
        String query = "select Filter(CrossJoin([Store].[Store Name].members,                         [Store Type].[Store Type].members),                         Not IsEmpty([Measures].[Store Sqft])) on rows, {[Measures].[Store Sqft]} on columns from [Store]";
        this.propSaver.set(MondrianProperties.instance().EnableNativeFilter, true);
        boolean requestFreshConnection = true;
        this.checkNative(0, 20, query, null, requestFreshConnection);
    }

    public void testNativeCJWithRedundantSetBraces() {
        String query = "select non empty {CrossJoin({[Store].[Store Name].members},                         {{[Store Type].[Store Type].members}})}                         on rows, {[Measures].[Store Sqft]} on columns from [Store]";
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, true);
        boolean requestFreshConnection = true;
        this.checkNative(0, 20, query, null, requestFreshConnection);
    }

    public void testExpandAllNonNativeInputs() {
        String query = "select NonEmptyCrossJoin([Gender].Children, [Store].Children) on columns from [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Gender].[All Gender].[F], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[M], [Store].[All Stores].[USA]}\nRow #0: 131,558\nRow #0: 135,215\n";
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, true);
        boolean requestFreshConnection = true;
        this.checkNative(0, 2, query, NonEmptyTest.fold(result), requestFreshConnection);
    }

    public void testExpandOneNonNativeInput() {
        String query = "With Set [*Filtered_Set] as Filter([Product].[Product Name].Members, [Product].CurrentMember IS [Product].[Product Name].[Fast Raisins]) Set [*NECJ_Set] as NonEmptyCrossJoin([Store].[Store Country].Members, [*Filtered_Set]) select [*NECJ_Set] on columns From [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA], [Product].[All Products].[Food].[Snack Foods].[Snack Foods].[Dried Fruit].[Fast].[Fast Raisins]}\nRow #0: 152\n";
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, true);
        boolean requestFreshConnection = true;
        this.checkNative(0, 1, query, NonEmptyTest.fold(result), requestFreshConnection);
    }

    public void testExpandNonNativeResourceLimitFailure() {
        String query = "select NonEmptyCrossJoin({[Gender].Children, [Gender].[F]}, {[Store].Children, [Store].[Mexico]}) on columns from [Sales]";
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, true);
        this.propSaver.set(MondrianProperties.instance().ResultLimit, 2);
        try {
            this.executeQuery(query);
            NonEmptyTest.fail((String)"Expected error did not occur");
        }
        catch (Throwable e) {
            String expectedErrorMsg = "Mondrian Error:Size of CrossJoin result (3) exceeded limit (2)";
            NonEmptyTest.assertEquals((String)expectedErrorMsg, (String)e.getMessage());
        }
    }

    public void testExpandAllMembersInAllInputs() {
        String query = "select NON EMPTY {[Time].[1997]} ON COLUMNS,\n       NON EMPTY Crossjoin(Hierarchize(Union({[Store].[All Stores]},\n           [Store].[USA].[CA].[San Francisco].[Store 14].Children)), {[Product].[All Products]}) \n           ON ROWS\n    from [Sales]\n    where [Measures].[Unit Sales]";
        String result = "Axis #0:\n{[Measures].[Unit Sales]}\nAxis #1:\n{[Time].[1997]}\nAxis #2:\n{[Store].[All Stores], [Product].[All Products]}\nRow #0: 266,773\n";
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, true);
        this.checkNotNative(1, query, NonEmptyTest.fold(result));
    }

    public void testExpandCalcMembersInAllInputs() {
        String query = "With Member [Product].[*CTX_MEMBER_SEL~SUM] as 'Sum({[Product].[Product Family].Members})' Member [Gender].[*CTX_MEMBER_SEL~SUM] as 'Sum({[Gender].[All Gender]})' Select NonEmptyCrossJoin({[Gender].[*CTX_MEMBER_SEL~SUM]},{[Product].[*CTX_MEMBER_SEL~SUM]}) on columns From [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Gender].[*CTX_MEMBER_SEL~SUM], [Product].[*CTX_MEMBER_SEL~SUM]}\nRow #0: 266,773\n";
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, true);
        this.checkNotNative(1, query, NonEmptyTest.fold(result));
    }

    public void testExpandCalcMemberInputNECJ() {
        String query = "With \nMember [Product].[All Products].[Food].[CalcSum] as \n'Sum({[Product].[All Products].[Food]})', SOLVE_ORDER=-100\nSelect\n{[Measures].[Store Cost]} on columns,\nNonEmptyCrossJoin({[Product].[All Products].[Food].[CalcSum]},\n                  {[Education Level].DefaultMember}) on rows\nFrom [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Cost]}\nAxis #2:\n{[Product].[All Products].[Food].[CalcSum], [Education Level].[All Education Levels]}\nRow #0: 163,270.72\n";
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.checkNotNative(1, query, NonEmptyTest.fold(result));
    }

    public void testExpandCalcMembers() {
        String query = "with member [Store Type].[All Store Types].[S] as sum({[Store Type].[All Store Types]}) set [Enum Store Types] as {    [Store Type].[All Store Types].[Small Grocery],     [Store Type].[All Store Types].[Supermarket],     [Store Type].[All Store Types].[HeadQuarters],     [Store Type].[All Store Types].[S]} set [Filtered Enum Store Types] as Filter([Enum Store Types], [Measures].[Unit Sales] > 0)select NonEmptyCrossJoin([Product].[All Products].Children, [Filtered Enum Store Types])  on columns from [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Product].[All Products].[Drink], [Store Type].[All Store Types].[Small Grocery]}\n{[Product].[All Products].[Drink], [Store Type].[All Store Types].[Supermarket]}\n{[Product].[All Products].[Drink], [Store Type].[All Store Types].[S]}\n{[Product].[All Products].[Food], [Store Type].[All Store Types].[Small Grocery]}\n{[Product].[All Products].[Food], [Store Type].[All Store Types].[Supermarket]}\n{[Product].[All Products].[Food], [Store Type].[All Store Types].[S]}\n{[Product].[All Products].[Non-Consumable], [Store Type].[All Store Types].[Small Grocery]}\n{[Product].[All Products].[Non-Consumable], [Store Type].[All Store Types].[Supermarket]}\n{[Product].[All Products].[Non-Consumable], [Store Type].[All Store Types].[S]}\nRow #0: 574\nRow #0: 14,092\nRow #0: 24,597\nRow #0: 4,764\nRow #0: 108,188\nRow #0: 191,940\nRow #0: 1,219\nRow #0: 28,275\nRow #0: 50,236\n";
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.checkNotNative(9, query, NonEmptyTest.fold(result));
    }

    public void testExpandNestedNonNativeInputs() {
        String query = "select NonEmptyCrossJoin(  NonEmptyCrossJoin([Gender].Children, [Store].Children),   [Product].Children) on columns from [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Gender].[All Gender].[F], [Store].[All Stores].[USA], [Product].[All Products].[Drink]}\n{[Gender].[All Gender].[F], [Store].[All Stores].[USA], [Product].[All Products].[Food]}\n{[Gender].[All Gender].[F], [Store].[All Stores].[USA], [Product].[All Products].[Non-Consumable]}\n{[Gender].[All Gender].[M], [Store].[All Stores].[USA], [Product].[All Products].[Drink]}\n{[Gender].[All Gender].[M], [Store].[All Stores].[USA], [Product].[All Products].[Food]}\n{[Gender].[All Gender].[M], [Store].[All Stores].[USA], [Product].[All Products].[Non-Consumable]}\nRow #0: 12,202\nRow #0: 94,814\nRow #0: 24,542\nRow #0: 12,395\nRow #0: 97,126\nRow #0: 25,694\n";
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, true);
        boolean requestFreshConnection = true;
        this.checkNative(0, 6, query, NonEmptyTest.fold(result), requestFreshConnection);
    }

    public void testExpandLowMaxConstraints() {
        String query = "select NonEmptyCrossJoin(    Filter([Store Type].Children, [Measures].[Unit Sales] > 10000),     [Product].Children) on columns from [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Store Type].[All Store Types].[Deluxe Supermarket], [Product].[All Products].[Drink]}\n{[Store Type].[All Store Types].[Deluxe Supermarket], [Product].[All Products].[Food]}\n{[Store Type].[All Store Types].[Deluxe Supermarket], [Product].[All Products].[Non-Consumable]}\n{[Store Type].[All Store Types].[Gourmet Supermarket], [Product].[All Products].[Drink]}\n{[Store Type].[All Store Types].[Gourmet Supermarket], [Product].[All Products].[Food]}\n{[Store Type].[All Store Types].[Gourmet Supermarket], [Product].[All Products].[Non-Consumable]}\n{[Store Type].[All Store Types].[Mid-Size Grocery], [Product].[All Products].[Drink]}\n{[Store Type].[All Store Types].[Mid-Size Grocery], [Product].[All Products].[Food]}\n{[Store Type].[All Store Types].[Mid-Size Grocery], [Product].[All Products].[Non-Consumable]}\n{[Store Type].[All Store Types].[Supermarket], [Product].[All Products].[Drink]}\n{[Store Type].[All Store Types].[Supermarket], [Product].[All Products].[Food]}\n{[Store Type].[All Store Types].[Supermarket], [Product].[All Products].[Non-Consumable]}\nRow #0: 6,827\nRow #0: 55,358\nRow #0: 14,652\nRow #0: 1,945\nRow #0: 15,438\nRow #0: 3,950\nRow #0: 1,159\nRow #0: 8,192\nRow #0: 2,140\nRow #0: 14,092\nRow #0: 108,188\nRow #0: 28,275\n";
        this.propSaver.set(MondrianProperties.instance().MaxConstraints, 2);
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.checkNotNative(12, query, NonEmptyTest.fold(result));
    }

    public void testExpandDifferentLevels() {
        String query = "select NonEmptyCrossJoin(    Descendants([Customers].[All Customers].[USA].[WA].[Yakima]),     [Product].Children) on columns from [Sales]";
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.checkNotNative(278, query, null);
    }

    public void testExpandTupleInputs1() {
        String query = "with set [Tuple Set] as {([Store Type].[All Store Types].[HeadQuarters], [Product].[All Products].[Drink]), ([Store Type].[All Store Types].[Supermarket], [Product].[All Products].[Food])} set [Filtered Tuple Set] as Filter([Tuple Set], 1=1) set [NECJ] as NonEmptyCrossJoin([Store].Children, [Filtered Tuple Set]) select [NECJ] on columns from [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA], [Store Type].[All Store Types].[Supermarket], [Product].[All Products].[Food]}\nRow #0: 108,188\n";
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.checkNotNative(1, query, NonEmptyTest.fold(result));
    }

    public void testExpandTupleInputs2() {
        String query = "with set [Tuple Set] as {([Store Type].[All Store Types].[HeadQuarters], [Product].[All Products].[Drink]), ([Store Type].[All Store Types].[Supermarket], [Product].[All Products].[Food])} set [Filtered Tuple Set] as Filter([Tuple Set], 1=1) set [NECJ] as NonEmptyCrossJoin([Filtered Tuple Set], [Store].Children) select [NECJ] on columns from [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Store Type].[All Store Types].[Supermarket], [Product].[All Products].[Food], [Store].[All Stores].[USA]}\nRow #0: 108,188\n";
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.checkNotNative(1, query, NonEmptyTest.fold(result));
    }

    public void testExpandWithOneEmptyInput() {
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        String query = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Gender],[*BASE_MEMBERS_Product])' Set [*BASE_MEMBERS_Measures] as '{[Measures].[*FORMATTED_MEASURE_0]}' Set [*BASE_MEMBERS_Gender] as 'Filter([Gender].[Gender].Members,[Gender].CurrentMember.Name Matches (\"abc\"))' Set [*NATIVE_MEMBERS_Gender] as 'Generate([*NATIVE_CJ_SET], {[Gender].CurrentMember})' Set [*BASE_MEMBERS_Product] as '[Product].[Product Name].Members' Set [*NATIVE_MEMBERS_Product] as 'Generate([*NATIVE_CJ_SET], {[Product].CurrentMember})' Member [Measures].[*FORMATTED_MEASURE_0] as '[Measures].[Unit Sales]', FORMAT_STRING = '#,##0', SOLVE_ORDER=400 Select [*BASE_MEMBERS_Measures] on columns, Non Empty Generate([*NATIVE_CJ_SET], {([Gender].CurrentMember,[Product].CurrentMember)}) on rows From [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[*FORMATTED_MEASURE_0]}\nAxis #2:\n";
        boolean requestFreshConnection = true;
        this.checkNative(0, 0, NonEmptyTest.fold(query), NonEmptyTest.fold(result), requestFreshConnection);
    }

    public void testExpandWithTwoEmptyInputs() {
        this.getConnection().getCacheControl(null).flushSchemaCache();
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        String query = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Gender],[*BASE_MEMBERS_Product])' Set [*BASE_MEMBERS_Measures] as '{[Measures].[*FORMATTED_MEASURE_0]}' Set [*BASE_MEMBERS_Gender] as 'Filter([Gender].[Gender].Members,[Gender].CurrentMember.Name Matches (\"abc\"))' Set [*NATIVE_MEMBERS_Gender] as 'Generate([*NATIVE_CJ_SET], {[Gender].CurrentMember})' Set [*BASE_MEMBERS_Product] as 'Filter([Product].[Product Name].Members, [Product].[Product Name].CurrentMember.Name Matches (\"abc\"))' Set [*NATIVE_MEMBERS_Product] as 'Generate([*NATIVE_CJ_SET], {[Product].CurrentMember})' Member [Measures].[*FORMATTED_MEASURE_0] as '[Measures].[Unit Sales]', FORMAT_STRING = '#,##0', SOLVE_ORDER=400 Select [*BASE_MEMBERS_Measures] on columns, Non Empty Generate([*NATIVE_CJ_SET], {([Gender].CurrentMember,[Product].CurrentMember)}) on rows From [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[*FORMATTED_MEASURE_0]}\nAxis #2:\n";
        this.checkNotNative(0, NonEmptyTest.fold(query), NonEmptyTest.fold(result));
    }

    public void testEnumLowMaxConstraints() {
        String query = "with set [All Store Types] as {[Store Type].[All Store Types].[Deluxe Supermarket], [Store Type].[All Store Types].[Gourmet Supermarket], [Store Type].[All Store Types].[Mid-Size Grocery], [Store Type].[All Store Types].[Small Grocery], [Store Type].[All Store Types].[Supermarket]} set [All Products] as {[Product].[All Products].[Drink], [Product].[All Products].[Food], [Product].[All Products].[Non-Consumable]} select NonEmptyCrossJoin(Filter([All Store Types], ([Measures].[Unit Sales] > 10000)), [All Products]) on columns from [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Store Type].[All Store Types].[Deluxe Supermarket], [Product].[All Products].[Drink]}\n{[Store Type].[All Store Types].[Deluxe Supermarket], [Product].[All Products].[Food]}\n{[Store Type].[All Store Types].[Deluxe Supermarket], [Product].[All Products].[Non-Consumable]}\n{[Store Type].[All Store Types].[Gourmet Supermarket], [Product].[All Products].[Drink]}\n{[Store Type].[All Store Types].[Gourmet Supermarket], [Product].[All Products].[Food]}\n{[Store Type].[All Store Types].[Gourmet Supermarket], [Product].[All Products].[Non-Consumable]}\n{[Store Type].[All Store Types].[Mid-Size Grocery], [Product].[All Products].[Drink]}\n{[Store Type].[All Store Types].[Mid-Size Grocery], [Product].[All Products].[Food]}\n{[Store Type].[All Store Types].[Mid-Size Grocery], [Product].[All Products].[Non-Consumable]}\n{[Store Type].[All Store Types].[Supermarket], [Product].[All Products].[Drink]}\n{[Store Type].[All Store Types].[Supermarket], [Product].[All Products].[Food]}\n{[Store Type].[All Store Types].[Supermarket], [Product].[All Products].[Non-Consumable]}\nRow #0: 6,827\nRow #0: 55,358\nRow #0: 14,652\nRow #0: 1,945\nRow #0: 15,438\nRow #0: 3,950\nRow #0: 1,159\nRow #0: 8,192\nRow #0: 2,140\nRow #0: 14,092\nRow #0: 108,188\nRow #0: 28,275\n";
        this.propSaver.set(MondrianProperties.instance().MaxConstraints, 2);
        this.checkNotNative(12, query, NonEmptyTest.fold(result));
    }

    public void testAllMembersNECJ1() {
        String query = "select NonEmptyCrossJoin({[Store].[All Stores]}, {[Product].[All Products]}) on columns from [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores], [Product].[All Products]}\nRow #0: 266,773\n";
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, true);
        this.checkNotNative(1, query, NonEmptyTest.fold(result));
    }

    public void testAllMembersNECJ2() {
        String query = "select NonEmptyCrossJoin([Product].[All Products].Children, {[Store].[All Stores]}) on columns from [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Product].[All Products].[Drink], [Store].[All Stores]}\n{[Product].[All Products].[Food], [Store].[All Stores]}\n{[Product].[All Products].[Non-Consumable], [Store].[All Stores]}\nRow #0: 24,597\nRow #0: 191,940\nRow #0: 50,236\n";
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, true);
        boolean requestFreshConnection = true;
        this.checkNative(0, 3, query, NonEmptyTest.fold(result), requestFreshConnection);
    }

    public void testAllLevelMembers() {
        this.checkNative(14, 14, "select {[Measures].[Store Sales]} ON COLUMNS, NON EMPTY Crossjoin([Product].[(All)].Members, [Promotion Media].[All Media].Children) ON ROWS from [Sales]");
    }

    public void testCjDescendantsEnumAllOnly() {
        this.checkNative(9, 9, "select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin(  Descendants([Customers].[All Customers].[USA], [Customers].[City]),   {[Product].[All Products]}) ON ROWS from [Sales] where ([Promotions].[All Promotions].[Bag Stuffers])");
    }

    public void testResultIsModifyableCopy() {
        this.checkNative(3, 3, "select {[Measures].[Store Sales]} on columns,  NON EMPTY Order(        CrossJoin([Customers].[All Customers].[USA].children, [Promotions].[Promotion Name].Members),         [Measures].[Store Sales]) ON ROWS from [Sales] where (  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],  [Time].[1997].[Q1].[1])");
    }

    public void testNativeTopCount() {
        switch (this.getTestContext().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                return;
            }
        }
        String query = "select {[Measures].[Store Sales]} on columns,  NON EMPTY TopCount(        CrossJoin([Customers].[All Customers].[USA].children, [Promotions].[Promotion Name].Members),         3, (3 * [Measures].[Store Sales]) - 100) ON ROWS from [Sales] where (  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],  [Time].[1997].[Q1].[1])";
        this.propSaver.set(MondrianProperties.instance().EnableNativeTopCount, true);
        boolean requestFreshConnection = true;
        this.checkNative(3, 3, query, null, requestFreshConnection);
    }

    public void testCmNativeTopCount() {
        switch (this.getTestContext().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                return;
            }
        }
        String query = "with member [Measures].[Store Profit Rate] as '([Measures].[Store Sales]-[Measures].[Store Cost])/[Measures].[Store Cost]', format = '#.00%' select {[Measures].[Store Sales]} on columns,  NON EMPTY TopCount(        [Customers].[All Customers].[USA].children,         3, [Measures].[Store Profit Rate] / 2) ON ROWS from [Sales]";
        this.propSaver.set(MondrianProperties.instance().EnableNativeTopCount, true);
        boolean requestFreshConnection = true;
        this.checkNative(3, 3, query, null, requestFreshConnection);
    }

    public void testMeasureAndAggregateInSlicer() {
        String result = NonEmptyTest.fold("Axis #0:\n{[Store Type].[All Store Types].[All Types], [Measures].[Unit Sales], [Customers].[All Customers].[USA], [Product].[All Products].[Drink]}\nAxis #1:\n{[Time].[1997]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\nRow #0: 1,945\nRow #1: 2,422\nRow #2: 2,560\nRow #3: 175\n");
        this.assertQueryReturns("with member [Store Type].[All Store Types].[All Types] as 'Aggregate({[Store Type].[All Store Types].[Deluxe Supermarket],  [Store Type].[All Store Types].[Gourmet Supermarket],  [Store Type].[All Store Types].[HeadQuarters],  [Store Type].[All Store Types].[Mid-Size Grocery],  [Store Type].[All Store Types].[Small Grocery],  [Store Type].[All Store Types].[Supermarket]})'  select NON EMPTY {[Time].[1997]} ON COLUMNS,   NON EMPTY [Store].[All Stores].[USA].[CA].Children ON ROWS   from [Sales] where ([Store Type].[All Store Types].[All Types], [Measures].[Unit Sales], [Customers].[All Customers].[USA], [Product].[All Products].[Drink])  ", result);
    }

    public void testMeasureInSlicer() {
        String result = NonEmptyTest.fold("Axis #0:\n{[Measures].[Unit Sales], [Customers].[All Customers].[USA], [Product].[All Products].[Drink]}\nAxis #1:\n{[Time].[1997]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\nRow #0: 1,945\nRow #1: 2,422\nRow #2: 2,560\nRow #3: 175\n");
        this.assertQueryReturns("select NON EMPTY {[Time].[1997]} ON COLUMNS,   NON EMPTY [Store].[All Stores].[USA].[CA].Children ON ROWS  from [Sales]  where ([Measures].[Unit Sales], [Customers].[All Customers].[USA], [Product].[All Products].[Drink])", result);
    }

    public void testCmInTopCount() {
        this.checkNotNative(1, "with member [Time].[Jan] as  'Aggregate({[Time].[1998].[Q1].[1], [Time].[1997].[Q1].[1]})'  select NON EMPTY {[Measures].[Unit Sales]} ON columns,  NON EMPTY TopCount({[Time].[Jan]}, 2) ON rows from [Sales] ");
    }

    public void testCmInSlicer() {
        this.checkNotNative(3, "with member [Time].[Jan] as  'Aggregate({[Time].[1998].[Q1].[1], [Time].[1997].[Q1].[1]})'  select NON EMPTY {[Measures].[Unit Sales]} ON columns,  NON EMPTY [Product].[All Products].Children ON rows from [Sales] where ([Time].[Jan]) ");
    }

    public void testCjMembersMembersMembers() {
        this.checkNative(67, 67, "select {[Measures].[Store Sales]} on columns,  NON EMPTY Crossjoin(    Crossjoin(        [Customers].[Name].Members,        [Product].[Product Name].Members),     [Promotions].[Promotion Name].Members) ON rows  from [Sales] where (  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],  [Time].[1997].[Q1].[1])");
    }

    public void testCjEnumEnum() {
        int minConstraints = 2;
        if (MondrianProperties.instance().MaxConstraints.get() < minConstraints) {
            this.propSaver.set(MondrianProperties.instance().MaxConstraints, minConstraints);
        }
        this.checkNative(4, 4, "select {[Measures].[Unit Sales]} ON COLUMNS, NonEmptyCrossjoin({[Product].[All Products].[Drink].[Beverages], [Product].[All Products].[Drink].[Dairy]}, {[Customers].[All Customers].[USA].[OR].[Portland], [Customers].[All Customers].[USA].[OR].[Salem]}) ON ROWS from [Sales] ");
    }

    public void testCjNullInEnum() {
        this.propSaver.set(MondrianProperties.instance().IgnoreInvalidMembersDuringQuery, true);
        this.checkNative(20, 0, "select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin({[Gender].[All Gender].[emale]}, [Customers].[All Customers].[USA].children) ON ROWS from [Sales] ");
    }

    public void testCjDescendantsEnumAll() {
        this.checkNotNative(13, "select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin(  Descendants([Customers].[All Customers].[USA], [Customers].[City]),   {[Product].[All Products], [Product].[All Products].[Drink].[Dairy]}) ON ROWS from [Sales] where ([Promotions].[All Promotions].[Bag Stuffers])");
    }

    public void testCjDescendantsEnum() {
        int minConstraints = 2;
        if (MondrianProperties.instance().MaxConstraints.get() < minConstraints) {
            this.propSaver.set(MondrianProperties.instance().MaxConstraints, minConstraints);
        }
        this.checkNative(11, 11, "select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin(  Descendants([Customers].[All Customers].[USA], [Customers].[City]),   {[Product].[All Products].[Drink].[Beverages], [Product].[All Products].[Drink].[Dairy]}) ON ROWS from [Sales] where ([Promotions].[All Promotions].[Bag Stuffers])");
    }

    public void testCjEnumChildren() {
        int minConstraints = 2;
        if (MondrianProperties.instance().MaxConstraints.get() < minConstraints) {
            this.propSaver.set(MondrianProperties.instance().MaxConstraints, minConstraints);
        }
        this.checkNative(3, 3, "select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin(  {[Product].[All Products].[Drink].[Beverages], [Product].[All Products].[Drink].[Dairy]},   [Customers].[All Customers].[USA].[WA].Children) ON ROWS from [Sales] where ([Promotions].[All Promotions].[Bag Stuffers])");
    }

    public void testCjEnumDifferentLevelsChildren() {
        if (MondrianProperties.instance().TestExpDependencies.get() > 0) {
            return;
        }
        TestCase c = new TestCase(8, 5, "select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin(  {[Product].[All Products].[Food], [Product].[All Products].[Drink].[Dairy]},   [Customers].[All Customers].[USA].[WA].Children) ON ROWS from [Sales] where ([Promotions].[All Promotions].[Bag Stuffers])");
        c.run();
    }

    public void testCjDescendantsMembers() {
        this.checkNative(67, 67, "select {[Measures].[Store Sales]} on columns, NON EMPTY Crossjoin(   Descendants([Customers].[All Customers].[USA].[CA], [Customers].[Name]),     [Product].[Product Name].Members) ON rows  from [Sales] where (  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],  [Time].[1997].[Q1].[1])");
    }

    public void testCjMembersDescendants() {
        this.checkNative(67, 67, "select {[Measures].[Store Sales]} on columns, NON EMPTY Crossjoin(  [Product].[Product Name].Members,  Descendants([Customers].[All Customers].[USA].[CA], [Customers].[Name])) ON rows  from [Sales] where (  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],  [Time].[1997].[Q1].[1])");
    }

    public void testCjChildrenMembers() {
        this.checkNative(67, 67, "select {[Measures].[Store Sales]} on columns,  NON EMPTY Crossjoin([Customers].[All Customers].[USA].[CA].children,    [Product].[Product Name].Members) ON rows  from [Sales] where (  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],  [Time].[1997].[Q1].[1])");
    }

    public void testCjMembersChildren() {
        this.checkNative(67, 67, "select {[Measures].[Store Sales]} on columns,  NON EMPTY Crossjoin([Product].[Product Name].Members,    [Customers].[All Customers].[USA].[CA].children) ON rows  from [Sales] where (  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],  [Time].[1997].[Q1].[1])");
    }

    public void testCjMembersMembers() {
        this.checkNative(67, 67, "select {[Measures].[Store Sales]} on columns,  NON EMPTY Crossjoin([Customers].[Name].Members,    [Product].[Product Name].Members) ON rows  from [Sales] where (  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],  [Time].[1997].[Q1].[1])");
    }

    public void testCjChildrenChildren() {
        this.checkNative(3, 3, "select {[Measures].[Store Sales]} on columns,   NON EMPTY Crossjoin(    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].children,     [Customers].[All Customers].[USA].[CA].CHILDREN) ON rows from [Sales] where (  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],  [Time].[1997].[Q1].[1])");
    }

    public void testMultiLevelMemberConstraintNonNullParent() {
        String query = "with set [Filtered Store City Set] as {[Store].[USA].[OR].[Portland],  [Store].[USA].[OR].[Salem],  [Store].[USA].[CA].[San Francisco],  [Store].[USA].[WA].[Tacoma]} set [NECJ] as NonEmptyCrossJoin([Filtered Store City Set], {[Product].[Product Family].Food}) select [NECJ] on columns from [Sales]";
        String necjSqlDerby = "select \"store\".\"store_country\", \"store\".\"store_state\", \"store\".\"store_city\", \"product_class\".\"product_family\" from \"store\" as \"store\", \"sales_fact_1997\" as \"sales_fact_1997\", \"product\" as \"product\", \"product_class\" as \"product_class\" where \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and ((\"store\".\"store_state\" = 'OR' and \"store\".\"store_city\" in ('Portland', 'Salem')) or (\"store\".\"store_state\" = 'CA' and \"store\".\"store_city\" = 'San Francisco') or (\"store\".\"store_state\" = 'WA' and \"store\".\"store_city\" = 'Tacoma')) and (\"product_class\".\"product_family\" = 'Food') group by \"store\".\"store_country\", \"store\".\"store_state\", \"store\".\"store_city\", \"product_class\".\"product_family\" order by \"store\".\"store_country\" ASC, \"store\".\"store_state\" ASC, \"store\".\"store_city\" ASC, \"product_class\".\"product_family\" ASC";
        String necjSqlMySql = "select `store`.`store_country` as `c0`, `store`.`store_state` as `c1`, `store`.`store_city` as `c2`, `product_class`.`product_family` as `c3` from `store` as `store`, `sales_fact_1997` as `sales_fact_1997`, `product` as `product`, `product_class` as `product_class` where `sales_fact_1997`.`store_id` = `store`.`store_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and `sales_fact_1997`.`product_id` = `product`.`product_id` and ((`store`.`store_city`,`store`.`store_state`) in (('Portland','OR'),('Salem','OR'),('San Francisco','CA'),('Tacoma','WA'))) and (`product_class`.`product_family` = 'Food') group by `store`.`store_country`, `store`.`store_state`, `store`.`store_city`, `product_class`.`product_family` order by ISNULL(`store`.`store_country`), `store`.`store_country` ASC, ISNULL(`store`.`store_state`), `store`.`store_state` ASC, ISNULL(`store`.`store_city`), `store`.`store_city` ASC, ISNULL(`product_class`.`product_family`), `product_class`.`product_family` ASC";
        if (MondrianProperties.instance().UseAggregates.get() && MondrianProperties.instance().ReadAggregates.get()) {
            necjSqlMySql = necjSqlMySql.replaceAll("sales_fact_1997", "agg_c_14_sales_fact_1997");
            necjSqlDerby = necjSqlDerby.replaceAll("sales_fact_1997", "agg_c_14_sales_fact_1997");
        }
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, necjSqlDerby, necjSqlDerby), new SqlPattern(Dialect.DatabaseProduct.MYSQL, necjSqlMySql, necjSqlMySql)};
        this.assertQuerySql(query, patterns);
    }

    public void testMultiLevelMemberConstraintNullParent() {
        if (!this.isDefaultNullMemberRepresentation()) {
            return;
        }
        String dimension = "<Dimension name=\"Warehouse2\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"warehouse_id\">\n    <Table name=\"warehouse\"/>\n    <Level name=\"address3\" column=\"wa_address3\" uniqueMembers=\"true\"/>\n    <Level name=\"address2\" column=\"wa_address2\" uniqueMembers=\"true\"/>\n    <Level name=\"address1\" column=\"wa_address1\" uniqueMembers=\"false\"/>\n    <Level name=\"name\" column=\"warehouse_name\" uniqueMembers=\"false\"/>\n  </Hierarchy>\n</Dimension>\n";
        String cube = "<Cube name=\"Warehouse2\">\n  <Table name=\"inventory_fact_1997\"/>\n  <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n  <DimensionUsage name=\"Warehouse2\" source=\"Warehouse2\" foreignKey=\"warehouse_id\"/>\n  <Measure name=\"Warehouse Cost\" column=\"warehouse_cost\" aggregator=\"sum\"/>\n  <Measure name=\"Warehouse Sales\" column=\"warehouse_sales\" aggregator=\"sum\"/>\n</Cube>";
        String query = "with\nset [Filtered Warehouse Set] as {[Warehouse2].[#null].[#null].[5617 Saclan Terrace].[Arnold and Sons], [Warehouse2].[#null].[#null].[3377 Coachman Place].[Jones International]} set [NECJ] as NonEmptyCrossJoin([Filtered Warehouse Set], {[Product].[Product Family].Food}) select [NECJ] on columns from [Warehouse2]";
        String necjSqlDerby = "select \"warehouse\".\"wa_address3\", \"warehouse\".\"wa_address2\", \"warehouse\".\"wa_address1\", \"warehouse\".\"warehouse_name\", \"product_class\".\"product_family\" from \"warehouse\" as \"warehouse\", \"inventory_fact_1997\" as \"inventory_fact_1997\", \"product\" as \"product\", \"product_class\" as \"product_class\" where \"inventory_fact_1997\".\"warehouse_id\" = \"warehouse\".\"warehouse_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"inventory_fact_1997\".\"product_id\" = \"product\".\"product_id\" and ((\"warehouse\".\"wa_address1\" = '5617 Saclan Terrace' and \"warehouse\".\"wa_address2\" is null and \"warehouse\".\"warehouse_name\" = 'Arnold and Sons') or (\"warehouse\".\"wa_address1\" = '3377 Coachman Place' and \"warehouse\".\"wa_address2\" is null and \"warehouse\".\"warehouse_name\" = 'Jones International')) and (\"product_class\".\"product_family\" = 'Food') group by \"warehouse\".\"wa_address3\", \"warehouse\".\"wa_address2\", \"warehouse\".\"wa_address1\", \"warehouse\".\"warehouse_name\", \"product_class\".\"product_family\" order by \"warehouse\".\"wa_address3\" ASC, \"warehouse\".\"wa_address2\" ASC, \"warehouse\".\"wa_address1\" ASC, \"warehouse\".\"warehouse_name\" ASC, \"product_class\".\"product_family\" ASC";
        String necjSqlMySql = "select `warehouse`.`wa_address3` as `c0`, `warehouse`.`wa_address2` as `c1`, `warehouse`.`wa_address1` as `c2`, `warehouse`.`warehouse_name` as `c3`, `product_class`.`product_family` as `c4` from `warehouse` as `warehouse`, `inventory_fact_1997` as `inventory_fact_1997`, `product` as `product`, `product_class` as `product_class` where `inventory_fact_1997`.`warehouse_id` = `warehouse`.`warehouse_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and `inventory_fact_1997`.`product_id` = `product`.`product_id` and ((`warehouse`.`wa_address2` is null and (`warehouse`.`warehouse_name`,`warehouse`.`wa_address1`) in (('Arnold and Sons','5617 Saclan Terrace'),('Jones International','3377 Coachman Place')))) and (`product_class`.`product_family` = 'Food') group by `warehouse`.`wa_address3`, `warehouse`.`wa_address2`, `warehouse`.`wa_address1`, `warehouse`.`warehouse_name`, `product_class`.`product_family` order by ISNULL(`warehouse`.`wa_address3`), `warehouse`.`wa_address3` ASC, ISNULL(`warehouse`.`wa_address2`), `warehouse`.`wa_address2` ASC, ISNULL(`warehouse`.`wa_address1`), `warehouse`.`wa_address1` ASC, ISNULL(`warehouse`.`warehouse_name`), `warehouse`.`warehouse_name` ASC, ISNULL(`product_class`.`product_family`), `product_class`.`product_family` ASC";
        TestContext testContext = TestContext.create(dimension, cube, null, null, null, null);
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, necjSqlDerby, necjSqlDerby), new SqlPattern(Dialect.DatabaseProduct.MYSQL, necjSqlMySql, necjSqlMySql)};
        this.assertQuerySql(testContext, query, patterns);
    }

    public void testMultiLevelMemberConstraintMixedNullNonNullParent() {
        if (!this.isDefaultNullMemberRepresentation()) {
            return;
        }
        String dimension = "<Dimension name=\"Warehouse2\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"warehouse_id\">\n    <Table name=\"warehouse\"/>\n    <Level name=\"fax\" column=\"warehouse_fax\" uniqueMembers=\"true\"/>\n    <Level name=\"address1\" column=\"wa_address1\" uniqueMembers=\"false\"/>\n    <Level name=\"name\" column=\"warehouse_name\" uniqueMembers=\"false\"/>\n  </Hierarchy>\n</Dimension>\n";
        String cube = "<Cube name=\"Warehouse2\">\n  <Table name=\"inventory_fact_1997\"/>\n  <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n  <DimensionUsage name=\"Warehouse2\" source=\"Warehouse2\" foreignKey=\"warehouse_id\"/>\n  <Measure name=\"Warehouse Cost\" column=\"warehouse_cost\" aggregator=\"sum\"/>\n  <Measure name=\"Warehouse Sales\" column=\"warehouse_sales\" aggregator=\"sum\"/>\n</Cube>";
        String query = "with\nset [Filtered Warehouse Set] as {[Warehouse2].[#null].[234 West Covina Pkwy].[Freeman And Co], [Warehouse2].[971-555-6213].[3377 Coachman Place].[Jones International]} set [NECJ] as NonEmptyCrossJoin([Filtered Warehouse Set], {[Product].[Product Family].Food}) select [NECJ] on columns from [Warehouse2]";
        String necjSqlDerby = "select \"warehouse\".\"warehouse_fax\", \"warehouse\".\"wa_address1\", \"warehouse\".\"warehouse_name\", \"product_class\".\"product_family\" from \"warehouse\" as \"warehouse\", \"inventory_fact_1997\" as \"inventory_fact_1997\", \"product\" as \"product\", \"product_class\" as \"product_class\" where \"inventory_fact_1997\".\"warehouse_id\" = \"warehouse\".\"warehouse_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"inventory_fact_1997\".\"product_id\" = \"product\".\"product_id\" and ((\"warehouse\".\"wa_address1\" = '234 West Covina Pkwy' and \"warehouse\".\"warehouse_fax\" is null and \"warehouse\".\"warehouse_name\" = 'Freeman And Co') or (\"warehouse\".\"wa_address1\" = '3377 Coachman Place' and \"warehouse\".\"warehouse_fax\" = '971-555-6213' and \"warehouse\".\"warehouse_name\" = 'Jones International')) and (\"product_class\".\"product_family\" = 'Food') group by \"warehouse\".\"warehouse_fax\", \"warehouse\".\"wa_address1\", \"warehouse\".\"warehouse_name\", \"product_class\".\"product_family\" order by \"warehouse\".\"warehouse_fax\" ASC, \"warehouse\".\"wa_address1\" ASC, \"warehouse\".\"warehouse_name\" ASC, \"product_class\".\"product_family\" ASC";
        String necjSqlMySql = "select `warehouse`.`warehouse_fax` as `c0`, `warehouse`.`wa_address1` as `c1`, `warehouse`.`warehouse_name` as `c2`, `product_class`.`product_family` as `c3` from `warehouse` as `warehouse`, `inventory_fact_1997` as `inventory_fact_1997`, `product` as `product`, `product_class` as `product_class` where `inventory_fact_1997`.`warehouse_id` = `warehouse`.`warehouse_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and `inventory_fact_1997`.`product_id` = `product`.`product_id` and ((`warehouse`.`warehouse_name`,`warehouse`.`wa_address1`,`warehouse`.`warehouse_fax`) in (('Jones International','3377 Coachman Place','971-555-6213')) or (`warehouse`.`warehouse_fax` is null and (`warehouse`.`warehouse_name`,`warehouse`.`wa_address1`) in (('Freeman And Co','234 West Covina Pkwy')))) and (`product_class`.`product_family` = 'Food') group by `warehouse`.`warehouse_fax`, `warehouse`.`wa_address1`, `warehouse`.`warehouse_name`, `product_class`.`product_family` order by ISNULL(`warehouse`.`warehouse_fax`), `warehouse`.`warehouse_fax` ASC, ISNULL(`warehouse`.`wa_address1`), `warehouse`.`wa_address1` ASC, ISNULL(`warehouse`.`warehouse_name`), `warehouse`.`warehouse_name` ASC, ISNULL(`product_class`.`product_family`), `product_class`.`product_family` ASC";
        TestContext testContext = TestContext.create(dimension, cube, null, null, null, null);
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, necjSqlDerby, necjSqlDerby), new SqlPattern(Dialect.DatabaseProduct.MYSQL, necjSqlMySql, necjSqlMySql)};
        this.assertQuerySql(testContext, query, patterns);
    }

    public void testMultiLevelMemberConstraintWithMixedNullNonNullChild() {
        if (!this.isDefaultNullMemberRepresentation()) {
            return;
        }
        String dimension = "<Dimension name=\"Warehouse2\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"warehouse_id\">\n    <Table name=\"warehouse\"/>\n    <Level name=\"address3\" column=\"wa_address3\" uniqueMembers=\"true\"/>\n    <Level name=\"address2\" column=\"wa_address2\" uniqueMembers=\"false\"/>\n    <Level name=\"fax\" column=\"warehouse_fax\" uniqueMembers=\"false\"/>\n  </Hierarchy>\n</Dimension>\n";
        String cube = "<Cube name=\"Warehouse2\">\n  <Table name=\"inventory_fact_1997\"/>\n  <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n  <DimensionUsage name=\"Warehouse2\" source=\"Warehouse2\" foreignKey=\"warehouse_id\"/>\n  <Measure name=\"Warehouse Cost\" column=\"warehouse_cost\" aggregator=\"sum\"/>\n  <Measure name=\"Warehouse Sales\" column=\"warehouse_sales\" aggregator=\"sum\"/>\n</Cube>";
        String query = "with\nset [Filtered Warehouse Set] as {[Warehouse2].[#null].[#null].[#null], [Warehouse2].[#null].[#null].[971-555-6213]} set [NECJ] as NonEmptyCrossJoin([Filtered Warehouse Set], {[Product].[Product Family].Food}) select [NECJ] on columns from [Warehouse2]";
        String necjSqlDerby = "select \"warehouse\".\"wa_address3\", \"warehouse\".\"wa_address2\", \"warehouse\".\"warehouse_fax\", \"product_class\".\"product_family\" from \"warehouse\" as \"warehouse\", \"inventory_fact_1997\" as \"inventory_fact_1997\", \"product\" as \"product\", \"product_class\" as \"product_class\" where \"inventory_fact_1997\".\"warehouse_id\" = \"warehouse\".\"warehouse_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"inventory_fact_1997\".\"product_id\" = \"product\".\"product_id\" and ((\"warehouse\".\"warehouse_fax\" = '971-555-6213' or \"warehouse\".\"warehouse_fax\" is null) and \"warehouse\".\"wa_address2\" is null and \"warehouse\".\"wa_address3\" is null) and (\"product_class\".\"product_family\" = 'Food') group by \"warehouse\".\"wa_address3\", \"warehouse\".\"wa_address2\", \"warehouse\".\"warehouse_fax\", \"product_class\".\"product_family\" order by \"warehouse\".\"wa_address3\" ASC, \"warehouse\".\"wa_address2\" ASC, \"warehouse\".\"warehouse_fax\" ASC, \"product_class\".\"product_family\" ASC";
        String necjSqlMySql = "select `warehouse`.`wa_address3` as `c0`, `warehouse`.`wa_address2` as `c1`, `warehouse`.`warehouse_fax` as `c2`, `product_class`.`product_family` as `c3` from `warehouse` as `warehouse`, `inventory_fact_1997` as `inventory_fact_1997`, `product` as `product`, `product_class` as `product_class` where `inventory_fact_1997`.`warehouse_id` = `warehouse`.`warehouse_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and `inventory_fact_1997`.`product_id` = `product`.`product_id` and ((`warehouse`.`warehouse_fax` = '971-555-6213' or `warehouse`.`warehouse_fax` is null) and `warehouse`.`wa_address2` is null and `warehouse`.`wa_address3` is null) and (`product_class`.`product_family` = 'Food') group by `warehouse`.`wa_address3`, `warehouse`.`wa_address2`, `warehouse`.`warehouse_fax`, `product_class`.`product_family` order by ISNULL(`warehouse`.`wa_address3`), `warehouse`.`wa_address3` ASC, ISNULL(`warehouse`.`wa_address2`), `warehouse`.`wa_address2` ASC, ISNULL(`warehouse`.`warehouse_fax`), `warehouse`.`warehouse_fax` ASC, ISNULL(`product_class`.`product_family`), `product_class`.`product_family` ASC";
        TestContext testContext = TestContext.create(dimension, cube, null, null, null, null);
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, necjSqlDerby, necjSqlDerby), new SqlPattern(Dialect.DatabaseProduct.MYSQL, necjSqlMySql, necjSqlMySql)};
        this.assertQuerySql(testContext, query, patterns);
    }

    public void testNonEmptyUnionQuery() {
        Result result = this.executeQuery("select {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales]} on columns,\n NON EMPTY Hierarchize(\n   Union(\n     Crossjoin(\n       Crossjoin([Gender].[All Gender].children,\n                 [Marital Status].[All Marital Status].children),\n       Crossjoin([Customers].[All Customers].children,\n                 [Product].[All Products].children) ),\n     Crossjoin({([Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M])},\n       Crossjoin(\n         [Customers].[All Customers].[USA].children,\n         [Product].[All Products].children) ) )) on rows\nfrom Sales where ([Time].[1997])");
        Axis rowsAxis = result.getAxes()[1];
        Assert.assertEquals((int)21, (int)rowsAxis.getPositions().size());
    }

    public void testLookupMemberCache() {
        if (MondrianProperties.instance().TestExpDependencies.get() > 0) {
            return;
        }
        SmartMemberReader smr = this.getSmartMemberReader("Store");
        MemberCacheHelper smrch = smr.cacheHelper;
        MemberCacheHelper rcsmrch = ((RolapCubeHierarchy.RolapCubeHierarchyMemberReader)((Object)smr)).getRolapCubeMemberCacheHelper();
        SmartMemberReader ssmr = this.getSharedSmartMemberReader("Store");
        MemberCacheHelper ssmrch = ssmr.cacheHelper;
        this.clearAndHardenCache(smrch);
        this.clearAndHardenCache(rcsmrch);
        this.clearAndHardenCache(ssmrch);
        RolapResult result = (RolapResult)this.executeQuery("select {[Store].[All Stores].[USA].[CA].[San Francisco]} on columns from [Sales]");
        NonEmptyTest.assertTrue((String)("no additional members should be read:" + ssmrch.mapKeyToMember.size()), (ssmrch.mapKeyToMember.size() <= 5 ? 1 : 0) != 0);
        RolapMember sf = (RolapMember)result.getAxes()[0].getPositions().get(0).get(0);
        RolapMember ca = sf.getParentMember();
        ca = ((RolapCubeMember)ca).getRolapMember();
        sf = ((RolapCubeMember)sf).getRolapMember();
        List<RolapMember> list = ssmrch.mapMemberToChildren.get(ca, this.scf.getMemberChildrenConstraint(null));
        NonEmptyTest.assertNull((String)"children of [CA] are not in cache", list);
        list = ssmrch.mapMemberToChildren.get(ca, this.scf.getChildByNameConstraint(ca, new Id.Segment("San Francisco", Id.Quoting.QUOTED)));
        NonEmptyTest.assertNotNull((String)"child [San Francisco] of [CA] is in cache", list);
        NonEmptyTest.assertEquals((String)"[San Francisco] expected", (Object)sf, (Object)list.get(0));
    }

    public void testLookupMember() {
        this.executeQuery("SELECT DESCENDANTS([Time].[1997], [Month]) ON COLUMNS FROM [Sales]");
    }

    public void testNonEmptyCrossJoinList() {
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, false);
        boolean oldEnableNativeNonEmpty = MondrianProperties.instance().EnableNativeNonEmpty.get();
        MondrianProperties.instance().EnableNativeNonEmpty.set(false);
        this.executeQuery("select non empty CrossJoin([Customers].[Name].Members, {[Promotions].[All Promotions].[Fantastic Discounts]}) ON COLUMNS FROM [Sales]");
        MondrianProperties.instance().EnableNativeNonEmpty.set(oldEnableNativeNonEmpty);
    }

    public void testLookupMember2() {
        this.executeQuery("select {[Store].[USA].[Washington]} on columns from [Sales Ragged]");
    }

    public void testCalcMemberWithNonEmptyCrossJoin() {
        this.getConnection().getCacheControl(null).flushSchemaCache();
        Result result = this.executeQuery("with member [Measures].[CustomerCount] as \n'Count(CrossJoin({[Product].[All Products]}, [Customers].[Name].Members))'\nselect \nNON EMPTY{[Measures].[CustomerCount]} ON columns,\nNON EMPTY{[Product].[All Products]} ON rows\nfrom [Sales]\nwhere ([Store].[All Stores].[USA].[CA].[San Francisco].[Store 14], [Time].[1997].[Q1].[1])");
        Cell c = result.getCell(new int[]{0, 0});
        NonEmptyTest.assertEquals((String)"10,281", (String)c.getFormattedValue());
    }

    public void testLevelMembers() {
        if (MondrianProperties.instance().TestExpDependencies.get() > 0) {
            return;
        }
        SmartMemberReader smr = this.getSmartMemberReader("Customers");
        MemberCacheHelper smrch = ((RolapCubeHierarchy.CacheRolapCubeHierarchyMemberReader)smr).rolapCubeCacheHelper;
        this.clearAndHardenCache(smrch);
        MemberCacheHelper smrich = smr.cacheHelper;
        this.clearAndHardenCache(smrich);
        SmartMemberReader ssmr = this.getSharedSmartMemberReader("Customers");
        MemberCacheHelper ssmrch = ssmr.cacheHelper;
        this.clearAndHardenCache(ssmrch);
        TestCase c = new TestCase(50, 21, "select \n{[Measures].[Unit Sales]} ON columns,\nNON EMPTY {[Customers].[All Customers], [Customers].[Name].Members} ON rows\nfrom [Sales]\nwhere ([Store].[All Stores].[USA].[CA].[San Francisco].[Store 14], [Time].[1997].[Q1].[1])");
        Result r = c.run();
        mondrian.olap.Level[] levels = smr.getHierarchy().getLevels();
        mondrian.olap.Level nameLevel = levels[levels.length - 1];
        RolapEvaluator context = this.getEvaluator(r, new int[]{0, 0});
        TupleConstraint lmc = this.scf.getLevelMembersConstraint(null);
        NonEmptyTest.assertNull(smrch.mapLevelToMembers.get((RolapLevel)nameLevel, lmc));
        lmc = this.scf.getLevelMembersConstraint(context.push(true));
        List<RolapMember> list = smrch.mapLevelToMembers.get((RolapLevel)nameLevel, lmc);
        if (MondrianProperties.instance().EnableRolapCubeMemberCache.get()) {
            NonEmptyTest.assertNotNull(list);
            NonEmptyTest.assertEquals((int)20, (int)list.size());
        }
        Member member = (Member)r.getAxes()[1].getPositions().get(1).get(0);
        Member parent = member.getParentMember();
        parent = ((RolapCubeMember)parent).getRolapMember();
        member = ((RolapCubeMember)member).getRolapMember();
        MemberChildrenConstraint mcc = this.scf.getMemberChildrenConstraint(null);
        NonEmptyTest.assertNull(ssmrch.mapMemberToChildren.get((RolapMember)parent, mcc));
        mcc = this.scf.getMemberChildrenConstraint(context.push(true));
        list = smrich.mapMemberToChildren.get((RolapMember)parent, mcc);
        NonEmptyTest.assertNotNull(list);
        NonEmptyTest.assertTrue((boolean)list.contains(member));
    }

    public void testLevelMembersWithoutNonEmpty() {
        SmartMemberReader smr = this.getSmartMemberReader("Customers");
        MemberCacheHelper smrch = ((RolapCubeHierarchy.CacheRolapCubeHierarchyMemberReader)smr).rolapCubeCacheHelper;
        this.clearAndHardenCache(smrch);
        MemberCacheHelper smrich = smr.cacheHelper;
        this.clearAndHardenCache(smrich);
        SmartMemberReader ssmr = this.getSharedSmartMemberReader("Customers");
        MemberCacheHelper ssmrch = ssmr.cacheHelper;
        this.clearAndHardenCache(ssmrch);
        Result r = this.executeQuery("select \n{[Measures].[Unit Sales]} ON columns,\n{[Customers].[All Customers], [Customers].[Name].Members} ON rows\nfrom [Sales]\nwhere ([Store].[All Stores].[USA].[CA].[San Francisco].[Store 14], [Time].[1997].[Q1].[1])");
        mondrian.olap.Level[] levels = smr.getHierarchy().getLevels();
        mondrian.olap.Level nameLevel = levels[levels.length - 1];
        RolapEvaluator context = this.getEvaluator(r, new int[]{0, 0});
        TupleConstraint lmc = this.scf.getLevelMembersConstraint(null);
        List<RolapMember> list = smrch.mapLevelToMembers.get((RolapLevel)nameLevel, lmc);
        if (MondrianProperties.instance().EnableRolapCubeMemberCache.get()) {
            NonEmptyTest.assertNotNull(list);
            NonEmptyTest.assertEquals((int)10281, (int)list.size());
        }
        lmc = this.scf.getLevelMembersConstraint(context.push(true));
        NonEmptyTest.assertNull(smrch.mapLevelToMembers.get((RolapLevel)nameLevel, lmc));
        Member member = (Member)r.getAxes()[1].getPositions().get(1).get(0);
        Member parent = member.getParentMember();
        parent = ((RolapCubeMember)parent).getRolapMember();
        member = ((RolapCubeMember)member).getRolapMember();
        MemberChildrenConstraint mcc = this.scf.getMemberChildrenConstraint(null);
        list = ssmrch.mapMemberToChildren.get((RolapMember)parent, mcc);
        NonEmptyTest.assertNotNull(list);
        NonEmptyTest.assertTrue((boolean)list.contains(member));
        mcc = this.scf.getMemberChildrenConstraint(context.push(true));
        list = ssmrch.mapMemberToChildren.get((RolapMember)parent, mcc);
        NonEmptyTest.assertNull(list);
    }

    public void testDimensionMembers() {
        TestCase c = new TestCase(34, 34, "select \n{[Measures].[Unit Sales]} ON columns,\nNON EMPTY [Customers].Members ON rows\nfrom [Sales]\nwhere ([Store].[All Stores].[USA].[CA].[San Francisco].[Store 14], [Time].[1997].[Q1].[1])");
        c.run();
    }

    public void testMemberChildrenOfRolapMember() {
        TestCase c = new TestCase(50, 4, "select \n{[Measures].[Unit Sales]} ON columns,\nNON EMPTY [Customers].[All Customers].[USA].[CA].[Palo Alto].Children ON rows\nfrom [Sales]\nwhere ([Store].[All Stores].[USA].[CA].[San Francisco].[Store 14], [Time].[1997].[Q1].[1])");
        c.run();
    }

    public void testMemberChildrenOfAllMember() {
        TestCase c = new TestCase(50, 14, "select {[Measures].[Unit Sales]} ON columns,\nNON EMPTY [Promotions].[All Promotions].Children ON rows from [Sales]\nwhere ([Time].[1997].[Q1].[1])");
        c.run();
    }

    public void testMemberChildrenNoWhere() {
        TestCase c = new TestCase(50, 48, "select {[Measures].[Unit Sales]} ON columns,\nNON EMPTY [Promotions].[All Promotions].Children ON rows from [Sales]\n");
        c.run();
    }

    public void testMemberChildrenNameCol() {
        if (MondrianProperties.instance().TestExpDependencies.get() > 0) {
            return;
        }
        TestCase c = new TestCase(3, 1, "select  {[Measures].[Count]} ON columns, {[Time].[1997].[Q2].[April]} on rows from [HR]");
        c.run();
    }

    public void testCrossjoin() {
        if (MondrianProperties.instance().TestExpDependencies.get() > 0) {
            return;
        }
        TestCase c = new TestCase(45, 4, "select \n{[Measures].[Unit Sales]} ON columns,\nNON EMPTY Crossjoin({[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}, [Customers].[All Customers].[USA].[CA].[Palo Alto].Children) ON rows\nfrom [Sales] where ([Time].[1997].[Q1].[1])");
        c.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonEmptyDescendants() {
        if (MondrianProperties.instance().TestExpDependencies.get() > 0) {
            return;
        }
        Connection con = this.getTestContext().getFoodMartConnection(false);
        SmartMemberReader smr = this.getSmartMemberReader(con, "Customers");
        MemberCacheHelper smrch = smr.cacheHelper;
        this.clearAndHardenCache(smrch);
        SmartMemberReader ssmr = this.getSmartMemberReader(con, "Customers");
        MemberCacheHelper ssmrch = ssmr.cacheHelper;
        this.clearAndHardenCache(ssmrch);
        TestCase c = new TestCase(con, 45, 21, "select \n{[Measures].[Unit Sales]} ON columns, NON EMPTY {[Customers].[All Customers], Descendants([Customers].[All Customers].[USA].[CA], [Customers].[Name])} on rows from [Sales] where ([Store].[All Stores].[USA].[CA].[San Francisco].[Store 14], [Time].[1997].[Q1].[1])");
        Result result = c.run();
        RolapMember peggy = (RolapMember)result.getAxes()[1].getPositions().get(1).get(0);
        RolapMember burlingame = peggy.getParentMember();
        peggy = ((RolapCubeMember)peggy).getRolapMember();
        burlingame = ((RolapCubeMember)burlingame).getRolapMember();
        MemberChildrenConstraint mcc = this.scf.getMemberChildrenConstraint(null);
        NonEmptyTest.assertNull(ssmrch.mapMemberToChildren.get(burlingame, mcc));
        RolapEvaluator evaluator = this.getEvaluator(result, new int[]{0, 0});
        mcc = this.scf.getMemberChildrenConstraint(evaluator.push(true));
        List<RolapMember> list = ssmrch.mapMemberToChildren.get(burlingame, mcc);
        NonEmptyTest.assertNotNull(list);
        NonEmptyTest.assertTrue((boolean)list.contains(peggy));
        RolapNativeRegistry reg = this.getRegistry(con);
        reg.setListener(new RolapNative.Listener(){

            public void foundEvaluator(RolapNative.NativeEvent e) {
            }

            public void foundInCache(RolapNative.TupleEvent e) {
            }

            public void excutingSql(RolapNative.TupleEvent e) {
                Assert.fail((String)"expected caching");
            }
        });
        try {
            c.run();
        }
        finally {
            reg.setListener(null);
        }
    }

    public void testBug1412384() {
        this.assertQueryReturns("select NON EMPTY {[Time].[1997]} ON COLUMNS,\nNON EMPTY Hierarchize(Union({[Customers].[All Customers]},\n[Customers].[All Customers].Children)) ON ROWS\nfrom [Sales]\nwhere [Measures].[Profit]", NonEmptyTest.fold("Axis #0:\n{[Measures].[Profit]}\nAxis #1:\n{[Time].[1997]}\nAxis #2:\n{[Customers].[All Customers]}\n{[Customers].[All Customers].[USA]}\nRow #0: $339,610.90\nRow #1: $339,610.90\n"));
    }

    public void testVirtualCubeCrossJoin() {
        this.checkNative(18, 3, "select {[Measures].[Units Ordered], [Measures].[Store Sales]} on columns, non empty crossjoin([Product].[All Products].children, [Store].[All Stores].children) on rows from [Warehouse and Sales]");
    }

    public void testVirtualCubeNonEmptyCrossJoin() {
        this.checkNative(18, 3, "select {[Measures].[Units Ordered], [Measures].[Store Sales]} on columns, NonEmptyCrossJoin([Product].[All Products].children, [Store].[All Stores].children) on rows from [Warehouse and Sales]");
    }

    public void testVirtualCubeNonEmptyCrossJoin3Args() {
        this.checkNative(3, 3, "select {[Measures].[Store Sales]} on columns, nonEmptyCrossJoin([Product].[All Products].children, nonEmptyCrossJoin([Customers].[All Customers].children,[Store].[All Stores].children)) on rows from [Warehouse and Sales]");
    }

    public void testVirtualCubeCrossJoinNonConformingDim() {
        this.propSaver.set(MondrianProperties.instance().AlertNativeEvaluationUnsupported, "ERROR");
        this.checkNotNative(0, "select {[Measures].[Units Ordered], [Measures].[Store Sales]} on columns, NonEmptyCrossJoin([Customers].[All Customers].children, [Warehouse].[All Warehouses].children) on rows from [Warehouse and Sales]");
    }

    public void testNotNativeVirtualCubeCrossJoin1() {
        switch (this.getTestContext().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                return;
            }
        }
        this.propSaver.set(MondrianProperties.instance().AlertNativeEvaluationUnsupported, "ERROR");
        this.checkNotNative(3, "select {[Measures].AllMembers} on columns, non empty crossjoin([Product].[All Products].children, [Store].[All Stores].children) on rows from [Warehouse and Sales]");
    }

    public void testNotNativeVirtualCubeCrossJoin2() {
        this.checkNotNative(3, "select {[Measures].[Sales Count] : [Measures].[Unit Sales]} on columns, non empty crossjoin([Product].[All Products].children, [Store].[All Stores].children) on rows from [Warehouse and Sales]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotNativeVirtualCubeCrossJoinUnsupported() {
        switch (this.getTestContext().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                return;
            }
        }
        BooleanProperty enableProperty = MondrianProperties.instance().EnableNativeCrossJoin;
        StringProperty alertProperty = MondrianProperties.instance().AlertNativeEvaluationUnsupported;
        if (!enableProperty.get()) {
            return;
        }
        String mdx = "select {[Measures].AllMembers} on columns, NonEmptyCrossJoin([Product].[All Products].children, [Store].[All Stores].children) on rows from [Warehouse and Sales]";
        final ArrayList<LoggingEvent> events = new ArrayList<LoggingEvent>();
        AppenderSkeleton alertListener = new AppenderSkeleton(){

            protected void append(LoggingEvent event) {
                events.add(event);
            }

            public void close() {
            }

            public boolean requiresLayout() {
                return false;
            }
        };
        Logger rolapUtilLogger = Logger.getLogger(RolapUtil.class);
        rolapUtilLogger.addAppender((Appender)alertListener);
        String expectedMessage = "Unable to use native SQL evaluation for 'NonEmptyCrossJoin'";
        this.propSaver.set(alertProperty, Level.ERROR.toString());
        try {
            this.checkNotNative(3, mdx);
            NonEmptyTest.fail((String)"Expected NativeEvaluationUnsupportedException");
        }
        catch (NativeEvaluationUnsupportedException ex) {
        }
        finally {
            this.propSaver.reset();
        }
        int nEvents = this.countFilteredEvents(events, Level.ERROR, expectedMessage);
        NonEmptyTest.assertEquals((int)1, (int)nEvents);
        events.clear();
        this.propSaver.set(alertProperty, Level.WARN.toString());
        try {
            this.checkNotNative(3, mdx);
        }
        finally {
            this.propSaver.reset();
        }
        nEvents = this.countFilteredEvents(events, Level.WARN, expectedMessage);
        NonEmptyTest.assertEquals((int)1, (int)nEvents);
        events.clear();
        this.propSaver.set(alertProperty, Level.WARN.toString());
        this.propSaver.set(enableProperty, false);
        try {
            this.checkNotNative(3, mdx);
        }
        finally {
            this.propSaver.reset();
        }
        nEvents = this.countFilteredEvents(events, Level.WARN, expectedMessage);
        NonEmptyTest.assertEquals((int)0, (int)nEvents);
        events.clear();
        rolapUtilLogger.removeAppender((Appender)alertListener);
    }

    private int countFilteredEvents(List<LoggingEvent> events, Level level, String pattern) {
        int filteredEventCount = 0;
        for (LoggingEvent event : events) {
            if (!event.getLevel().equals((Object)level) || event.getMessage().toString().indexOf(pattern) == -1) continue;
            ++filteredEventCount;
        }
        return filteredEventCount;
    }

    public void testVirtualCubeCrossJoinCalculatedMember1() {
        this.checkNative(18, 3, "WITH MEMBER [Measures].[Total Cost] as '[Measures].[Store Cost] + [Measures].[Warehouse Cost]' select {[Measures].[Total Cost]} on columns, non empty crossjoin([Product].[All Products].children, [Store].[All Stores].children) on rows from [Warehouse and Sales]");
    }

    public void testVirtualCubeCrossJoinCalculatedMember2() {
        this.checkNative(18, 3, "select {[Measures].[Profit Per Unit Shipped]} on columns, non empty crossjoin([Product].[All Products].children, [Store].[All Stores].children) on rows from [Warehouse and Sales]");
    }

    public void testNotNativeVirtualCubeCrossJoinCalculatedMember() {
        this.checkNotNative(3, "WITH MEMBER [Measures].[CurrMember] as '[Measures].CurrentMember' select {[Measures].[CurrMember]} on columns, non empty crossjoin([Product].[All Products].children, [Store].[All Stores].children) on rows from [Warehouse and Sales]");
    }

    public void testCjEnumCalcMembers() {
        this.checkNotNative(30, "with member [Product].[All Products].[Drink].[*SUBTOTAL_MEMBER_SEL~SUM] as     'sum({[Product].[All Products].[Drink]})' member [Product].[All Products].[Non-Consumable].[*SUBTOTAL_MEMBER_SEL~SUM] as     'sum({[Product].[All Products].[Non-Consumable]})' member [Customers].[All Customers].[USA].[CA].[*SUBTOTAL_MEMBER_SEL~SUM] as     'sum({[Customers].[All Customers].[USA].[CA]})' member [Customers].[All Customers].[USA].[OR].[*SUBTOTAL_MEMBER_SEL~SUM] as     'sum({[Customers].[All Customers].[USA].[OR]})' member [Customers].[All Customers].[USA].[WA].[*SUBTOTAL_MEMBER_SEL~SUM] as     'sum({[Customers].[All Customers].[USA].[WA]})' select {[Measures].[Unit Sales]} on columns, non empty     crossjoin(        crossjoin(            crossjoin(                {[Product].[All Products].[Drink].[*SUBTOTAL_MEMBER_SEL~SUM],                     [Product].[All Products].[Non-Consumable].[*SUBTOTAL_MEMBER_SEL~SUM]},                 [Education Level].[Education Level].Members),             {[Customers].[All Customers].[USA].[CA].[*SUBTOTAL_MEMBER_SEL~SUM],                 [Customers].[All Customers].[USA].[OR].[*SUBTOTAL_MEMBER_SEL~SUM],                 [Customers].[All Customers].[USA].[WA].[*SUBTOTAL_MEMBER_SEL~SUM]}),         [Time].[Year].members)    on rows from [Sales]");
    }

    public void testCjEnumCalcMembersBug() {
        String query = "with member [Store Type].[All Store Types].[S] as sum({[Store Type].[All Store Types]}) set [Enum Store Types] as {    [Store Type].[All Store Types].[HeadQuarters],     [Store Type].[All Store Types].[Small Grocery],     [Store Type].[All Store Types].[Supermarket],     [Store Type].[All Store Types].[S]}select [Measures] on columns,\n    NonEmptyCrossJoin([Product].[All Products].Children, [Enum Store Types]) on rows\nfrom [Sales]";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Drink], [Store Type].[All Store Types].[Small Grocery]}\n{[Product].[All Products].[Drink], [Store Type].[All Store Types].[Supermarket]}\n{[Product].[All Products].[Drink], [Store Type].[All Store Types].[S]}\n{[Product].[All Products].[Food], [Store Type].[All Store Types].[Small Grocery]}\n{[Product].[All Products].[Food], [Store Type].[All Store Types].[Supermarket]}\n{[Product].[All Products].[Food], [Store Type].[All Store Types].[S]}\n{[Product].[All Products].[Non-Consumable], [Store Type].[All Store Types].[Small Grocery]}\n{[Product].[All Products].[Non-Consumable], [Store Type].[All Store Types].[Supermarket]}\n{[Product].[All Products].[Non-Consumable], [Store Type].[All Store Types].[S]}\nRow #0: 574\nRow #1: 14,092\nRow #2: 24,597\nRow #3: 4,764\nRow #4: 108,188\nRow #5: 191,940\nRow #6: 1,219\nRow #7: 28,275\nRow #8: 50,236\n";
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, true);
        this.propSaver.set(MondrianProperties.instance().ExpandNonNative, true);
        this.checkNotNative(9, query, NonEmptyTest.fold(result));
    }

    public void testCjEnumEmptyCalcMembers() {
        int minConstraints = 3;
        if (MondrianProperties.instance().MaxConstraints.get() < minConstraints) {
            this.propSaver.set(MondrianProperties.instance().MaxConstraints, minConstraints);
        }
        this.checkNotNative(5, "with member [Customers].[All Customers].[USA].[*SUBTOTAL_MEMBER_SEL~SUM] as     'sum({[Customers].[All Customers].[USA]})' member [Customers].[All Customers].[Mexico].[*SUBTOTAL_MEMBER_SEL~SUM] as     'sum({[Customers].[All Customers].[Mexico]})' member [Customers].[All Customers].[Canada].[*SUBTOTAL_MEMBER_SEL~SUM] as     'sum({[Customers].[All Customers].[Canada]})' select {[Measures].[Unit Sales]} on columns, non empty     crossjoin(        {[Customers].[All Customers].[Mexico].[*SUBTOTAL_MEMBER_SEL~SUM],             [Customers].[All Customers].[Canada].[*SUBTOTAL_MEMBER_SEL~SUM],             [Customers].[All Customers].[USA].[*SUBTOTAL_MEMBER_SEL~SUM]},         [Education Level].[Education Level].Members)     on rows from [Sales]");
    }

    public void testCjUnionEnumCalcMembers() {
        this.checkNotNative(46, "with member [Education Level].[*SUBTOTAL_MEMBER_SEL~SUM] as     'sum({[Education Level].[All Education Levels]})' member [Education Level].[*SUBTOTAL_MEMBER_SEL~AVG] as    'avg([Education Level].[Education Level].Members)' select {[Measures].[Unit Sales]} on columns, non empty union (Crossjoin(    [Product].[Product Department].Members,     {[Education Level].[*SUBTOTAL_MEMBER_SEL~AVG]}), crossjoin(    [Product].[Product Department].Members,     {[Education Level].[*SUBTOTAL_MEMBER_SEL~SUM]})) on rows from [Sales]");
    }

    public void testNonEmptyWithWeirdDefaultMember() {
    }

    public void testCrossJoinNamedSets1() {
        this.checkNative(3, 3, "with SET [ProductChildren] as '[Product].[All Products].children' SET [StoreMembers] as '[Store].[Store Country].members' select {[Measures].[Store Sales]} on columns, non empty crossjoin([ProductChildren], [StoreMembers]) on rows from [Sales]");
    }

    public void testCrossJoinNamedSets2() {
        int minConstraints = 3;
        if (MondrianProperties.instance().MaxConstraints.get() < minConstraints) {
            this.propSaver.set(MondrianProperties.instance().MaxConstraints, minConstraints);
        }
        this.checkNative(3, 3, "with SET [ProductChildren] as '{[Product].[All Products].[Drink], [Product].[All Products].[Food], [Product].[All Products].[Non-Consumable]}' SET [StoreChildren] as '[Store].[All Stores].children' select {[Measures].[Store Sales]} on columns, non empty crossjoin([ProductChildren], [StoreChildren]) on rows from [Sales]");
    }

    public void testCrossJoinSetWithDifferentParents() {
        this.checkNative(5, 5, "select {[Measures].[Unit Sales]} on columns, NonEmptyCrossJoin([Education Level].[Education Level].Members, {[Time].[1997].[Q1], [Time].[1998].[Q2]}) on rows from Sales");
    }

    public void testCrossJoinSetWithCrossProdMembers() {
        int minConstraints = 6;
        if (MondrianProperties.instance().MaxConstraints.get() < minConstraints) {
            this.propSaver.set(MondrianProperties.instance().MaxConstraints, minConstraints);
        }
        this.checkNative(15, 15, "select {[Measures].[Unit Sales]} on columns, NonEmptyCrossJoin([Education Level].[Education Level].Members, {[Time].[1997].[Q1], [Time].[1997].[Q2], [Time].[1997].[Q3], [Time].[1998].[Q1], [Time].[1998].[Q2], [Time].[1998].[Q3]})on rows from Sales");
    }

    public void testCrossJoinSetWithSameParent() {
        int minConstraints = 2;
        if (MondrianProperties.instance().MaxConstraints.get() < minConstraints) {
            this.propSaver.set(MondrianProperties.instance().MaxConstraints, minConstraints);
        }
        this.checkNative(10, 10, "select {[Measures].[Unit Sales]} on columns, NonEmptyCrossJoin([Education Level].[Education Level].Members, {[Store].[All Stores].[USA].[CA].[Beverly Hills], [Store].[All Stores].[USA].[CA].[San Francisco]}) on rows from Sales");
    }

    public void testCrossJoinSetWithUniqueLevel() {
        int minConstraints = 2;
        if (MondrianProperties.instance().MaxConstraints.get() < minConstraints) {
            this.propSaver.set(MondrianProperties.instance().MaxConstraints, minConstraints);
        }
        this.checkNative(10, 10, "select {[Measures].[Unit Sales]} on columns, NonEmptyCrossJoin([Education Level].[Education Level].Members, {[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6], [Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}) on rows from Sales");
    }

    public void testCrossJoinMultiInExprAllMember() {
        this.checkNative(10, 10, "select {[Measures].[Unit Sales]} on columns, NonEmptyCrossJoin([Education Level].[Education Level].Members, {[Product].[All Products].[Drink].[Alcoholic Beverages], [Product].[All Products].[Food].[Breakfast Foods]}) on rows from Sales");
    }

    public void testCrossJoinEvaluatorContext1() {
        this.assertQueryReturns("With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Store], [*BASE_MEMBERS_Products])' Set [*TOP_BOTTOM_SET] as 'Order([*GENERATED_MEMBERS_Store], ([Measures].[Unit Sales], [Product].[All Products].[*TOP_BOTTOM_MEMBER]), BDESC)' Set [*BASE_MEMBERS_Store] as '[Store].members' Set [*GENERATED_MEMBERS_Store] as 'Generate([*NATIVE_CJ_SET], {[Store].CurrentMember})' Set [*BASE_MEMBERS_Products] as '{[Product].[All Products].[Food], [Product].[All Products].[Drink], [Product].[All Products].[Non-Consumable]}' Set [*GENERATED_MEMBERS_Products] as 'Generate([*NATIVE_CJ_SET], {[Product].CurrentMember})' Member [Product].[All Products].[*TOP_BOTTOM_MEMBER] as 'Aggregate([*GENERATED_MEMBERS_Products])'Member [Measures].[*TOP_BOTTOM_MEMBER] as 'Rank([Store].CurrentMember,[*TOP_BOTTOM_SET])' Member [Store].[All Stores].[*SUBTOTAL_MEMBER_SEL~SUM] as 'sum(Filter([*GENERATED_MEMBERS_Store], [Measures].[*TOP_BOTTOM_MEMBER] <= 10))'Select {[Measures].[Store Cost]} on columns, Non Empty Filter(Generate([*NATIVE_CJ_SET], {([Store].CurrentMember)}), [Measures].[*TOP_BOTTOM_MEMBER] <= 10) on rows From [Sales]", NonEmptyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Cost]}\nAxis #2:\n{[Store].[All Stores]}\n{[Store].[All Stores].[USA]}\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[OR].[Portland]}\n{[Store].[All Stores].[USA].[OR].[Salem]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA]}\n{[Store].[All Stores].[USA].[WA].[Tacoma]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\nRow #0: 225,627.23\nRow #1: 225,627.23\nRow #2: 63,530.43\nRow #3: 56,772.50\nRow #4: 21,948.94\nRow #5: 34,823.56\nRow #6: 34,823.56\nRow #7: 105,324.31\nRow #8: 29,959.28\nRow #9: 29,959.28\n"));
    }

    public void testCrossJoinEvaluatorContext2() {
        int minConstraints = 2;
        if (MondrianProperties.instance().MaxConstraints.get() < minConstraints) {
            this.propSaver.set(MondrianProperties.instance().MaxConstraints, minConstraints);
        }
        this.assertQueryReturns("With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Dates], [*BASE_MEMBERS_Stores])' Set [*BASE_MEMBERS_Dates] as '{[Time].[1997].[Q1], [Time].[1997].[Q2]}' Set [*GENERATED_MEMBERS_Dates] as 'Generate([*NATIVE_CJ_SET], {[Time].CurrentMember})' Set [*GENERATED_MEMBERS_Measures] as '{[Measures].[*SUMMARY_METRIC_0]}' Set [*BASE_MEMBERS_Stores] as '{[Store].[USA].[CA], [Store].[USA].[WA]}' Set [*GENERATED_MEMBERS_Stores] as 'Generate([*NATIVE_CJ_SET], {[Store].CurrentMember})' Member [Time].[*SM_CTX_SEL] as 'Aggregate([*GENERATED_MEMBERS_Dates])' Member [Measures].[*SUMMARY_METRIC_0] as '[Measures].[Unit Sales]/([Measures].[Unit Sales],[Time].[*SM_CTX_SEL])', FORMAT_STRING = '0.00%' Member [Time].[*SUBTOTAL_MEMBER_SEL~SUM] as 'sum([*GENERATED_MEMBERS_Dates])' Member [Store].[*SUBTOTAL_MEMBER_SEL~SUM] as 'sum(Filter([*GENERATED_MEMBERS_Stores], ([Measures].[Unit Sales], [Time].[*SUBTOTAL_MEMBER_SEL~SUM]) > 0.0))' Select Union (CrossJoin (Filter (Generate([*NATIVE_CJ_SET], {([Time].CurrentMember)}), Not IsEmpty ([Measures].[Unit Sales])), [*GENERATED_MEMBERS_Measures]), CrossJoin (Filter ({[Time].[*SUBTOTAL_MEMBER_SEL~SUM]}, Not IsEmpty ([Measures].[Unit Sales])), [*GENERATED_MEMBERS_Measures])) on columns, Non Empty Union (Filter (Filter (Generate([*NATIVE_CJ_SET], {([Store].CurrentMember)}), ([Measures].[Unit Sales], [Time].[*SUBTOTAL_MEMBER_SEL~SUM]) > 0.0), Not IsEmpty ([Measures].[Unit Sales])), Filter({[Store].[*SUBTOTAL_MEMBER_SEL~SUM]}, Not IsEmpty ([Measures].[Unit Sales]))) on rows From [Sales]", NonEmptyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997].[Q1], [Measures].[*SUMMARY_METRIC_0]}\n{[Time].[1997].[Q2], [Measures].[*SUMMARY_METRIC_0]}\n{[Time].[*SUBTOTAL_MEMBER_SEL~SUM], [Measures].[*SUMMARY_METRIC_0]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[WA]}\n{[Store].[*SUBTOTAL_MEMBER_SEL~SUM]}\nRow #0: 48.34%\nRow #0: 51.66%\nRow #0: 100.00%\nRow #1: 50.53%\nRow #1: 49.47%\nRow #1: 100.00%\nRow #2: 49.72%\nRow #2: 50.28%\nRow #2: 100.00%\n"));
    }

    public void testVCNativeCJWithIsEmptyOnMeasure() {
        this.assertQueryReturns("with set BM_PRODUCT as {[Product].[All Products].[Drink]} set BM_EDU as [Education Level].[Education Level].Members set BM_GENDER as {[Gender].[Gender].[M]} set CJ as NonEmptyCrossJoin(BM_GENDER,NonEmptyCrossJoin(BM_EDU,BM_PRODUCT)) set GM_PRODUCT as Generate(CJ, {[Product].CurrentMember}) set GM_EDU as Generate(CJ, {[Education Level].CurrentMember}) set GM_GENDER as Generate(CJ, {[Gender].CurrentMember}) set GM_MEASURE as {[Measures].[Unit Sales]} member [Education Level].FILTER1 as Aggregate(GM_EDU) member [Gender].FILTER2 as Aggregate(GM_GENDER) select Filter(GM_PRODUCT, Not IsEmpty([Measures].[Unit Sales])) on rows, GM_MEASURE on columns from [Warehouse and Sales] where ([Education Level].FILTER1, [Gender].FILTER2)", NonEmptyTest.fold("Axis #0:\n{[Education Level].[FILTER1], [Gender].[FILTER2]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Drink]}\nRow #0: 12,395\n"));
    }

    public void testVCNativeCJWithTopPercent() {
        this.checkNative(92, 1, "select {topPercent(nonemptycrossjoin([Product].[Product Department].members, [Time].[1997].children),10,[Measures].[Store Sales])} on columns, {[Measures].[Store Sales]} on rows from [Warehouse and Sales]");
    }

    public void testVCOrdinalExpression() {
        this.checkNative(67, 67, "select {[Measures].[Store Sales]} on columns,  NON EMPTY Crossjoin([Customers].[Name].Members,    [Product].[Product Name].Members) ON rows  from [Warehouse and Sales] where (  [Store].[All Stores].[USA].[CA].[San Francisco].[Store 14],  [Time].[1997].[Q1].[1])");
    }

    public void testNonEmptyWithCalcMeasure() {
        this.checkNative(15, 6, "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Store],NonEmptyCrossJoin([*BASE_MEMBERS_Education Level],[*BASE_MEMBERS_Product]))' Set [*METRIC_CJ_SET] as 'Filter([*NATIVE_CJ_SET],[Measures].[*Store Sales_SEL~SUM] > 50000.0 And [Measures].[*Unit Sales_SEL~MAX] > 50000.0)' Set [*BASE_MEMBERS_Store] as '[Store].[Store Country].Members' Set [*NATIVE_MEMBERS_Store] as 'Generate([*NATIVE_CJ_SET], {[Store].CurrentMember})' Set [*METRIC_MEMBERS_Store] as 'Generate([*METRIC_CJ_SET], {[Store].CurrentMember})' Set [*BASE_MEMBERS_Measures] as '{[Measures].[Store Sales],[Measures].[Unit Sales]}' Set [*BASE_MEMBERS_Education Level] as '[Education Level].[Education Level].Members' Set [*NATIVE_MEMBERS_Education Level] as 'Generate([*NATIVE_CJ_SET], {[Education Level].CurrentMember})' Set [*METRIC_MEMBERS_Education Level] as 'Generate([*METRIC_CJ_SET], {[Education Level].CurrentMember})' Set [*BASE_MEMBERS_Product] as '[Product].[Product Family].Members' Set [*NATIVE_MEMBERS_Product] as 'Generate([*NATIVE_CJ_SET], {[Product].CurrentMember})' Set [*METRIC_MEMBERS_Product] as 'Generate([*METRIC_CJ_SET], {[Product].CurrentMember})' Member [Product].[*CTX_METRIC_MEMBER_SEL~SUM] as 'Sum({[Product].[All Products]})' Member [Store].[*CTX_METRIC_MEMBER_SEL~SUM] as 'Sum({[Store].[All Stores]})' Member [Measures].[*Store Sales_SEL~SUM] as '([Measures].[Store Sales],[Education Level].CurrentMember,[Product].[*CTX_METRIC_MEMBER_SEL~SUM],[Store].[*CTX_METRIC_MEMBER_SEL~SUM])' Member [Product].[*CTX_METRIC_MEMBER_SEL~MAX] as 'Max([*NATIVE_MEMBERS_Product])' Member [Store].[*CTX_METRIC_MEMBER_SEL~MAX] as 'Max([*NATIVE_MEMBERS_Store])' Member [Measures].[*Unit Sales_SEL~MAX] as '([Measures].[Unit Sales],[Education Level].CurrentMember,[Product].[*CTX_METRIC_MEMBER_SEL~MAX],[Store].[*CTX_METRIC_MEMBER_SEL~MAX])' Select CrossJoin(Generate([*METRIC_CJ_SET], {([Store].CurrentMember)}),[*BASE_MEMBERS_Measures]) on columns, Non Empty Generate([*METRIC_CJ_SET], {([Education Level].CurrentMember,[Product].CurrentMember)}) on rows From [Sales]");
    }

    public void testCalculatedSlicerMember() {
        this.checkNative(20, 1, "With Set BM_PRODUCT as '{[Product].[All Products].[Drink]}' Set BM_EDU as '[Education Level].[Education Level].Members' Set BM_GENDER as '{[Gender].[Gender].[M]}' Set NECJ_SET as 'NonEmptyCrossJoin(BM_GENDER, NonEmptyCrossJoin(BM_EDU,BM_PRODUCT))' Set GM_PRODUCT as 'Generate(NECJ_SET, {[Product].CurrentMember})' Set GM_EDU as 'Generate(NECJ_SET, {[Education Level].CurrentMember})' Set GM_GENDER as 'Generate(NECJ_SET, {[Gender].CurrentMember})' Set GM_MEASURE as '{[Measures].[Unit Sales]}' Member [Education Level].FILTER1 as 'Aggregate(GM_EDU)' Member [Gender].FILTER2 as 'Aggregate(GM_GENDER)' Select GM_PRODUCT on rows, GM_MEASURE on columns From [Sales] Where ([Education Level].FILTER1, [Gender].FILTER2)");
    }

    public void testIndependentSlicerMemberNonNative() {
        this.checkIndependentSlicerMemberNative(false);
    }

    public void testIndependentSlicerMemberNative() {
        this.checkIndependentSlicerMemberNative(true);
    }

    private void checkIndependentSlicerMemberNative(boolean useNative) {
        String query = "with set [p] as '[Product].[Product Family].members' set [s] as '[Store].[Store Country].members' set [ne] as 'nonemptycrossjoin([p],[s])' set [nep] as 'Generate([ne],{[Product].CurrentMember})' select [nep] on columns from sales where ([Store].[Store Country].[Mexico])";
        String expectedResult = "Axis #0:\n{[Store].[All Stores].[Mexico]}\nAxis #1:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: \nRow #0: \nRow #0: \n";
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, useNative);
        Connection conn = this.getTestContext().getFoodMartConnection(false);
        TestContext context = this.getTestContext(conn);
        context.assertQueryReturns(query, NonEmptyTest.fold(expectedResult));
    }

    public void testDependentSlicerMemberNonNative() {
        String query = "with set [p] as '[Product].[Product Family].members' set [s] as '[Store].[Store Country].members' set [ne] as 'nonemptycrossjoin([p],[s])' set [nep] as 'Generate([ne],{[Product].CurrentMember})' select [nep] on columns from sales where ([Time].[1998])";
        String resultNonNative = "Axis #0:\n{[Time].[1998]}\nAxis #1:\n";
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, false);
        Connection conn = this.getTestContext().getFoodMartConnection(false);
        TestContext context = this.getTestContext(conn);
        context.assertQueryReturns(query, NonEmptyTest.fold(resultNonNative));
    }

    public void testDependentSlicerMemberNative() {
        String query = "with set [p] as '[Product].[Product Family].members' set [s] as '[Store].[Store Country].members' set [ne] as 'nonemptycrossjoin([p],[s])' set [nep] as 'Generate([ne],{[Product].CurrentMember})' select [nep] on columns from sales where ([Time].[1998])";
        String resultNative = "Axis #0:\n{[Time].[1998]}\nAxis #1:\n";
        this.propSaver.set(MondrianProperties.instance().EnableNativeCrossJoin, true);
        Connection conn = this.getTestContext().getFoodMartConnection(false);
        TestContext context = this.getTestContext(conn);
        context.assertQueryReturns(query, NonEmptyTest.fold(resultNative));
    }

    public void testBug1791609NonEmptyCrossJoinEliminatesCalcMember() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonEmptyLevelMembers() {
        boolean currentNativeNonEmpty = MondrianProperties.instance().EnableNativeNonEmpty.get();
        boolean currentNonEmptyOnAllAxis = MondrianProperties.instance().EnableNonEmptyOnAllAxis.get();
        try {
            MondrianProperties.instance().EnableNativeNonEmpty.set(false);
            MondrianProperties.instance().EnableNonEmptyOnAllAxis.set(true);
            this.assertQueryReturns("WITH MEMBER [Measures].[One] AS '1' SELECT NON EMPTY {[Measures].[One], [Measures].[Store Sales]} ON rows, NON EMPTY [Store].[Store State].MEMBERS on columns FROM sales", NonEmptyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[Canada].[BC]}\n{[Store].[All Stores].[Mexico].[DF]}\n{[Store].[All Stores].[Mexico].[Guerrero]}\n{[Store].[All Stores].[Mexico].[Jalisco]}\n{[Store].[All Stores].[Mexico].[Veracruz]}\n{[Store].[All Stores].[Mexico].[Yucatan]}\n{[Store].[All Stores].[Mexico].[Zacatecas]}\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nAxis #2:\n{[Measures].[One]}\n{[Measures].[Store Sales]}\nRow #0: 1\nRow #0: 1\nRow #0: 1\nRow #0: 1\nRow #0: 1\nRow #0: 1\nRow #0: 1\nRow #0: 1\nRow #0: 1\nRow #0: 1\nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: 159,167.84\nRow #1: 142,277.07\nRow #1: 263,793.22\n"));
        }
        finally {
            MondrianProperties.instance().EnableNativeNonEmpty.set(currentNativeNonEmpty);
            MondrianProperties.instance().EnableNonEmptyOnAllAxis.set(currentNonEmptyOnAllAxis);
        }
    }

    public void testNonEmptyResults() {
        this.assertQueryReturns("select NON EMPTY {[Measures].[Unit Sales], [Measures].[Store Cost]} ON columns, NON EMPTY Filter([Product].[Brand Name].Members, ([Measures].[Unit Sales] > 100000.0)) ON rows from [Sales] where [Time].[1997]", NonEmptyTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\nAxis #2:\n"));
    }

    private void checkNotNative(int rowCount, String mdx) {
        this.checkNotNative(rowCount, mdx, null);
    }

    private void checkNotNative(int rowCount, String mdx, String expectedResult) {
        String nonNativeResult;
        mdx = TestContext.instance().upgradeQuery(mdx);
        this.getConnection().getCacheControl(null).flushSchemaCache();
        Connection con = this.getTestContext().getFoodMartConnection(false);
        RolapNativeRegistry reg = this.getRegistry(con);
        reg.setListener(new RolapNative.Listener(){

            public void foundEvaluator(RolapNative.NativeEvent e) {
                Assert.fail((String)"should not be executed native");
            }

            public void foundInCache(RolapNative.TupleEvent e) {
            }

            public void excutingSql(RolapNative.TupleEvent e) {
            }
        });
        TestCase c = new TestCase(con, 0, rowCount, mdx);
        Result result = c.run();
        if (expectedResult != null && !(nonNativeResult = this.toString(result)).equals(expectedResult)) {
            TestContext.assertEqualsVerbose(expectedResult, nonNativeResult, false, "Non Native implementation returned different result than expected; MDX=" + mdx);
        }
    }

    RolapNativeRegistry getRegistry(Connection connection) {
        RolapCube cube = (RolapCube)connection.getSchema().lookupCube("Sales", true);
        RolapSchemaReader schemaReader = (RolapSchemaReader)cube.getSchemaReader();
        return schemaReader.getSchema().getNativeRegistry();
    }

    private void checkNative(int resultLimit, int rowCount, String mdx) {
        this.checkNative(resultLimit, rowCount, mdx, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNative(int resultLimit, int rowCount, String mdx, String expectedResult, boolean freshConnection) {
        if (MondrianProperties.instance().TestExpDependencies.get() > 0) {
            return;
        }
        mdx = TestContext.instance().upgradeQuery(mdx);
        this.getConnection().getCacheControl(null).flushSchemaCache();
        try {
            logger.debug((Object)("*** Native: " + mdx));
            boolean reuseConnection = !freshConnection;
            Connection con = this.getTestContext().getFoodMartConnection(reuseConnection);
            RolapNativeRegistry reg = this.getRegistry(con);
            reg.useHardCache(true);
            TestListener listener = new TestListener();
            reg.setListener(listener);
            reg.setEnabled(true);
            TestCase c = new TestCase(con, resultLimit, rowCount, mdx);
            Result result = c.run();
            String nativeResult = this.toString(result);
            if (!listener.isFoundEvaluator()) {
                NonEmptyTest.fail((String)("expected native execution of " + mdx));
            }
            if (!listener.isExecuteSql()) {
                NonEmptyTest.fail((String)"cache is empty: expected SQL query to be executed");
            }
            if (MondrianProperties.instance().EnableRolapCubeMemberCache.get()) {
                listener.setExecuteSql(false);
                c.run();
                if (listener.isExecuteSql()) {
                    NonEmptyTest.fail((String)"expected result from cache when query runs twice");
                }
            }
            con.close();
            logger.debug((Object)("*** Interpreter: " + mdx));
            this.getConnection().getCacheControl(null).flushSchemaCache();
            con = this.getTestContext().getFoodMartConnection(false);
            reg = this.getRegistry(con);
            listener.setFoundEvaluator(false);
            reg.setListener(listener);
            reg.setEnabled(false);
            result = this.executeQuery(mdx, con);
            String interpretedResult = this.toString(result);
            if (listener.isFoundEvaluator()) {
                NonEmptyTest.fail((String)("did not expect native executions of " + mdx));
            }
            if (expectedResult != null) {
                TestContext.assertEqualsVerbose(expectedResult, nativeResult, false, "Native implementation returned different result than expected; MDX=" + mdx);
                TestContext.assertEqualsVerbose(expectedResult, interpretedResult, false, "Interpreter implementation returned different result than expected; MDX=" + mdx);
            }
            if (!nativeResult.equals(interpretedResult)) {
                TestContext.assertEqualsVerbose(interpretedResult, nativeResult, false, "Native implementation returned different result than interpreter; MDX=" + mdx);
            }
        }
        finally {
            Connection con = this.getConnection();
            RolapNativeRegistry reg = this.getRegistry(con);
            reg.setEnabled(true);
            reg.useHardCache(false);
        }
    }

    Result executeQuery(String mdx, Connection connection) {
        Query query = connection.parseQuery(mdx);
        query.setResultStyle(ResultStyle.LIST);
        return connection.execute(query);
    }

    private String toString(Result r) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        r.print(pw);
        pw.close();
        return sw.toString();
    }

    void clearAndHardenCache(MemberCacheHelper helper) {
        helper.mapLevelToMembers.setCache(new HardSmartCache());
        helper.mapMemberToChildren.setCache(new HardSmartCache());
        helper.mapKeyToMember.clear();
    }

    SmartMemberReader getSmartMemberReader(String hierName) {
        Connection con = this.getTestContext().getFoodMartConnection();
        return this.getSmartMemberReader(con, hierName);
    }

    SmartMemberReader getSmartMemberReader(Connection con, String hierName) {
        RolapCube cube = (RolapCube)con.getSchema().lookupCube("Sales", true);
        RolapSchemaReader schemaReader = (RolapSchemaReader)cube.getSchemaReader();
        RolapHierarchy hierarchy = (RolapHierarchy)cube.lookupHierarchy(new Id.Segment(hierName, Id.Quoting.UNQUOTED), false);
        NonEmptyTest.assertNotNull((Object)hierarchy);
        return (SmartMemberReader)hierarchy.createMemberReader(schemaReader.getRole());
    }

    SmartMemberReader getSharedSmartMemberReader(String hierName) {
        Connection con = this.getTestContext().getFoodMartConnection();
        return this.getSharedSmartMemberReader(con, hierName);
    }

    SmartMemberReader getSharedSmartMemberReader(Connection con, String hierName) {
        RolapCube cube = (RolapCube)con.getSchema().lookupCube("Sales", true);
        RolapSchemaReader schemaReader = (RolapSchemaReader)cube.getSchemaReader();
        RolapCubeHierarchy hierarchy = (RolapCubeHierarchy)cube.lookupHierarchy(new Id.Segment(hierName, Id.Quoting.UNQUOTED), false);
        NonEmptyTest.assertNotNull((Object)hierarchy);
        return (SmartMemberReader)hierarchy.getRolapHierarchy().createMemberReader(schemaReader.getRole());
    }

    RolapEvaluator getEvaluator(Result res, int[] pos) {
        while (res instanceof RolapConnection.NonEmptyResult) {
            res = ((RolapConnection.NonEmptyResult)res).underlying;
        }
        return (RolapEvaluator)((RolapResult)res).getEvaluator(pos);
    }

    static class TestListener
    implements RolapNative.Listener {
        boolean foundEvaluator;
        boolean foundInCache;
        boolean executeSql;

        TestListener() {
        }

        boolean isExecuteSql() {
            return this.executeSql;
        }

        void setExecuteSql(boolean executeSql) {
            this.executeSql = executeSql;
        }

        boolean isFoundEvaluator() {
            return this.foundEvaluator;
        }

        void setFoundEvaluator(boolean foundEvaluator) {
            this.foundEvaluator = foundEvaluator;
        }

        boolean isFoundInCache() {
            return this.foundInCache;
        }

        void setFoundInCache(boolean foundInCache) {
            this.foundInCache = foundInCache;
        }

        public void foundEvaluator(RolapNative.NativeEvent e) {
            this.foundEvaluator = true;
        }

        public void foundInCache(RolapNative.TupleEvent e) {
            this.foundInCache = true;
        }

        public void excutingSql(RolapNative.TupleEvent e) {
            this.executeSql = true;
        }
    }

    class TestCase {
        int resultLimit;
        String query;
        int rowCount;
        Connection con;

        public TestCase(int resultLimit, int rowCount, String query) {
            this.con = NonEmptyTest.this.getConnection();
            this.resultLimit = resultLimit;
            this.rowCount = rowCount;
            this.query = query;
        }

        public TestCase(Connection con, int resultLimit, int rowCount, String query) {
            this.con = con;
            this.resultLimit = resultLimit;
            this.rowCount = rowCount;
            this.query = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Result run() {
            NonEmptyTest.this.getConnection().getCacheControl(null).flushSchemaCache();
            IntegerProperty monLimit = MondrianProperties.instance().ResultLimit;
            int oldLimit = monLimit.get();
            try {
                monLimit.set(this.resultLimit);
                Result result = NonEmptyTest.this.executeQuery(this.query, this.con);
                int numAxes = result.getAxes().length;
                Axis a = result.getAxes()[numAxes - 1];
                Assert.assertEquals((int)this.rowCount, (int)a.getPositions().size());
                Result result2 = result;
                return result2;
            }
            finally {
                monLimit.set(oldLimit);
            }
        }
    }
}

