/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.Result;
import mondrian.rolap.aggmatcher.AggTableTestCase;
import mondrian.test.TestContext;

public class RolapResultTest
extends AggTableTestCase {
    private static final String RolapResultTest = "RolapResultTest.csv";
    private static final String DIRECTORY = "testsrc/main/mondrian/rolap";
    private static final String RESULTS_ALL = mondrian.rolap.RolapResultTest.fold("Axis #0:\n{}\nAxis #1:\n{[D1].[All D1s].[a]}\n{[D1].[All D1s].[b]}\n{[D1].[All D1s].[c]}\nAxis #2:\n{[D2].[All D2s].[x]}\n{[D2].[All D2s].[y]}\n{[D2].[All D2s].[z]}\nRow #0: 5\nRow #0: \nRow #0: \nRow #1: \nRow #1: 10\nRow #1: \nRow #2: \nRow #2: \nRow #2: 15\n");
    private static final String RESULTS = mondrian.rolap.RolapResultTest.fold("Axis #0:\n{}\nAxis #1:\n{[D1].[a]}\n{[D1].[b]}\n{[D1].[c]}\nAxis #2:\n{[D2].[x]}\n{[D2].[y]}\n{[D2].[z]}\nRow #0: 5\nRow #0: \nRow #0: \nRow #1: \nRow #1: 10\nRow #1: \nRow #2: \nRow #2: \nRow #2: 15\n");

    public RolapResultTest() {
    }

    public RolapResultTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAll() throws Exception {
        if (!this.isApplicable()) {
            return;
        }
        String mdx = "select  filter({[D1].[a],[D1].[b],[D1].[c]},     [Measures].[Value] > 0)  ON COLUMNS,  {[D2].[x],[D2].[y],[D2].[z]}  ON ROWS from FTAll";
        this.getCubeTestContext().assertQueryReturns(mdx, RESULTS_ALL);
    }

    public void testD1() throws Exception {
        if (!this.isApplicable()) {
            return;
        }
        String mdx = "select  filter({[D1].[a],[D1].[b],[D1].[c]},     [Measures].[Value] > 0)  ON COLUMNS,  {[D2].[x],[D2].[y],[D2].[z]}  ON ROWS from FT1";
        Result result = this.getCubeTestContext().executeQuery(mdx);
        String resultString = TestContext.toString(result);
        mondrian.rolap.RolapResultTest.assertEquals((String)resultString, (String)RESULTS);
    }

    public void testD2() throws Exception {
        if (!this.isApplicable()) {
            return;
        }
        String mdx = "select  NON EMPTY filter({[D1].[a],[D1].[b],[D1].[c]},     [Measures].[Value] > 0)  ON COLUMNS,  {[D2].[x],[D2].[y],[D2].[z]}  ON ROWS from FT2";
        this.getCubeTestContext().assertQueryReturns(mdx, RESULTS);
    }

    public void _testNullDefaultMeasure() throws Exception {
        if (!this.isApplicable()) {
            return;
        }
        String mdx = "select  NON EMPTY filter({[D1].[a],[D1].[b],[D1].[c]},     [Measures].[Value] > 0)  ON COLUMNS,  {[D2].[x],[D2].[y],[D2].[z]}  ON ROWS from FT2Extra";
        Result result = this.getCubeTestContext().executeQuery(mdx);
        String resultString = TestContext.toString(result);
        mondrian.rolap.RolapResultTest.assertTrue((boolean)resultString.equals(RESULTS));
    }

    protected String getFileName() {
        return RolapResultTest;
    }

    protected String getDirectoryName() {
        return DIRECTORY;
    }

    protected String getCubeDescription() {
        return "<Cube name='FTAll'>\n<Table name='FT1' />\n<Dimension name='D1' foreignKey='d1_id' >\n <Hierarchy hasAll='true' primaryKey='d1_id'>\n <Table name='D1'/>\n <Level name='Name' column='name' type='String' uniqueMembers='true'/>\n </Hierarchy>\n</Dimension>\n<Dimension name='D2' foreignKey='d2_id' >\n <Hierarchy hasAll='true' primaryKey='d2_id'>\n <Table name='D2'/>\n <Level name='Name' column='name' type='String' uniqueMembers='true'/>\n </Hierarchy>\n</Dimension>\n<Measure name='Value' \n    column='value' aggregator='sum'\n   formatString='#,###'/>\n</Cube> \n<Cube name='FT1'>\n<Table name='FT1' />\n<Dimension name='D1' foreignKey='d1_id' >\n <Hierarchy hasAll='false' defaultMember='[D1].[d]' primaryKey='d1_id'>\n <Table name='D1'/>\n <Level name='Name' column='name' type='String' uniqueMembers='true'/>\n </Hierarchy>\n</Dimension>\n<Dimension name='D2' foreignKey='d2_id' >\n <Hierarchy hasAll='false' defaultMember='[D2].[w]' primaryKey='d2_id'>\n <Table name='D2'/>\n <Level name='Name' column='name' type='String' uniqueMembers='true'/>\n </Hierarchy>\n</Dimension>\n<Measure name='Value' \n    column='value' aggregator='sum'\n   formatString='#,###'/>\n</Cube> \n<Cube name='FT2'>\n<Table name='FT2'/>\n<Dimension name='D1' foreignKey='d1_id' >\n <Hierarchy hasAll='false' defaultMember='[D1].[d]' primaryKey='d1_id'>\n <Table name='D1'/>\n <Level name='Name' column='name' type='String' uniqueMembers='true'/>\n </Hierarchy>\n</Dimension>\n<Dimension name='D2' foreignKey='d2_id' >\n <Hierarchy hasAll='false' defaultMember='[D2].[w]' primaryKey='d2_id'>\n <Table name='D2'/>\n <Level name='Name' column='name' type='String' uniqueMembers='true'/>\n </Hierarchy>\n</Dimension>\n<Measure name='Value' \n    column='value' aggregator='sum'\n   formatString='#,###'/>\n</Cube>\n<Cube name='FT2Extra'>\n<Table name='FT2'/>\n<Dimension name='D1' foreignKey='d1_id' >\n <Hierarchy hasAll='false' defaultMember='[D1].[d]' primaryKey='d1_id'>\n <Table name='D1'/>\n <Level name='Name' column='name' type='String' uniqueMembers='true'/>\n </Hierarchy>\n</Dimension>\n<Dimension name='D2' foreignKey='d2_id' >\n <Hierarchy hasAll='false' defaultMember='[D2].[w]' primaryKey='d2_id'>\n <Table name='D2'/>\n <Level name='Name' column='name' type='String' uniqueMembers='true'/>\n </Hierarchy>\n</Dimension>\n<Measure name='VExtra' \n    column='vextra' aggregator='sum'\n   formatString='#,###'/>\n<Measure name='Value' \n    column='value' aggregator='sum'\n   formatString='#,###'/>\n</Cube>";
    }

    public void testNonAllPromotionMembers() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Promotions2\" foreignKey=\"promotion_id\">\n  <Hierarchy hasAll=\"false\" primaryKey=\"promotion_id\">\n    <Table name=\"promotion\"/>\n    <Level name=\"Promotion2 Name\" column=\"promotion_name\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>");
        testContext.assertQueryReturns("select {[Promotion2 Name].[Price Winners], [Promotion2 Name].[Sale Winners]} * {Tail([Time].[Year].Members,3)} ON COLUMNS, NON EMPTY Crossjoin({[Store].CurrentMember.Children},  {[Store Type].[All Store Types].Children}) ON ROWS from [Sales]", mondrian.rolap.RolapResultTest.fold("Axis #0:\n{}\nAxis #1:\n{[Promotions2].[Price Winners], [Time].[1997]}\n{[Promotions2].[Price Winners], [Time].[1998]}\n{[Promotions2].[Sale Winners], [Time].[1997]}\n{[Promotions2].[Sale Winners], [Time].[1998]}\nAxis #2:\n{[Store].[All Stores].[USA], [Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Store].[All Stores].[USA], [Store Type].[All Store Types].[Small Grocery]}\n{[Store].[All Stores].[USA], [Store Type].[All Store Types].[Supermarket]}\nRow #0: \nRow #0: \nRow #0: 444\nRow #0: \nRow #1: 23\nRow #1: \nRow #1: \nRow #1: \nRow #2: 1,271\nRow #2: \nRow #2: \nRow #2: \n"));
    }
}

