/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import mondrian.olap.MondrianProperties;
import mondrian.test.ConcurrentValidatingQueryRunner;
import mondrian.test.FoodMartTestCase;

public class ConcurrentMdxTest
extends FoodMartTestCase {
    private MondrianProperties props;
    static final FoodMartTestCase.QueryAndResult[] mdxQueries = new FoodMartTestCase.QueryAndResult[]{new FoodMartTestCase.QueryAndResult("select {[Measures].[Sales Count]} on 0 from [Sales] ", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\nRow #0: 86,837\n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Store Cost]} on 0 from [Sales] ", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Cost]}\nRow #0: 225,627.23\n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Sales Count], [Measures].[Store Invoice]} on 0 from [Warehouse and Sales]", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\n{[Measures].[Store Invoice]}\nRow #0: 86,837\nRow #0: 102,278.409\n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Sales Count], [Measures].[Store Invoice]} on 0 from [Warehouse and Sales]", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\n{[Measures].[Store Invoice]}\nRow #0: 86,837\nRow #0: 102,278.409\n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Sales Count], [Measures].[Store Invoice]} on 0, {[Time].[1997],[Time].[1998]} on 1 from [Warehouse and Sales]", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\n{[Measures].[Store Invoice]}\nAxis #2:\n{[Time].[1997]}\n{[Time].[1998]}\nRow #0: 86,837\nRow #0: 102,278.409\nRow #1: \nRow #1: \n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Sales Count], [Measures].[Store Invoice]} on 0, {([Gender].[M],[Time].[1997])} on 1 from [Warehouse and Sales]", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\n{[Measures].[Store Invoice]}\nAxis #2:\n{[Gender].[All Gender].[M], [Time].[1997]}\nRow #0: 44,006\nRow #0: \n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Sales Count], [Measures].[Store Invoice]} on 0, {([Gender].[F],[Time].[1997])} on 1 from [Warehouse and Sales]", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\n{[Measures].[Store Invoice]}\nAxis #2:\n{[Gender].[All Gender].[F], [Time].[1997]}\nRow #0: 42,831\nRow #0: \n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Store Cost], [Measures].[Supply Time]} on 0 from [Warehouse and Sales]", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Cost]}\n{[Measures].[Supply Time]}\nRow #0: 225,627.23\nRow #0: 10,425\n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Store Sales], [Measures].[Units Ordered]} on 0 from [Warehouse and Sales]", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\n{[Measures].[Units Ordered]}\nRow #0: 565,238.13\nRow #0: 227238.0\n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Unit Sales], [Measures].[Units Ordered]} on 0 from [Warehouse and Sales]", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Units Ordered]}\nRow #0: 266,773\nRow #0: 227238.0\n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Profit], [Measures].[Units Shipped]} on 0 from [Warehouse and Sales]", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Profit]}\n{[Measures].[Units Shipped]}\nRow #0: $339,610.90\nRow #0: 207726.0\n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Unit Sales]} on columns" + nl + " from Sales", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nRow #0: 266,773\n"), new FoodMartTestCase.QueryAndResult("select " + nl + "{[Measures].[Unit Sales]} on columns," + nl + "order(except([Promotion Media].[Media Type].members," + "{[Promotion Media].[Media Type].[No Media]})," + "[Measures].[Unit Sales],DESC) on rows" + nl + "from Sales", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Promotion Media].[All Media].[Daily Paper, Radio, TV]}\n{[Promotion Media].[All Media].[Daily Paper]}\n{[Promotion Media].[All Media].[Product Attachment]}\n{[Promotion Media].[All Media].[Daily Paper, Radio]}\n{[Promotion Media].[All Media].[Cash Register Handout]}\n{[Promotion Media].[All Media].[Sunday Paper, Radio]}\n{[Promotion Media].[All Media].[Street Handout]}\n{[Promotion Media].[All Media].[Sunday Paper]}\n{[Promotion Media].[All Media].[Bulk Mail]}\n{[Promotion Media].[All Media].[In-Store Coupon]}\n{[Promotion Media].[All Media].[TV]}\n{[Promotion Media].[All Media].[Sunday Paper, Radio, TV]}\n{[Promotion Media].[All Media].[Radio]}\nRow #0: 9,513\nRow #1: 7,738\nRow #2: 7,544\nRow #3: 6,891\nRow #4: 6,697\nRow #5: 5,945\nRow #6: 5,753\nRow #7: 4,339\nRow #8: 4,320\nRow #9: 3,798\nRow #10: 3,607\nRow #11: 2,726\nRow #12: 2,454\n"), new FoodMartTestCase.QueryAndResult("select" + nl + "{ [Measures].[Units Shipped], [Measures].[Units Ordered] }" + " on columns," + nl + "NON EMPTY [Store].[Store Name].members on rows" + nl + "from Warehouse", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Units Shipped]}\n{[Measures].[Units Ordered]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}\n{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\nRow #0: 10759.0\nRow #0: 11699.0\nRow #1: 24587.0\nRow #1: 26463.0\nRow #2: 23835.0\nRow #2: 26270.0\nRow #3: 1696.0\nRow #3: 1875.0\nRow #4: 8515.0\nRow #4: 9109.0\nRow #5: 32393.0\nRow #5: 35797.0\nRow #6: 2348.0\nRow #6: 2454.0\nRow #7: 22734.0\nRow #7: 24610.0\nRow #8: 24110.0\nRow #8: 26703.0\nRow #9: 11889.0\nRow #9: 12828.0\nRow #10: 32411.0\nRow #10: 35930.0\nRow #11: 1860.0\nRow #11: 2074.0\nRow #12: 10589.0\nRow #12: 11426.0\n"), new FoodMartTestCase.QueryAndResult("with member [Measures].[Store Sales Last Period] as '([Measures].[Store Sales], Time.PrevMember)'" + nl + "select" + nl + " {[Measures].[Store Sales Last Period]} on columns," + nl + " {TopCount([Product].[Product Department].members,5," + " [Measures].[Store Sales Last Period])} on rows" + nl + "from Sales" + nl + "where ([Time].[1998])", "Axis #0:\n{[Time].[1998]}\nAxis #1:\n{[Measures].[Store Sales Last Period]}\nAxis #2:\n{[Product].[All Products].[Food].[Produce]}\n{[Product].[All Products].[Food].[Snack Foods]}\n{[Product].[All Products].[Non-Consumable].[Household]}\n{[Product].[All Products].[Food].[Frozen Foods]}\n{[Product].[All Products].[Food].[Canned Foods]}\nRow #0: 82,248.42\nRow #1: 67,609.82\nRow #2: 60,469.89\nRow #3: 55,207.50\nRow #4: 39,774.34\n"), new FoodMartTestCase.QueryAndResult("with member [Measures].[Total Store Sales] as'Sum(YTD(),[Measures].[Store Sales])'" + nl + "select" + nl + "{[Measures].[Total Store Sales]} on columns," + nl + "{TopCount([Product].[Product Department].members,5," + "[Measures].[Total Store Sales])} on rows" + nl + "from Sales" + nl + "where ([Time].[1997].[Q2].[4])", "Axis #0:\n{[Time].[1997].[Q2].[4]}\nAxis #1:\n{[Measures].[Total Store Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Produce]}\n{[Product].[All Products].[Food].[Snack Foods]}\n{[Product].[All Products].[Non-Consumable].[Household]}\n{[Product].[All Products].[Food].[Frozen Foods]}\n{[Product].[All Products].[Food].[Canned Foods]}\nRow #0: 26,526.67\nRow #1: 21,897.10\nRow #2: 19,980.90\nRow #3: 17,882.63\nRow #4: 12,963.23\n"), new FoodMartTestCase.QueryAndResult("with member [Measures].[Store Profit Rate] as'([Measures].[Store Sales]-[Measures].[Store Cost])/[Measures].[Store Cost]', format = '#.00%'" + nl + "select" + nl + "    {[Measures].[Store Cost],[Measures].[Store Sales]," + "[Measures].[Store Profit Rate]} on columns," + nl + "    Order([Product].[Product Department].members, " + "[Measures].[Store Profit Rate], BDESC) on rows" + nl + "from Sales" + nl + "where ([Time].[1997])", "Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\n{[Measures].[Store Profit Rate]}\nAxis #2:\n{[Product].[All Products].[Food].[Breakfast Foods]}\n{[Product].[All Products].[Non-Consumable].[Carousel]}\n{[Product].[All Products].[Food].[Canned Products]}\n{[Product].[All Products].[Food].[Baking Goods]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Product].[All Products].[Non-Consumable].[Health and Hygiene]}\n{[Product].[All Products].[Food].[Snack Foods]}\n{[Product].[All Products].[Food].[Baked Goods]}\n{[Product].[All Products].[Drink].[Beverages]}\n{[Product].[All Products].[Food].[Frozen Foods]}\n{[Product].[All Products].[Non-Consumable].[Periodicals]}\n{[Product].[All Products].[Food].[Produce]}\n{[Product].[All Products].[Food].[Seafood]}\n{[Product].[All Products].[Food].[Deli]}\n{[Product].[All Products].[Food].[Meat]}\n{[Product].[All Products].[Food].[Canned Foods]}\n{[Product].[All Products].[Non-Consumable].[Household]}\n{[Product].[All Products].[Food].[Starchy Foods]}\n{[Product].[All Products].[Food].[Eggs]}\n{[Product].[All Products].[Food].[Snacks]}\n{[Product].[All Products].[Food].[Dairy]}\n{[Product].[All Products].[Drink].[Dairy]}\n{[Product].[All Products].[Non-Consumable].[Checkout]}\nRow #0: 2,756.80\nRow #0: 6,941.46\nRow #0: 151.79%\nRow #1: 595.97\nRow #1: 1,500.11\nRow #1: 151.71%\nRow #2: 1,317.13\nRow #2: 3,314.52\nRow #2: 151.65%\nRow #3: 15,370.61\nRow #3: 38,670.41\nRow #3: 151.59%\nRow #4: 5,576.79\nRow #4: 14,029.08\nRow #4: 151.56%\nRow #5: 12,972.99\nRow #5: 32,571.86\nRow #5: 151.07%\nRow #6: 26,963.34\nRow #6: 67,609.82\nRow #6: 150.75%\nRow #7: 6,564.09\nRow #7: 16,455.43\nRow #7: 150.69%\nRow #8: 11,069.53\nRow #8: 27,748.53\nRow #8: 150.67%\nRow #9: 22,030.66\nRow #9: 55,207.50\nRow #9: 150.59%\nRow #10: 3,614.55\nRow #10: 9,056.76\nRow #10: 150.56%\nRow #11: 32,831.33\nRow #11: 82,248.42\nRow #11: 150.52%\nRow #12: 1,520.70\nRow #12: 3,809.14\nRow #12: 150.49%\nRow #13: 10,108.87\nRow #13: 25,318.93\nRow #13: 150.46%\nRow #14: 1,465.42\nRow #14: 3,669.89\nRow #14: 150.43%\nRow #15: 15,894.53\nRow #15: 39,774.34\nRow #15: 150.24%\nRow #16: 24,170.73\nRow #16: 60,469.89\nRow #16: 150.18%\nRow #17: 4,705.91\nRow #17: 11,756.07\nRow #17: 149.82%\nRow #18: 3,684.90\nRow #18: 9,200.76\nRow #18: 149.69%\nRow #19: 5,827.58\nRow #19: 14,550.05\nRow #19: 149.68%\nRow #20: 12,228.85\nRow #20: 30,508.85\nRow #20: 149.48%\nRow #21: 2,830.92\nRow #21: 7,058.60\nRow #21: 149.34%\nRow #22: 1,525.04\nRow #22: 3,767.71\nRow #22: 147.06%\n"), new FoodMartTestCase.QueryAndResult("with" + nl + "   member [Product].[All Products].[Drink].[Percent of Alcoholic Drinks]" + " as '[Product].[All Products].[Drink].[Alcoholic Beverages]/" + "[Product].[All Products].[Drink]', format = '#.00%'" + nl + "select" + nl + "   { [Product].[All Products].[Drink].[Percent of Alcoholic Drinks] }" + " on columns," + nl + "   order([Customers].[All Customers].[USA].[WA].Children," + " [Product].[All Products].[Drink].[Percent of Alcoholic Drinks],BDESC)" + " on rows" + nl + "from Sales" + nl + "where ([Measures].[Unit Sales])", "Axis #0:\n{[Measures].[Unit Sales]}\nAxis #1:\n{[Product].[All Products].[Drink].[Percent of Alcoholic Drinks]}\nAxis #2:\n{[Customers].[All Customers].[USA].[WA].[Seattle]}\n{[Customers].[All Customers].[USA].[WA].[Kirkland]}\n{[Customers].[All Customers].[USA].[WA].[Marysville]}\n{[Customers].[All Customers].[USA].[WA].[Anacortes]}\n{[Customers].[All Customers].[USA].[WA].[Olympia]}\n{[Customers].[All Customers].[USA].[WA].[Ballard]}\n{[Customers].[All Customers].[USA].[WA].[Bremerton]}\n{[Customers].[All Customers].[USA].[WA].[Puyallup]}\n{[Customers].[All Customers].[USA].[WA].[Yakima]}\n{[Customers].[All Customers].[USA].[WA].[Tacoma]}\n{[Customers].[All Customers].[USA].[WA].[Everett]}\n{[Customers].[All Customers].[USA].[WA].[Renton]}\n{[Customers].[All Customers].[USA].[WA].[Issaquah]}\n{[Customers].[All Customers].[USA].[WA].[Bellingham]}\n{[Customers].[All Customers].[USA].[WA].[Port Orchard]}\n{[Customers].[All Customers].[USA].[WA].[Redmond]}\n{[Customers].[All Customers].[USA].[WA].[Spokane]}\n{[Customers].[All Customers].[USA].[WA].[Burien]}\n{[Customers].[All Customers].[USA].[WA].[Lynnwood]}\n{[Customers].[All Customers].[USA].[WA].[Walla Walla]}\n{[Customers].[All Customers].[USA].[WA].[Edmonds]}\n{[Customers].[All Customers].[USA].[WA].[Sedro Woolley]}\nRow #0: 44.05%\nRow #1: 34.41%\nRow #2: 34.20%\nRow #3: 32.93%\nRow #4: 31.05%\nRow #5: 30.84%\nRow #6: 30.69%\nRow #7: 29.81%\nRow #8: 28.82%\nRow #9: 28.70%\nRow #10: 28.37%\nRow #11: 26.67%\nRow #12: 26.60%\nRow #13: 26.47%\nRow #14: 26.42%\nRow #15: 26.28%\nRow #16: 25.96%\nRow #17: 24.70%\nRow #18: 21.89%\nRow #19: 21.47%\nRow #20: 17.47%\nRow #21: 13.79%\n"), new FoodMartTestCase.QueryAndResult("with member [Measures].[Accumulated Sales] as 'Sum(YTD(),[Measures].[Store Sales])'" + nl + "select" + nl + "    {[Measures].[Store Sales],[Measures].[Accumulated Sales]}" + " on columns," + nl + "    {Descendants([Time].[1997],[Time].[Month])} on rows" + nl + "from Sales", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\n{[Measures].[Accumulated Sales]}\nAxis #2:\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2].[5]}\n{[Time].[1997].[Q2].[6]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997].[Q3].[8]}\n{[Time].[1997].[Q3].[9]}\n{[Time].[1997].[Q4].[10]}\n{[Time].[1997].[Q4].[11]}\n{[Time].[1997].[Q4].[12]}\nRow #0: 45,539.69\nRow #0: 45,539.69\nRow #1: 44,058.79\nRow #1: 89,598.48\nRow #2: 50,029.87\nRow #2: 139,628.35\nRow #3: 42,878.25\nRow #3: 182,506.60\nRow #4: 44,456.29\nRow #4: 226,962.89\nRow #5: 45,331.73\nRow #5: 272,294.62\nRow #6: 50,246.88\nRow #6: 322,541.50\nRow #7: 46,199.04\nRow #7: 368,740.54\nRow #8: 43,825.97\nRow #8: 412,566.51\nRow #9: 42,342.27\nRow #9: 454,908.78\nRow #10: 53,363.71\nRow #10: 508,272.49\nRow #11: 56,965.64\nRow #11: 565,238.13\n"), new FoodMartTestCase.QueryAndResult("select" + nl + " {[Measures].[Unit Sales]} on columns," + nl + " [Gender].members on rows" + nl + "from Sales", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender]}\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 266,773\nRow #1: 131,558\nRow #2: 135,215\n"), new FoodMartTestCase.QueryAndResult("WITH" + nl + "   MEMBER [Measures].[StoreType] AS " + nl + "   '[Store].CurrentMember.Properties(\"Store Type\")'," + nl + "   SOLVE_ORDER = 2" + nl + "   MEMBER [Measures].[ProfitPct] AS " + nl + "   '((Measures.[Store Sales] - Measures.[Store Cost]) /" + " Measures.[Store Sales])'," + nl + "   SOLVE_ORDER = 1, FORMAT_STRING = 'Percent'" + nl + "SELECT non empty" + nl + "   { [Store].[Store Name].Members} ON COLUMNS," + nl + "   { [Measures].[Store Sales], [Measures].[Store Cost]," + " [Measures].[StoreType]," + nl + "   [Measures].[ProfitPct] } ON ROWS" + nl + "FROM Sales", "Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}\n{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\nAxis #2:\n{[Measures].[Store Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[StoreType]}\n{[Measures].[ProfitPct]}\nRow #0: 45,750.24\nRow #0: 54,545.28\nRow #0: 54,431.14\nRow #0: 4,441.18\nRow #0: 55,058.79\nRow #0: 87,218.28\nRow #0: 4,739.23\nRow #0: 52,896.30\nRow #0: 52,644.07\nRow #0: 49,634.46\nRow #0: 74,843.96\nRow #0: 4,705.97\nRow #0: 24,329.23\nRow #1: 18,266.44\nRow #1: 21,771.54\nRow #1: 21,713.53\nRow #1: 1,778.92\nRow #1: 21,948.94\nRow #1: 34,823.56\nRow #1: 1,896.62\nRow #1: 21,121.96\nRow #1: 20,956.80\nRow #1: 19,795.49\nRow #1: 29,959.28\nRow #1: 1,880.34\nRow #1: 9,713.81\nRow #2: Gourmet Supermarket\nRow #2: Supermarket\nRow #2: Supermarket\nRow #2: Small Grocery\nRow #2: Supermarket\nRow #2: Deluxe Supermarket\nRow #2: Small Grocery\nRow #2: Supermarket\nRow #2: Supermarket\nRow #2: Supermarket\nRow #2: Deluxe Supermarket\nRow #2: Small Grocery\nRow #2: Mid-Size Grocery\nRow #3: 60.07%\nRow #3: 60.09%\nRow #3: 60.11%\nRow #3: 59.94%\nRow #3: 60.14%\nRow #3: 60.07%\nRow #3: 59.98%\nRow #3: 60.07%\nRow #3: 60.19%\nRow #3: 60.12%\nRow #3: 59.97%\nRow #3: 60.04%\nRow #3: 60.07%\n"), new FoodMartTestCase.QueryAndResult("WITH" + nl + "   MEMBER [Product].[All Products].[Drink].[Alcoholic Beverages]" + ".[Beer and Wine].[BigSeller] AS" + nl + "  'IIf([Product].[All Products].[Drink].[Alcoholic Beverages]" + ".[Beer and Wine] > 100, \"Yes\",\"No\")'" + nl + "SELECT" + nl + "   {[Product].[All Products].[Drink].[Alcoholic Beverages]" + ".[Beer and Wine].[BigSeller]} ON COLUMNS," + nl + "   {Store.[Store Name].Members} ON ROWS" + nl + "FROM Sales", "Axis #0:\n{}\nAxis #1:\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[BigSeller]}\nAxis #2:\n{[Store].[All Stores].[Canada].[BC].[Vancouver].[Store 19]}\n{[Store].[All Stores].[Canada].[BC].[Victoria].[Store 20]}\n{[Store].[All Stores].[Mexico].[DF].[Mexico City].[Store 9]}\n{[Store].[All Stores].[Mexico].[DF].[San Andres].[Store 21]}\n{[Store].[All Stores].[Mexico].[Guerrero].[Acapulco].[Store 1]}\n{[Store].[All Stores].[Mexico].[Jalisco].[Guadalajara].[Store 5]}\n{[Store].[All Stores].[Mexico].[Veracruz].[Orizaba].[Store 10]}\n{[Store].[All Stores].[Mexico].[Yucatan].[Merida].[Store 8]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Camacho].[Store 4]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo].[Store 12]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo].[Store 18]}\n{[Store].[All Stores].[USA].[CA].[Alameda].[HQ]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}\n{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\nRow #0: No\nRow #1: No\nRow #2: No\nRow #3: No\nRow #4: No\nRow #5: No\nRow #6: No\nRow #7: No\nRow #8: No\nRow #9: No\nRow #10: No\nRow #11: No\nRow #12: Yes\nRow #13: Yes\nRow #14: Yes\nRow #15: No\nRow #16: Yes\nRow #17: Yes\nRow #18: No\nRow #19: Yes\nRow #20: Yes\nRow #21: Yes\nRow #22: Yes\nRow #23: No\nRow #24: Yes\n"), new FoodMartTestCase.QueryAndResult("WITH" + nl + "   MEMBER [Measures].[ProfitPct] AS " + nl + "   '((Measures.[Store Sales] - Measures.[Store Cost]) /" + " Measures.[Store Sales])'," + nl + "   SOLVE_ORDER = 1, FORMAT_STRING = 'Percent'" + nl + "   MEMBER [Measures].[ProfitValue] AS " + nl + "   '[Measures].[Store Sales] * [Measures].[ProfitPct]'," + nl + "   SOLVE_ORDER = 2, FORMAT_STRING = 'Currency'" + nl + "SELECT non empty " + nl + "   { [Store].[Store Name].Members} ON COLUMNS," + nl + "   { [Measures].[Store Sales], [Measures].[Store Cost]," + " [Measures].[ProfitValue]," + nl + "   [Measures].[ProfitPct] } ON ROWS" + nl + "FROM Sales", "Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}\n{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\nAxis #2:\n{[Measures].[Store Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[ProfitValue]}\n{[Measures].[ProfitPct]}\nRow #0: 45,750.24\nRow #0: 54,545.28\nRow #0: 54,431.14\nRow #0: 4,441.18\nRow #0: 55,058.79\nRow #0: 87,218.28\nRow #0: 4,739.23\nRow #0: 52,896.30\nRow #0: 52,644.07\nRow #0: 49,634.46\nRow #0: 74,843.96\nRow #0: 4,705.97\nRow #0: 24,329.23\nRow #1: 18,266.44\nRow #1: 21,771.54\nRow #1: 21,713.53\nRow #1: 1,778.92\nRow #1: 21,948.94\nRow #1: 34,823.56\nRow #1: 1,896.62\nRow #1: 21,121.96\nRow #1: 20,956.80\nRow #1: 19,795.49\nRow #1: 29,959.28\nRow #1: 1,880.34\nRow #1: 9,713.81\nRow #2: $27,483.80\nRow #2: $32,773.74\nRow #2: $32,717.61\nRow #2: $2,662.26\nRow #2: $33,109.85\nRow #2: $52,394.72\nRow #2: $2,842.61\nRow #2: $31,774.34\nRow #2: $31,687.27\nRow #2: $29,838.97\nRow #2: $44,884.68\nRow #2: $2,825.63\nRow #2: $14,615.42\nRow #3: 60.07%\nRow #3: 60.09%\nRow #3: 60.11%\nRow #3: 59.94%\nRow #3: 60.14%\nRow #3: 60.07%\nRow #3: 59.98%\nRow #3: 60.07%\nRow #3: 60.19%\nRow #3: 60.12%\nRow #3: 59.97%\nRow #3: 60.04%\nRow #3: 60.07%\n"), new FoodMartTestCase.QueryAndResult("WITH MEMBER MEASURES.ProfitPercent AS" + nl + "     '([Measures].[Store Sales]-[Measures].[Store Cost])/" + "([Measures].[Store Cost])'," + nl + " FORMAT_STRING = '#.00%', SOLVE_ORDER = 1" + nl + " MEMBER [Time].[First Half 97] AS  '[Time].[1997].[Q1] +" + " [Time].[1997].[Q2]'" + nl + " MEMBER [Time].[Second Half 97] AS '[Time].[1997].[Q3] +" + " [Time].[1997].[Q4]'" + nl + " SELECT {[Time].[First Half 97]," + nl + "     [Time].[Second Half 97]," + nl + "     [Time].[1997].CHILDREN} ON COLUMNS," + nl + " {[Store].[Store Country].[USA].CHILDREN} ON ROWS" + nl + " FROM [Sales]" + nl + " WHERE ([Measures].[ProfitPercent])", "Axis #0:\n{[Measures].[ProfitPercent]}\nAxis #1:\n{[Time].[First Half 97]}\n{[Time].[Second Half 97]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q3]}\n{[Time].[1997].[Q4]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 150.55%\nRow #0: 150.53%\nRow #0: 150.68%\nRow #0: 150.44%\nRow #0: 151.35%\nRow #0: 149.81%\nRow #1: 150.15%\nRow #1: 151.08%\nRow #1: 149.80%\nRow #1: 150.60%\nRow #1: 151.37%\nRow #1: 150.78%\nRow #2: 150.59%\nRow #2: 150.34%\nRow #2: 150.72%\nRow #2: 150.45%\nRow #2: 150.39%\nRow #2: 150.29%\n"), new FoodMartTestCase.QueryAndResult("with member [Measures].[Accumulated Sales] as 'Sum(YTD(),[Measures].[Store Sales])'" + nl + "select" + nl + "    {[Measures].[Store Sales],[Measures].[Accumulated Sales]}" + " on columns," + nl + "    {Descendants([Time].[1997],[Time].[Month])} on rows" + nl + "from [Warehouse and Sales]", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\n{[Measures].[Accumulated Sales]}\nAxis #2:\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2].[5]}\n{[Time].[1997].[Q2].[6]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997].[Q3].[8]}\n{[Time].[1997].[Q3].[9]}\n{[Time].[1997].[Q4].[10]}\n{[Time].[1997].[Q4].[11]}\n{[Time].[1997].[Q4].[12]}\nRow #0: 45,539.69\nRow #0: 45,539.69\nRow #1: 44,058.79\nRow #1: 89,598.48\nRow #2: 50,029.87\nRow #2: 139,628.35\nRow #3: 42,878.25\nRow #3: 182,506.60\nRow #4: 44,456.29\nRow #4: 226,962.89\nRow #5: 45,331.73\nRow #5: 272,294.62\nRow #6: 50,246.88\nRow #6: 322,541.50\nRow #7: 46,199.04\nRow #7: 368,740.54\nRow #8: 43,825.97\nRow #8: 412,566.51\nRow #9: 42,342.27\nRow #9: 454,908.78\nRow #10: 53,363.71\nRow #10: 508,272.49\nRow #11: 56,965.64\nRow #11: 565,238.13\n"), new FoodMartTestCase.QueryAndResult("select non empty CrossJoin(\r\n  {[Warehouse].DefaultMember, [Warehouse].[USA].children}," + nl + " {[Measures].[Unit Sales], [Measures].[Units Shipped]}) on" + " columns," + nl + " [Time].children on rows" + nl + "from [Warehouse and Sales]", "Axis #0:\n{}\nAxis #1:\n{[Warehouse].[All Warehouses], [Measures].[Unit Sales]}\n{[Warehouse].[All Warehouses], [Measures].[Units Shipped]}\n{[Warehouse].[All Warehouses].[USA].[CA], [Measures].[Units Shipped]}\n{[Warehouse].[All Warehouses].[USA].[OR], [Measures].[Units Shipped]}\n{[Warehouse].[All Warehouses].[USA].[WA], [Measures].[Units Shipped]}\nAxis #2:\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q3]}\n{[Time].[1997].[Q4]}\nRow #0: 66,291\nRow #0: 50951.0\nRow #0: 8539.0\nRow #0: 7994.0\nRow #0: 34418.0\nRow #1: 62,610\nRow #1: 49187.0\nRow #1: 15726.0\nRow #1: 7575.0\nRow #1: 25886.0\nRow #2: 65,848\nRow #2: 57789.0\nRow #2: 20821.0\nRow #2: 8673.0\nRow #2: 28295.0\nRow #3: 72,024\nRow #3: 49799.0\nRow #3: 15791.0\nRow #3: 16666.0\nRow #3: 17342.0\n"), new FoodMartTestCase.QueryAndResult("select {[Measures].[Unit Sales]} on columns," + nl + " {[Store], [Store].children} on rows" + nl + "from [Sales]", "Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores]}\n{[Store].[All Stores].[Canada]}\n{[Store].[All Stores].[Mexico]}\n{[Store].[All Stores].[USA]}\nRow #0: 266,773\nRow #1: \nRow #2: \nRow #3: 266,773\n"), new FoodMartTestCase.QueryAndResult("select" + nl + "  CrossJoin(" + nl + "    {[Measures].[Unit Sales], [Measures].[Store Sales]}," + nl + "    {[Time].[1997].[Q2].children}) on columns, " + nl + "  CrossJoin(" + nl + "    CrossJoin(" + nl + "      [Gender].members," + nl + "      [Marital Status].members)," + nl + "   {[Store], [Store].children}) on rows" + nl + "from [Sales]" + nl + "where (" + nl + " [Product].[Food]," + nl + " [Education Level].[High School Degree]," + nl + " [Promotions].DefaultMember)", "Axis #0:\n{[Product].[All Products].[Food], [Education Level].[All Education Levels].[High School Degree], [Promotions].[All Promotions]}\nAxis #1:\n{[Measures].[Unit Sales], [Time].[1997].[Q2].[4]}\n{[Measures].[Unit Sales], [Time].[1997].[Q2].[5]}\n{[Measures].[Unit Sales], [Time].[1997].[Q2].[6]}\n{[Measures].[Store Sales], [Time].[1997].[Q2].[4]}\n{[Measures].[Store Sales], [Time].[1997].[Q2].[5]}\n{[Measures].[Store Sales], [Time].[1997].[Q2].[6]}\nAxis #2:\n{[Gender].[All Gender], [Marital Status].[All Marital Status], [Store].[All Stores]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status], [Store].[All Stores].[USA]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[M], [Store].[All Stores]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[USA]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[S], [Store].[All Stores]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status], [Store].[All Stores]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Store].[All Stores]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S], [Store].[All Stores]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status], [Store].[All Stores]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M], [Store].[All Stores]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Store].[All Stores]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[USA]}\nRow #0: 4,284\nRow #0: 3,972\nRow #0: 4,476\nRow #0: 9,014.60\nRow #0: 8,595.99\nRow #0: 9,480.21\nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #3: 4,284\nRow #3: 3,972\nRow #3: 4,476\nRow #3: 9,014.60\nRow #3: 8,595.99\nRow #3: 9,480.21\nRow #4: 1,942\nRow #4: 1,843\nRow #4: 2,128\nRow #4: 4,133.87\nRow #4: 4,007.53\nRow #4: 4,541.97\nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #7: 1,942\nRow #7: 1,843\nRow #7: 2,128\nRow #7: 4,133.87\nRow #7: 4,007.53\nRow #7: 4,541.97\nRow #8: 2,342\nRow #8: 2,129\nRow #8: 2,348\nRow #8: 4,880.73\nRow #8: 4,588.46\nRow #8: 4,938.24\nRow #9: \nRow #9: \nRow #9: \nRow #9: \nRow #9: \nRow #9: \nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #11: 2,342\nRow #11: 2,129\nRow #11: 2,348\nRow #11: 4,880.73\nRow #11: 4,588.46\nRow #11: 4,938.24\nRow #12: 2,093\nRow #12: 1,981\nRow #12: 1,918\nRow #12: 4,380.67\nRow #12: 4,338.31\nRow #12: 4,130.34\nRow #13: \nRow #13: \nRow #13: \nRow #13: \nRow #13: \nRow #13: \nRow #14: \nRow #14: \nRow #14: \nRow #14: \nRow #14: \nRow #14: \nRow #15: 2,093\nRow #15: 1,981\nRow #15: 1,918\nRow #15: 4,380.67\nRow #15: 4,338.31\nRow #15: 4,130.34\nRow #16: 901\nRow #16: 942\nRow #16: 837\nRow #16: 1,905.00\nRow #16: 2,069.44\nRow #16: 1,865.44\nRow #17: \nRow #17: \nRow #17: \nRow #17: \nRow #17: \nRow #17: \nRow #18: \nRow #18: \nRow #18: \nRow #18: \nRow #18: \nRow #18: \nRow #19: 901\nRow #19: 942\nRow #19: 837\nRow #19: 1,905.00\nRow #19: 2,069.44\nRow #19: 1,865.44\nRow #20: 1,192\nRow #20: 1,039\nRow #20: 1,081\nRow #20: 2,475.67\nRow #20: 2,268.87\nRow #20: 2,264.90\nRow #21: \nRow #21: \nRow #21: \nRow #21: \nRow #21: \nRow #21: \nRow #22: \nRow #22: \nRow #22: \nRow #22: \nRow #22: \nRow #22: \nRow #23: 1,192\nRow #23: 1,039\nRow #23: 1,081\nRow #23: 2,475.67\nRow #23: 2,268.87\nRow #23: 2,264.90\nRow #24: 2,191\nRow #24: 1,991\nRow #24: 2,558\nRow #24: 4,633.93\nRow #24: 4,257.68\nRow #24: 5,349.87\nRow #25: \nRow #25: \nRow #25: \nRow #25: \nRow #25: \nRow #25: \nRow #26: \nRow #26: \nRow #26: \nRow #26: \nRow #26: \nRow #26: \nRow #27: 2,191\nRow #27: 1,991\nRow #27: 2,558\nRow #27: 4,633.93\nRow #27: 4,257.68\nRow #27: 5,349.87\nRow #28: 1,041\nRow #28: 901\nRow #28: 1,291\nRow #28: 2,228.87\nRow #28: 1,938.09\nRow #28: 2,676.53\nRow #29: \nRow #29: \nRow #29: \nRow #29: \nRow #29: \nRow #29: \nRow #30: \nRow #30: \nRow #30: \nRow #30: \nRow #30: \nRow #30: \nRow #31: 1,041\nRow #31: 901\nRow #31: 1,291\nRow #31: 2,228.87\nRow #31: 1,938.09\nRow #31: 2,676.53\nRow #32: 1,150\nRow #32: 1,090\nRow #32: 1,267\nRow #32: 2,405.06\nRow #32: 2,319.59\nRow #32: 2,673.34\nRow #33: \nRow #33: \nRow #33: \nRow #33: \nRow #33: \nRow #33: \nRow #34: \nRow #34: \nRow #34: \nRow #34: \nRow #34: \nRow #34: \nRow #35: 1,150\nRow #35: 1,090\nRow #35: 1,267\nRow #35: 2,405.06\nRow #35: 2,319.59\nRow #35: 2,673.34\n"), new FoodMartTestCase.QueryAndResult("select from [Warehouse and Sales]", "Axis #0:\n{}\n565,238.13")};

    public void testConcurrentValidatingQueriesInRandomOrder() {
        this.props.DisableCaching.set(false);
        this.props.UseAggregates.set(false);
        this.props.ReadAggregates.set(false);
        FoodMartTestCase.QueryAndResult[] singleQuery = new FoodMartTestCase.QueryAndResult[]{mdxQueries[0]};
        ConcurrentMdxTest.assertTrue((ConcurrentValidatingQueryRunner.runTest(1, 1, false, true, singleQuery).size() == 0 ? 1 : 0) != 0);
        FoodMartTestCase.QueryAndResult[] singleQueryFor2Threads = new FoodMartTestCase.QueryAndResult[]{mdxQueries[1]};
        ConcurrentMdxTest.assertTrue((ConcurrentValidatingQueryRunner.runTest(2, 5, false, true, singleQueryFor2Threads).size() == 0 ? 1 : 0) != 0);
        ConcurrentMdxTest.assertTrue((ConcurrentValidatingQueryRunner.runTest(10, 45, true, true, mdxQueries).size() == 0 ? 1 : 0) != 0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.props = MondrianProperties.instance();
    }
}

