/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import rex.utils.S;

public class MDXViewer
extends JPanel {
    private static int MAX_QUERIES_COUNT = 10;
    JTextArea queriesArea = new JTextArea(){
        {
            this.setOpaque(false);
        }

        public void paintComponent(Graphics g) {
            S.paintBackground(g, this);
            super.paintComponent(g);
        }
    };
    LinkedList queries;

    public MDXViewer() {
        this.queriesArea.setFont(new Font("Monospaced", 1, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.queriesArea), "Center");
        this.queries = new LinkedList();
    }

    public void addQuery(String q) {
        if (this.queries.size() > MAX_QUERIES_COUNT) {
            this.queries.removeLast();
        }
        this.queries.addFirst(q);
        this.refreshDisplay();
    }

    private void refreshDisplay() {
        this.queriesArea.setText("");
        StringBuffer newText = new StringBuffer("");
        String separator = "\n----------------------------------------------------------------------------------------------------\n";
        Iterator it = this.queries.iterator();
        while (it.hasNext()) {
            newText.append(separator);
            newText.append((String)it.next());
            newText.append(separator);
        }
        this.queriesArea.setText(newText.toString());
    }
}

