/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class DisconnectAction
extends DatabaseAction {
    static final long serialVersionUID = -5994051723289754485L;

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
            if (databaseNodeInfo != null) {
                DatabaseNodeInfo databaseNodeInfo2 = databaseNodeInfo.getParent("connection");
                if (databaseNodeInfo2 == null || databaseNodeInfo2.getConnection() != null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected int mode() {
        return 4;
    }

    public void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        final Node[] nodeArray2 = nodeArray;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                for (int i = 0; i < nodeArray2.length; ++i) {
                    Node node = nodeArray2[i];
                    try {
                        DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
                        ConnectionNodeInfo connectionNodeInfo = (ConnectionNodeInfo)databaseNodeInfo.getParent("connection");
                        connectionNodeInfo.disconnect();
                        continue;
                    }
                    catch (Exception exception) {
                        DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToDisconnect"), exception.getMessage());
                    }
                }
            }
        }, 0);
    }
}

