/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import org.openide.nodes.PropertySupport;

public final class ImageExpressionClassNameProperty
extends PropertySupport.ReadWrite {
    private final JRDesignImage element;
    PropertyEditor editor = null;

    public ImageExpressionClassNameProperty(JRDesignImage element) {
        super("valueClassName", String.class, "Expression Class", "Expression Class");
        this.element = element;
        this.setValue("canEditAsText", true);
        this.setValue("oneline", true);
        this.setValue("suppressCustomEditor", false);
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        if (this.element.getExpression() == null) {
            return "java.lang.String";
        }
        if (this.element.getExpression().getValueClassName() == null) {
            return "java.lang.String";
        }
        return this.element.getExpression().getValueClassName();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JRDesignExpression oldExp = (JRDesignExpression)this.element.getExpression();
        JRDesignExpression newExp = null;
        String newVal = val != null ? val + "" : "";
        if ((newVal = newVal.trim()).equals("")) {
            newVal = null;
        }
        newExp = new JRDesignExpression();
        newExp.setText(oldExp != null ? oldExp.getText() : null);
        newExp.setValueClassName(newVal);
        this.element.setExpression((JRExpression)newExp);
        ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Expression", JRExpression.class, oldExp, newExp);
        IReportManager.getInstance().addUndoableEdit(urob);
    }

    public boolean isDefaultValue() {
        return this.element.getExpression() == null || this.element.getExpression().getValueClassName() == null || this.element.getExpression().getValueClassName().equals("java.lang.String");
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
        this.editor.setValue("java.lang.String");
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> classes = new ArrayList<Tag>();
            classes.add(new Tag("java.lang.String"));
            classes.add(new Tag("java.io.File"));
            classes.add(new Tag("java.net.URL"));
            classes.add(new Tag("java.io.InputStream"));
            classes.add(new Tag("java.awt.Image"));
            classes.add(new Tag("net.sf.jasperreports.engine.JRRenderable"));
            this.editor = new ComboBoxPropertyEditor(false, classes);
        }
        return this.editor;
    }
}

