/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ProcessPanelWorker;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ProcessPanel
extends IzPanel
implements AbstractUIProcessHandler {
    private static final long serialVersionUID = 3258417209583155251L;
    protected JLabel processLabel;
    protected JProgressBar overallProgressBar;
    private boolean validated = false;
    private ProcessPanelWorker worker;
    private int noOfJobs = 0;
    private int currentJob = 0;
    private JTextArea outputPane;
    private static boolean finishedWork = false;

    public ProcessPanel(InstallerFrame installerFrame, InstallData installData) throws IOException {
        super(installerFrame, installData);
        this.worker = new ProcessPanelWorker(installData, this);
        JLabel jLabel = new JLabel();
        Font font = jLabel.getFont();
        font = font.deriveFont(1, (float)font.getSize() * 2.0f);
        jLabel.setFont(font);
        jLabel.setHorizontalAlignment(0);
        jLabel.setText(installerFrame.langpack.getString("ProcessPanel.heading"));
        jLabel.setVerticalAlignment(1);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(2);
        borderLayout.setVgap(2);
        this.setLayout(borderLayout);
        this.add((Component)jLabel, "North");
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.5f);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.processLabel = new JLabel();
        this.processLabel.setAlignmentX(0.5f);
        this.processLabel.setText(" ");
        jPanel.add(this.processLabel);
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setAlignmentX(0.5f);
        this.overallProgressBar.setStringPainted(true);
        jPanel.add(this.overallProgressBar);
        this.outputPane = new JTextArea();
        this.outputPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.outputPane);
        jPanel.add(jScrollPane);
        this.add((Component)jPanel, "Center");
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void startProcessing(int n) {
        this.noOfJobs = n;
        this.overallProgressBar.setMaximum(n);
        this.overallProgressBar.setIndeterminate(true);
        this.parent.lockPrevButton();
    }

    public void finishProcessing(boolean bl, boolean bl2) {
        this.overallProgressBar.setIndeterminate(false);
        String string = Integer.toString(this.noOfJobs);
        this.overallProgressBar.setString(string + " / " + string);
        this.processLabel.setText(" ");
        this.processLabel.setEnabled(false);
        this.validated = true;
        this.idata.installSuccess = this.worker.getResult();
        if (this.idata.panels.indexOf(this) != this.idata.panels.size() - 1 && bl2) {
            this.parent.unlockNextButton();
        }
        if (bl) {
            this.parent.unlockPrevButton();
        }
        finishedWork = this.idata.installSuccess;
    }

    public void logOutput(String string, boolean bl) {
        this.outputPane.append(string + '\n');
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProcessPanel.this.outputPane.setCaretPosition(ProcessPanel.this.outputPane.getText().length());
            }
        });
    }

    public void startProcess(String string) {
        this.processLabel.setText(string);
        ++this.currentJob;
        this.overallProgressBar.setValue(this.currentJob);
        this.overallProgressBar.setString(Integer.toString(this.currentJob) + " / " + Integer.toString(this.noOfJobs));
    }

    public void finishProcess() {
    }

    public void panelActivate() {
        Dimension dimension = this.parent.getPanelsContainerSize();
        dimension.width -= dimension.width / 4;
        dimension.height = 150;
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.parent.lockNextButton();
        if (!finishedWork) {
            this.worker.startThread();
        }
    }

    public void makeXMLData(IXMLElement iXMLElement) {
    }
}

