/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.gui.TwoColumnLayout;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.FileInputField;
import com.izforge.izpack.panels.MultipleFileInputField;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.PasswordUIElement;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.RadioButtonUIElement;
import com.izforge.izpack.panels.RuleInputField;
import com.izforge.izpack.panels.TextInputField;
import com.izforge.izpack.panels.UIElement;
import com.izforge.izpack.panels.UIElementType;
import com.izforge.izpack.panels.UserInputPanelAutomationHelper;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.rules.VariableExistenceCondition;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.HyperlinkHandler;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInputPanel
extends IzPanel
implements ActionListener,
ItemListener,
FocusListener {
    private static final long serialVersionUID = 3257850965439886129L;
    protected static final String ICON_KEY = "icon";
    private static final String SPEC_FILE_NAME = "userInputSpec.xml";
    private static final String LANG_FILE_NAME = "userInputLang.xml";
    private static final String NODE_ID = "panel";
    private static final String FIELD_NODE_ID = "field";
    private static final String INSTANCE_IDENTIFIER = "order";
    protected static final String PANEL_IDENTIFIER = "id";
    private static final String TYPE = "type";
    private static final String DESCRIPTION = "description";
    private static final String VARIABLE = "variable";
    private static final String TEXT = "txt";
    private static final String KEY = "id";
    private static final String SPEC = "spec";
    private static final String SET = "set";
    private static final String REVALIDATE = "revalidate";
    private static final String TOPBUFFER = "topBuffer";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String ALIGNMENT = "align";
    private static final String LEFT = "left";
    private static final String CENTER = "center";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String ITALICS = "italic";
    private static final String BOLD = "bold";
    private static final String SIZE = "size";
    private static final String VALIDATOR = "validator";
    private static final String PROCESSOR = "processor";
    private static final String CLASS = "class";
    private static final String TITLE_FIELD = "title";
    private static final String TEXT_FIELD = "text";
    private static final String TEXT_SIZE = "size";
    private static final String STATIC_TEXT = "staticText";
    private static final String COMBO_FIELD = "combo";
    private static final String COMBO_CHOICE = "choice";
    private static final String COMBO_VALUE = "value";
    private static final String RADIO_FIELD = "radio";
    private static final String RADIO_CHOICE = "choice";
    private static final String RADIO_VALUE = "value";
    private static final String SPACE_FIELD = "space";
    private static final String DIVIDER_FIELD = "divider";
    private static final String CHECK_FIELD = "check";
    private static final String RULE_FIELD = "rule";
    private static final String RULE_LAYOUT = "layout";
    private static final String RULE_SEPARATOR = "separator";
    private static final String RULE_RESULT_FORMAT = "resultFormat";
    private static final String RULE_PLAIN_STRING = "plainString";
    private static final String RULE_DISPLAY_FORMAT = "displayFormat";
    private static final String RULE_SPECIAL_SEPARATOR = "specialSeparator";
    private static final String RULE_ENCRYPTED = "processed";
    private static final String RULE_PARAM_NAME = "name";
    private static final String RULE_PARAM_VALUE = "value";
    private static final String RULE_PARAM = "param";
    private static final String PWD_FIELD = "password";
    private static final String PWD_INPUT = "pwd";
    private static final String PWD_SIZE = "size";
    private static final String SEARCH_FIELD = "search";
    private static final String FILE_FIELD = "file";
    private static final String DIR_FIELD = "dir";
    private static final String SEARCH_CHOICE = "choice";
    private static final String SEARCH_FILENAME = "filename";
    private static final String SEARCH_RESULT = "result";
    private static final String SEARCH_VALUE = "value";
    private static final String SEARCH_TYPE = "type";
    private static final String SEARCH_FILE = "file";
    private static final String SEARCH_DIRECTORY = "directory";
    private static final String SEARCH_PARENTDIR = "parentdir";
    private static final String SEARCH_CHECKFILENAME = "checkfilename";
    private static final String SELECTEDPACKS = "createForPack";
    private static final String UNSELECTEDPACKS = "createForUnselectedPack";
    protected static final String ATTRIBUTE_CONDITIONID_NAME = "conditionid";
    protected static final String VARIABLE_NODE = "variable";
    protected static final String ATTRIBUTE_VARIABLE_NAME = "name";
    protected static final String ATTRIBUTE_VARIABLE_VALUE = "value";
    private static final String NAME = "name";
    private static final String OS = "os";
    private static final String FAMILY = "family";
    private static final String MULTIPLE_FILE_FIELD = "multiFile";
    private static int instanceCount = 0;
    protected int instanceNumber = 0;
    private boolean packsDefined = false;
    private InstallerFrame parentFrame;
    private IXMLElement spec;
    private boolean haveSpec = false;
    private Vector<ButtonGroup> buttonGroups = new Vector();
    private Vector<PasswordGroup> passwordGroups = new Vector();
    private Vector passwordGroupsRead = new Vector();
    private Vector<SearchField> searchFields = new Vector();
    private Vector<TextValuePair> entries = new Vector();
    private LocaleDatabase langpack = null;
    private boolean validating = true;
    private boolean eventsActivated = false;
    private Vector<UIElement> elements = new Vector();

    public UserInputPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.instanceNumber = instanceCount++;
        this.parentFrame = installerFrame;
    }

    private void createBuiltInVariableConditions(String string) {
        if (string != null) {
            VariableExistenceCondition variableExistenceCondition = new VariableExistenceCondition();
            variableExistenceCondition.setId("izpack.input." + string);
            variableExistenceCondition.setInstalldata(this.idata);
            variableExistenceCondition.setVariable(string);
            this.parent.getRules().addCondition(variableExistenceCondition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        TwoColumnLayout twoColumnLayout;
        this.eventsActivated = false;
        super.removeAll();
        this.elements.clear();
        try {
            this.langpack = (LocaleDatabase)this.parent.langpack.clone();
            String string = "userInputLang.xml_" + this.idata.localeISO3;
            this.langpack.add(ResourceManager.getInstance().getInputStream(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this.readSpec();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        int n = 25;
        try {
            n = Integer.parseInt(this.spec.getAttribute(TOPBUFFER));
        }
        catch (Exception exception) {
        }
        finally {
            twoColumnLayout = new TwoColumnLayout(10, 5, 30, n, 0);
        }
        this.setLayout(twoColumnLayout);
        if (!this.haveSpec) {
            return;
        }
        this.updateVariables();
        Vector<IXMLElement> vector = this.spec.getChildrenNamed(FIELD_NODE_ID);
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            IXMLElement iXMLElement = vector.elementAt(i);
            String string2 = iXMLElement.getAttribute("type");
            String string3 = iXMLElement.getAttribute("variable");
            if (string3 != null) {
                this.createBuiltInVariableConditions(string3);
            }
            if ((string = iXMLElement.getAttribute(ATTRIBUTE_CONDITIONID_NAME)) != null && !this.parent.getRules().isConditionTrue(string, this.idata.getVariables()) || string2 == null) continue;
            if (string2.equals(RULE_FIELD)) {
                this.addRuleField(iXMLElement);
                continue;
            }
            if (string2.equals(TEXT_FIELD)) {
                this.addTextField(iXMLElement);
                continue;
            }
            if (string2.equals(COMBO_FIELD)) {
                this.addComboBox(iXMLElement);
                continue;
            }
            if (string2.equals(RADIO_FIELD)) {
                this.addRadioButton(iXMLElement);
                continue;
            }
            if (string2.equals(PWD_FIELD)) {
                this.addPasswordField(iXMLElement);
                continue;
            }
            if (string2.equals(SPACE_FIELD)) {
                this.addSpace(iXMLElement);
                continue;
            }
            if (string2.equals(DIVIDER_FIELD)) {
                this.addDivider(iXMLElement);
                continue;
            }
            if (string2.equals(CHECK_FIELD)) {
                this.addCheckBox(iXMLElement);
                continue;
            }
            if (string2.equals(STATIC_TEXT)) {
                this.addText(iXMLElement);
                continue;
            }
            if (string2.equals(TITLE_FIELD)) {
                this.addTitle(iXMLElement);
                continue;
            }
            if (string2.equals(SEARCH_FIELD)) {
                this.addSearch(iXMLElement);
                continue;
            }
            if (string2.equals(MULTIPLE_FILE_FIELD)) {
                this.addMultipleFileField(iXMLElement);
                continue;
            }
            if (string2.equals("file")) {
                this.addFileField(iXMLElement);
                continue;
            }
            if (!string2.equals(DIR_FIELD)) continue;
            this.addDirectoryField(iXMLElement);
        }
        this.eventsActivated = true;
    }

    private List<ValidatorContainer> analyzeValidator(IXMLElement iXMLElement) {
        ArrayList<ValidatorContainer> arrayList = null;
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(VALIDATOR);
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            arrayList = new ArrayList<ValidatorContainer>(n);
            for (int i = 0; i < n; ++i) {
                IXMLElement iXMLElement22 = vector.get(i);
                String string = iXMLElement22.getAttribute(CLASS);
                String string2 = this.getText(iXMLElement22);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                Vector<IXMLElement> vector2 = iXMLElement22.getChildrenNamed(RULE_PARAM);
                if (vector2 != null && vector2.size() > 0) {
                    for (IXMLElement iXMLElement22 : vector2) {
                        String string3 = iXMLElement22.getAttribute("name");
                        String string4 = iXMLElement22.getAttribute("value");
                        hashMap.put(string3, string4);
                    }
                }
                arrayList.add(new ValidatorContainer(string, string2, hashMap));
            }
        }
        return arrayList;
    }

    private void addDirectoryField(IXMLElement iXMLElement) {
        int n;
        Object object;
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        String string = iXMLElement.getAttribute("variable");
        if (string == null || string.length() == 0) {
            return;
        }
        boolean bl = false;
        boolean bl2 = true;
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed(SPEC);
        if (iXMLElement2 == null) {
            Debug.trace("Error: no spec element defined in file field");
            return;
        }
        JLabel jLabel = new JLabel(this.getText(iXMLElement2));
        String string2 = iXMLElement2.getAttribute(SET);
        if (string2 == null) {
            string2 = this.idata.getVariable(string);
            if (string2 == null) {
                string2 = "";
            }
        } else if (string2 != null && !"".equals(string2)) {
            object = new VariableSubstitutor(this.idata.getVariables());
            string2 = ((VariableSubstitutor)object).substitute(string2, null);
            this.idata.setVariable(string, string2);
        }
        try {
            n = Integer.parseInt(iXMLElement2.getAttribute("size"));
        }
        catch (Throwable throwable) {
            n = 1;
        }
        bl = Boolean.parseBoolean(iXMLElement2.getAttribute("allowEmptyValue", FALSE));
        bl2 = Boolean.parseBoolean(iXMLElement2.getAttribute("mustExist", TRUE));
        List<ValidatorContainer> list = this.analyzeValidator(iXMLElement);
        object = new TwoColumnConstraints();
        ((TwoColumnConstraints)object).position = 15;
        UIElement uIElement = new UIElement();
        uIElement.setType(UIElementType.LABEL);
        uIElement.setConstraints(object);
        uIElement.setComponent(jLabel);
        uIElement.setForPacks(vector);
        uIElement.setForOs(vector2);
        this.elements.add(uIElement);
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 26;
        FileInputField fileInputField = new FileInputField(this, this.idata, true, bl2, string2, n, list);
        fileInputField.setAllowEmptyInput(bl);
        UIElement uIElement2 = new UIElement();
        uIElement2.setType(UIElementType.DIRECTORY);
        uIElement2.setConstraints(twoColumnConstraints);
        uIElement2.setComponent(fileInputField);
        uIElement2.setForPacks(vector);
        uIElement2.setForOs(vector2);
        uIElement2.setAssociatedVariable(string);
        this.elements.add(uIElement2);
    }

    private void addMultipleFileField(IXMLElement iXMLElement) {
        Object object;
        Object object2;
        int n;
        Object object3;
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        String string = null;
        String string2 = null;
        String string3 = iXMLElement.getAttribute("variable");
        if (string3 == null || string3.length() == 0) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 200;
        int n3 = 200;
        int n4 = 10;
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed(SPEC);
        if (iXMLElement2 == null) {
            Debug.trace("Error: no spec element defined in multi file field");
            return;
        }
        String string4 = this.getText(iXMLElement2);
        String string5 = iXMLElement2.getAttribute(SET);
        if (string5 == null) {
            string5 = this.idata.getVariable(string3);
            if (string5 == null) {
                string5 = "";
            }
        } else if (string5 != null && !"".equals(string5)) {
            object3 = new VariableSubstitutor(this.idata.getVariables());
            string5 = ((VariableSubstitutor)object3).substitute(string5, null);
        }
        try {
            n = Integer.parseInt(iXMLElement2.getAttribute("size"));
        }
        catch (Throwable throwable) {
            n = 1;
        }
        string = iXMLElement2.getAttribute("fileext");
        if (string == null) {
            string = "";
        }
        if ((string2 = iXMLElement2.getAttribute("fileextdesc")) == null) {
            string2 = "";
        }
        string2 = this.langpack.getString(string2);
        object3 = iXMLElement2.getAttribute("visibleRows");
        if (object3 != null) {
            try {
                n4 = Integer.parseInt((String)object3);
            }
            catch (Exception exception) {
                Debug.error("Illegal value for visibleRows found.");
            }
        }
        if ((object2 = iXMLElement2.getAttribute("prefX")) != null) {
            try {
                n2 = Integer.parseInt((String)object2);
            }
            catch (Exception exception) {
                Debug.error("Illegal value for prefX found.");
            }
        }
        if ((object = iXMLElement2.getAttribute("prefY")) != null) {
            try {
                n3 = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                Debug.error("Illegal value for prefY found.");
            }
        }
        bl2 = Boolean.parseBoolean(iXMLElement2.getAttribute("multipleVariables", FALSE));
        bl = Boolean.parseBoolean(iXMLElement2.getAttribute("allowEmptyValue", FALSE));
        object3 = this.analyzeValidator(iXMLElement);
        object2 = new TwoColumnConstraints();
        ((TwoColumnConstraints)object2).position = 26;
        object = new MultipleFileInputField(this.parentFrame, this.idata, false, string5, n, (List<ValidatorContainer>)object3, string, string2, bl2, n4, n2, n3, string4);
        ((MultipleFileInputField)object).setAllowEmptyInput(bl);
        UIElement uIElement = new UIElement();
        uIElement.setType(UIElementType.MULTIPLE_FILE);
        uIElement.setConstraints(object2);
        uIElement.setComponent((JComponent)object);
        uIElement.setForPacks(vector);
        uIElement.setForOs(vector2);
        uIElement.setAssociatedVariable(string3);
        this.elements.add(uIElement);
    }

    private void addFileField(IXMLElement iXMLElement) {
        int n;
        Object object;
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        String string = null;
        String string2 = null;
        String string3 = iXMLElement.getAttribute("variable");
        if (string3 == null || string3.length() == 0) {
            return;
        }
        boolean bl = false;
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed(SPEC);
        if (iXMLElement2 == null) {
            Debug.trace("Error: no spec element defined in file field");
            return;
        }
        JLabel jLabel = new JLabel(this.getText(iXMLElement2));
        String string4 = iXMLElement2.getAttribute(SET);
        if (string4 == null) {
            string4 = this.idata.getVariable(string3);
            if (string4 == null) {
                string4 = "";
            }
        } else if (string4 != null && !"".equals(string4)) {
            object = new VariableSubstitutor(this.idata.getVariables());
            string4 = ((VariableSubstitutor)object).substitute(string4, null);
            this.idata.setVariable(string3, string4);
        }
        try {
            n = Integer.parseInt(iXMLElement2.getAttribute("size"));
        }
        catch (Throwable throwable) {
            n = 1;
        }
        string = iXMLElement2.getAttribute("fileext");
        if (string == null) {
            string = "";
        }
        if ((string2 = iXMLElement2.getAttribute("fileextdesc")) == null) {
            string2 = "";
        }
        string2 = this.idata.langpack.getString(string2);
        bl = Boolean.parseBoolean(iXMLElement2.getAttribute("allowEmptyValue", FALSE));
        object = this.analyzeValidator(iXMLElement);
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 15;
        UIElement uIElement = new UIElement();
        uIElement.setType(UIElementType.LABEL);
        uIElement.setConstraints(twoColumnConstraints);
        uIElement.setComponent(jLabel);
        uIElement.setForPacks(vector);
        uIElement.setForOs(vector2);
        this.elements.add(uIElement);
        TwoColumnConstraints twoColumnConstraints2 = new TwoColumnConstraints();
        twoColumnConstraints2.position = 26;
        FileInputField fileInputField = new FileInputField(this, this.idata, false, true, string4, n, (List<ValidatorContainer>)object, string, string2);
        fileInputField.setAllowEmptyInput(bl);
        UIElement uIElement2 = new UIElement();
        uIElement2.setType(UIElementType.FILE);
        uIElement2.setConstraints(twoColumnConstraints2);
        uIElement2.setComponent(fileInputField);
        uIElement2.setForPacks(vector);
        uIElement2.setForOs(vector2);
        uIElement2.setAssociatedVariable(string3);
        this.elements.add(uIElement2);
    }

    protected void updateUIElements() {
        boolean bl = false;
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
        for (UIElement uIElement : this.elements) {
            JComponent jComponent;
            if (!uIElement.hasVariableAssignment()) continue;
            String string = uIElement.getAssociatedVariable();
            String string2 = this.idata.getVariable(string);
            Debug.trace("updateUIElements() variable=" + string + " value=" + string2 + "\n");
            if (uIElement.getType() == UIElementType.RADIOBUTTON) {
                jComponent = (JRadioButton)uIElement.getComponent();
                if (string2 == null) continue;
                if (string2.equals(uIElement.getTrueValue())) {
                    ((AbstractButton)jComponent).setSelected(true);
                } else {
                    ((AbstractButton)jComponent).setSelected(false);
                }
            } else if (uIElement.getType() == UIElementType.TEXT) {
                jComponent = (TextInputField)uIElement.getComponent();
                if (string2 == null) {
                    string2 = ((TextInputField)jComponent).getText();
                }
                ((TextInputField)jComponent).setText(variableSubstitutor.substitute(string2, null));
            } else if (uIElement.getType() == UIElementType.RULE) {
                jComponent = (RuleInputField)uIElement.getComponent();
                if (string2 == null) {
                    string2 = ((RuleInputField)jComponent).getText();
                }
            } else if (uIElement.getType() == UIElementType.MULTIPLE_FILE) {
                jComponent = (MultipleFileInputField)uIElement.getComponent();
                if (string2 != null) {
                    Object object;
                    ((MultipleFileInputField)jComponent).clearFiles();
                    if (((MultipleFileInputField)jComponent).isCreateMultipleVariables()) {
                        ((MultipleFileInputField)jComponent).addFile(string2);
                        object = uIElement.getAssociatedVariable();
                        int n = 1;
                        while (string2 != null) {
                            StringBuffer stringBuffer = new StringBuffer((String)object);
                            stringBuffer.append("_");
                            stringBuffer.append(n++);
                            string2 = this.idata.getVariable(stringBuffer.toString());
                            if (string2 == null) continue;
                            ((MultipleFileInputField)jComponent).addFile(string2);
                        }
                    } else {
                        for (String string3 : object = string2.split(";")) {
                            ((MultipleFileInputField)jComponent).addFile(string3);
                        }
                    }
                }
            } else if (uIElement.getType() == UIElementType.FILE) {
                jComponent = (FileInputField)uIElement.getComponent();
                if (string2 != null) {
                    ((FileInputField)jComponent).setFile(string2);
                }
            } else if (uIElement.getType() == UIElementType.DIRECTORY) {
                jComponent = (FileInputField)uIElement.getComponent();
                if (string2 != null) {
                    ((FileInputField)jComponent).setFile(string2);
                }
            }
            bl = true;
        }
        if (bl) {
            super.invalidate();
        }
    }

    @Override
    public boolean isValidated() {
        return this.readInput();
    }

    @Override
    public void panelActivate() {
        this.init();
        if (this.spec == null) {
            this.emitError("User input specification could not be found.", "The specification for the user input panel could not be found. Please contact the packager.");
            this.parentFrame.skipPanel();
        }
        this.updateUIElements();
        Vector<IXMLElement> vector = this.spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = this.spec.getChildrenNamed(UNSELECTEDPACKS);
        Vector<IXMLElement> vector3 = this.spec.getChildrenNamed(OS);
        if (!(this.itemRequiredFor(vector) && this.itemRequiredForUnselected(vector2) && this.itemRequiredForOs(vector3))) {
            this.parentFrame.skipPanel();
            return;
        }
        if (!this.haveSpec) {
            this.parentFrame.skipPanel();
            return;
        }
        this.buildUI();
        this.setSize(this.getMaximumSize().width, this.getMaximumSize().height);
        this.validate();
        if (this.packsDefined) {
            this.parentFrame.lockPrevButton();
        }
    }

    @Override
    public void makeXMLData(IXMLElement iXMLElement) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.entries.size(); ++i) {
            TextValuePair textValuePair = this.entries.elementAt(i);
            String string = textValuePair.toString();
            hashMap.put(string, this.idata.getVariable(string));
        }
        new UserInputPanelAutomationHelper(hashMap).makeXMLData(this.idata, iXMLElement);
    }

    private void buildUI() {
        for (UIElement uIElement : this.elements) {
            if (this.itemRequiredFor(uIElement.getForPacks()) && this.itemRequiredForOs(uIElement.getForOs())) {
                if (uIElement.isDisplayed()) continue;
                uIElement.setDisplayed(true);
                this.add((Component)uIElement.getComponent(), uIElement.getConstraints());
                continue;
            }
            if (!uIElement.isDisplayed()) continue;
            uIElement.setDisplayed(false);
            this.remove(uIElement.getComponent());
        }
    }

    private boolean readInput() {
        boolean bl = true;
        this.passwordGroupsRead.clear();
        for (UIElement uIElement : this.elements) {
            if (!uIElement.isDisplayed()) continue;
            if (uIElement.getType() == UIElementType.RULE) {
                bl = this.readRuleField(uIElement);
            } else if (uIElement.getType() == UIElementType.PASSWORD) {
                bl = this.readPasswordField(uIElement);
            } else if (uIElement.getType() == UIElementType.TEXT) {
                bl = this.readTextField(uIElement);
            } else if (uIElement.getType() == UIElementType.COMBOBOX) {
                bl = this.readComboBox(uIElement);
            } else if (uIElement.getType() == UIElementType.RADIOBUTTON) {
                bl = this.readRadioButton(uIElement);
            } else if (uIElement.getType() == UIElementType.CHECKBOX) {
                bl = this.readCheckBox(uIElement);
            } else if (uIElement.getType() == UIElementType.SEARCH) {
                bl = this.readSearch(uIElement);
            } else if (uIElement.getType() == UIElementType.MULTIPLE_FILE) {
                bl = this.readMultipleFileField(uIElement);
            } else if (uIElement.getType() == UIElementType.FILE) {
                bl = this.readFileField(uIElement);
            } else if (uIElement.getType() == UIElementType.DIRECTORY) {
                bl = this.readDirectoryField(uIElement);
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean readDirectoryField(UIElement uIElement) {
        boolean bl;
        block3: {
            bl = false;
            try {
                FileInputField fileInputField = (FileInputField)uIElement.getComponent();
                bl = fileInputField.validateField();
                if (bl) {
                    this.idata.setVariable(uIElement.getAssociatedVariable(), fileInputField.getSelectedFile().getAbsolutePath());
                    this.entries.add(new TextValuePair(uIElement.getAssociatedVariable(), fileInputField.getSelectedFile().getAbsolutePath()));
                }
            }
            catch (Exception exception) {
                if (!Debug.stackTracing()) break block3;
                Debug.trace(exception);
            }
        }
        return bl;
    }

    private boolean readFileField(UIElement uIElement) {
        boolean bl;
        block3: {
            bl = false;
            try {
                FileInputField fileInputField = (FileInputField)uIElement.getComponent();
                bl = fileInputField.validateField();
                if (bl) {
                    this.idata.setVariable(uIElement.getAssociatedVariable(), fileInputField.getSelectedFile().getAbsolutePath());
                    this.entries.add(new TextValuePair(uIElement.getAssociatedVariable(), fileInputField.getSelectedFile().getAbsolutePath()));
                }
            }
            catch (Exception exception) {
                if (!Debug.stackTracing()) break block3;
                Debug.trace(exception);
            }
        }
        return bl;
    }

    private boolean readMultipleFileField(UIElement uIElement) {
        boolean bl;
        block8: {
            bl = false;
            try {
                MultipleFileInputField multipleFileInputField = (MultipleFileInputField)uIElement.getComponent();
                bl = multipleFileInputField.validateField();
                if (bl) {
                    List<String> list = multipleFileInputField.getSelectedFiles();
                    String string = uIElement.getAssociatedVariable();
                    if (multipleFileInputField.isCreateMultipleVariables()) {
                        int n = 0;
                        for (String string2 : list) {
                            StringBuffer stringBuffer = new StringBuffer(string);
                            if (n > 0) {
                                stringBuffer.append("_");
                                stringBuffer.append(n);
                            }
                            ++n;
                            this.idata.setVariable(stringBuffer.toString(), string2);
                            this.entries.add(new TextValuePair(stringBuffer.toString(), string2));
                        }
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (String string3 : list) {
                            stringBuffer.append(string3);
                            stringBuffer.append(";");
                        }
                        this.idata.setVariable(string, stringBuffer.toString());
                        this.entries.add(new TextValuePair(string, stringBuffer.toString()));
                    }
                }
            }
            catch (Exception exception) {
                if (!Debug.stackTracing()) break block8;
                Debug.trace(exception);
            }
        }
        return bl;
    }

    private void readSpec() throws Exception {
        InputStream inputStream = null;
        String string = Integer.toString(this.instanceNumber);
        String string2 = null;
        Panel panel = this.getMetadata();
        if (panel != null) {
            string2 = panel.getPanelid();
        }
        try {
            inputStream = this.parentFrame.getResource(SPEC_FILE_NAME);
        }
        catch (Exception exception) {
            this.haveSpec = false;
            return;
        }
        if (inputStream == null) {
            this.haveSpec = false;
            return;
        }
        XMLParser xMLParser = new XMLParser();
        IXMLElement iXMLElement = xMLParser.parse(inputStream);
        if (iXMLElement.hasChildren()) {
            Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(NODE_ID);
            for (int i = 0; i < vector.size(); ++i) {
                iXMLElement = vector.elementAt(i);
                String string3 = iXMLElement.getAttribute(INSTANCE_IDENTIFIER);
                String string4 = iXMLElement.getAttribute("id");
                if ((string3 == null || !string.equals(string3)) && (string4 == null || string2 == null || !string2.equals(string4))) continue;
                this.spec = iXMLElement;
                inputStream.close();
                this.haveSpec = true;
                return;
            }
            this.haveSpec = false;
            return;
        }
        this.haveSpec = false;
    }

    private void addTitle(IXMLElement iXMLElement) {
        String string = this.getText(iXMLElement);
        boolean bl = this.getBoolean(iXMLElement, ITALICS, false);
        boolean bl2 = this.getBoolean(iXMLElement, BOLD, false);
        float f = this.getFloat(iXMLElement, "size", 2.0f);
        int n = this.getAlignment(iXMLElement);
        String string2 = this.getIconName(iXMLElement);
        if (string != null) {
            JLabel jLabel = null;
            ImageIcon imageIcon = null;
            try {
                imageIcon = this.parent.icons.getImageIcon(string2);
                jLabel = LabelFactory.create(string, imageIcon, 11, true);
            }
            catch (Exception exception) {
                Debug.trace("Icon " + string2 + " not found in icon list. " + exception.getMessage());
                jLabel = LabelFactory.create(string);
            }
            Font font = jLabel.getFont();
            float f2 = font.getSize();
            int n2 = 0;
            if (bl2) {
                ++n2;
            }
            if (bl) {
                n2 += 2;
            }
            font = font.deriveFont(n2, f2 * f);
            jLabel.setFont(font);
            jLabel.setAlignmentX(0.0f);
            TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
            twoColumnConstraints.align = n;
            twoColumnConstraints.position = 9;
            this.add((Component)jLabel, twoColumnConstraints);
        }
    }

    protected String getIconName(IXMLElement iXMLElement) {
        if (iXMLElement == null) {
            return null;
        }
        String string = iXMLElement.getAttribute(ICON_KEY);
        String string2 = null;
        if (string != null && this.langpack != null) {
            try {
                string2 = this.langpack.getString(string);
            }
            catch (Throwable throwable) {
                string2 = null;
            }
        }
        return string2;
    }

    private void addRuleField(IXMLElement iXMLElement) {
        Object twoColumnConstraints;
        String string;
        String string2;
        String string3;
        JLabel jLabel;
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed(SPEC);
        String string4 = iXMLElement.getAttribute("variable");
        RuleInputField ruleInputField = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        String string7 = null;
        String string8 = null;
        HashMap<String, String> hashMap = null;
        Vector<IXMLElement> vector3 = null;
        String string9 = null;
        int n = 2;
        if (iXMLElement2 != null) {
            jLabel = new JLabel(this.getText(iXMLElement2));
            string3 = iXMLElement2.getAttribute(RULE_LAYOUT);
            string2 = iXMLElement2.getAttribute(SET);
            string = iXMLElement2.getAttribute(RULE_SEPARATOR);
            String string10 = iXMLElement2.getAttribute(RULE_RESULT_FORMAT);
            if (string10 != null) {
                if (string10.equals(RULE_PLAIN_STRING)) {
                    n = 1;
                } else if (string10.equals(RULE_DISPLAY_FORMAT)) {
                    n = 2;
                } else if (string10.equals(RULE_SPECIAL_SEPARATOR)) {
                    n = 3;
                } else if (string10.equals(RULE_ENCRYPTED)) {
                    n = 4;
                }
            }
        } else {
            return;
        }
        iXMLElement2 = iXMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription(iXMLElement2, vector, vector2);
        iXMLElement2 = iXMLElement.getFirstChildNamed(VALIDATOR);
        if (iXMLElement2 != null) {
            string5 = iXMLElement2.getAttribute(CLASS);
            string6 = this.getText(iXMLElement2);
            vector3 = iXMLElement2.getChildrenNamed(RULE_PARAM);
            if (vector3 != null && vector3.size() > 0) {
                bl = true;
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                }
                twoColumnConstraints = vector3.iterator();
                while (twoColumnConstraints.hasNext()) {
                    IXMLElement object2;
                    iXMLElement2 = object2 = (IXMLElement)twoColumnConstraints.next();
                    string7 = iXMLElement2.getAttribute("name");
                    string8 = iXMLElement2.getAttribute("value");
                    hashMap.put(string7, string8);
                }
            }
        }
        if ((iXMLElement2 = iXMLElement.getFirstChildNamed(PROCESSOR)) != null) {
            string9 = iXMLElement2.getAttribute(CLASS);
        }
        ruleInputField = bl ? new RuleInputField(string3, string2, string, string5, hashMap, string9, n, this.getToolkit(), this.idata) : new RuleInputField(string3, string2, string, string5, string9, n, this.getToolkit(), this.idata);
        twoColumnConstraints = new TwoColumnConstraints();
        ((TwoColumnConstraints)twoColumnConstraints).position = 15;
        UIElement uIElement = new UIElement();
        uIElement.setType(UIElementType.LABEL);
        uIElement.setConstraints(twoColumnConstraints);
        uIElement.setComponent(jLabel);
        uIElement.setForPacks(vector);
        uIElement.setForOs(vector2);
        this.elements.add(uIElement);
        TwoColumnConstraints twoColumnConstraints2 = new TwoColumnConstraints();
        twoColumnConstraints2.position = 26;
        UIElement uIElement2 = new UIElement();
        uIElement2.setType(UIElementType.RULE);
        uIElement2.setConstraints(twoColumnConstraints2);
        uIElement2.setComponent(ruleInputField);
        uIElement2.setForPacks(vector);
        uIElement2.setForOs(vector2);
        uIElement2.setAssociatedVariable(string4);
        uIElement2.setMessage(string6);
        this.elements.add(uIElement2);
    }

    private boolean readRuleField(UIElement uIElement) {
        boolean bl;
        RuleInputField ruleInputField = null;
        String string = null;
        String string2 = null;
        try {
            ruleInputField = (RuleInputField)uIElement.getComponent();
            string = uIElement.getAssociatedVariable();
            string2 = uIElement.getMessage();
        }
        catch (Throwable throwable) {
            return true;
        }
        if (string == null || ruleInputField == null) {
            return true;
        }
        boolean bl2 = bl = !this.validating || ruleInputField.validateContents();
        if (!bl) {
            this.showWarningMessageDialog(this.parentFrame, string2);
            return false;
        }
        this.idata.setVariable(string, ruleInputField.getText());
        this.entries.add(new TextValuePair(string, ruleInputField.getText()));
        return true;
    }

    private void addTextField(IXMLElement iXMLElement) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Iterator<IXMLElement> iterator;
        String string;
        JLabel jLabel;
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        Object object4 = iXMLElement.getFirstChildNamed(SPEC);
        HashMap<Object, Object> hashMap = null;
        Vector<IXMLElement> vector3 = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        String string4 = iXMLElement.getAttribute("variable");
        if (string4 == null || string4.length() == 0) {
            return;
        }
        if (object4 != null) {
            jLabel = new JLabel(this.getText((IXMLElement)object4));
            string = object4.getAttribute(SET);
            if (string == null) {
                string = this.idata.getVariable(string4);
                if (string == null) {
                    string = "";
                }
            } else if (string != null && !"".equals(string)) {
                iterator = new VariableSubstitutor(this.idata.getVariables());
                string = ((VariableSubstitutor)((Object)iterator)).substitute(string, null);
            }
            try {
                n = Integer.parseInt(object4.getAttribute("size"));
            }
            catch (Throwable throwable) {
                n = 1;
            }
        } else {
            Debug.trace("No specification element, returning.");
            return;
        }
        object4 = iXMLElement.getFirstChildNamed(VALIDATOR);
        if (object4 != null) {
            string2 = object4.getAttribute(CLASS);
            Debug.trace("Validator found for text field: " + string2);
            string3 = this.getText((IXMLElement)object4);
            vector3 = object4.getChildrenNamed(RULE_PARAM);
            if (vector3 != null && vector3.size() > 0) {
                Debug.trace("Validator has " + vector3.size() + " parameters.");
                bl = true;
                if (hashMap == null) {
                    hashMap = new HashMap<Object, Object>();
                }
                iterator = vector3.iterator();
                while (iterator.hasNext()) {
                    object4 = object3 = iterator.next();
                    object2 = object4.getAttribute("name");
                    object = object4.getAttribute("value");
                    hashMap.put(object2, object);
                }
            }
        }
        object4 = iXMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription((IXMLElement)object4, vector, vector2);
        TextInputField textInputField = bl ? new TextInputField(string, n, string2, hashMap) : new TextInputField(string, n, string2);
        textInputField.addFocusListener(this);
        iterator = new TwoColumnConstraints();
        ((TwoColumnConstraints)((Object)iterator)).position = 15;
        object3 = new UIElement();
        ((UIElement)object3).setType(UIElementType.LABEL);
        ((UIElement)object3).setConstraints(iterator);
        ((UIElement)object3).setComponent(jLabel);
        ((UIElement)object3).setForPacks(vector);
        ((UIElement)object3).setForOs(vector2);
        this.elements.add((UIElement)object3);
        object2 = new TwoColumnConstraints();
        ((TwoColumnConstraints)object2).position = 26;
        object = new UIElement();
        ((UIElement)object).setType(UIElementType.TEXT);
        ((UIElement)object).setConstraints(object2);
        ((UIElement)object).setComponent(textInputField);
        ((UIElement)object).setForPacks(vector);
        ((UIElement)object).setForOs(vector2);
        ((UIElement)object).setAssociatedVariable(string4);
        ((UIElement)object).setMessage(string3);
        this.elements.add((UIElement)object);
    }

    private boolean readTextField(UIElement uIElement) {
        TextInputField textInputField = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            textInputField = (TextInputField)uIElement.getComponent();
            string = uIElement.getAssociatedVariable();
            string3 = uIElement.getMessage();
            string2 = textInputField.getText();
        }
        catch (Throwable throwable) {
            return true;
        }
        if (string == null || string2 == null) {
            return true;
        }
        Debug.trace("Validating text field");
        boolean bl = textInputField.validateContents();
        if (!bl) {
            Debug.trace("Validation did not pass, message: " + string3);
            if (string3 == null) {
                string3 = "Text entered did not pass validation.";
            }
            this.showWarningMessageDialog(this.parentFrame, string3);
            return false;
        }
        Debug.trace("Field validated");
        this.idata.setVariable(string, string2);
        this.entries.add(new TextValuePair(string, string2));
        return true;
    }

    private void addComboBox(IXMLElement iXMLElement) {
        Object object;
        Object object2;
        Cloneable cloneable;
        JLabel jLabel;
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed(SPEC);
        String string = iXMLElement.getAttribute("variable");
        TextValuePair textValuePair = null;
        JComboBox<TextValuePair> jComboBox = new JComboBox<TextValuePair>();
        jComboBox.addItemListener(this);
        boolean bl = false;
        if (iXMLElement2 != null) {
            jLabel = new JLabel(this.getText(iXMLElement2));
            cloneable = iXMLElement2.getChildrenNamed("choice");
            if (cloneable == null) {
                return;
            }
            object2 = this.idata.getVariable(string);
            if (object2 != null) {
                bl = true;
            }
            for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                Object object3;
                String string2;
                String string3;
                object = ((Vector)cloneable).elementAt(i).getAttribute(PROCESSOR);
                if (object != null && !"".equals(object)) {
                    string3 = "";
                    try {
                        string3 = ((Processor)Class.forName((String)object).newInstance()).process(null);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    string2 = ((IXMLElement)((Vector)cloneable).elementAt(i)).getAttribute(SET);
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (string2 != null && !"".equals(string2)) {
                        object3 = new VariableSubstitutor(this.idata.getVariables());
                        string2 = ((VariableSubstitutor)object3).substitute(string2, null);
                    }
                    object3 = new StringTokenizer(string3, ":");
                    int n = 0;
                    while (((StringTokenizer)object3).hasMoreTokens()) {
                        String string4 = ((StringTokenizer)object3).nextToken();
                        textValuePair = new TextValuePair(string4, string4);
                        jComboBox.addItem(textValuePair);
                        if (string2.equals(string4)) {
                            jComboBox.setSelectedIndex(jComboBox.getItemCount() - 1);
                        }
                        ++n;
                    }
                    continue;
                }
                string3 = ((Vector)cloneable).elementAt(i).getAttribute("value");
                textValuePair = new TextValuePair(this.getText((IXMLElement)((Vector)cloneable).elementAt(i)), string3);
                jComboBox.addItem(textValuePair);
                if (bl) {
                    if (string3 == null || string3.length() <= 0 || !((String)object2).equals(string3)) continue;
                    jComboBox.setSelectedIndex(i);
                    continue;
                }
                string2 = ((IXMLElement)((Vector)cloneable).elementAt(i)).getAttribute(SET);
                if (string2 == null) continue;
                if (string2 != null && !"".equals(string2)) {
                    object3 = new VariableSubstitutor(this.idata.getVariables());
                    string2 = ((VariableSubstitutor)object3).substitute(string2, null);
                }
                if (!string2.equals(TRUE)) continue;
                jComboBox.setSelectedIndex(i);
            }
        } else {
            return;
        }
        iXMLElement2 = iXMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription(iXMLElement2, vector, vector2);
        cloneable = new TwoColumnConstraints();
        ((TwoColumnConstraints)cloneable).position = 15;
        object2 = new UIElement();
        ((UIElement)object2).setType(UIElementType.LABEL);
        ((UIElement)object2).setConstraints(cloneable);
        ((UIElement)object2).setComponent(jLabel);
        ((UIElement)object2).setForPacks(vector);
        ((UIElement)object2).setForOs(vector2);
        this.elements.add((UIElement)object2);
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 26;
        object = new UIElement();
        ((UIElement)object).setType(UIElementType.COMBOBOX);
        ((UIElement)object).setConstraints(twoColumnConstraints);
        ((UIElement)object).setComponent(jComboBox);
        ((UIElement)object).setForPacks(vector);
        ((UIElement)object).setForOs(vector2);
        ((UIElement)object).setAssociatedVariable(string);
        this.elements.add((UIElement)object);
    }

    private boolean readComboBox(UIElement uIElement) {
        String string;
        String string2;
        try {
            string2 = uIElement.getAssociatedVariable();
            JComboBox jComboBox = (JComboBox)uIElement.getComponent();
            string = ((TextValuePair)jComboBox.getSelectedItem()).getValue();
        }
        catch (Throwable throwable) {
            return true;
        }
        if (string2 == null || string == null) {
            return true;
        }
        this.idata.setVariable(string2, string);
        this.entries.add(new TextValuePair(string2, string));
        return true;
    }

    private void addRadioButton(IXMLElement iXMLElement) {
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        String string = iXMLElement.getAttribute("variable");
        String string2 = null;
        IXMLElement iXMLElement2 = null;
        ButtonGroup buttonGroup = new ButtonGroup();
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 29;
        twoColumnConstraints.indent = true;
        twoColumnConstraints.stretch = true;
        iXMLElement2 = iXMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription(iXMLElement2, vector, vector2);
        iXMLElement2 = iXMLElement.getFirstChildNamed(SPEC);
        if (iXMLElement2 != null) {
            Vector<IXMLElement> vector3 = iXMLElement2.getChildrenNamed("choice");
            if (vector3 == null) {
                return;
            }
            for (int i = 0; i < vector3.size(); ++i) {
                Object object;
                JRadioButton jRadioButton = new JRadioButton();
                jRadioButton.setText(this.getText(vector3.elementAt(i)));
                String string3 = vector3.elementAt(i).getAttribute(REVALIDATE);
                if (string3 != null && string3.equals("yes")) {
                    jRadioButton.addActionListener(this);
                }
                string2 = vector3.elementAt(i).getAttribute("value");
                buttonGroup.add(jRadioButton);
                String string4 = vector3.elementAt(i).getAttribute(SET);
                if (this.idata.getVariable(string) == null && string4 != null) {
                    this.idata.setVariable(string, string2);
                }
                if (string4 != null) {
                    if (string4 != null && !"".equals(string4)) {
                        object = new VariableSubstitutor(this.idata.getVariables());
                        string4 = ((VariableSubstitutor)object).substitute(string4, null);
                    }
                    if (string4.equals(TRUE)) {
                        jRadioButton.setSelected(true);
                    }
                }
                this.buttonGroups.add(buttonGroup);
                object = new RadioButtonUIElement();
                ((UIElement)object).setType(UIElementType.RADIOBUTTON);
                ((UIElement)object).setConstraints(twoColumnConstraints);
                ((UIElement)object).setComponent(jRadioButton);
                ((UIElement)object).setForPacks(vector);
                ((UIElement)object).setForOs(vector2);
                ((RadioButtonUIElement)object).setButtonGroup(buttonGroup);
                ((UIElement)object).setAssociatedVariable(string);
                ((UIElement)object).setTrueValue(string2);
                this.elements.add((UIElement)object);
            }
        }
    }

    private boolean readRadioButton(UIElement uIElement) {
        String string = null;
        String string2 = null;
        JRadioButton jRadioButton = null;
        try {
            jRadioButton = (JRadioButton)uIElement.getComponent();
            if (!jRadioButton.isSelected()) {
                return true;
            }
            string = uIElement.getAssociatedVariable();
            string2 = uIElement.getTrueValue();
        }
        catch (Throwable throwable) {
            return true;
        }
        this.idata.setVariable(string, string2);
        this.entries.add(new TextValuePair(string, string2));
        return true;
    }

    private void addPasswordField(IXMLElement iXMLElement) {
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        String string = iXMLElement.getAttribute("variable");
        String string2 = null;
        IXMLElement iXMLElement2 = null;
        PasswordGroup passwordGroup = null;
        int n = 0;
        iXMLElement2 = iXMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription(iXMLElement2, vector, vector2);
        List<ValidatorContainer> list = this.analyzeValidator(iXMLElement);
        if (list == null) {
            list = new ArrayList<ValidatorContainer>();
        }
        if ((iXMLElement2 = iXMLElement.getFirstChildNamed(PROCESSOR)) != null) {
            string2 = iXMLElement2.getAttribute(CLASS);
        }
        passwordGroup = new PasswordGroup(this.idata, list, string2);
        iXMLElement2 = iXMLElement.getFirstChildNamed(SPEC);
        if (iXMLElement2 != null) {
            Vector<IXMLElement> vector3 = iXMLElement2.getChildrenNamed(PWD_INPUT);
            if (vector3 == null) {
                return;
            }
            for (int i = 0; i < vector3.size(); ++i) {
                Serializable serializable;
                IXMLElement iXMLElement3 = vector3.elementAt(i);
                String string3 = iXMLElement3.getAttribute(SET);
                if (string3 != null && !"".equals(string3)) {
                    serializable = new VariableSubstitutor(this.idata.getVariables());
                    string3 = ((VariableSubstitutor)serializable).substitute(string3, null);
                }
                serializable = new JLabel(this.getText(iXMLElement3));
                try {
                    n = Integer.parseInt(iXMLElement3.getAttribute("size"));
                }
                catch (Throwable throwable) {
                    n = 1;
                }
                JPasswordField jPasswordField = new JPasswordField(string3, n);
                jPasswordField.setCaretPosition(0);
                TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
                twoColumnConstraints.position = 15;
                UIElement uIElement = new UIElement();
                uIElement.setType(UIElementType.LABEL);
                uIElement.setConstraints(twoColumnConstraints);
                uIElement.setComponent((JComponent)serializable);
                uIElement.setForPacks(vector);
                uIElement.setForOs(vector2);
                this.elements.add(uIElement);
                TwoColumnConstraints twoColumnConstraints2 = new TwoColumnConstraints();
                twoColumnConstraints2.position = 26;
                PasswordUIElement passwordUIElement = new PasswordUIElement();
                passwordUIElement.setType(UIElementType.PASSWORD);
                passwordUIElement.setConstraints(twoColumnConstraints2);
                passwordUIElement.setComponent(jPasswordField);
                passwordUIElement.setForPacks(vector);
                passwordUIElement.setForOs(vector2);
                passwordUIElement.setPasswordGroup(passwordGroup);
                passwordUIElement.setAssociatedVariable(string);
                this.elements.add(passwordUIElement);
                passwordGroup.addField(jPasswordField);
            }
        }
        this.passwordGroups.add(passwordGroup);
    }

    private boolean readPasswordField(UIElement uIElement) {
        boolean bl;
        PasswordUIElement passwordUIElement = (PasswordUIElement)uIElement;
        PasswordGroup passwordGroup = null;
        String string = null;
        try {
            passwordGroup = passwordUIElement.getPasswordGroup();
            string = uIElement.getAssociatedVariable();
        }
        catch (Throwable throwable) {
            return true;
        }
        if (string == null || this.passwordGroupsRead.contains(passwordGroup)) {
            return true;
        }
        this.passwordGroups.add(passwordGroup);
        boolean bl2 = bl = !this.validating;
        if (!bl) {
            int n = passwordGroup.validatorSize();
            for (int i = 0; i < n; ++i) {
                bl = passwordGroup.validateContents(i);
                if (bl) continue;
                JOptionPane.showMessageDialog(this.parentFrame, passwordGroup.getValidatorMessage(i), this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
                break;
            }
        }
        if (bl) {
            this.idata.setVariable(string, passwordGroup.getPassword());
            this.entries.add(new TextValuePair(string, passwordGroup.getPassword()));
        }
        return bl;
    }

    private void addCheckBox(IXMLElement iXMLElement) {
        Serializable serializable;
        Object object;
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        String string = "";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = iXMLElement.getAttribute("variable");
        String string6 = null;
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed(SPEC);
        if (string5 == null) {
            return;
        }
        if (iXMLElement2 != null) {
            string = this.getText(iXMLElement2);
            string2 = iXMLElement2.getAttribute(SET);
            string3 = iXMLElement2.getAttribute(TRUE);
            string4 = iXMLElement2.getAttribute(FALSE);
            string6 = iXMLElement2.getAttribute(REVALIDATE);
            object = this.idata.getVariable(string5);
            Debug.trace("check: value: " + (String)object + ", set: " + string2);
            if (object != null && ((String)object).equals(string3)) {
                string2 = TRUE;
            }
        }
        object = new JCheckBox(string);
        ((AbstractButton)object).addItemListener(this);
        if (string6 != null && string6.equals("yes")) {
            ((AbstractButton)object).addActionListener(this);
        }
        if (string2 != null) {
            if (string2 != null && !"".equals(string2)) {
                serializable = new VariableSubstitutor(this.idata.getVariables());
                string2 = ((VariableSubstitutor)serializable).substitute(string2, null);
            }
            if (string2.equals(FALSE)) {
                ((AbstractButton)object).setSelected(false);
            }
            if (string2.equals(TRUE)) {
                ((AbstractButton)object).setSelected(true);
            }
        }
        serializable = iXMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription((IXMLElement)serializable, vector, vector2);
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 29;
        twoColumnConstraints.stretch = true;
        twoColumnConstraints.indent = true;
        UIElement uIElement = new UIElement();
        uIElement.setType(UIElementType.CHECKBOX);
        uIElement.setConstraints(twoColumnConstraints);
        uIElement.setComponent((JComponent)object);
        uIElement.setForPacks(vector);
        uIElement.setForOs(vector2);
        uIElement.setTrueValue(string3);
        uIElement.setFalseValue(string4);
        uIElement.setAssociatedVariable(string5);
        this.elements.add(uIElement);
    }

    private boolean readCheckBox(UIElement uIElement) {
        String string = null;
        String string2 = null;
        String string3 = null;
        JCheckBox jCheckBox = null;
        try {
            jCheckBox = (JCheckBox)uIElement.getComponent();
            string = uIElement.getAssociatedVariable();
            string2 = uIElement.getTrueValue();
            if (string2 == null) {
                string2 = "";
            }
            if ((string3 = uIElement.getFalseValue()) == null) {
                string3 = "";
            }
        }
        catch (Throwable throwable) {
            Debug.trace("readCheckBox(): failed: " + throwable);
            return true;
        }
        if (jCheckBox.isSelected()) {
            Debug.trace("readCheckBox(): selected, setting " + string + " to " + string2);
            this.idata.setVariable(string, string2);
            this.entries.add(new TextValuePair(string, string2));
        } else {
            Debug.trace("readCheckBox(): not selected, setting " + string + " to " + string3);
            this.idata.setVariable(string, string3);
            this.entries.add(new TextValuePair(string, string3));
        }
        return true;
    }

    private void addSearch(IXMLElement iXMLElement) {
        boolean bl;
        Serializable serializable;
        Object object;
        Object object2;
        Cloneable cloneable;
        Object object3;
        Object object4;
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed(SPEC);
        String string = iXMLElement.getAttribute("variable");
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        JComboBox<String> jComboBox = new JComboBox<String>();
        JLabel jLabel = null;
        jComboBox.setEditable(true);
        if (iXMLElement2 != null) {
            jLabel = new JLabel(this.getText(iXMLElement2));
            n = 2;
            object4 = iXMLElement2.getAttribute("type");
            if (object4 != null) {
                if (((String)object4).equals("file")) {
                    n = 2;
                } else if (((String)object4).equals(SEARCH_DIRECTORY)) {
                    n = 1;
                }
            }
            if ((object3 = iXMLElement2.getAttribute(SEARCH_RESULT)) == null) {
                return;
            }
            if (((String)object3).equals("file")) {
                n2 = 2;
            } else if (((String)object3).equals(SEARCH_DIRECTORY)) {
                n2 = 1;
            } else if (((String)object3).equals(SEARCH_PARENTDIR)) {
                n2 = 3;
            } else {
                return;
            }
            string2 = iXMLElement2.getAttribute(SEARCH_FILENAME);
            string3 = iXMLElement2.getAttribute(SEARCH_CHECKFILENAME);
            cloneable = iXMLElement2.getChildrenNamed("choice");
            if (cloneable == null) {
                return;
            }
            for (int i = 0; i < cloneable.size(); ++i) {
                IXMLElement iXMLElement3 = cloneable.elementAt(i);
                if (!OsConstraint.oneMatchesCurrentSystem(iXMLElement3)) continue;
                object2 = iXMLElement3.getAttribute("value");
                jComboBox.addItem((String)object2);
                object = cloneable.elementAt(i).getAttribute(SET);
                if (object == null) continue;
                if (object != null && !"".equals(object)) {
                    serializable = new VariableSubstitutor(this.idata.getVariables());
                    object = ((VariableSubstitutor)serializable).substitute((String)object, null);
                }
                if (!((String)object).equals(TRUE)) continue;
                jComboBox.setSelectedIndex(i);
            }
        } else {
            return;
        }
        iXMLElement2 = iXMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription(iXMLElement2, vector, vector2);
        object4 = new TwoColumnConstraints();
        ((TwoColumnConstraints)object4).position = 15;
        object3 = new UIElement();
        ((UIElement)object3).setType(UIElementType.LABEL);
        ((UIElement)object3).setConstraints(object4);
        ((UIElement)object3).setComponent(jLabel);
        ((UIElement)object3).setForPacks(vector);
        ((UIElement)object3).setForOs(vector2);
        this.elements.add((UIElement)object3);
        cloneable = new TwoColumnConstraints();
        ((TwoColumnConstraints)cloneable).position = 26;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location"), new Object[]{new String[]{string2}}));
        }
        boolean bl2 = bl = string3 != null && string3.length() > 0;
        if (bl) {
            stringBuffer.append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location.checkedfile"), new Object[]{new String[]{string3}}));
        }
        if (stringBuffer.length() > 0) {
            jComboBox.setToolTipText(stringBuffer.toString());
        }
        object2 = new UIElement();
        ((UIElement)object2).setType(UIElementType.SEARCH);
        ((UIElement)object2).setConstraints(cloneable);
        ((UIElement)object2).setComponent(jComboBox);
        ((UIElement)object2).setForPacks(vector);
        ((UIElement)object2).setForOs(vector2);
        ((UIElement)object2).setAssociatedVariable(string);
        this.elements.add((UIElement)object2);
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(3));
        serializable = ButtonFactory.createButton(this.parentFrame.langpack.getString("UserInputPanel.search.autodetect"), this.idata.buttonsHColor);
        ((JComponent)serializable).setVisible(bl);
        ((JComponent)serializable).setToolTipText(this.parentFrame.langpack.getString("UserInputPanel.search.autodetect.tooltip"));
        ((Container)object).add((Component)serializable);
        JButton jButton = ButtonFactory.createButton(this.parentFrame.langpack.getString("UserInputPanel.search.browse"), this.idata.buttonsHColor);
        ((Container)object).add(jButton);
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 27;
        UIElement uIElement = new UIElement();
        uIElement.setType(UIElementType.SEARCHBUTTON);
        uIElement.setConstraints(twoColumnConstraints);
        uIElement.setComponent((JComponent)object);
        uIElement.setForPacks(vector);
        uIElement.setForOs(vector2);
        this.elements.add(uIElement);
        this.searchFields.add(new SearchField(string2, string3, this.parentFrame, jComboBox, (JButton)serializable, jButton, n, n2));
    }

    private boolean readSearch(UIElement uIElement) {
        String string = null;
        String string2 = null;
        JComboBox jComboBox = null;
        try {
            string = uIElement.getAssociatedVariable();
            jComboBox = (JComboBox)uIElement.getComponent();
            for (int i = 0; i < this.searchFields.size(); ++i) {
                SearchField searchField = this.searchFields.elementAt(i);
                if (!searchField.belongsTo(jComboBox)) continue;
                string2 = searchField.getResult();
                break;
            }
        }
        catch (Throwable throwable) {
            return true;
        }
        if (string == null || string2 == null) {
            return true;
        }
        this.idata.setVariable(string, string2);
        this.entries.add(new TextValuePair(string, string2));
        return true;
    }

    private void addText(IXMLElement iXMLElement) {
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        this.addDescription(iXMLElement, vector, vector2);
    }

    private void addSpace(IXMLElement iXMLElement) {
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        JPanel jPanel = new JPanel();
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 29;
        twoColumnConstraints.stretch = true;
        UIElement uIElement = new UIElement();
        uIElement.setType(UIElementType.SPACE);
        uIElement.setConstraints(twoColumnConstraints);
        uIElement.setComponent(jPanel);
        uIElement.setForPacks(vector);
        uIElement.setForOs(vector2);
        this.elements.add(uIElement);
    }

    private void addDivider(IXMLElement iXMLElement) {
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(OS);
        JPanel jPanel = new JPanel();
        String string = iXMLElement.getAttribute(ALIGNMENT);
        if (string != null) {
            if (string.equals(TOP)) {
                jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
            } else {
                jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
            }
        } else {
            jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        }
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 29;
        twoColumnConstraints.stretch = true;
        UIElement uIElement = new UIElement();
        uIElement.setType(UIElementType.DIVIDER);
        uIElement.setConstraints(twoColumnConstraints);
        uIElement.setComponent(jPanel);
        uIElement.setForPacks(vector);
        uIElement.setForOs(vector2);
        this.elements.add(uIElement);
    }

    private void addDescription(IXMLElement iXMLElement, Vector<IXMLElement> vector, Vector<IXMLElement> vector2) {
        String string;
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 29;
        twoColumnConstraints.stretch = true;
        if (iXMLElement != null && (string = this.getText(iXMLElement)) != null) {
            JTextPane jTextPane = new JTextPane();
            jTextPane.setEditable(false);
            if (string.startsWith("<html>") && string.endsWith("</html>")) {
                jTextPane.setContentType("text/html");
                jTextPane.addHyperlinkListener(new HyperlinkHandler());
            }
            jTextPane.setText(string);
            jTextPane.setBackground(UIManager.getColor("label.backgroud"));
            jTextPane.setMargin(new Insets(3, 0, 3, 0));
            jTextPane.getPreferredSize();
            UIElement uIElement = new UIElement();
            uIElement.setType(UIElementType.DESCRIPTION);
            uIElement.setConstraints(twoColumnConstraints);
            uIElement.setComponent(jTextPane);
            uIElement.setForPacks(vector);
            uIElement.setForOs(vector2);
            this.elements.add(uIElement);
        }
    }

    private boolean getBoolean(IXMLElement iXMLElement, String string, boolean bl) {
        String string2;
        boolean bl2 = bl;
        if (string != null && string.length() > 0 && (string2 = iXMLElement.getAttribute(string)) != null) {
            if (string2.equals(TRUE)) {
                bl2 = true;
            } else if (string2.equals(FALSE)) {
                bl2 = false;
            }
        }
        return bl2;
    }

    private float getFloat(IXMLElement iXMLElement, String string, float f) {
        float f2 = f;
        if (string != null && string.length() > 0) {
            try {
                f2 = Float.parseFloat(iXMLElement.getAttribute(string));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return f2;
    }

    private String getText(IXMLElement iXMLElement) {
        if (iXMLElement == null) {
            return null;
        }
        String string = iXMLElement.getAttribute("id");
        String string2 = null;
        if (string != null && this.langpack != null) {
            try {
                string2 = this.langpack.getString(string);
            }
            catch (Throwable throwable) {
                string2 = null;
            }
        }
        if (string2 == null) {
            string2 = iXMLElement.getAttribute(TEXT);
        }
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
        return variableSubstitutor.substitute(string2, null);
    }

    private int getAlignment(IXMLElement iXMLElement) {
        int n = 31;
        String string = iXMLElement.getAttribute(ALIGNMENT);
        if (string != null) {
            if (string.equals(LEFT)) {
                n = 31;
            } else if (string.equals(CENTER)) {
                n = 35;
            } else if (string.equals(RIGHT)) {
                n = 47;
            }
        }
        return n;
    }

    public boolean itemRequiredForOs(Vector<IXMLElement> vector) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).getAttribute(FAMILY);
            boolean bl = false;
            if ("windows".equals(string)) {
                bl = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(string)) {
                bl = OsVersion.IS_OSX;
            } else if ("unix".equals(string)) {
                bl = OsVersion.IS_UNIX;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean itemRequiredFor(Vector<IXMLElement> vector) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String string = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = vector.elementAt(j).getAttribute("name", "");
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean itemRequiredForUnselected(Vector<IXMLElement> vector) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String string = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = vector.elementAt(j).getAttribute("name", "");
                if (!string.equals(string2)) continue;
                return false;
            }
        }
        return true;
    }

    protected void updateVariables() {
        Vector<IXMLElement> vector = this.spec.getChildrenNamed("variable");
        RulesEngine rulesEngine = this.parent.getRules();
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            IXMLElement iXMLElement = vector.elementAt(i);
            String string = iXMLElement.getAttribute("name");
            String string2 = iXMLElement.getAttribute("value");
            if (string2 == null && iXMLElement.hasChildren()) {
                object = iXMLElement.getFirstChildNamed("value");
                string2 = object.getContent();
            }
            if ((object = iXMLElement.getAttribute(ATTRIBUTE_CONDITIONID_NAME)) != null && !rulesEngine.isConditionTrue((String)object, this.idata.getVariables()) || !OsConstraint.oneMatchesCurrentSystem(iXMLElement) || string == null) continue;
            if (string2 != null) {
                string2 = variableSubstitutor.substitute(string2, null);
                this.idata.setVariable(string, "");
                string2 = variableSubstitutor.substitute(string2, null);
            }
            this.idata.setVariable(string, string2);
            this.entries.add(new TextValuePair(string, string2));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateDialog();
    }

    private void showMessageDialog(InstallerFrame installerFrame, String string, String string2, int n) {
        String string3;
        String string4 = installerFrame.langpack.getString(string);
        if (string4 == null || string4.trim().length() == 0) {
            string4 = string;
        }
        if ((string3 = installerFrame.langpack.getString(string2)) == null || string3.trim().length() == 0) {
            string3 = string2;
        }
        JOptionPane.showMessageDialog(installerFrame, string4, string3, n);
    }

    private void showWarningMessageDialog(InstallerFrame installerFrame, String string) {
        this.showMessageDialog(installerFrame, string, "UserInputPanel.error.caption", 2);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateDialog();
    }

    private void updateDialog() {
        if (this.eventsActivated) {
            this.eventsActivated = false;
            if (this.isValidated()) {
                this.init();
                this.updateVariables();
                this.updateUIElements();
                this.buildUI();
                this.validate();
                this.repaint();
            }
            this.eventsActivated = true;
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.updateDialog();
    }

    private class SearchField
    implements ActionListener {
        public static final int TYPE_DIRECTORY = 1;
        public static final int TYPE_FILE = 2;
        public static final int RESULT_DIRECTORY = 1;
        public static final int RESULT_FILE = 2;
        public static final int RESULT_PARENTDIR = 3;
        private String filename = null;
        private String checkFilename = null;
        private JButton autodetectButton = null;
        private JButton browseButton = null;
        private JComboBox pathComboBox = null;
        private int searchType = 1;
        private int resultType = 1;
        private InstallerFrame parent = null;

        public SearchField(String string, String string2, InstallerFrame installerFrame, JComboBox jComboBox, JButton jButton, JButton jButton2, int n, int n2) {
            this.filename = string;
            this.checkFilename = string2;
            this.parent = installerFrame;
            this.autodetectButton = jButton;
            this.browseButton = jButton2;
            this.pathComboBox = jComboBox;
            this.searchType = n;
            this.resultType = n2;
            this.autodetectButton.addActionListener(this);
            this.browseButton.addActionListener(this);
            ((JTextField)this.pathComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.checkNextButtonState();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.checkNextButtonState();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.checkNextButtonState();
                }

                private void checkNextButtonState() {
                    Document document = ((JTextField)SearchField.this.pathComboBox.getEditor().getEditorComponent()).getDocument();
                    try {
                        if (SearchField.this.pathMatches(document.getText(0, document.getLength()))) {
                            SearchField.this.getInstallerFrame().unlockNextButton(false);
                        } else {
                            SearchField.this.getInstallerFrame().lockNextButton();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            this.autodetect();
        }

        private InstallerFrame getInstallerFrame() {
            return this.parent;
        }

        public boolean belongsTo(JComboBox jComboBox) {
            return this.pathComboBox == jComboBox;
        }

        private boolean pathMatches(String string) {
            if (string != null) {
                File file = null;
                file = this.filename == null || this.searchType == 1 ? new File(string) : new File(string, this.filename);
                if (file.exists() && (this.searchType == 1 && file.isDirectory() || this.searchType == 2 && file.isFile())) {
                    if (this.checkFilename == null) {
                        return true;
                    }
                    file = new File(file, this.checkFilename);
                    return file.exists();
                }
            }
            return false;
        }

        public boolean autodetect() {
            Object object;
            String string4;
            Vector<String> vector = new Vector<String>();
            String string2 = (String)this.pathComboBox.getSelectedItem();
            if (string2 == null) {
                this.parent.lockNextButton();
                return false;
            }
            boolean bl = false;
            for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                if (!this.pathComboBox.getItemAt(i).equals(string2)) continue;
                bl = true;
            }
            if (!bl) {
                this.pathComboBox.addItem(this.pathComboBox.getSelectedItem());
            }
            VariableSubstitutor variableSubstitutor = new VariableSubstitutor(UserInputPanel.this.idata.getVariables());
            for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                string4 = variableSubstitutor.substitute((String)this.pathComboBox.getItemAt(i), null);
                if (string4.endsWith("*")) {
                    File[] fileArray;
                    object = new File(string4 = string4.substring(0, string4.length() - 1));
                    if (!((File)object).isDirectory()) continue;
                    for (File file : fileArray = ((File)object).listFiles()) {
                        String string3 = file.getAbsolutePath();
                        if (!this.pathMatches(string3)) continue;
                        vector.add(string3);
                    }
                    continue;
                }
                if (!this.pathMatches(string4)) continue;
                vector.add(string4);
            }
            vector = new Vector(new HashSet(vector));
            this.pathComboBox.removeAllItems();
            for (String string4 : vector) {
                object = variableSubstitutor.substitute(string4, "plain");
                this.pathComboBox.addItem(object);
            }
            for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                string4 = (String)this.pathComboBox.getItemAt(i);
                if (!this.pathMatches(string4)) continue;
                this.pathComboBox.setSelectedIndex(i);
                this.parent.unlockNextButton();
                return true;
            }
            if (this.pathMatches((String)this.pathComboBox.getSelectedItem())) {
                this.parent.unlockNextButton();
                return true;
            }
            this.parent.lockNextButton();
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.autodetectButton) {
                if (!this.autodetect()) {
                    UserInputPanel.this.showMessageDialog(this.parent, "UserInputPanel.search.autodetect.failed.message", "UserInputPanel.search.autodetect.failed.caption", 2);
                }
            } else if (actionEvent.getSource() == this.browseButton) {
                int n;
                JFileChooser jFileChooser = new JFileChooser();
                if (this.resultType != 2) {
                    jFileChooser.setFileSelectionMode(1);
                }
                if ((n = jFileChooser.showOpenDialog(this.parent)) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    this.pathComboBox.setSelectedItem(file.getAbsolutePath());
                    if (this.resultType != 2 && !this.pathMatches(file.getAbsolutePath())) {
                        UserInputPanel.this.showMessageDialog(this.parent, "UserInputPanel.search.wrongselection.message", "UserInputPanel.search.wrongselection.caption", 2);
                    }
                }
            }
        }

        public String getResult() {
            String string = (String)this.pathComboBox.getSelectedItem();
            if (string != null) {
                string = string.trim();
            }
            String string2 = string;
            File file = new File(string);
            if (!file.isDirectory()) {
                string2 = file.getParent();
            }
            if (this.resultType == 1) {
                return string2;
            }
            if (this.resultType == 2) {
                if (this.filename != null) {
                    return string2 + File.separatorChar + this.filename;
                }
                return string;
            }
            if (this.resultType == 3) {
                File file2 = new File(string2);
                return file2.getParent();
            }
            return null;
        }
    }

    private static class TextValuePair {
        private String text = "";
        private String value = "";

        public TextValuePair(String string, String string2) {
            this.text = string;
            this.value = string2;
        }

        public void setText(String string) {
            this.text = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String toString() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }
    }
}

