/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class UserInputPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    protected int instanceNumber = instanceCount++;
    private static int instanceCount = 0;
    private static final String SPEC_FILE_NAME = "userInputSpec.xml";
    private static final String NODE_ID = "panel";
    private static final String INSTANCE_IDENTIFIER = "order";
    protected static final String PANEL_IDENTIFIER = "id";
    private static final String FIELD_NODE_ID = "field";
    protected static final String ATTRIBUTE_CONDITIONID_NAME = "conditionid";
    private static final String VARIABLE = "variable";
    private static final String SET = "set";
    private static final String TEXT = "txt";
    private static final String SPEC = "spec";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String TEXT_FIELD = "text";
    private static final String COMBO_FIELD = "combo";
    private static final String STATIC_TEXT = "staticText";
    private static final String CHOICE = "choice";
    private static final String VALUE = "value";
    private static final String RADIO_FIELD = "radio";
    private static final String DESCRIPTION = "description";
    private static final String TRUE = "true";
    public List<Input> listInputs = new ArrayList<Input>();

    public boolean runConsoleFromPropertiesFile(AutomatedInstallData automatedInstallData, Properties properties) {
        this.collectInputs(automatedInstallData);
        Iterator<Input> iterator = this.listInputs.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().strVariableName;
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            automatedInstallData.setVariable(string, string2);
        }
        return true;
    }

    public boolean runGeneratePropertiesFile(AutomatedInstallData automatedInstallData, PrintWriter printWriter) {
        this.collectInputs(automatedInstallData);
        Iterator<Input> iterator = this.listInputs.iterator();
        while (iterator.hasNext()) {
            printWriter.println(iterator.next().strVariableName + "=");
        }
        return true;
    }

    public boolean runConsole(AutomatedInstallData automatedInstallData) {
        this.collectInputs(automatedInstallData);
        boolean bl = true;
        for (Input input : this.listInputs) {
            String string = input.strText;
            if (string != null) {
                System.out.println(string);
            }
            if (TEXT_FIELD.equals(input.strFieldType)) {
                bl = bl && this.processTextField(input, automatedInstallData);
                continue;
            }
            if (!COMBO_FIELD.equals(input.strFieldType) && !RADIO_FIELD.equals(input.strFieldType)) continue;
            bl = bl && this.processComboRadioField(input, automatedInstallData);
        }
        int n = this.askEndOfConsolePanel();
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        return this.runConsole(automatedInstallData);
    }

    public boolean collectInputs(AutomatedInstallData automatedInstallData) {
        this.listInputs.clear();
        IXMLElement iXMLElement = null;
        String string = automatedInstallData.panelsOrder.get(automatedInstallData.curPanelNumber).getPanelid();
        String string2 = Integer.toString(this.instanceNumber);
        SpecHelper specHelper = new SpecHelper();
        try {
            specHelper.readSpec(specHelper.getResource(SPEC_FILE_NAME));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Vector<IXMLElement> vector = specHelper.getSpec().getChildrenNamed(NODE_ID);
        for (int i = 0; i < vector.size(); ++i) {
            IXMLElement iXMLElement2 = vector.elementAt(i);
            String string3 = iXMLElement2.getAttribute(INSTANCE_IDENTIFIER);
            String string4 = iXMLElement2.getAttribute(PANEL_IDENTIFIER);
            if ((string3 == null || !string2.equals(string3)) && (string4 == null || string == null || !string.equals(string4))) continue;
            iXMLElement = iXMLElement2;
        }
        Vector<IXMLElement> vector2 = iXMLElement.getChildrenNamed(FIELD_NODE_ID);
        for (int i = 0; i < vector2.size(); ++i) {
            IXMLElement iXMLElement3 = vector2.elementAt(i);
            String string5 = iXMLElement3.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
            if (string5 != null && !automatedInstallData.getRules().isConditionTrue(string5, automatedInstallData.getVariables())) continue;
            this.listInputs.add(this.getInputFromField(iXMLElement3));
        }
        return true;
    }

    boolean processTextField(Input input, AutomatedInstallData automatedInstallData) {
        Object object;
        String string = input.strVariableName;
        if (string == null || string.length() == 0) {
            return false;
        }
        if (input.listChoices.size() == 0) {
            Debug.trace("Error: no spec element defined in file field");
            return false;
        }
        String string2 = input.strDefaultValue;
        if (string2 == null) {
            string2 = automatedInstallData.getVariable(string);
            if (string2 == null) {
                string2 = "";
            }
        } else if (string2 != null && !"".equals(string2)) {
            object = new VariableSubstitutor(automatedInstallData.getVariables());
            string2 = ((VariableSubstitutor)object).substitute(string2, null);
        }
        String string3 = input.listChoices.get((int)0).strText;
        System.out.println(string3 + " [" + string2 + "] ");
        try {
            object = new BufferedReader(new InputStreamReader(System.in));
            String string4 = ((BufferedReader)object).readLine();
            if (!string4.trim().equals("")) {
                automatedInstallData.setVariable(string, string4);
            } else {
                automatedInstallData.setVariable(string, string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    boolean processComboRadioField(Input input, AutomatedInstallData automatedInstallData) {
        String string;
        String string2 = input.strVariableName;
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        String string3 = automatedInstallData.getVariable(string2);
        boolean bl = false;
        List<Choice> list = input.listChoices;
        if (list.size() == 0) {
            Debug.trace("Error: no spec element defined in file field");
            return false;
        }
        if (string3 != null) {
            bl = true;
        }
        for (int i = 0; i < list.size(); ++i) {
            Choice choice = list.get(i);
            string = choice.strValue;
            if (bl) {
                if (string != null && string.length() > 0 && string3.equals(string)) {
                    input.iSelectedChoice = i;
                }
            } else {
                String string4 = choice.strSet;
                if (string4 != null) {
                    if (string4 != null && !"".equals(string4)) {
                        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(automatedInstallData.getVariables());
                        string4 = variableSubstitutor.substitute(string4, null);
                    }
                    if (string4.equals(TRUE)) {
                        input.iSelectedChoice = i;
                    }
                }
            }
            System.out.println(i + "  [" + (input.iSelectedChoice == i ? "x" : " ") + "] " + (choice.strText != null ? choice.strText : ""));
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            boolean bl2 = true;
            while (bl2) {
                System.out.println("input selection:");
                string = bufferedReader.readLine();
                if (string.trim().equals("") && input.iSelectedChoice != -1) {
                    bl2 = false;
                }
                int n = -1;
                try {
                    n = Integer.valueOf(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n < 0 || n >= list.size()) continue;
                input.iSelectedChoice = n;
                bl2 = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        automatedInstallData.setVariable(string2, input.listChoices.get((int)input.iSelectedChoice).strValue);
        return true;
    }

    public Input getInputFromField(IXMLElement iXMLElement) {
        String string = iXMLElement.getAttribute(VARIABLE);
        String string2 = iXMLElement.getAttribute(TYPE_ATTRIBUTE);
        if (STATIC_TEXT.equals(string2)) {
            String string3 = null;
            string3 = iXMLElement.getAttribute(TEXT);
            return new Input(string, null, null, STATIC_TEXT, string3, 0);
        }
        if (TEXT_FIELD.equals(string2)) {
            ArrayList<Choice> arrayList = new ArrayList<Choice>();
            String string4 = null;
            String string5 = null;
            String string6 = null;
            IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed(SPEC);
            IXMLElement iXMLElement3 = iXMLElement.getFirstChildNamed(DESCRIPTION);
            if (iXMLElement2 != null) {
                string6 = iXMLElement.getFirstChildNamed(SPEC).getAttribute(TEXT);
                string5 = iXMLElement.getFirstChildNamed(SPEC).getAttribute(SET);
            }
            if (iXMLElement3 != null) {
                string4 = iXMLElement3.getAttribute(TEXT);
            }
            arrayList.add(new Choice(string6, null, string5));
            return new Input(string, string5, arrayList, TEXT_FIELD, string4, 0);
        }
        if (COMBO_FIELD.equals(string2) || RADIO_FIELD.equals(string2)) {
            ArrayList<Choice> arrayList = new ArrayList<Choice>();
            String string7 = null;
            IXMLElement iXMLElement4 = iXMLElement.getFirstChildNamed(SPEC);
            IXMLElement iXMLElement5 = iXMLElement.getFirstChildNamed(DESCRIPTION);
            Vector<IXMLElement> vector = null;
            if (iXMLElement4 != null) {
                vector = iXMLElement4.getChildrenNamed(CHOICE);
            }
            if (iXMLElement5 != null) {
                string7 = iXMLElement5.getAttribute(TEXT);
            }
            for (int i = 0; i < vector.size(); ++i) {
                IXMLElement iXMLElement6 = vector.elementAt(i);
                arrayList.add(new Choice(iXMLElement6.getAttribute(TEXT), iXMLElement6.getAttribute(VALUE), iXMLElement6.getAttribute(SET)));
            }
            return new Input(string, null, arrayList, COMBO_FIELD, string7, -1);
        }
        System.out.println(string2 + " field collection not implemented");
        return null;
    }

    public class Choice {
        String strText;
        String strValue;
        String strSet;

        public Choice(String string, String string2, String string3) {
            this.strText = string;
            this.strValue = string2;
            this.strSet = string3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Input {
        String strVariableName;
        String strDefaultValue;
        List<Choice> listChoices;
        String strFieldType;
        String strText;
        int iSelectedChoice = -1;

        public Input(String string, String string2, List<Choice> list, String string3, String string4, int n) {
            this.strVariableName = string;
            this.strDefaultValue = string2;
            this.listChoices = list;
            this.strFieldType = string3;
            this.strText = string4;
            this.iSelectedChoice = n;
        }
    }
}

