/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.settings;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.DatabaseDriver;
import lu.tudor.santec.settings.SettingsPlugin;

public class DatabasePlugin
extends SettingsPlugin
implements Relocalizable,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger m_Logger = Logger.getLogger("lu.tudor.santec.settings.DatabasePlugin");
    private JPanel m_DriverPanel;
    private JLabel m_DriverDescription;
    private JComboBox m_DriverSelector;
    private JPanel m_ConnectionPanel;
    private JLabel m_ConnectionDescription;
    private JTextField m_DSN;
    private JTextField m_Username;
    private JPasswordField m_Password;
    private JButton m_TestConnection;
    private JLabel m_DriverLabel;
    private JLabel m_DSNLabel;
    private JLabel m_UsernameLabel;
    private JLabel m_PasswordLabel;
    private JLabel m_StatusMessage;
    private Vector m_DatabaseDrivers;
    private Hashtable m_DriverLookup;
    private DatabaseDriver m_DatabaseDriver;
    private int m_ConnectionStatus;
    public static final DatabaseDriver MYSQL = new DatabaseDriver("com.mysql.jdbc.Driver", "MySQL", "jdbc:mysql:[//[host][:port]/]database");
    public static final DatabaseDriver POSTGRESQL = new DatabaseDriver("org.postgresql.Driver", "PostgreSQL", "jdbc:postgresql:[//[host][:port]/]database");
    public static final DatabaseDriver HSQLDB = new DatabaseDriver("org.hsqldb.jdbcDriver", "HSQL Server", "jdbc:hsqldb:hsql:[//[host][:port]/]database");
    public static final DatabaseDriver ORACLE = new DatabaseDriver("oracle.jdbc.driver.OracleDriver", "Oracle Database", "jdbc:oracle:thin:@host:port[:oraclesid]");
    public static final int c_None = 0;
    public static final int c_Okay = 1;
    public static final int c_Failure = 2;

    public DatabasePlugin(String p_Name) {
        super(p_Name);
        this.setIcon(DatabasePlugin.getIconResource("icn_database"));
        this.setLabel(Translatrix.getTranslationString((String)"database.Label"));
        this.m_DatabaseDrivers = new Vector();
        this.m_DriverLookup = new Hashtable();
        this.m_DatabaseDriver = null;
        FormLayout l_Layout = new FormLayout("right:50dlu,5dlu,left:120dlu:grow", "center:pref,5dlu,center:pref");
        CellConstraints l_Constraints = new CellConstraints();
        this.m_DriverPanel = this.createSubPanel(Translatrix.getTranslationString((String)"database.DriverTitle"));
        this.m_DriverPanel.setLayout((LayoutManager)l_Layout);
        this.m_DriverDescription = new JLabel();
        this.m_DriverDescription.setText(Translatrix.getTranslationString((String)"database.DriverDescription"));
        this.m_DriverPanel.add((Component)this.m_DriverDescription, l_Constraints.xyw(1, 1, 3));
        this.m_DriverLabel = new JLabel(Translatrix.getTranslationString((String)"database.DriverLabel"));
        this.m_DriverSelector = new JComboBox();
        this.m_DriverSelector.addActionListener(this);
        this.m_DriverPanel.add((Component)this.m_DriverLabel, l_Constraints.xy(1, 3));
        this.m_DriverPanel.add((Component)this.m_DriverSelector, l_Constraints.xy(3, 3));
        this.addSubPanel(this.m_DriverPanel);
        l_Layout = new FormLayout("right:50dlu,5dlu,left:120dlu:grow", "center:pref,5dlu,center:pref,5dlu,center:pref,5dlu,center:pref,5dlu,center:pref,5dlu,center:pref");
        l_Constraints = new CellConstraints();
        this.m_ConnectionPanel = this.createSubPanel(Translatrix.getTranslationString((String)"database.ConnectionTitle"));
        this.m_ConnectionPanel.setLayout((LayoutManager)l_Layout);
        this.m_ConnectionDescription = new JLabel();
        this.m_ConnectionDescription.setText(Translatrix.getTranslationString((String)"database.Description"));
        this.m_ConnectionPanel.add((Component)this.m_ConnectionDescription, l_Constraints.xyw(1, 1, 3, "fill, center"));
        this.m_DSNLabel = new JLabel(Translatrix.getTranslationString((String)"database.DSNLabel"));
        this.m_DSN = new JTextField("");
        this.m_DSN.addActionListener(this);
        this.m_ConnectionPanel.add((Component)this.m_DSNLabel, l_Constraints.xy(1, 3));
        this.m_ConnectionPanel.add((Component)this.m_DSN, l_Constraints.xy(3, 3, "fill, center"));
        this.m_UsernameLabel = new JLabel(Translatrix.getTranslationString((String)"database.UsernameLabel"));
        this.m_Username = new JTextField("");
        this.m_ConnectionPanel.add((Component)this.m_UsernameLabel, l_Constraints.xy(1, 5));
        this.m_ConnectionPanel.add((Component)this.m_Username, l_Constraints.xy(3, 5, "fill, center"));
        this.m_PasswordLabel = new JLabel(Translatrix.getTranslationString((String)"database.PasswordLabel"));
        this.m_Password = new JPasswordField("");
        this.m_ConnectionPanel.add((Component)this.m_PasswordLabel, l_Constraints.xy(1, 7));
        this.m_ConnectionPanel.add((Component)this.m_Password, l_Constraints.xy(3, 7, "fill, center"));
        this.m_TestConnection = new JButton(Translatrix.getTranslationString((String)"database.TestButton"));
        this.m_TestConnection.addActionListener(this);
        this.m_ConnectionPanel.add((Component)this.m_TestConnection, l_Constraints.xy(3, 9));
        this.m_ConnectionStatus = 0;
        this.m_StatusMessage = new JLabel();
        this.m_StatusMessage.setVerticalTextPosition(1);
        this.m_ConnectionPanel.add((Component)this.m_StatusMessage, l_Constraints.xy(3, 11));
        this.addSubPanel(this.m_ConnectionPanel);
        this.setStationary("Driver", HSQLDB);
        this.setStationary("DSN", HSQLDB.getDSNTemplate());
        this.setStationary("Username", new String("none"));
        this.setStationary("Password", new String("none"));
    }

    private void setDatabaseDriver(DatabaseDriver p_Driver) {
        if (p_Driver == null) {
            return;
        }
        this.m_DatabaseDriver = p_Driver;
        this.m_DSN.setText(p_Driver.getDSNTemplate());
    }

    public void revertToDefaults() {
        this.resetValueChanged();
        this.setValue("Driver", this.getDefault("Driver"));
        this.setValue("DSN", this.getDefault("DSN"));
        this.setValue("Username", this.getDefault("Username"));
        this.setValue("Password", this.getDefault("Password"));
        this.reflectSettings();
        super.revertToDefaults();
    }

    public void updateSettings() {
        this.resetValueChanged();
        this.setValue("Driver", this.m_DatabaseDriver);
        this.setValue("DSN", this.m_DSN.getText());
        this.setValue("Username", this.m_Username.getText());
        this.setValue("Password", new String(this.m_Password.getPassword()));
        super.updateSettings();
    }

    public void reflectSettings() {
        this.m_DatabaseDriver = (DatabaseDriver)this.getValue("Driver");
        this.m_DriverSelector.setSelectedItem(this.m_DatabaseDriver.getDriverName());
        this.m_DSN.setText((String)this.getValue("DSN"));
        this.m_Username.setText((String)this.getValue("Username"));
        this.m_Password.setText((String)this.getValue("Password"));
        super.reflectSettings();
    }

    public void addDatabaseDriver(DatabaseDriver p_Driver) {
        if (p_Driver == null) {
            return;
        }
        this.m_DatabaseDrivers.add(p_Driver);
        this.m_DriverLookup.put(p_Driver.getDriverName(), new Integer(this.m_DatabaseDrivers.size() - 1));
        this.m_DriverSelector.addItem(p_Driver.getDriverName());
        if (this.m_DatabaseDrivers.size() >= 2) {
            this.m_DriverPanel.setVisible(true);
        }
    }

    public boolean testConnection() {
        Connection l_Connection = null;
        if (this.m_DatabaseDriver != null) {
            try {
                Class.forName(this.m_DatabaseDriver.getDriverClass()).newInstance();
                l_Connection = DriverManager.getConnection(this.m_DSN.getText(), this.m_Username.getText(), new String(this.m_Password.getPassword()));
                l_Connection.close();
                this.m_ConnectionStatus = 1;
                this.m_StatusMessage.setIcon(DatabasePlugin.getIconResource("icn_okay"));
                this.m_StatusMessage.setText(Translatrix.getTranslationString((String)"database.StatusOkay"));
                return true;
            }
            catch (SQLException p_Exception) {
                m_Logger.log(Level.WARNING, "Database connection not working: ", p_Exception);
                this.m_ConnectionStatus = 2;
                this.m_StatusMessage.setIcon(DatabasePlugin.getIconResource("icn_failed"));
                this.m_StatusMessage.setText(Translatrix.getTranslationString((String)"database.StatusFailed"));
                return false;
            }
            catch (Exception p_Exception) {
                m_Logger.log(Level.WARNING, "Database connection not working: ", p_Exception);
                this.m_ConnectionStatus = 2;
                this.m_StatusMessage.setIcon(DatabasePlugin.getIconResource("icn_failed"));
                this.m_StatusMessage.setText(Translatrix.getTranslationString((String)"database.StatusFailed"));
                return false;
            }
        }
        return false;
    }

    public void relocalize() {
        super.relocalize();
        this.setLabel(Translatrix.getTranslationString((String)"database.PluginLabel"));
        this.setSubPanelTitle(this.m_DriverPanel, Translatrix.getTranslationString((String)"database.DriverTitle"));
        this.m_DriverDescription.setText(Translatrix.getTranslationString((String)"database.DriverDescription"));
        this.m_DriverLabel.setText(Translatrix.getTranslationString((String)"database.DriverLabel"));
        this.setSubPanelTitle(this.m_ConnectionPanel, Translatrix.getTranslationString((String)"database.DriverTitle"));
        this.m_ConnectionDescription.setText(Translatrix.getTranslationString((String)"database.Description"));
        this.m_DSNLabel.setText(Translatrix.getTranslationString((String)"database.DSNLabel"));
        this.m_UsernameLabel.setText(Translatrix.getTranslationString((String)"database.UsernameLabel"));
        this.m_PasswordLabel.setText(Translatrix.getTranslationString((String)"database.PasswordLabel"));
        this.m_TestConnection.setText(Translatrix.getTranslationString((String)"database.TestButton"));
        switch (this.m_ConnectionStatus) {
            case 0: {
                break;
            }
            case 1: {
                this.m_StatusMessage.setText(Translatrix.getTranslationString((String)"database.StatusOkay"));
                break;
            }
            case 2: {
                this.m_StatusMessage.setText(Translatrix.getTranslationString((String)"database.StatusFailed"));
            }
        }
    }

    public void actionPerformed(ActionEvent p_ActionEvent) {
        String l_DriverName;
        if (p_ActionEvent.getSource() == this.m_TestConnection) {
            this.testConnection();
        }
        if (p_ActionEvent.getSource() == this.m_DriverSelector && this.m_DriverLookup.containsKey(l_DriverName = (String)this.m_DriverSelector.getSelectedItem())) {
            int l_DriverIndex = (Integer)this.m_DriverLookup.get(l_DriverName);
            this.setDatabaseDriver((DatabaseDriver)this.m_DatabaseDrivers.elementAt(l_DriverIndex));
        }
        if (p_ActionEvent.getSource() == this.m_DSN && this.m_DSN.getText().length() == 0 && this.m_DatabaseDriver != null) {
            this.m_DSN.setText(this.m_DatabaseDriver.getDSNTemplate());
        }
    }
}

