/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.jre.JRELogger;

public abstract class Logger {
    public static final String LOGGER_LOGGING_IMPLEMENTATION = "lu.luxtrust.logging.impl";
    public static final String LOGGER_LOGGING_CONFIGURATION = "lu.luxtrust.logging.conf";
    public static final String LOGGER_LOGGING_CUSTOM_CONFIGURATION = "lu.luxtrust.logging.conf.custom";
    public static String LOGGER_DEFAULT_IMPLEMENTATION = "lu.luxtrust.logging.jre.JRELogger";
    public static String LOGGER_DEFAULT_CONF_PATH = "LuxTrust_Logging.properties";
    static /* synthetic */ Class class$0;

    private static Class createDefaultLoggerImplementation() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        File configFile;
        String implementation = null;
        String configPath = null;
        configPath = System.getProperty(LOGGER_LOGGING_CONFIGURATION);
        if (configPath == null || configPath.equals("")) {
            configPath = LOGGER_DEFAULT_CONF_PATH;
        }
        if ((configFile = new File(configPath)).exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(configFile));
                implementation = properties.getProperty(LOGGER_LOGGING_IMPLEMENTATION);
                System.setProperty(LOGGER_LOGGING_CONFIGURATION, configPath);
                String customConfigPath = properties.getProperty(LOGGER_LOGGING_CUSTOM_CONFIGURATION);
                if (customConfigPath != null && !customConfigPath.equals("")) {
                    System.setProperty(LOGGER_LOGGING_CUSTOM_CONFIGURATION, customConfigPath);
                }
            }
            catch (FileNotFoundException e) {
                implementation = null;
                System.setProperty(LOGGER_LOGGING_CONFIGURATION, null);
            }
            catch (IOException e) {
                implementation = null;
                System.setProperty(LOGGER_LOGGING_CONFIGURATION, null);
            }
        } else {
            implementation = null;
        }
        if (implementation == null && ((implementation = System.getProperty(LOGGER_LOGGING_IMPLEMENTATION)) == null || implementation.equals(""))) {
            implementation = LOGGER_DEFAULT_IMPLEMENTATION;
        }
        Class<?> theClass = null;
        theClass = Class.forName(implementation, true, Thread.currentThread().getContextClassLoader());
        return theClass;
    }

    private static Log createDefaultLogImplementation() {
        return JRELogger.getLogger(LOGGER_DEFAULT_IMPLEMENTATION);
    }

    public static Log getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Log getLogger(String className) {
        try {
            Class logger = Logger.createDefaultLoggerImplementation();
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method method = logger.getMethod("getLogger", classArray);
            Object _obj = method.invoke(null, className);
            if (_obj instanceof Log) {
                return (Log)_obj;
            }
            return Logger.createDefaultLogImplementation();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Logger.createDefaultLogImplementation();
        }
    }
}

