/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.callback;

import java.util.Iterator;
import java.util.List;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;

public class CallbackClient {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;
    private Client remotingClient;
    private Connector callbackServerConnector;

    public void createRemotingClient(String locatorURI) throws Exception {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        System.out.println("Calling remoting server with locator uri of: " + locatorURI);
        this.remotingClient = new Client(locator);
    }

    public void makeInvocation() throws Throwable {
        Object response = this.remotingClient.invoke("Do something", null);
        System.out.println("Invocation response: " + response);
    }

    public void testPullCallback() throws Throwable {
        CallbackHandler callbackHandler = new CallbackHandler();
        this.remotingClient.addListener(callbackHandler);
        Thread.currentThread();
        Thread.sleep(2000L);
        this.makeInvocation();
        List callbacks = this.remotingClient.getCallbacks(callbackHandler);
        Iterator itr = callbacks.iterator();
        while (itr.hasNext()) {
            Callback callbackObject = (Callback)itr.next();
            System.out.println("Pull Callback value = " + callbackObject.getCallbackObject());
        }
        this.remotingClient.removeListener(callbackHandler);
    }

    public void testPushCallback() throws Throwable {
        String callbackLocatorURI = transport + "://" + host + ":" + (port + 1);
        InvokerLocator callbackLocator = new InvokerLocator(callbackLocatorURI);
        this.setupServer(callbackLocator);
        CallbackHandler callbackHandler = new CallbackHandler();
        String callbackHandleObject = "myCallbackHandleObject";
        this.remotingClient.addListener(callbackHandler, callbackLocator, callbackHandleObject);
        Thread.sleep(2000L);
        this.remotingClient.removeListener(callbackHandler);
        this.callbackServerConnector.stop();
        this.callbackServerConnector.destroy();
    }

    public void setupServer(InvokerLocator locator) throws Exception {
        System.out.println("Starting remoting server with locator uri of: " + locator);
        this.callbackServerConnector = new Connector();
        this.callbackServerConnector.setInvokerLocator(locator.getLocatorURI());
        this.callbackServerConnector.start();
    }

    public static void main(String[] args) {
        if (args != null && args.length == 2) {
            transport = args[0];
            port = Integer.parseInt(args[1]);
        }
        String locatorURI = transport + "://" + host + ":" + port;
        CallbackClient client = new CallbackClient();
        try {
            client.createRemotingClient(locatorURI);
            client.testPullCallback();
            client.testPushCallback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public class CallbackHandler
    implements InvokerCallbackHandler {
        public void handleCallback(Callback callback) throws HandleCallbackException {
            System.out.println("Received push callback.");
            System.out.println("Received callback value of: " + callback.getCallbackObject());
            System.out.println("Received callback handle object of: " + callback.getCallbackHandleObject());
            System.out.println("Received callback server invoker of: " + callback.getServerLocator());
        }
    }
}

