/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.NameValuePair;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.web.WebServerInvoker;
import org.jboss.remoting.transport.web.WebUtil;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.threadpool.ThreadPoolMBean;

public class HTTPServerInvoker
extends WebServerInvoker
implements Runnable {
    public static final String MAX_NUM_HTTP_THREADS_KEY = "maxNumThreadsHTTP";
    public static final String HTTP_THREAD_POOL_CLASS_KEY = "HTTPThreadPool";
    public static final String HTTP_KEEP_ALIVE_TIMEOUT_KEY = "keepAliveTimeout";
    private String httpThreadPoolClass = null;
    private static int BACKLOG_DEFAULT = 1000;
    private static int MAX_POOL_SIZE_DEFAULT = 100;
    private ServerSocket serverSocket = null;
    private boolean running = false;
    private ThreadPool httpThreadPool;
    private int maxPoolSize = MAX_POOL_SIZE_DEFAULT;
    protected int backlog = BACKLOG_DEFAULT;
    protected int keepAliveTimeout = 15000;
    public static String HTML = "text/html";
    public static String PLAIN = "text/plain";
    public static String SOAP = "application/soap+xml";
    static /* synthetic */ Class class$org$jboss$util$threadpool$ThreadPoolMBean;

    public HTTPServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public HTTPServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    protected void setup() throws Exception {
        super.setup();
        Map config = this.getConfiguration();
        String maxNumOfThreads = (String)config.get(MAX_NUM_HTTP_THREADS_KEY);
        if (maxNumOfThreads != null && maxNumOfThreads.length() > 0) {
            try {
                this.maxPoolSize = Integer.parseInt(maxNumOfThreads);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Can not convert max number of threads value (" + maxNumOfThreads + ") into a number."));
            }
        }
        this.httpThreadPoolClass = (String)config.get(HTTP_THREAD_POOL_CLASS_KEY);
        String keepAliveTimeoutValue = (String)config.get(HTTP_KEEP_ALIVE_TIMEOUT_KEY);
        if (keepAliveTimeoutValue != null && keepAliveTimeoutValue.length() > 0) {
            try {
                this.keepAliveTimeout = Integer.parseInt(keepAliveTimeoutValue);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Can not convert keep alive timeout value (" + keepAliveTimeoutValue + ") into a number."));
            }
        }
    }

    public void setMaxNumberOfHTTPThreads(int numOfThreads) {
        this.maxPoolSize = numOfThreads;
    }

    public int getMaxNumberOfHTTPThreads() {
        return this.maxPoolSize;
    }

    public ThreadPool getHTTPThreadPool() {
        if (this.httpThreadPool == null) {
            if (this.httpThreadPoolClass == null || this.httpThreadPoolClass.length() == 0) {
                BasicThreadPool basicthreadpool = new BasicThreadPool("JBossRemoting - HTTP Server Invoker");
                basicthreadpool.setBlockingMode(BlockingMode.RUN);
                basicthreadpool.setMaximumPoolSize(this.maxPoolSize);
                this.httpThreadPool = basicthreadpool;
            } else {
                boolean isObjName = false;
                try {
                    ObjectName objName = new ObjectName(this.httpThreadPoolClass);
                    this.httpThreadPool = this.createThreadPoolProxy(objName);
                    isObjName = true;
                }
                catch (MalformedObjectNameException e) {
                    this.log.debug((Object)"Thread pool class supplied is not an object name.");
                }
                if (!isObjName) {
                    try {
                        this.httpThreadPool = (ThreadPool)Class.forName(this.httpThreadPoolClass, false, this.getClassLoader()).newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error loading instance of ThreadPool based on class name: " + this.httpThreadPoolClass);
                    }
                }
            }
        }
        return this.httpThreadPool;
    }

    private ThreadPool createThreadPoolProxy(ObjectName objName) {
        MBeanServer server = this.getMBeanServer();
        if (server == null) {
            throw new RuntimeException("Can not register MBean ThreadPool as the ServerInvoker has not been registered with a MBeanServer.");
        }
        ThreadPoolMBean poolMBean = (ThreadPoolMBean)MBeanServerInvocationHandler.newProxyInstance(server, objName, class$org$jboss$util$threadpool$ThreadPoolMBean == null ? (class$org$jboss$util$threadpool$ThreadPoolMBean = HTTPServerInvoker.class$("org.jboss.util.threadpool.ThreadPoolMBean")) : class$org$jboss$util$threadpool$ThreadPoolMBean, false);
        ThreadPool pool = poolMBean.getInstance();
        return pool;
    }

    public void setHTTPThreadPool(ThreadPool pool) {
        this.httpThreadPool = pool;
    }

    public void start() throws IOException {
        if (!this.running) {
            try {
                ThreadPool httpThreadPool = this.getHTTPThreadPool();
                InetAddress bindAddress = InetAddress.getByName(this.getServerBindAddress());
                this.serverSocket = this.createServerSocket(this.getServerBindPort(), this.backlog, bindAddress);
                for (int t = 0; t < this.maxPoolSize; ++t) {
                    httpThreadPool.run((Runnable)this);
                }
                this.running = true;
            }
            catch (IOException e) {
                this.log.error((Object)("Error starting ServerSocket.  Bind port: " + this.getServerBindPort() + ", bind address: " + this.getServerBindAddress()));
                throw e;
            }
        }
        super.start();
    }

    protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress) throws IOException {
        return new ServerSocket(serverBindPort, backlog, bindAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block25: {
            try {
                Exception e2222;
                FilterOutputStream dataOutput;
                BufferedInputStream dataInput;
                Socket socket;
                block26: {
                    socket = this.serverSocket.accept();
                    dataInput = null;
                    dataOutput = null;
                    if (socket == null) break block25;
                    this.httpThreadPool.run((Runnable)this);
                    boolean keepAlive = true;
                    socket.setKeepAlive(true);
                    socket.setSoTimeout(this.keepAliveTimeout);
                    DataInputStream realdataInput = new DataInputStream(socket.getInputStream());
                    DataOutputStream realdataOutput = new DataOutputStream(socket.getOutputStream());
                    while (keepAlive) {
                        dataOutput = new BufferedOutputStream(realdataOutput, 512);
                        dataInput = new BufferedInputStream(realdataInput, 512);
                        keepAlive = this.processRequest(dataInput, dataOutput);
                    }
                    Object var8_9 = null;
                    if (dataInput == null) break block26;
                    try {
                        dataInput.close();
                    }
                    catch (Exception e2222) {
                        this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                    }
                }
                if (dataOutput != null) {
                    try {
                        dataOutput.close();
                    }
                    catch (Exception e2222) {
                        this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                    }
                }
                try {
                    socket.close();
                }
                catch (Exception e2222) {
                    this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                }
                break block25;
                {
                    catch (Throwable thr) {
                        if (this.running) {
                            this.log.error((Object)"Error processing incoming request.", thr);
                        }
                        Object var8_10 = null;
                        if (dataInput != null) {
                            try {
                                dataInput.close();
                            }
                            catch (Exception e2222) {
                                this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                            }
                        }
                        if (dataOutput != null) {
                            try {
                                dataOutput.close();
                            }
                            catch (Exception e2222) {
                                this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                            }
                        }
                        try {
                            socket.close();
                        }
                        catch (Exception e2222) {
                            this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (dataInput != null) {
                        try {
                            dataInput.close();
                        }
                        catch (Exception e2222) {
                            this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                        }
                    }
                    if (dataOutput != null) {
                        try {
                            dataOutput.close();
                        }
                        catch (Exception e2222) {
                            this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                        }
                    }
                    try {
                        socket.close();
                    }
                    catch (Exception e2222) {
                        this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                    }
                    throw throwable;
                }
            }
            catch (Throwable thr) {
                if (!this.running) break block25;
                this.log.error((Object)"Error processing incoming request.", thr);
            }
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.maxPoolSize = 0;
            try {
                this.httpThreadPool.stop(false);
                this.httpThreadPool.waitForTasks(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                }
                this.serverSocket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.stop();
        this.log.debug((Object)"HTTPServerInvoker stopped.");
    }

    private boolean processRequest(FilterInputStream dataInput, FilterOutputStream dataOutput) {
        boolean keepAlive = true;
        try {
            Object response = null;
            boolean isError = false;
            String requestContentType = null;
            String methodType = null;
            String path = null;
            String httpVersion = null;
            InvocationRequest request = null;
            try {
                UnMarshaller unmarshaller;
                Object obj;
                int ch;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                while ((ch = dataInput.read()) >= 0) {
                    buffer.write(ch);
                    if (ch != 10) continue;
                }
                byte[] firstLineRaw = buffer.toByteArray();
                buffer.close();
                if (firstLineRaw[firstLineRaw.length - 2] != 13) {
                    this.log.error((Object)"Error processing first line.  Should have ended in \r\n, but did not");
                    throw new RuntimeException("Error processing HTTP request type.  First line of request is invalid.");
                }
                String firstLine = new String(firstLineRaw).trim();
                int startIndex = 0;
                int endIndex = firstLine.indexOf(32);
                methodType = firstLine.substring(startIndex, endIndex);
                startIndex = endIndex + 1;
                endIndex = firstLine.indexOf(32, startIndex);
                path = firstLine.substring(startIndex, endIndex);
                startIndex = endIndex + 1;
                httpVersion = firstLine.substring(startIndex);
                HashMap<String, String> metadata = new HashMap<String, String>();
                Header[] headers = HttpParser.parseHeaders((InputStream)dataInput);
                for (int x = 0; x < headers.length; ++x) {
                    String headerName = headers[x].getName();
                    String headerValue = headers[x].getValue();
                    metadata.put(headerName, headerValue);
                    if (!"Content-Type".equalsIgnoreCase(headerName)) continue;
                    requestContentType = headers[x].getValue();
                }
                metadata.put("MethodType", methodType);
                metadata.put("Path", path);
                metadata.put("HttpVersion", httpVersion);
                keepAlive = this.checkForConnecctionClose(headers);
                if (methodType.equals("OPTIONS")) {
                    request = this.createNewInvocationRequest(metadata, null);
                    response = this.invoke(request);
                    Map responseMap = request.getReturnPayload();
                    dataOutput.write("HTTP/1.1 ".getBytes());
                    String status = "200 OK";
                    dataOutput.write(status.getBytes());
                    String server = "\r\nServer: JBoss Remoting HTTP Server/1.4.6.GA (Wormer)";
                    dataOutput.write(server.getBytes());
                    String date = "\r\nDate: " + new Date();
                    dataOutput.write(date.getBytes());
                    String contentLength = "\r\nContent-Length: 0";
                    dataOutput.write(contentLength.getBytes());
                    if (responseMap != null) {
                        Set entries = responseMap.entrySet();
                        Iterator itr = entries.iterator();
                        while (itr.hasNext()) {
                            Map.Entry entry = itr.next();
                            String entryString = "\r\n" + entry.getKey() + ": " + entry.getValue();
                            dataOutput.write(entryString.getBytes());
                        }
                    }
                    String close = "\r\nConnection: close";
                    dataOutput.write(close.getBytes());
                    dataOutput.write("\r\n\r\n".getBytes());
                    dataOutput.flush();
                    return keepAlive;
                }
                request = methodType.equals("GET") || methodType.equals("HEAD") ? this.createNewInvocationRequest(metadata, null) : ((obj = (unmarshaller = this.getUnMarshaller()).read(dataInput, metadata)) instanceof InvocationRequest ? (InvocationRequest)obj : (WebUtil.isBinary(requestContentType) ? this.getInvocationRequest(metadata, obj) : this.createNewInvocationRequest(metadata, obj)));
                try {
                    response = this.invoke(request);
                }
                catch (Throwable ex) {
                    this.log.debug((Object)"Error thrown calling invoke on server invoker.", ex);
                    response = ex;
                    isError = true;
                }
            }
            catch (Throwable thr) {
                this.log.debug((Object)"Error thrown processing request.  Probably error with processing headers.", thr);
                if (thr instanceof SocketException) {
                    this.log.error((Object)"Error processing on socket.", thr);
                    keepAlive = false;
                    return keepAlive;
                }
                response = thr instanceof Exception ? (Exception)thr : new Exception(thr);
                isError = true;
            }
            if (dataOutput != null) {
                String contentType;
                String handlerStatus;
                Map responseMap = null;
                if (request != null) {
                    responseMap = request.getReturnPayload();
                }
                if (response == null) {
                    dataOutput.write("HTTP/1.1 ".getBytes());
                    String status = "204 No Content";
                    if (responseMap != null && (handlerStatus = (String)responseMap.get("ResponseCode")) != null) {
                        status = handlerStatus;
                    }
                    dataOutput.write(status.getBytes());
                    contentType = "\r\nContent-Type: text/html";
                    dataOutput.write(contentType.getBytes());
                    String contentLength = "\r\nContent-Length: 0";
                    dataOutput.write(contentLength.getBytes());
                    if (responseMap != null) {
                        Set entries = responseMap.entrySet();
                        Iterator itr = entries.iterator();
                        while (itr.hasNext()) {
                            Map.Entry entry = itr.next();
                            String entryString = "\r\n" + entry.getKey() + ": " + entry.getValue();
                            dataOutput.write(entryString.getBytes());
                        }
                    }
                    dataOutput.write("\r\n\r\n".getBytes());
                    dataOutput.flush();
                } else {
                    dataOutput.write("HTTP/1.1 ".getBytes());
                    String status = null;
                    if (isError) {
                        status = "500 JBoss Remoting: Error occurred within target application.";
                    } else {
                        status = "200 OK";
                        if (responseMap != null && (handlerStatus = (String)responseMap.get("ResponseCode")) != null) {
                            status = handlerStatus;
                        }
                    }
                    dataOutput.write(status.getBytes());
                    contentType = "\r\nContent-Type: " + requestContentType;
                    dataOutput.write(contentType.getBytes());
                    int iContentLength = this.getContentLength(response);
                    String contentLength = "\r\nContent-Length: " + iContentLength;
                    dataOutput.write(contentLength.getBytes());
                    if (responseMap != null) {
                        Set entries = responseMap.entrySet();
                        Iterator itr = entries.iterator();
                        while (itr.hasNext()) {
                            Map.Entry entry = itr.next();
                            String entryString = "\r\n" + entry.getKey() + ": " + entry.getValue();
                            dataOutput.write(entryString.getBytes());
                        }
                    }
                    dataOutput.write("\r\n\r\n".getBytes());
                    if (methodType != null && !methodType.equals("HEAD")) {
                        Marshaller marshaller = this.getMarshaller();
                        marshaller.write(response, dataOutput);
                    }
                }
            } else if (isError) {
                this.log.warn((Object)"Can not send error response due to output stream being null (due to previous error).");
            } else {
                this.log.error((Object)"Can not send response due to output stream being null (even though there was not a previous error encountered).");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error processing client request.", (Throwable)e);
            keepAlive = false;
        }
        return keepAlive;
    }

    private boolean checkForConnecctionClose(Header[] headers) {
        boolean keepAlive = true;
        if (headers != null) {
            block2: for (int x = 0; x < headers.length; ++x) {
                String name = headers[x].getName();
                if (!"Connection".equals(name)) continue;
                String value = headers[x].getValue();
                if (value != null) {
                    if (!"close".equalsIgnoreCase(value)) continue;
                    keepAlive = false;
                    break;
                }
                try {
                    HeaderElement[] hdrElements = headers[x].getValues();
                    if (hdrElements == null) continue;
                    for (int i = 0; i < hdrElements.length; ++i) {
                        NameValuePair pair = hdrElements[i].getParameterByName("Connection");
                        if (!"close".equalsIgnoreCase(pair.getValue())) continue;
                        keepAlive = false;
                        continue block2;
                    }
                    continue;
                }
                catch (HttpException e) {
                    e.printStackTrace();
                }
            }
        }
        return keepAlive;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

