/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex.utility;

import java.io.ByteArrayOutputStream;

public class ShrinkableByteArrayOutputStream
extends ByteArrayOutputStream {
    private static int MIN_LENGTH = 1024;
    private int used = 0;
    private int nextUsed = 0;
    private int bytesReturned = 0;

    public ShrinkableByteArrayOutputStream() {
        super(MIN_LENGTH);
    }

    public int available() {
        return this.count - this.nextUsed;
    }

    public int bytesReturned() {
        return this.bytesReturned;
    }

    public int start() {
        return this.used;
    }

    public synchronized byte[] toByteArray(int length) {
        this.used = this.nextUsed;
        int currentLength = this.buf.length;
        int quarterLength = currentLength >> 2;
        if (currentLength > MIN_LENGTH && currentLength - this.used <= quarterLength) {
            byte[] newbuf = new byte[currentLength >> 1];
            System.arraycopy(this.buf, this.used, newbuf, 0, this.available());
            this.buf = newbuf;
            this.count -= this.used;
            this.used = 0;
        }
        this.bytesReturned = Math.min(this.count - this.used, length);
        this.nextUsed = this.used + this.bytesReturned;
        return this.buf;
    }

    public synchronized void write(int b) {
        if (this.count == this.buf.length && this.used > this.buf.length >> 1) {
            System.arraycopy(this.buf, this.used, this.buf, 0, this.count - this.used);
            this.nextUsed -= this.used;
            this.count -= this.used;
            this.used = 0;
        }
        super.write(b);
    }

    public synchronized void write(byte[] b, int off, int len) {
        if (this.count + len > this.buf.length && this.used > this.buf.length >> 1) {
            System.arraycopy(this.buf, this.used, this.buf, 0, this.count - this.used);
            this.nextUsed -= this.used;
            this.count -= this.used;
            this.used = 0;
        }
        super.write(b, off, len);
    }

    protected int getCount() {
        return super.size();
    }

    protected int getLength() {
        return this.buf.length;
    }

    protected int getNextUsed() {
        return this.nextUsed;
    }

    protected int getUsed() {
        return this.used;
    }
}

