/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.server.RMIServerSocketFactory;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;

public class RemotingRMIServerSocketFactory
implements RMIServerSocketFactory,
Serializable {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$rmi$RemotingRMIServerSocketFactory == null ? (class$org$jboss$remoting$transport$rmi$RemotingRMIServerSocketFactory = RemotingRMIServerSocketFactory.class$("org.jboss.remoting.transport.rmi.RemotingRMIServerSocketFactory")) : class$org$jboss$remoting$transport$rmi$RemotingRMIServerSocketFactory));
    private ServerSocketFactory serverSocketFactory;
    private int backlog;
    private InetAddress bindAddress;
    private int timeout;
    static /* synthetic */ Class class$org$jboss$remoting$transport$rmi$RemotingRMIServerSocketFactory;

    public RemotingRMIServerSocketFactory(String bindHost) throws UnknownHostException {
        this(null, -1, bindHost);
    }

    public RemotingRMIServerSocketFactory(int backlog, String bindHost) throws UnknownHostException {
        this(null, backlog, bindHost);
    }

    public RemotingRMIServerSocketFactory(ServerSocketFactory serverSocketFactory, int backlog, String bindHost) throws UnknownHostException {
        this(serverSocketFactory, backlog, bindHost, 60000);
    }

    public RemotingRMIServerSocketFactory(ServerSocketFactory serverSocketFactory, int backlog, String bindHost, int timeout) throws UnknownHostException {
        log.info((Object)("bind host: " + bindHost));
        this.serverSocketFactory = serverSocketFactory;
        this.backlog = backlog;
        this.bindAddress = InetAddress.getByName(bindHost);
        this.timeout = timeout;
    }

    public RemotingRMIServerSocketFactory(String bindHost, int timeout) throws UnknownHostException {
        this(null, -1, bindHost, timeout);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket svrSocket = null;
        svrSocket = this.serverSocketFactory != null ? this.serverSocketFactory.createServerSocket(port, this.backlog, this.bindAddress) : new ServerSocket(port, this.backlog, this.bindAddress);
        svrSocket.setSoTimeout(this.timeout);
        return svrSocket;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemotingRMIServerSocketFactory)) {
            return false;
        }
        RemotingRMIServerSocketFactory ssf = (RemotingRMIServerSocketFactory)o;
        if (this.serverSocketFactory != null) {
            return ssf.serverSocketFactory != null && this.serverSocketFactory.equals(ssf.serverSocketFactory) && this.backlog == ssf.backlog && this.bindAddress.equals(ssf.bindAddress);
        }
        return ssf.serverSocketFactory == null && this.backlog == ssf.backlog && this.bindAddress.equals(ssf.bindAddress);
    }

    public int hashCode() {
        if (this.serverSocketFactory != null) {
            return this.serverSocketFactory.hashCode() * this.backlog * this.bindAddress.hashCode();
        }
        return this.backlog * this.bindAddress.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

