/*
 * Decompiled with CFR 0.152.
 */
package com.netghost.perkup;

import com.netghost.perkup.Notification;
import com.netghost.perkup.NotificationHandler;
import com.netghost.perkup.swing.RenderingComponent;
import com.netghost.perkup.swing.SimpleTile;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class OverlayNotifier
implements NotificationHandler {
    RootPaneContainer displayPane = null;
    RenderingComponent renderer;
    SimpleTile popup;
    private long displayTime = 2000L;
    Icon defaultIcon;

    public OverlayNotifier(RootPaneContainer mainWindow) {
        this.displayPane = mainWindow;
    }

    public OverlayNotifier(JComponent component) {
        Component parent = SwingUtilities.getRoot(component);
        if (parent instanceof RootPaneContainer) {
            this.displayPane = (RootPaneContainer)((Object)parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notifcation) {
        this.getPopup().setText(notifcation.getMessage());
        this.getPopup().setDescription(notifcation.getDescription());
        Icon icon = notifcation.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        this.getPopup().setIcon(icon);
        try {
            this.displayPane.setGlassPane(this.getRenderer());
            this.displayPane.getGlassPane().setVisible(true);
            Thread.sleep(this.displayTime);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.displayPane.getGlassPane().setVisible(false);
        }
    }

    public RenderingComponent getRenderer() {
        if (this.renderer == null) {
            this.renderer = new RenderingComponent(this.getPopup());
        }
        return this.renderer;
    }

    public SimpleTile getPopup() {
        if (this.popup == null) {
            this.popup = new SimpleTile();
            this.popup.setSize(156, 64);
            this.popup.setOpaque(true);
            this.popup.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        return this.popup;
    }

    public void setPopup(SimpleTile popup) {
        this.popup = popup;
    }

    public long getDisplayTime() {
        return this.displayTime;
    }

    public void setDisplayTime(long displayTime) {
        this.displayTime = displayTime;
    }

    public Icon getDefaultIcon() {
        if (this.defaultIcon == null) {
            this.defaultIcon = new ImageIcon(this.getClass().getResource("/info_big.png"));
        }
        return this.defaultIcon;
    }

    public void setDefaultIcon(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }
}

