/*
 * Decompiled with CFR 0.152.
 */
package com.netghost.perkup.demo;

import com.netghost.perkup.AcceleratingSlider;
import com.netghost.perkup.DefaultNotificationHandler;
import com.netghost.perkup.Notifier;
import com.netghost.perkup.WindowSlider;
import com.netghost.perkup.demo.GraphicsConfigRenderer;
import com.netghost.perkup.demo.NotificationDemo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DefaultNotificationDemo
implements NotificationDemo,
ActionListener,
ItemListener {
    Notifier cornerAlerter;
    WindowSlider slider = new AcceleratingSlider();
    JRadioButton northWest;
    JRadioButton northEast;
    JRadioButton southWest;
    JRadioButton southEast;
    ButtonGroup corners;
    JComboBox displayCombo;
    JPanel demoPanel;
    JPanel cornerChooser;
    JPanel displayChooser;

    public String getName() {
        return "Corner Popup";
    }

    public Notifier getNotifier() {
        if (this.cornerAlerter == null) {
            this.cornerAlerter = new Notifier();
            DefaultNotificationHandler handler = new DefaultNotificationHandler();
            handler.getWindowController().setPresenter(this.slider);
            this.cornerAlerter.setHandler(handler);
        }
        return this.cornerAlerter;
    }

    public JPanel getPanel() {
        if (this.demoPanel == null) {
            this.demoPanel = new JPanel();
            this.demoPanel.setLayout(new BorderLayout());
            this.demoPanel.add((Component)this.getDisplayChooser(), "North");
            this.demoPanel.add((Component)this.getCornerChooser(), "Center");
        }
        return this.demoPanel;
    }

    protected JPanel getCornerChooser() {
        if (this.cornerChooser == null) {
            this.cornerChooser = new JPanel(new BorderLayout());
            ImageIcon screenIcon = new ImageIcon(this.getClass().getResource("/display.png"));
            JLabel screen = new JLabel();
            screen.setIcon(screenIcon);
            screen.setHorizontalAlignment(0);
            this.cornerChooser.add((Component)screen, "Center");
            JPanel north = new JPanel();
            BoxLayout layout = new BoxLayout(north, 0);
            this.northWest = this.buildButton(0);
            north.add(this.northWest);
            north.add(Box.createHorizontalStrut(screenIcon.getIconWidth()));
            this.northEast = this.buildButton(1);
            north.add(this.northEast);
            this.cornerChooser.add((Component)north, "North");
            JPanel south = new JPanel();
            layout = new BoxLayout(south, 0);
            this.southWest = this.buildButton(2);
            south.add(this.southWest);
            south.add(Box.createHorizontalStrut(screenIcon.getIconWidth()));
            this.southEast = this.buildButton(3);
            south.add(this.southEast);
            this.cornerChooser.add((Component)south, "South");
        }
        return this.cornerChooser;
    }

    protected JPanel getDisplayChooser() {
        if (this.displayChooser == null) {
            this.displayChooser = new JPanel();
            JLabel label = new JLabel("Display");
            this.displayChooser.add(label);
            this.displayChooser.add(this.getDisplayCombo());
        }
        return this.displayChooser;
    }

    protected JRadioButton buildButton(int corner) {
        JRadioButton button = new JRadioButton();
        button.setActionCommand("" + corner);
        button.addActionListener(this);
        this.getCorners().add(button);
        if (corner == this.slider.getCorner()) {
            button.setSelected(true);
        }
        return button;
    }

    protected ButtonGroup getCorners() {
        if (this.corners == null) {
            this.corners = new ButtonGroup();
        }
        return this.corners;
    }

    protected JComboBox getDisplayCombo() {
        if (this.displayCombo == null) {
            DefaultComboBoxModel<GraphicsConfiguration> model = new DefaultComboBoxModel<GraphicsConfiguration>();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            GraphicsDevice defaultDevice = ge.getDefaultScreenDevice();
            int defaultIndex = 0;
            for (int j = 0; j < gs.length; ++j) {
                GraphicsDevice gd = gs[j];
                GraphicsConfiguration gc = gd.getDefaultConfiguration();
                model.addElement(gc);
                if (defaultDevice != gd) continue;
                defaultIndex = j;
            }
            this.displayCombo = new JComboBox(model);
            this.displayCombo.setSelectedIndex(defaultIndex);
            this.displayCombo.addItemListener(this);
            this.displayCombo.setRenderer(new GraphicsConfigRenderer());
        }
        return this.displayCombo;
    }

    public void actionPerformed(ActionEvent e) {
        String selected = this.corners.getSelection().getActionCommand();
        if (selected.length() == 1) {
            int corner = Integer.parseInt(selected);
            this.slider.setCorner(corner);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.displayCombo) {
            GraphicsConfiguration gc = (GraphicsConfiguration)this.displayCombo.getSelectedItem();
            this.slider.setGraphicsConfiguration(gc);
        }
    }
}

