/*
 * Decompiled with CFR 0.152.
 */
package com.netghost.perkup.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class SimpleTile
extends JPanel {
    public static final String DESCRIPTION = "description";
    public static final String ICON_VISIBLE = "iconVisible";
    public static final String TEXT = "text";
    public static final String ICON = "icon";
    private int iconHeightPadding = 2;
    private int iconWidthFactor = 4;
    private boolean showIcon = true;
    Dimension defaultSize = new Dimension(192, 48);
    private JTextArea description;
    private JLabel icon;
    private JLabel text;

    public SimpleTile(String text, Icon icon, String description) {
        this.initComponents();
        this.setText(text);
        this.setIcon(icon);
        this.setDescription(description);
    }

    public SimpleTile(String text, Icon icon) {
        this(text, icon, "");
    }

    public SimpleTile() {
        this("", null, "");
    }

    public void setText(String text) {
        String oldText = this.getText();
        this.text.setText(text);
        this.firePropertyChange(TEXT, oldText, text);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setDescription(String text) {
        String oldDescription = this.getDescription();
        this.description.setText(text);
        this.firePropertyChange(DESCRIPTION, oldDescription, text);
    }

    public String getDescription() {
        return this.description.getText();
    }

    public void setIcon(Icon icon) {
        Icon oldIcon = this.getIcon();
        this.icon.setIcon(icon);
        this.updateIconSize();
        this.firePropertyChange(ICON, oldIcon, icon);
    }

    protected void updateIconSize() {
        Icon i = this.icon.getIcon();
        if (i != null && this.showIcon) {
            Dimension d = new Dimension(i.getIconWidth(), i.getIconHeight());
            this.icon.setPreferredSize(d);
            this.icon.setMaximumSize(d);
        } else {
            this.icon.setPreferredSize(null);
        }
        this.invalidate();
    }

    public void setIconVisible(boolean visible) {
        boolean oldVis = this.showIcon;
        this.showIcon = visible;
        this.updateIconSize();
        this.firePropertyChange(ICON_VISIBLE, oldVis, visible);
    }

    public Icon getIcon() {
        return this.icon.getIcon();
    }

    public Dimension getPreferredSize() {
        Icon i = this.getIcon();
        Dimension d = i == null ? this.defaultSize : new Dimension(i.getIconWidth() * this.iconWidthFactor, i.getIconHeight() + this.iconHeightPadding);
        return d;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private void initComponents() {
        this.icon = new JLabel();
        this.text = new JLabel();
        this.text.setFont(this.text.getFont().deriveFont(1));
        this.description = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.icon.setAlignmentX(0.5f);
        this.icon.setMinimumSize(new Dimension(48, 48));
        this.icon.setPreferredSize(new Dimension(48, 48));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.icon, gridBagConstraints);
        this.text.setText("Text");
        this.text.setMinimumSize(new Dimension(32, 18));
        this.text.setPreferredSize(new Dimension(32, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.5;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.text, gridBagConstraints);
        this.description.setColumns(16);
        this.description.setEditable(false);
        this.description.setFont(new Font("SansSerif", 0, 10));
        this.description.setForeground(UIManager.getDefaults().getColor("Label.disabledForeground"));
        this.description.setLineWrap(true);
        this.description.setRows(2);
        this.description.setText("Description");
        this.description.setWrapStyleWord(true);
        this.description.setAutoscrolls(false);
        this.description.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.description, gridBagConstraints);
    }
}

