/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1NonStringObject;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class ASN1Enumerated
extends ASN1NonStringObject {
    private BigInteger value;

    public byte getTag() {
        return 10;
    }

    public ASN1Enumerated() {
    }

    public ASN1Enumerated(int val) {
        this.value = BigInteger.valueOf(val);
    }

    public ASN1Enumerated(BigInteger val) {
        this.value = val;
    }

    public void decodeValue(int tag, byte[] enc) throws ASN1Exception {
        if (enc.length == 0) {
            throw new ASN1Exception("Zero-length integer value");
        }
        this.value = new BigInteger(enc);
    }

    public void encodeValue(OutputStream out) throws ASN1Exception, IOException {
        out.write(this.value.toByteArray());
    }

    public int getInteger() throws ASN1Exception {
        return this.value.intValue();
    }

    public BigInteger getBigInteger() throws ASN1Exception {
        return this.value;
    }

    public byte[] toByteArray() throws ASN1Exception {
        return this.value.toByteArray();
    }

    public String toString() {
        return this.value.toString();
    }

    public void set(BigInteger val) {
        this.value = val;
    }

    public void set(int val) {
        this.value = BigInteger.valueOf(val);
    }
}

