/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1NonStringObject;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class ASN1Integer
extends ASN1NonStringObject {
    private BigInteger value;

    public byte getTag() {
        return 2;
    }

    public ASN1Integer() {
    }

    public ASN1Integer(int val) {
        this.value = BigInteger.valueOf(val);
    }

    public ASN1Integer(BigInteger val) {
        this.value = val;
    }

    public void setUnsignedValueMSB(byte[] enc) throws ASN1Exception {
        byte[] realvalue;
        int index;
        if (enc == null) {
            throw new ASN1Exception("No input value");
        }
        if (enc.length == 0) {
            throw new ASN1Exception("Zero-length integer value");
        }
        for (index = 0; index < enc.length && enc[index] == 0; ++index) {
        }
        if (index == enc.length) {
            this.value = new BigInteger("0");
            return;
        }
        if ((enc[index] & 0x80) == 0) {
            realvalue = new byte[enc.length - index];
            System.arraycopy(enc, index, realvalue, 0, enc.length - index);
        } else {
            realvalue = new byte[enc.length - index + 1];
            realvalue[0] = 0;
            System.arraycopy(enc, index, realvalue, 1, enc.length - index);
        }
        this.value = new BigInteger(realvalue);
    }

    public void setUnsignedValueLSB(byte[] enc) throws ASN1Exception {
        if (enc == null) {
            throw new ASN1Exception("No input value");
        }
        if (enc.length == 0) {
            throw new ASN1Exception("Zero-length integer value");
        }
        byte[] temp = new byte[enc.length];
        for (int i = 0; i < enc.length; ++i) {
            temp[i] = enc[enc.length - 1 - i];
        }
        this.setUnsignedValueMSB(temp);
    }

    public void decodeValue(int tag, byte[] enc) throws ASN1Exception {
        if (enc.length == 0) {
            throw new ASN1Exception("Zero-length integer value");
        }
        this.value = new BigInteger(enc);
    }

    public void encodeValue(OutputStream out) throws ASN1Exception, IOException {
        out.write(this.value.toByteArray());
    }

    public int getInteger() throws ASN1Exception {
        return this.value.intValue();
    }

    public BigInteger getBigInteger() throws ASN1Exception {
        return this.value;
    }

    public byte[] toByteArray() throws ASN1Exception {
        return this.value.toByteArray();
    }

    public String toString() {
        return this.value.toString();
    }

    public void set(BigInteger val) {
        this.value = val;
    }

    public void set(int val) {
        this.value = BigInteger.valueOf(val);
    }
}

